include promise.inc
protseg segment use32   public
assume  cs:protseg,ds:protseg

;-----------------------------------------------;
extrn   gen_arc_cos:near                        ; Fong.
extrn   gen_fong_table:near
extrn   fong_line:near

extrn   param_cut_triangle:near                 ; Prmcfill.

extrn   set_video_mode:near                     ; Common.
extrn   rot_transform:near                      ; Common.
extrn   visible:near                            ; Common.
extrn   raster:near                             ; Common.



;-----------------------------------------------;
; Runtime allokated addresses

_filltbl        dd      ?                       ; Da triangle sidez table addr
_fongmap        dd      ?                       ; Fong table addr
_virtscreen     dd      ?                       ; Guess ho??
_track          dd      ?                       ; Objekt's trak



;-----------------------------------------------;
lamp    dd      0,10000h,10000h                 ; Fong engin lightsource vektor

frmc	dd	180*2+90

public  moravian
moravian:
		push	prolomemstart prohimemstart
                call    fong_init
                call    video_init
                call    prepare_track

                mov     esi,_track
zzzz:
		call    raster
		call    raster

                push    esi

                xor     eax,eax                 ; Klear virtual skreen
                mov     ecx,4000h
                mov     edi,_virtscreen
        rep     stosd

                call    disp_star

		mov	eax,135
                mov     esi,_virtscreen         ; Refresh video memory
		add	esi,320*35+88
                mov     edi,0a0000h+320*35+88
                sub     edi,absprotseg
zzzzz:
                mov     ecx,144/4
        rep     movsd
		add	esi,88*2
		add	edi,88*2
		dec	eax
		jne	zzzzz

                pop     esi
                add     esi,36*48
                mov     eax,_track
                add     eax,311040
                cmp     esi,eax
                jb      hehe
                mov     esi,_track
hehe:
		dec	frmc
                jne     zzzz

suks:
		pop	prohimemstart prolomemstart
		ret


;-----------------------------------------------;
; Display one frame.
; In: esi = frame descriptor (x',y',z)
;-----------------------------------------------;
align   4
kx0     dd      ?,?,040000000h,040000000h
        dd      ?,?,040000000h,0c0000000h
        dd      ?,?,0c0000000h,080000000h

;-----------------------------------------------;
disp_star:
                cld
                mov     ecx,48
dsl:
                cmp     b [esi+20],0
                je      disped

                push    ecx esi
                mov     edi,o kx0
                movsd
                movsd
                add     esi,4
                add     edi,8
                movsd
                movsd
                add     esi,4
                add     edi,8
                movsd
                movsd

;		xor	kx0[8],0c0000000h
;		xor	kx0[12],0c0000000h
;		xor	kx0[8+16],0c0000000h
;		xor	kx0[12+16],040000000h
;		xor	kx0[8+16*2],040000000h
;		xor	kx0[12+16*2],0a0000000h

                mov     eax,o kx0
                call    disp_one
                pop     esi ecx

disped:
                add     esi,36
                dec     ecx
                jne     dsl

                ret



;-----------------------------------------------;
; Draw one triangle
; In: eax -> triangle deskriptor (3* x,y,c0,c1)

disp_one:
                lea     ebx,[eax+16]
                lea     ecx,[eax+32]
                mov     edi,_filltbl
                call    param_cut_triangle

                xchg    ebp,eax
                mov     esi,_filltbl
                mov     edi,_virtscreen
                call    fong_triangle
                ret



;-----------------------------------------------;
; Draw a fonged/textured triangle
; In:   esi -> table (w x0, w y0, d c00, d c01, w x1, w y1, d c10, d c11)
;       edi -> 320*200 array
;       ebp =  table length
;-----------------------------------------------;
align   16
public  fong_triangle
fong_triangle:
                test    ebp,ebp
                jne     fc_yeah
                ret

fc_yeah:
                mov     _cutarray,edi

fc_loop:
                push    esi ebp
                lea     ebx,[esi+4]
                movzx   eax,w [esi+2]
                lea     ecx,[esi+16]
                movzx   ebp,w [esi+12]
                movzx   edi,w [esi]

                sub     ebp,edi
                jnb     fc_nochange

                neg     ebp
                sub     edi,ebp
                xchg    ecx,ebx
fc_nochange:
                inc     ebp
                imul    eax,320
                lea     edi,[edi+eax+100h]
_cutarray       equ     d $-4

                shr     d [ebx],24
                shr     d [ebx+4],24
                shr     d [ecx],24
                shr     d [ecx+4],24

                mov     esi,_fongmap
                call    fong_line

                pop     ebp esi
fc_skip:
                add     esi,24
                dec     ebp
                jne     fc_loop
                ret





;-----------------------------------------------;
; Initialize da fong engin

fong_init:
                cld
                mov     eax,256                 ; Gen arkus kosinus table
                mov     ebx,256
                mov     ecx,64
                call    gen_arc_cos

                mov     eax,24*200              ; Gen kolor map
                call    getlomem
                mov     _filltbl,eax
                xchg    edi,eax

                mov     eax,3f3f3f3fh
fi_gencolormap:
                stosd
                sub     eax,01010101h
                jns     fi_gencolormap

                mov     eax,10000h              ; Gen fong map
                call    gethimem
                mov     _fongmap,eax
                lea     edx,[edi-256]
                xchg    edi,eax
                mov     esi,o lamp
                call    gen_fong_table

                ret



;-----------------------------------------------;
; Set video mode & palette

video_init:
                mov     eax,10000h
                call    gethimem
                mov     _virtscreen,eax

                call    set_video_mode

                mov	al,0
                mov     edx,3c8h
                out     dx,al
		xor	ecx,ecx
                inc     edx
vi_zzz:
		mov	al,0
		out	dx,al
		imul	eax,ecx,40
		shr	eax,6
		out	dx,al
		imul	eax,ecx,57
		shr	eax,6
		out	dx,al
                inc     ecx
                cmp     cl,60
                jne     vi_zzz

		mov	al,13*63/100
		out	dx,al
		mov	al,60*63/100
		out	dx,al
		mov	al,82*63/100
		out	dx,al

		mov	al,27*63/100
		out	dx,al
		mov	al,70*63/100
		out	dx,al
		mov	al,85*63/100
		out	dx,al
                ret



;-----------------------------------------------;
prepare_track:

INCLUDE VECTMATH.LIB                    ; Lineris algebra makri

Multiplier EQU 6553600
Shifter    EQU 900*65536

Start_frame=0
End_frame=179

Vector          STRUC
X               DQ      0
Y               DQ      0
Z               DQ      0
ENDS

Polygon         STRUC
P1              Vector<>
P2              Vector<>
P3              Vector<>
P4              Vector<>
ENDS

Rotate          MACRO   _S,_X,_Y,_Z
                FLD     [_S.X]  ;; X1
                FLD     _X      ;; _X  X1
                FMUL    Rad     ;; _X*Rad  X1
                FSINCOS         ;; COS(_X*Rad)  SIN(_X*Rad)  X1
                FLD     [_S.Y]  ;; Y0  COS(_X*Rad)  SIN(_X*Rad)  X1
                FMUL    ST,ST(1);; Y0*COS(_X*Rad)  COS(_X*Rad)  SIN(_X*Rad)  X1
                FLD     [_S.Z]  ;; Z0  Y0*COS(_X*Rad)  COS(_X*Rad)  SIN(_X*Rad)  X1
                FMUL    ST,ST(3);; Z0*SIN(_X*Rad)  Y0*COS(_X*Rad)  COS(_X*Rad)  SIN(_X*Rad)  X1
                FSUBP   ST(1),ST;; Y1  COS(_X*Rad)  SIN(_X*Rad)  X1
                FXCH    ST(2)   ;; SIN(_X*Rad)  COS(_X*Rad)  Y1  X1
                FMUL    [_S.Y]  ;; Y0*SIN(_X*Rad)  COS(_X*Rad)  Y1  X1
                FXCH            ;; COS(_X*Rad)  Y0*SIN(_X*Rad)  Y1  X1
                FMUL    [_S.Z]  ;; Z0*COS(_X*Rad)  Y0*SIN(_X*Rad)  Y1  X1
                FADD            ;; Z1  Y1  X1
                FLD     _Y      ;; _Y  Z1  Y1  X1
                FMUL    Rad     ;; _Y*Rad  Z1  Y1  X1
                FSINCOS         ;; COS(_Y*Rad)  SIN(_Y*Rad)  Z1  Y1  X1
                FLD     ST(4)   ;; X1  COS(_Y*Rad)  SIN(_Y*Rad)  Z1  Y1  X1
                FMUL    ST,ST(1);; X1*COS(_Y*Rad)  COS(_Y*Rad)  SIN(_Y*Rad)  Z1  Y1  X1
                FLD     ST(3)   ;; Z1  X1*COS(_Y*Rad)  COS(_Y*Rad)  SIN(_Y*Rad)  Z1  Y1  X1
                FMUL    ST,ST(3);; Z1*SIN(_Y*Rad)  X1*COS(_Y*Rad)  COS(_Y*Rad)  SIN(_Y*Rad)  Z1  Y1  X1
                FADD            ;; X2  COS(_Y*Rad)  SIN(_Y*Rad)  Z1  Y2  X1
                FXCH    ST(2)   ;; COS(_Y*Rad)  X2  Z1  Y2  X1
                FMULP   ST(5),ST;; COS(_Y*Rad)  X2  Z1  Y2  X1*SIN(_Y*Rad)
                FMULP   ST(2),ST;; X2  Z1*COS(_Y*Rad)  Y2  X1*SIN(_Y*Rad)
                FXCH            ;; Z1*COS(_Y*Rad)  X2  Y2  X1*SIN(_Y*Rad)
                FSUBRP  ST(3),ST;; X2  Y2  Z2
                FLD     _Z      ;; _Z  X2  Y2  Z2
                FMUL    Rad     ;; _Z*Rad  X2  Y2  Z2
                FSINCOS         ;; COS(_Z*Rad)  SIN(_Z*Rad)  X2  Y2  Z2
                FLD     ST(2)   ;; X2  COS(_Z*Rad)  SIN(_Z*Rad)  X2  Y2  Z2
                FMUL    ST,ST(1);; X2*COS(_Z*Rad)  COS(_Z*Rad)  SIN(_Z*Rad)  X2  Y2  Z2
                FLD     ST(4)   ;; Y2  X2*COS(_Z*Rad)  COS(_Z*Rad)  SIN(_Z*Rad)  X2  Y2  Z2
                FMUL    ST,ST(3);; Y2*SIN(_Z*Rad)  X2*COS(_Z*Rad)  COS(_Z*Rad)  SIN(_Z*Rad)  X2  Y2  Z2
                FSUBP   ST(1),ST;; X3  COS(_Z*Rad)  SIN(_Z*Rad)  X2  Y2  Z2
                FXCH    ST(3)   ;; X2  COS(_Z*Rad)  SIN(_Z*Rad)  X3  Y2  Z2
                FMULP   ST(2),ST;; COS(_Z*Rad)  X2*SIN(_Z*Rad)  X3  Y2  Z2
                FMULP   ST(3),ST;; X2*SIN(_Z*Rad)  X3  Y2*COS(_Z*Rad)  Z2
                FADDP   ST(2),ST;; X3  Y3  Z3
ENDM

Obj_poly3       MACRO   _A,_B
                VLD     _A
                VSTP    EDI.P1
                VLD     _B
                VSTP    EDI.P2
                VLD     C01
                VSTP    EDI.P3
                ADD     EDI,3*SIZE Vector
ENDM

Obj_face        MACRO   _A,_B,_C
        LOCAL _1
                MOV     ESI,L O Face
                MOV     ECX,3*8
_1:
                Rotate ESI,_A,_B,_C
                VSTP    Temp
                Rotate Temp,Index,Ph1,Ph2
                FILD    Factor
                VMULFR
                FISTP   D [EBX]
                FISTP   D [EBX+4]
                FIADD   Shift
                FISTP   D [EBX+8]
                ADD     ESI,SIZE Vector
                ADD     EBX,12
                DEC     ECX
                JNZ     _1
ENDM

                mov     eax,(311040/16+1)*16
                call    getlomem
                mov     _track,eax

                MOV     EBX,EAX
Next_frame:
                FILD    Frame
                FMUL    Const360
                FIDIV   Total_frames
                FSTP    Index

                FLD     Index
                FMUL    Rad
                FCOS
                FMUL    Half
                FADD    Plus1
                FSTP    Ph1

                FLD     Index
                FMUL    Rad
                FSIN
                FMUL    Half
                FADD    Plus1
                FMUL    Half
                FSTP    Ph2

                MOV     ESI,L O Valleys
                VMULF   ESI.P1,Ph1
                VSTP    F01
                VMULF   ESI.P2,Ph1
                VSTP    F02
                VMULF   ESI.P3,Ph1
                VSTP    F03
                VMULF   ESI.P4,Ph1
                VSTP    F04

                MOV     ESI,L O Peaks
                VMULF   ESI.P1,Ph2
                VSTP    T01
                VMULF   ESI.P2,Ph2
                VSTP    T02
                VMULF   ESI.P3,Ph2
                VSTP    T03
                VMULF   ESI.P4,Ph2
                VSTP    T04

                MOV     EDI,L O Face
                Obj_poly3 F01,T01
                Obj_poly3 T01,F02
                Obj_poly3 F02,T02
                Obj_poly3 T02,F03
                Obj_poly3 F03,T03
                Obj_poly3 T03,F04
                Obj_poly3 F04,T04
                Obj_poly3 T04,F01

                FLD     Index
                FMUL    Rad
                FADD    ST,ST(0)
                FSIN
                FMUL    Const45
                FSTP    Ph1

                FLD     Index
                FMUL    Rad
                FCOS
                FMUL    Const90
                FSTP    Ph2

                Obj_face Zero,Zero,Zero
                Obj_face Zero,Const90,Zero
                Obj_face Zero,Const180,Zero
                Obj_face Zero,Const270,Zero
                Obj_face Const90,Zero,Zero
                Obj_face Const270,Zero,Zero

                MOV     EAX,Frame
                INC     EAX
                CMP     EAX,End_frame
                MOV     Frame,EAX
                JNA     Next_frame

                mov     eax,10100h              ; Reserve mem. for sorting
                call    gethimem
                mov     __sortmem,eax

                mov     ecx,180*48*3            ; Transform to 2d
                mov     esi,_track
                call    rot_transform

                mov     edi,_track              ; Adjust 2 fit da skreen &
                mov     ecx,180*48              ; average trianglez
scrshift:
                add     d [edi],160
                add     d [edi+4],100
                add     d [edi+12],160
                add     d [edi+12+4],100
                mov     eax,[edi+12+8]
                add     d [edi+24],160
                add     d [edi+24+4],100
                add     eax,[edi+24+8]
                add     [edi+8],eax

                push    ecx edi                 ; Chek visibility
                mov     ebx,[edi+2]
                mov     bx,[edi]
                mov     ecx,[edi+12+2]
                mov     cx,[edi+12]
                mov     edx,[edi+24+2]
                mov     dx,[edi+24]
                call    visible
                pop     edi ecx
                setge   [edi+20]

                add     edi,36
                dec     ecx
                jne     scrshift

                mov     al,180                  ; Sort triangle patternz
                mov     esi,_track
mainsortloop:
                push    eax esi

                mov     eax,?                   ; Sort 48 trianglez
__sortmem       equ     d $-4
                mov     ebp,48
                call    esort

                mov     ebx,__sortmem           ; Write trianglez in korrekt
                lea     edi,[ebx+100h]          ; order
                mov     ebp,48
innersortloop:
                mov     esi,[ebx]
                mov     ecx,9
        rep     movsd
                add     ebx,4
                dec     ebp
                jne     innersortloop

                pop     edi
                mov     esi,__sortmem
                add     esi,100h
                mov     ecx,9*48
        rep     movsd

                mov     esi,edi
                pop     eax
                dec     al
                jne     mainsortloop

                sub     prolomemstart,10100h
                ret
;----------------------------------------------;
Factor          DD      Multiplier
Shift           DD      Shifter

Total_frames    DD      End_frame-Start_frame+1
Frame           DD      Start_frame

;Pi              LABEL   QWORD           ; Pi
;                DD      1413754136,1074340347
Rad             LABEL   QWORD           ; Pi/180
                DD      2723323193,1066524486

Zero            DD      0.0
Half            DD      0.5
Plus1           DD      1.0

Const45         DD      45.0
Const90         DD      90.0
Const180        DD      180.0
Const270        DD      270.0
Const360        DD      360.0

Valleys         Vector< 0.0, 1.0, 1.0>
                Vector< 1.0, 0.0, 1.0>
                Vector< 0.0,-1.0, 1.0>
                Vector<-1.0, 0.0, 1.0>

Peaks           Vector< 1.0, 1.0, 1.0>
                Vector< 1.0,-1.0, 1.0>
                Vector<-1.0,-1.0, 1.0>
                Vector<-1.0, 1.0, 1.0>

C01             Vector< 0.0, 0.0, 1.0>

F01             Vector<>
F02             Vector<>
F03             Vector<>
F04             Vector<>

T01             Vector<>
T02             Vector<>
T03             Vector<>
T04             Vector<>

Index           DQ      0
Ph1             DQ      0
Ph2             DQ      0

Temp            Vector<>

Face            Vector 3*8 DUP(<>)

locals
include esort.asm

protseg ends
end
