include	promise.inc
protseg	segment	use32	public
assume	cs:protseg,ds:protseg

;-----------------------------------------------;
; Draw	a horizontal fong line
; In:	ebx -> left endpoint's spherical coordinates
;	ecx -> right endpoint's spherical coordinates
;	esi -> fong table
;	edi -> line's 1. point
;	ebp =  line's length

align	16
public	fong_line
fong_line:
		test	ebp,ebp
		jne	oxi
		ret
oxi:
		mov	eax,[ecx]
		sub	eax,[ebx]
		rcr	edx,1
		sar	edx,31
		shl	eax,23
		idiv	ebp
		ror	eax,23
		mov	_y_adder_high,al
		mov	_y_adder_high1,al
		mov	_y_adder_high2,al
		mov	al,0
		mov	_y_adder,eax
		mov	_y_adder1,eax
		mov	_y_adder2,eax

		mov	eax,[ecx+4]
		sub	eax,[ebx+4]
		rcr	edx,1
		sar	edx,31
		shl	eax,23
		idiv	ebp
		ror	eax,23
		mov	_x_adder_high,al
		mov	_x_adder_high1,al
		mov	_x_adder_high2,al
		mov	al,0
		mov	_x_adder,eax
		mov	_x_adder1,eax
		mov	_x_adder2,eax

		mov	ecx,[ebx]
		movzx	ebx,b [ebx+4]
		mov	bh,cl			; bl = x0, bh = y0
		mov	ecx,80000000h
		mov	edx,80000000h

		shr	ebp,1
		jnb	fong_loop

		mov	al,[esi+ebx]
		add	ecx,100h
_x_adder2	equ	d $-4
		adc	bl,0
_x_adder_high2	equ	b $-1
		add	edx,100h
_y_adder2	equ	d $-4
		adc	bh,0
_y_adder_high2	equ	b $-1

		stosb

		test	ebp,ebp
		jne	fong_loop
		ret

align	16
fong_loop:
		mov	al,[esi+ebx]
		add	ecx,100h
_x_adder	equ	d $-4
		adc	bl,0
_x_adder_high	equ	b $-1
		add	edx,100h
_y_adder	equ	d $-4
		adc	bh,0
_y_adder_high	equ	b $-1

		mov	ah,[esi+ebx]
		add	ecx,100h
_x_adder1	equ	d $-4
		adc	bl,0
_x_adder_high1	equ	b $-1
		add	edx,100h
_y_adder1	equ	d $-4
		adc	bh,0
_y_adder_high1	equ	b $-1

		stosw

		dec	ebp
		jne	fong_loop

		ret



;-----------------------------------------------;
; In:	esi -> table (w x0, w y0, d c00, d c01, w x1, w y1, d c10, d c11)
;	edi -> 320*200 array
;	ebp =  table length
;-----------------------------------------------;
align	16
public	triangle_cut
triangle_cut:
		movzx	ecx,w [esi+2]
		imul	ecx,320
		movzx	eax,w [esi]
		add	ecx,eax
		movzx	ebx,w [esi+12+2]
		imul	ebx,320
		movzx	eax,w [esi+12]
		add	ebx,eax
		add	ecx,edi
		add	ebx,edi

		push	edi
		mov	edi,ebx
		sub	ecx,ebx
		jnb	_fake
		add	edi,ecx
		neg	ecx
_fake:
		inc	ecx
		mov	al,63
	rep	stosb
		pop	edi
		add	esi,24
		dec	ebp
		jne	triangle_cut
		ret



;-----------------------------------------------;
; Generate 256*256 table for shading

; In:	edi -> table
;	esi -> lightsource vektor (3 dwords, 16/16 bit fixpoint)
;	edx -> color table (256 bytes)

align	4
_light		dd	3 dup(?)
_surf_norm	dd	3 dup(?)
_reflect	dd	3 dup(?)
_eye		dd	0,0,10000h
_alfa		dd	?
_beta		dd	?

public	gen_fong_table
gen_fong_table:
		pushad

		mov	ebp,edi
		mov	edi,o _light
		call	normalize

		mov	_alfa,0
		mov	ecx,1000000h
fong_outer:
		mov	cx,100h
		mov	_beta,0
fong_inner:
		mov	esi,o _alfa
		mov	edi,o _surf_norm
		call	ab2xyz

		mov	eax,o _light
		mov	ebx,o _surf_norm
		mov	edi,o _reflect
		call	mirror

		mov	eax,o _reflect
		mov	ebx,o _eye
		call	angle

		and	eax,0ffh
		mov	al,[edx+eax]
		mov	ds:[ebp],al
		inc	ebp

		inc	_beta
		dec	cx
		jne	fong_inner
		inc	_alfa
		sub	ecx,10000h
		jne	fong_outer

		popad
		ret



;-----------------------------------------------;
; Mirror a vektor to another vektor

; In:	eax -> v1 (to be mirrored)
;	ebx -> v2 (to be mirrored to)
;	edi -> v3

mirror:
		fild	d [eax]
		fimul	d [ebx]
		fild	d [eax+4]
		fimul	d [ebx+4]
		fadd
		fild	d [eax+8]
		fimul	d [ebx+8]
		fadd
		fld	st
		fadd

		fidiv	_10000h

		fld	st
		fld	st
		fimul	d [ebx]
		fidiv	_10000h
		fisub	d [eax]
		fistp	d [edi]
		fimul	d [ebx+4]
		fidiv	_10000h
		fisub	d [eax+4]
		fistp	d [edi+4]
		fimul	d [ebx+8]
		fidiv	_10000h
		fisub	d [eax+8]
		fistp	d [edi+8]
		ret



;-----------------------------------------------;
; Transform 3d (X,Y,Z) coordinates to alpha, beta spherical coordinates

; In:  ds:esi -> X,Y,Z 32-bit fixed point numbers (16/16) (normalized vektor)
; Out: eax,ebx alpha,beta

public	xyz2ab
xyz2ab:
		xor	eax,eax
		xor	ebx,ebx
		cmp	d [esi+8],eax
		jl	xyz_zero		; Cull	z-negative vektorz

		push	ecx edx
		mov	ebx,[esi+4]		; ebx = y
		cmp	ebx,10000h
		jl	_ebx1
		mov	ebx,0fffch
_ebx1:
		cmp	ebx,-10000h
		jg	_ebx2
		mov	ebx,-0fffch
_ebx2:
		sar	ebx,7
		and	bl,0fch
		add	ebx,arccos_table
		mov	ebx,[ebx+256*2]		; ebx = alfa [0..ff ,ff=2]
		movsx	ecx,sintab[ebx]		; ecx = sin(alfa) [0..0ff,7f=1]
		test	ecx,ecx
		je	xyz_zero2
		mov	eax,[esi]		; al = x
		cdq
		idiv	ecx

		cmp	eax,200h
		jl	ox1
		mov	eax,1ffh
ox1:
		cmp	eax,-200h
		jg	ox2
		mov	eax,-1ffh
ox2:
		and	al,0fch
		add	eax,arccos_table
		mov	eax,[eax+256*2]
xyz_zero2:
		pop	edx ecx
		xchg	ebx,eax
		clc
		ret

xyz_zero:
		stc
		ret

sintab	label	byte
db	0,1,3,4,6,7,9,10,12,14,15,17,18,20,21,23,24,26,27,29
db	30,32,34,35,37,38,39,41,42,44,45,47,48,50,51,53,54,55,57,58
db	60,61,62,64,65,66,68,69,70,72,73,74,75,77,78,79,80,82,83,84
db	85,86,87,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105
db	106,106,107,108,109,110,110,111,112,113
db	113,114,115,115,116,117,117,118,118,119
db	120,120,121,121,122,122,122,123,123,124
db	124,124,125,125,125,125,126,126,126,126
db	126,127,127,127,127,127,127,127,127,127
db	127,127,127,127,127,127,126,126,126,126
db	126,125,125,125,125,124,124,124,123,123
db	122,122,122,121,121,120,120,119,118,118
db	117,117,116,115,115,114,113,113,112,111
db	110,110,109,108,107,106,106,105,104,103
db	102,101,100,99,98,97,96,95,94,93,92,91,90,89,87,86,85,84,83,82
db	80,79,78,77,75,74,73,72,70,69,68,66,65,64,62,61,60,58,57,55
db	54,53,51,50,48,47,45,44,42,41,39,38,37,35,34,32,30,29,27,26
db	24,23,21,20,18,17,15,14,12,10,9,7,6,4,3,1,0



;-----------------------------------------------;
; Transform spherical coordinates to 3d coordinates

; In:  ds:esi -> a,b 32-bit angles (only 0-1ff angles are allowed: 21ff)
; Out: ds:edi -> X,Y,Z

align	8
pi_per_256	dq	0.0122718463
_10000h		dd	10000h

ab2xyz:
		fld	pi_per_256
		fld	st
		fld	st
		fimul	d [esi]
		fld	st
		fcos
		fimul	_10000h
		fistp	d [edi+4]
		fsin
		fxch	st(2)
		fimul	d [esi+4]
		fcos
		fmul	st,st(2)
		fimul	_10000h
		fistp	d [edi]
		fimul	d [esi+4]
		fsin
		fmul
		fimul	_10000h
		fistp	d [edi+8]

		ret



;-----------------------------------------------;
; Retrieves the angle betwen two normalized vektors

; In:	eax->v1		(fixpoint)
;	ebx->v2		(fixpoint)
; Out:	eax=angle	(256) [0..255]

align	8
_2_ad_32_pr_512	dd	2000000h+30000h
_angle		dd	?

angle:
		fild	d [eax]
		fimul	d [ebx]
		fild	d [eax+4]
		fimul	d [ebx+4]
		fadd
		fild	d [eax+8]
		fimul	d [ebx+8]
		fadd
		fidiv	_2_ad_32_pr_512
		fistp	_angle

		mov	eax,_angle
		shl	eax,2
		add	eax,arccos_table
		mov	eax,[256*2+eax]

		ret



;-----------------------------------------------;
; Normalize a vektor

; In:  esi -> vektor 2 normalize
; Out: edi -> Normalized vektor

align	4
_16	dd	16

normalize:
		fild	d [esi]
		fmul	st,st

		fild	d [esi+4]
		fmul	st,st
		fadd

		fild	d [esi+8]
		fmul	st,st
		fadd

		fsqrt

		fild	d _16

		fild	d [esi]
		fdiv	st,st(2)
		fscale
		fistp	d [edi]

		fild	d [esi+4]
		fdiv	st,st(2)
		fscale
		fistp	d [edi+4]

		fild	d [esi+8]
		fdiv	st,st(2)
		fscale
		fistp	d [edi+8]

		fstp	st
		fstp	st
		ret



;-----------------------------------------------;
; Generate arcus cosinus table

; arccos(x) = /2 - x - 1/2*x^3/3 - 1/2*3/4*x^5/5 - 1/2*3/4*5/6*x^7/7 - ...

; In:	eax: table length (number of dwords)
;	ebx: range max
;	ecx: taylor series depth (recommended: at least 64)

; Reserves memory for the table (arccos_table)

align	4
pi_per_2	dd	1.570796327
x_step		dd	?
max_ac_val	dd	?
arccos_table	dd	?

public	gen_arc_cos
gen_arc_cos:
		pushad

		push	eax
		shl	eax,2
		call	getlomem
		xchg	edi,eax
		pop	eax

		mov	arccos_table,edi
		mov	x_step,eax
		mov	max_ac_val,ebx
		mov	ebx,ecx

		fld1				; Calculate X step: 2/eax
		fld1
		fadd
		fild	x_step
		fdiv
		fstp	x_step

		mov	esi,prolomemstart	; Calculate Taylor coefficients
		fld1
		fldz

gen_coeff_loop:
		fld1
		fadd
		fmul	st(1),st
		fld1
		fadd
		fdiv	st(1),st

		fld	st(1)
		fld	st(1)
		fld1
		fadd
		fdiv
		fstp	q [esi]

		add	esi,8
		loop	gen_coeff_loop

		fstp	st
		fstp	st

		mov	ecx,eax			; Calculate arc cos values
		fld1
		fchs

g_ac_loop:
		fld	st			; Duplicate x
		fld	pi_per_2
		fsub	st,st(2)		; ST = /2-x (0. level Taylor)
		mov	edx,ebx
		mov	esi,prolomemstart

calc_acos:
		fld	st(1)
		fmul	st,st(3)
		fmul	st,st(3)
		fst	st(2)
		fmul	q [esi]
		fsub
		add	esi,8
		dec	edx
		jne	calc_acos

		fstp	st(1)			; Copy the exact arc cos value

		fimul	max_ac_val		; Linear interpolation to fit
		fldpi				; the value to da given range
		fdiv
		fistp	d [edi]

		fadd	x_step			; Calculate next pos in domain
		add	edi,4
		loop	g_ac_loop

		fstp	st

;		_dsdx	'arccos.bin',0
;		mov	ah,3ch
;		xor	ecx,ecx
;		int	21h
;		xchg	ebx,eax
;		mov	edx,arccos_table
;		add	edx,absprotseg
;		shld	real_eds,edx,28
;		and	edx,0fh
;		mov	ah,40h
;		mov	ecx,512*4
;		int	21h
;		mov	ah,3eh
;		int	21h

		popad
		ret

protseg	ends
end
