include	promise.inc
protseg	segment	public	use32
assume	cs:protseg,ds:protseg
locals
public	Sin_Gen,Raster,Set_Video_Mode
public	Rot_Make_Matrix,Rot_Turn9,Rot_Transform,Order,Visible

;------------------------------------------------------------------------------
; to es:edi
; eax: amp
; ebx: len of period
; ecx: one number length (1,2,3,4)
; ebp: len
; es:edi:pos
; eax,ebx,ecx,edx,edi

Sin_Gen	PROC NEAR

		mov	[@@Tmp2],ecx
		shr	ebx,2
		mov	[@@Cnt1],ebx
		mov	[@@Tmp4],ebx
		mov	[@@Cnt2],ebp
		mov	[@@Amp],eax
		mov	eax,102944		; eax=PI/2
		xor	edx,edx
		div	ebx
		mov	[@@Tmp3],eax
		xor	ecx,ecx
@@Sin1:
		mov	ebp,ecx		; sin(x) kb= x-x^3/3!+x^5/5!
		mov	eax,ecx
		imul	ecx
		shrd	eax,edx,10h
		imul	ecx
		shrd	eax,edx,10h
		cdq
		mov	esi,6
		idiv	esi
		sub	ebp,eax
		mov	eax,ecx
		imul	ecx
		shrd	eax,edx,10h
		imul	eax
		shrd	eax,edx,10h
		imul	ecx
		shrd	eax,edx,10h
		cdq
		mov	esi,120
		idiv	esi
		add	eax,ebp
		imul	[@@Amp]
		shrd	eax,edx,10h
		mov	es:[edi],eax
		add	edi,[@@Tmp2]
		add	ecx,[@@Tmp3]
		dec	[@@Cnt2]
		jz	@@Sin_Exit
		dec	[@@Cnt1]
		jnz	@@Sin1
		mov	esi,edi
		mov	edx,[@@Tmp2]
		mov	cl,0
@@Sin2:
		inc	cl
		and	cl,3
		neg	edx
		mov	ebp,[@@Tmp4]
@@Sin3:
		add	esi,edx
		mov	eax,es:[esi]
		test	cl,2
		jz	@@Sin4
		neg	eax
@@Sin4:
		mov	es:[edi],eax
		add	edi,[@@Tmp2]
		dec	[@@Cnt2]
		jz	@@Sin_Exit
		dec	ebp
		jnz	@@Sin3
		add	esi,edx
		jmp	@@Sin2

@@Sin_Exit:
		ret
@@Cnt1	dd 0
@@Cnt2	dd 0
@@Tmp2	dd 0
@@Tmp3	dd 0
@@Tmp4	dd 0
@@Amp	dd 0
Sin_Gen	ENDP


;-------------------------------------------------------------------------------
Rot_Make_Matrix	PROC NEAR
; The routin uses a 3x3 rotation matrix which elements are:
;  Ŀ
;                                                                            
;    *[cos(+)+cos(-)]     *[sin(-)-sin(+)]          sin()         
;                                                                            
;  Ĵ
;   *{ sin(+)-sin(-)+    *{ cos(+)+cos(-)+                         
;R=+*[cos(-+)+cos(--)--*[sin(+-)+sin(-+)--*[sin(+)+sin(-)]
;   -cos(++)-cos(+-)] } -sin(++)-sin(--)] }                      
;  Ĵ
;   *{ cos(-)-cos(+)+    *{ sin(+)+sin(-)+                         
;  +*[sin(-+)+sin(--)-+*[cos(+-)+cos(-+)- *[cos(+)+cos(-)]
;   -sin(++)-sin(+-)] } -cos(++)-cos(--)] }                      
;  
;                                             
;                                           x'
; Then the rotated coorindinates can be got y'=[x,y,z]*R
;                                           z'         =
;                                             

rotate_sinlen equ 512	; number of the elements in the sinus-table
rotate_ovrflw equ (rotate_sinlen-1)*4
rotate_cosadd equ rotate_sinlen/4*4
;rotate_costab equ offset rotate_sintab+rotate_cosadd

		lea	edi,[esi+rotate_cosadd]

		shl	eax,2
		shl	ebx,2
		shl	ecx,2

		mov	ebp,rotate_ovrflw

		and	ebx,ebp
		mov	edx,[esi+ebx]
		mov	[Rot_Mtx_Lmnt_13],edx	; Rot_Mtx_Lmnt_13

		mov	edx,eax
		add	edx,ebx
		and	edx,ebp
		mov	[@@apb],edx
		add	edx,ecx
		and	edx,ebp
		mov	[@@apbpg],edx
		mov	edx,eax
		sub	edx,ebx
		and	edx,ebp
		mov	[@@amb],edx
		add	edx,ecx
		and	edx,ebp
		mov	[@@ambpg],edx
		mov	edx,eax
		add	edx,ecx
		and	edx,ebp
		mov	[@@apg],edx
		mov	edx,eax
		sub	edx,ecx
		and	edx,ebp
		mov	[@@amg],edx
		sub	edx,ebx
		and	edx,ebp
		mov	[@@ambmg],edx
		mov	edx,ebx
		add	edx,ecx
		and	edx,ebp
		mov	[@@bpg],edx
		sub	ebx,ecx
		and	ebx,ebp
		mov	[@@bmg],ebx
		add	eax,ebx
		and	eax,ebp
		mov	[@@apbmg],eax

		mov	ecx,[@@bpg]
		mov	edx,[@@bmg]
		mov	eax,[edi+ecx]
		add	eax,[edi+edx]
		sar	eax,1
		adc	eax,0
		mov	[Rot_Mtx_Lmnt_11],eax	; Rot_Mtx_Lmnt_11

		mov	eax,[esi+edx]
		sub	eax,[esi+ecx]
		sar	eax,1
		adc	eax,0
		mov	[Rot_Mtx_Lmnt_12],eax	; Rot_Mtx_Lmnt_12

		mov	ecx,[@@ambpg]
		mov	eax,[edi+ecx]
		mov	ebx,[esi+ecx]
		mov	ecx,[@@ambmg]
		add	eax,[edi+ecx]
		add	ebx,[esi+ecx]
		mov	ecx,[@@apbpg]
		sub	eax,[edi+ecx]
		sub	ebx,[esi+ecx]
		mov	ecx,[@@apbmg]
		sub	eax,[edi+ecx]
		sub	ebx,[esi+ecx]
		mov	ecx,[@@apg]
		mov	edx,[@@amg]
		sar	eax,1
		adc	eax,[esi+ecx]
		sub	eax,[esi+edx]
		sar	ebx,1
		adc	ebx,[edi+edx]
		sub	ebx,[edi+ecx]
		sar	eax,1
		adc	eax,0
		mov	[Rot_Mtx_Lmnt_21],eax	; Rot_Mtx_Lmnt_21
		sar	ebx,1
		adc	ebx,0
		mov	[Rot_Mtx_Lmnt_31],ebx	; Rot_Mtx_Lmnt_31

		mov	ecx,[@@apbmg]
		mov	eax,[esi+ecx]
		mov	ebx,[edi+ecx]
		mov	ecx,[@@ambpg]
		add	eax,[esi+ecx]
		add	ebx,[edi+ecx]
		mov	ecx,[@@apbpg]
		sub	eax,[esi+ecx]
		sub	ebx,[edi+ecx]
		mov	ecx,[@@ambmg]
		sub	eax,[esi+ecx]
		sub	ebx,[edi+ecx]
		neg	eax
		mov	ecx,[@@apg]
		sar	eax,1
		adc	eax,[edi+ecx]
		sar	ebx,1
		adc	ebx,[esi+ecx]
		mov	ecx,[@@amg]
		add	eax,[edi+ecx]
		add	ebx,[esi+ecx]
		sar	eax,1
		adc	eax,0
		mov	[Rot_Mtx_Lmnt_22],eax	; Rot_Mtx_Lmnt_22
		sar	ebx,1
		adc	ebx,0
		mov	[Rot_Mtx_Lmnt_32],ebx	; Rot_Mtx_Lmnt_32

		mov	ecx,[@@apb]
		mov	eax,[esi+ecx]
		mov	ebx,[edi+ecx]
		mov	ecx,[@@amb]
		add	eax,[esi+ecx]
		add	ebx,[edi+ecx]
		sar	eax,1
		adc	eax,0
		neg	eax
		mov	[Rot_Mtx_Lmnt_23],eax	; Rot_Mtx_Lmnt_23
		sar	ebx,1
		adc	ebx,0
		mov	[Rot_Mtx_Lmnt_33],ebx	; Rot_Mtx_Lmnt_33
		ret

align 4
@@apb	dd 0	; +
@@amb	dd 0	; -
@@apg	dd 0	; +
@@amg	dd 0	; etc.
@@bpg	dd 0
@@bmg	dd 0
@@apbpg	dd 0
@@apbmg	dd 0
@@ambpg	dd 0
@@ambmg	dd 0

Rot_Mtx_Lmnt_11	dd 0	; The left-top element of rotation matrix
Rot_Mtx_Lmnt_12	dd 0	; The middle-top element
Rot_Mtx_Lmnt_13	dd 0	; etc.
Rot_Mtx_Lmnt_21	dd 0
Rot_Mtx_Lmnt_22	dd 0
Rot_Mtx_Lmnt_23	dd 0
Rot_Mtx_Lmnt_31	dd 0
Rot_Mtx_Lmnt_32	dd 0
Rot_Mtx_Lmnt_33	dd 0

Rot_Make_Matrix	ENDP
;------------------------------------------------------------------------------
Rot_Turn9		PROC NEAR

		mov	D [@@xadd],eax
		mov	D [@@yadd],ebx
		mov	D [@@zadd],edx
		cld
@@turn_loop:
		mov	eax,[esi]
		imul	[Rot_Mtx_Lmnt_11]
		shld	edx,eax,10h
		mov	eax,[esi+4]
		mov	ebx,edx
		imul	[Rot_Mtx_Lmnt_12]
		shld	edx,eax,10h
		mov	eax,[esi+8]
		add	ebx,edx
		imul	[Rot_Mtx_Lmnt_13]
		shld	edx,eax,10h
		add	ebx,edx
		add	ebx,[@@xadd]		; ebx=the roated X-coordinate
		mov	eax,[esi]
		mov	[edi],ebx		; then store it.

		imul	[Rot_Mtx_Lmnt_21]
		shld	edx,eax,10h
		mov	eax,[esi+4]
		mov	ebx,edx
		imul	[Rot_Mtx_Lmnt_22]
		shld	edx,eax,10h
		mov	eax,[esi+8]
		add	ebx,edx
		imul	[Rot_Mtx_Lmnt_23]
		shld	edx,eax,10h
		add	ebx,edx
		add	ebx,[@@yadd]		; ebx=the rotated Y-coord.
		lodsd
		mov	[edi+4],ebx

		imul	[Rot_Mtx_Lmnt_31]
		shld	edx,eax,10h
		lodsd
		mov	ebx,edx
		imul	[Rot_Mtx_Lmnt_32]
		shld	edx,eax,10h
		lodsd
		add	ebx,edx
		imul	[Rot_Mtx_Lmnt_33]
		shld	edx,eax,10h
		add	ebx,edx
		add	ebx,[@@zadd]		; ebx=the rotated Z-coord.
		mov	[edi+8],ebx
		add	edi,12
		dec	ecx
		jnz	@@turn_loop
		ret
@@xadd	dd ?
@@yadd	dd ?
@@zadd	dd ?
Rot_Turn9		ENDP
;------------------------------------------------------------------------------
Rot_Transform	PROC NEAR

		push	es
		cld
		mov	ax,ds
		mov	es,ax
		mov	ebx,@@aspect_ratio
		mov	edi,esi
@@trnsfrm1:
		mov	edx,@@zoom_factor
		xor	eax,eax
		idiv	dword ptr [esi+8]
		mov	ebp,eax
		mov	eax,[esi]
		imul	ebp
		shrd	eax,edx,10h
		imul	ebx
		shl	eax,1
		adc	edx,0
		mov	eax,[esi+4]
		mov	[edi],edx
		add	esi,12
		imul	ebp
		shl	eax,1
		adc	edx,0
		mov	[edi+4],edx
		add	edi,12
		dec	ecx
		jnz	@@trnsfrm1
		pop	es
		ret

@@aspect_ratio = 72090		; 1.1 * 10000h
@@zoom_factor  = 300

Rot_Transform ENDP
;------------------------------------------------------------------------------
Order		PROC NEAR

@@maxdarab	=512 ;1024
@@log2maxdarab	=11 ;12
@@strukthossz	=8

		push	es
		push	ds
		pop	es
		;cmp	ecx,1
		;jne	@@00
		;mov	D [edi+4],0
		;jmp	@@XIT
@@00:
		push	edi eax
		mov	ebp,ecx
		add	esi,4
@@0:
		mov	eax,[esi]
		lea	eax,[eax+eax*2]
		shl	eax,2
		mov	edx,[ebx+eax+8]
		sar	edx,2
		mov	eax,[esi+4]
		lea	eax,[eax+eax*2]
		shl	eax,2
		mov	eax,[ebx+eax+8]
		sar	eax,2
		add	edx,eax
		mov	eax,[esi+8]
		lea	eax,[eax+eax*2]
		shl	eax,2
		mov	eax,[ebx+eax+8]
		sar	eax,2
		add	edx,eax
		neg	edx
		mov	eax,ebp
		sub	eax,ecx
		mov	[edi],edx
		mov	[edi+4],eax
		add	edi,8
		add	esi,16
		dec	ecx
		jnz	@@0

;sort
		pop	eax
		mov	@@lista,eax
		add	eax,@@maxdarab*4
		mov	@@puffer_addr,eax

		call	@@init_sort
		pop	esi
		mov	ecx,ebp
@@1:
		xor	eax,eax
		mov	al,[esi]
		shl	eax,@@log2maxdarab
		add	eax,@@puffer_addr
		mov	edi,[eax]
		mov	[edi],esi
		add	edi,4
		add	esi,@@strukthossz
		mov	[eax],edi
		dec	ecx
		jnz	@@1

		call	@@fesul

		mov	ebx,1
@@2:
		call	@@init_sort
		mov	esi,@@lista
		mov	ecx,ebp
@@3:
		push	esi
		mov	esi,[esi]
		xor	eax,eax
		mov	al,[esi+ebx]
		shl	eax,@@log2maxdarab
		add	eax,@@puffer_addr
		mov	edi,[eax]
		mov	[edi],esi
		add	edi,4
		pop	esi
		mov	[eax],edi
		add	esi,4
		dec	ecx
		jnz	@@3

		call	@@fesul
		inc	ebx
		cmp	ebx,4
		jne	@@2
		pop	es
@@XIT:
		ret

@@fesul:
		mov	esi,@@puffer_addr
		mov	edi,@@lista
		mov	edx,256
@@4:
		push	esi
		mov	ecx,[esi]
		add	esi,4
		sub	ecx,esi
		shr	ecx,2
	rep	movsd
		pop	esi
		add	esi,@@maxdarab*4
		dec	edx
		jne	@@4
		ret


@@init_sort:
		mov	edi,@@puffer_addr
		mov	ecx,256
		add	edi,4
@@5:
		mov	[edi-4],edi
		add	edi,@@maxdarab*4
		dec	ecx
		jne	@@5
		ret
@@puffer_addr	dd	?
@@lista		dd	?
Order		ENDP
;------------------------------------------------------------------------------
Visible		PROC NEAR
		push	ebx ecx edx esi
		mov	esi,ebx
		mov	edi,edx
		movsx	eax,bx
		movsx	ebp,cx
		sub	ebp,eax
		mov	eax,esi
		sar	eax,10h
		sar	edx,10h
		sub	eax,edx
		imul	ebp
		mov	ebp,eax
		movsx	eax,si
		movsx	edx,di
		sub	eax,edx
		sar	ecx,10h
		sar	esi,10h
		sub	ecx,esi
		imul	ecx
		pop	esi edx ecx ebx
		cmp	ebp,eax
		ret
Visible		ENDP



Raster		PROC NEAR
; Waiting for raster retrace.
; User reg.: ax, dx

		mov	dx,3dah
@@Raster1:
		in	al,dx
		and	al,8
		jnz	@@Raster1
@@Raster2:
		in	al,dx
		and	al,8
		jz	@@Raster2
		ret

Raster		ENDP



;------------------------------------------------------------------------------
Set_Video_Mode	PROC NEAR
		push	es
		mov	ax,zrdss
		mov	es,ax
		call	raster
		mov	dx,3c8h	; Make black screen
		mov	al,0
		out	dx,al
		inc	dx
		mov	ecx,300h
@@SVM1:
		out	dx,al
		loop	@@SVM1

		call	raster
		mov	edi,0a0000h
		xor	eax,eax
		mov	ecx,65536/4
	rep	stosd

		call	raster
		mov	ax,13h	; Set video mode
		int	10h

		call	raster
		mov	dx,3c8h	; Make black screen
		mov	al,0
		out	dx,al
		inc	dx
		mov	ecx,300h
@@SVM2:
		out	dx,al
		loop	@@SVM2
		pop	es
		ret

Set_Video_Mode	ENDP

protseg	ends
end
