; ADATOK:
; -------
; A sugr (flegyenes)
;                          _
;       - kiindul pontja: P = (Px,Py,Pz)
;                 _
;       - irnya: D = (Dx,Dy,Dz)      <--  egysgnyi vektor
; 
; Az Y tengelyirny sk
;                         _
;       - norml vektora: N = (0,B,0)
;                     _
;       - egy pontja: Po = (0,Yo,0)
; 
;
; SZMOLS:
; ---------
; A tvolsg (t)
; 
;       D = - (B * Yo)       <-- init0
; 
;       d = B * Dy
; 
; s
;             B * Py + D
;       t = - ---------- , ha d <> 0
;                 d
; vagy
; 
;       V = - (B * Py + D)       <-- init
; 
;           V
;       t = - , ha d <> 0
;           d
;                _
; A metszspont (M)
;       _   _       _
;       M = P + t * D, ha t > 0
; 
;       azaz
;       _
;       M = (Px + t * Dx, Py + t * Dy, Pz + t * Dz), ha t > 0
; ___________________________________________________________________________

Plane_YType     STRUC
                Object<>
GBase           DQ      ?
GNorm           DQ      ?
GOffs           DQ      ?
GNdotP          DQ      ?
ENDS

Plane_Y         MACRO   _Yo,_B,_Texture:REQ,_Next

        IFB <_Next>
                DD      L O $ + SIZE Plane_YType
        ELSE
                DD      L O _Next
        ENDIF
                DD      L O Plane_YInitO
                DD      L O Plane_YInitF
                DD      L O Plane_YFirst
                DD      L O Plane_YShade
                DD      L O Plane_YIsect
                DD      L O Plane_YNorml
                DD      L O _Texture
                DD      ?
                DD      ?

                DQ      _Yo
                DQ      _B
                DQ      ?
                DQ      ?
ENDM

Plane_YInitO:
                FLD     [ESI.GBase]
                FMUL    [ESI.GNorm]
                FCHS
                FSTP    [ESI.GOffs]
                NextInitO

Plane_YInitF:
                FLD     [ESI.GNorm]
                FMUL    [EBX.EyePos.Y]
                FADD    [ESI.GOffs]
                FCHS
                FSTP    [ESI.GNdotP]
                NextInitF

Plane_YFirst:
                FLD     [Direction.Y]
                FMUL    [ESI.GNorm]
                FLD     ST
                FABS
                FCOMP   Epsilon
                FNSTSW  AX
                SAHF
                JBE     @@1
                FDIVR   [ESI.GNdotP]
                FCOM    Distance
                FNSTSW  AX
                SAHF
                JAE     @@1
                FCOM    Epsilon
                FNSTSW  AX
                SAHF
                JBE     @@1
                MOV     EBX,ESI
                MOV     ESI,[ESI.NextO]
                FSTP    Distance
                CMP     ESI,FirstO
                JE      LastFirst
                JMP     O [ESI.First]
@@1:
                NextFirst 1

Plane_YShade:
                FLD     [Shadow.Y]
                FMUL    [ESI.GNorm]
                FLD     ST
                FABS
                FCOMP   Epsilon
                FNSTSW  AX
                SAHF
                JBE     @@1
                FLD     [ESI.GNorm]
                FMUL    [Position.Y]
                FADD    [ESI.GOffs]
                FCHS
                FDIVRP  ST(1),ST
                FCOM    Epsilon
                FNSTSW  AX
                SAHF
                JBE     @@1
                FCOMP   Distance
                FNSTSW  AX
                SAHF
                JAE     @@0
                CALL    [ESI.Texture]
                FLD     [EDX.Transmit]  ; T
                FTST
                FNSTSW  AX
                SAHF
                JNZ     @@2
                MOV     [EBX.Cache],ESI
                RETN
@@2:
                MOV     ESI,[ESI.NextO]
                FMUL    Trans           ; P*T
                FSTP    Trans
                CMP     ESI,FirstO
                JE      LastShade
                JMP     O [ESI.Shade]
@@1:
                NextShade 1
@@0:
                NextShade

Plane_YIsect:
                FLD     [Direction.Y]
                FMUL    [ESI.GNorm]
                FLD     ST
                FABS
                FCOMP   Epsilon
                FNSTSW  AX
                SAHF
                JBE     @@1
                FLD     [ESI.GNorm]
                FMUL    [Position.Y]
                FADD    [ESI.GOffs]
                FCHS
                FDIVRP  ST(1),ST
                FCOM    Distance
                FNSTSW  AX
                SAHF
                JAE     @@1
                FCOM    Epsilon
                FNSTSW  AX
                SAHF
                JBE     @@1
                MOV     EBX,ESI
                MOV     ESI,[ESI.NextO]
                FSTP    Distance
                CMP     ESI,FirstO
                JE      LastIsect
                JMP     O [ESI.Isect]
@@1:
                NextIsect1

Plane_YNorml:
                FLD     Zero
                FLD     [EBX.GNorm]
                FLD     ST(1)
                RETN
