 		AREA code_start, CODE, READONLY
	
	IMPORT |Image$$RO$$Limit| 	; End of ROM code (=start of ROM data)
	IMPORT |Image$$RW$$Base| 	; Base of RAM to initialize
	IMPORT |Image$$ZI$$Base| 	; Base and limit of area
	IMPORT |Image$$ZI$$Limit| 	; to zero initialize
	
	IMPORT Main
	
	
Cpu_Mode_USR	EQU 	0x10
Cpu_Mode_IRQ 	EQU 	0x12
Cpu_Mode_SVC 	EQU 	0x13

Cpu_Stack_USR	EQU	0x03007F00	; GBA USR stack adress
Cpu_Stack_IRQ	EQU	0x03007FA0	; GBA IRQ stack adress
Cpu_Stack_SVC	EQU	0x03007FE0	; GBA SVC stack adress
Cpu_Int_Handler EQU 0x03007FFC	; GBA Interupt handler address
	
	ENTRY
	b 	start
	DCD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DCD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 	DCD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	b	SkipReservedStuff
	DCB	0
	DCB	0
	DCB	0
	DCB	0
	DCD	0
	DCD	0
	DCD	0
	DCD	0
	DCD	0
	DCD	0
SkipReservedStuff

start
	mov 	r0, #Cpu_Mode_IRQ:OR:0x80:OR:0x40 	; Disable interrupts
	msr 	CPSR_c, r0					; Enable IRQ mode
	ldr 	r13, =Cpu_Stack_IRQ			; Setup IRQ stack pointer

	mov 	r0, #Cpu_Mode_SVC:OR:0x80:OR:0x40 	; Disable interrupts
	msr 	CPSR_c, r0					; Enable SVC mode
	ldr 	r13, =Cpu_Stack_SVC			; Setup SVC stack pointer

	ldr 	r0, =|Image$$RO$$Limit| 	; Get pointer to ROM data
	ldr 	r1, =|Image$$RW$$Base| 		; and RAM copy
	ldr 	r3, =|Image$$ZI$$Base| 		; Zero init base => top of initialized data
	cmp 	r0, r1 				; Check that they are different
	beq 	%F1
0 	cmp 	r1, r3 				; Copy init data
	ldrcc 	r2, [r0], #4
	strcc 	r2, [r1], #4
	bcc	%B0
1	ldr 	r1, =|Image$$ZI$$Limit| 	; Top of zero init segment
	mov 	r2, #0
2 	cmp 	r3, r1 				; Zero init
	strcc 	r2, [r3], #4
	bcc	%B2

	ldr      r0,=intr_main
	ldr      r2,=Cpu_Int_Handler
	str      r0,[r2,#0x00]

	mov 	r0, #Cpu_Mode_SVC:OR:0x40	; Only IRQ enabled
	msr 	CPSR_c, r0
	
	mov 	r0, #Cpu_Mode_USR:OR:0x40	;
	msr 	CPSR_c, r0					; Switch to USR mode
	ldr 	sp, =Cpu_Stack_USR			; Setup USR stack pointer
	
	b	Main;		; Now branch to start of C code
final_return_loop
	b 	final_return_loop		; In case of a return...

; Interrupt table
IntrTable
	DCD	0x00000000	;V
	DCD	0x00000000	;H
	DCD	0x00000000	;V count
	DCD	0x00000000	;Timer0
	DCD	0x03002b04	;Timer1iRQ <- Reset buffers, fill it again
	DCD	0x00000000	;Timer2
	DCD	0x00000000	;Timer3
	DCD	0x00000000	;Sio
	DCD	0x00000000	;Dma0
	DCD	0x00000000	;Dma1
	DCD	0x00000000	;Dma2
	DCD	0x00000000	;Dma3
	DCD	0x00000000	;Key
	
; Interrupts handling
intr_main
    mov     r3, #0x04000000         ; Check IE/IF
    add     r3, r3, #0x200          ; r3: REG_IE
    ldr     r2, [r3]
    and     r1, r2, r2, lsr #16 	; r1: IE & IF
    ands    r0, r1, #0x2000  ; Cassette interrupt
loop    
    bne     loop
	mov     r2, #0
    ands    r0, r1, #0x0001   ; V Blank interrupt
    bne     jump_intr
    add     r2, r2, #4
    ands    r0, r1, #0x0002   ; H Blank interrupt
    bne     jump_intr
    add     r2, r2, #4
    ands    r0, r1, #0x0004   ; V Blank interrupt
    bne     jump_intr
    add     r2, r2, #4
    ands    r0, r1, #0x0008   ; Timer 0 interrupt
    bne     jump_intr
    add     r2, r2, #4
    ands    r0, r1, #0x0010   ; Timer 1 interrupt
    bne     jump_intr
    add     r2, r2, #4
    ands    r0, r1, #0x0020   ; Timer 2 interrupt
    bne     jump_intr
    add     r2, r2, #4
    ands    r0, r1, #0x0040   ; Timer 3 interrupt
    bne     jump_intr
    add     r2, r2, #4
    ands    r0, r1, #0x0080   ; Serial Communication interrupt
    bne     jump_intr
    add     r2, r2, #4
    ands    r0, r1, #0x0100   ; DMA0 interrupt
    bne     jump_intr
    add     r2, r2, #4
    ands    r0, r1, #0x0200   ; DMA1 interrupt
    bne     jump_intr
    add     r2, r2, #4
    ands    r0, r1, #0x0400   ; DMA2 interrupt
    bne     jump_intr
    add     r2, r2, #4
    ands    r0, r1, #0x0800   ; DMA3 interrupt
    bne     jump_intr
    add     r2, r2, #4
    ands    r0, r1, #0x1000   ; Key interrupt
jump_intr
    strh    r0, [r3, #2]      ; IF Clear           11c
    ldr     r1, =IntrTable    ; Jump to User IRQ Process
    add     r1, r1, r2
    ldr     r0, [r1]
    bx      r0
 	END
 	