diff -urN --exclude=*.$$$ e:\q2\game/g_cmds.c ./g_cmds.c
--- e:\q2\game/g_cmds.c	Tue Nov 25 05:31:16 1997
+++ ./g_cmds.c	Mon Dec 22 20:48:30 1997
@@ -588,6 +588,39 @@
 
 /*
 =================
+Cmd_CheckStats_f
+CCH: New function to print all players' stats
+=================
+*/
+void Cmd_CheckStats_f (edict_t *ent)
+{
+	int		i, j;
+	edict_t	*player;
+	char	stats[500];
+	vec3_t	v;
+	float	len;
+
+	// use in coop mode only
+//	if (!coop->value)
+//		return;
+
+	j = sprintf(stats, "            Name Health Range\n=============================\n");
+	for (i=0 ; i<maxclients->value ; i++)
+	{
+		player = g_edicts + 1 + i;
+		if (!player->inuse || !player->client)
+			continue; 
+		VectorSubtract (ent->s.origin, player->s.origin, v);
+		len = VectorLength (v);
+		j += sprintf(stats + j, "%16s %6d %5.0f\n", player->client->pers.netname, player->health, len);
+		if (j > 450)
+			break;
+	}
+	gi.centerprintf(ent, "%s", stats);
+}
+
+/*
+=================
 ClientCommand
 =================
 */
@@ -633,6 +666,11 @@
 		Cmd_PutAway_f (ent);
 	else if (Q_stricmp (cmd, "wave") == 0)
 		Cmd_Wave_f (ent);
+
+	// CCH: new command 'checkstats'
+	else if (Q_stricmp (cmd, "checkstats") == 0)
+		Cmd_CheckStats_f (ent);
+
 	else if (Q_stricmp (cmd, "gameversion") == 0)
 	{
 		gi.cprintf (ent, PRINT_HIGH, "%s : %s\n", GAMEVERSION, __DATE__);
