 /* Name       : uDrive Directory Show Program    */

#include <dos.h>
#include <stdio.h>
#include <conio.h>

#define PORT1 0x3F8

  /* Defines Serial Ports Base Address */
  /* COM1 0x3F8                        */
  /* COM2 0x2F8			       */
  /* COM3 0x3E8			       */
  /* COM4 0x2E8			       */

void main(void)
{
 int c;
 int ch,key;

 outportb(PORT1 + 1 , 0);   /* Turn off interrupts - Port1 */

 /*         PORT 1 - Communication Settings         */

 outportb(PORT1 + 3 , 0x80);  /* SET DLAB ON */
 outportb(PORT1 + 0 , 0x06);  /* Set Baud rate - Divisor Latch Low Byte */
			      /* Default 0x03 =  38,400 BPS */
			      /*         0x01 = 115,200 BPS */
			      /*         0x02 =  57,600 BPS */
			      /*         0x06 =  19,200 BPS */
			      /*         0x0C =   9,600 BPS */
			      /*         0x18 =   4,800 BPS */
			      /*         0x30 =   2,400 BPS */
 outportb(PORT1 + 1 , 0x00);  /* Set Baud rate - Divisor Latch High Byte */
 outportb(PORT1 + 3 , 0x03);  /* 8 Bits, No Parity, 1 Stop Bit */
 outportb(PORT1 + 2 , 0xC7);  /* FIFO Control Register */
 outportb(PORT1 + 4 , 0x0B);  /* Turn on DTR, RTS, and OUT2 */

 printf("\nuDrive Show Root Directory (COM1, 19200 baud). Press ESC to quit.\n");

 outportb(PORT1, 'U');   /* uDrive Autobaud handshake */

 key=0x00;

 do { c=inportb(PORT1 +5);    /* check if byte was received */

   if (c & 1) {
     ch = inportb(PORT1); /* get the byte itself */
     /* printf("%c",ch); fflush(stdout);  */
   }
   if (kbhit()) key=getch();
 } while ((key != 27) & !(c & 1));

 if (ch!=0x06) {
   puts("Wrong response when sending handshake 'U'");
   exit(1);
 }

 outportb(PORT1, '@');   /* command begin */
 outportb(PORT1, 'd');   /* d = directory */
 outportb(PORT1, '*');   /* filemask      */
 outportb(PORT1, 0x00);  /* string terminator */

 key = 0x00;
 ch = 0x00;

 do {
      c = inportb(PORT1 +5);           /* Check to see if char has been */
				       /* received.                     */
      if (c & 1) {
	ch = inportb(PORT1);           /* If so, then get Char          */
	if (ch!=0x06)
	  printf("%c",ch);
      }    /* Print Char to Screen if not Ack Char */

      if (kbhit()) key = getch();       /* If key pressed, get Char */

    } while ((key !=27) & (ch!=0x06));  /* Quit when ESC (ASC 27) is pressed */

}
