// Program try to get a webpage from 2 given URLs
// if the first one is successful, start IE with Parameterset 1
// if the second one is successful, start IE with Parameterset 2
// if nothing can be loaded, start IE without changes
// Peter Dassow, July 2009 @ www.z80.eu
// feel free to use the source code for your own projects
// but mention me always if you do so ! Sounds fair, or ?

unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, idHttp, TLHelp32, ShellAPI, Registry, StdCtrls; // idIPWatch

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Edit2: TEdit;
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;
  URL1,URL2: String;
  DebugSwitch: Boolean;
  EXEFileName: String;
  EXEFilePath: String;

implementation

{$R *.dfm}

{ this function tries to get a page from the given URL   }
{ ATTENTION: Page size is NOT tested, do NOT try to download big pages > 64KB }
function GetPage(URL:string):string;
var IdHTTP1:TIdHTTP;
    PageContent:String;
begin
  IdHTTP1 := TIdHTTP.Create(nil);
  try
    try
      PageContent:=IdHTTP1.Get(URL); // HttpGet auf die URL
    except
      PageContent:='';
    end;
  finally
    IdHTTP1.Free;
  end;
  GetPage:=PageContent;
end;

{ execute a program, wait for completition }
function ExecuteFile(const FileName, Params, DefaultDir: string; ShowCmd: Word): Integer;
var
  Info: TShellExecuteInfo;
  bOk:Boolean;
begin
  FillChar(Info, SizeOf(Info), Chr(0));
  Info.cbSize := SizeOf(Info);
  Info.fMask := SEE_MASK_NOCLOSEPROCESS;
  Info.lpVerb := PChar('Open');
  Info.lpFile := PChar(Filename);
  Info.lpParameters := PChar(Params);
  Info.lpDirectory := PChar(DefaultDir);
  Info.nShow := ShowCmd;
  bOk := ShellExecuteEx(@Info);
  if bOk then
  begin
    while
     WaitForSingleObject(Info.hProcess, 100) = WAIT_TIMEOUT
    do Application.ProcessMessages;
    bOk := GetExitCodeProcess(Info.hProcess, DWORD(Result));
  end;
  if not bOK then Result:= -1;
end;

procedure ShowDebug(msgstr:string);
begin
  if DebugSwitch then
    MessageDlg(msgstr, mtInformation, [mbOk], 0);
end;

procedure TForm1.FormActivate(Sender: TObject);
var
  //  IdIPWatch1 : TIdIPWatch;
  WhatProxyNo: integer;
  Registry: TRegistry;
  SavedString: String;
  PageContent: String;
begin
  // if any logic is wanted depending on the local IP address:
  // IdIPWatch1 := TIdIPWatch.Create(nil);
  // Variable_Name:=IdIPWatch1.LocalIP;

  URL1:=Edit1.Text; // just for visual control, can be deleted later
  URL2:=Edit2.Text; // just for visual control, can be deleted later

  // HERE, ONLY INTERNET EXPLORER IS COVERED !!!
  // Firefox does not store settings in the Registry
  // instead, it's an assignment in prefs.js (textfile)
  // prefs.js can be found deeper in %AppData%\\Mozilla\\Firefox\\Profiles\\xxxxx
  // xxxxx path is stored in profiles.ini
  // inside prefs.js, it's stored in the following line:
  // user_pref("network.proxy.autoconfig_url", "http://URL_for_PAC_file/");

  WhatProxyNo:=0;
  PageContent:=GetPage(URL1);
  if Length(PageContent)>0 then
  begin
    ShowDebug('Get PAC from:'+URL1);
    WhatProxyNo:=1;
  end
  else begin
    PageContent:=GetPage(URL2);
    if Length(PageContent)>0 then
    begin
      ShowDebug('Get PAC from:'+URL2);
      WhatProxyNo:=2;
    end else
    begin // can't get from any given URL any page
      ShowDebug('Can''t reach any given proxy address.');
    end;
  end;

  Registry:=TRegistry.Create;
  Registry.Rootkey:=HKEY_CURRENT_USER;
  Registry.OpenKeyReadOnly('Software\Microsoft\Windows\CurrentVersion\Internet Settings');
  SavedString:=Registry.ReadString('AutoConfigURL');
  ShowDebug('Current AutoConfigURL value:'+SavedString);
  Registry.CloseKey;
  Registry.Free;

  Registry:=TRegistry.Create;
  Registry.Rootkey:=HKEY_CURRENT_USER;

  // WhatProxyNo >0 then start IE without or with new Download URL
  if WhatProxyNo=1 then
  begin
    ShowDebug('Change Registry to Proxy Pac 1:'+URL1);
    if Registry.OpenKey('Software\Microsoft\Windows\CurrentVersion\Internet Settings',True) then
      Registry.WriteString('AutoConfigURL',URL1)
    else
      ShowDebug('OpenKey failed');
    Registry.CloseKey;
  end else if WhatProxyNo=2 then
  begin
    ShowDebug('Change Registry to Proxy Pac 2:'+URL2);
    if Registry.OpenKey('Software\Microsoft\Windows\CurrentVersion\Internet Settings',True) then
      Registry.WriteString('AutoConfigURL',URL2)
    else
      ShowDebug('OpenKey failed');
    Registry.CloseKey;
  end
  else
    ShowDebug('Nothing changed.');

  ExecuteFile(EXEFileName,paramstr(1)+' '+paramstr(2)+' '+paramstr(3),EXEFilePath,SW_SHOWNORMAL);

  if WhatProxyNo>0 then
  begin
    ShowDebug('Change Registry back to '+SavedString);
    Registry.OpenKey('Software\Microsoft\Windows\CurrentVersion\Internet Settings',True);
    Registry.WriteString('AutoConfigURL',SavedString);
  end;
  Registry.Free;
  Application.Terminate;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  Registry: TRegistry;
begin
  Registry:=TRegistry.Create;
  Registry.Rootkey:=HKEY_CURRENT_USER;

  if Registry.OpenKeyReadOnly('Software\ProxyFailover') then
  begin
    DebugSwitch:=Registry.ReadBool('DebugSwitch');
    URL1:=Registry.ReadString('URL1');
    URL2:=Registry.ReadString('URL2');
    EXEFileName:=Registry.ReadString('EXEFILENAME');
    EXEFilePath:=Registry.ReadString('EXEFILEPATH');
    ShowDebug('URL1:'+URL1+Chr(13)+Chr(10)+'URL2:'+URL2);
    ShowDebug('EXEFILEPATH,EXEFILENAME:'+EXEFilePath+','+EXEFileName);
  end
  else
  begin
    MessageDlg('ProxyFailover: Missing Registry entries, taking program defaults.',
               mtWarning, [mbOk], 0);
// ------------------------------------------------------------
// change here your default proxy server below (2 times)
// ------------------------------------------------------------
    URL1:='http://proxyserver1/accelerated_pac_base.pac';
    URL2:='http://proxyserver2/accelerated_pac_base.pac';
// ------------------------------------------------------------
    EXEFileName:='iexplore.exe';
    EXEFilePath:='%ProgramFiles%\\Intern~1';
  end;
  // Form1.borderstyle must changed at design time (not runtime!):
  // bsSizeable does not do the trick, however, bsDialog will do
  // do not know why, but it works
  // take a look inside the .dpr file !

  Edit1.Text:=URL1; // just for visual control, can be deleted later
  Edit2.Text:=URL2; // just for visual control, can be deleted later

end;

end.

