unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, Grids;

type
  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;
    BitBtn1: TBitBtn;
    Edit1: TEdit;
    Edit2: TEdit;
    Label1: TLabel;
    Edit4: TEdit;
    Label3: TLabel;
    Edit6: TEdit;
    Label7: TLabel;
    Label8: TLabel;
    Edit3: TEdit;
    Label4: TLabel;
    Memo1: TMemo;
    Button1: TButton;
    Label6: TLabel;
    BitBtn2: TBitBtn;
    Label2: TLabel;
    Edit5: TEdit;
    CheckBox1: TCheckBox;
    Label5: TLabel;
    procedure BitBtn1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Memo1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure Label2Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;
const SECSIZE = 256;         // this is the default for both formats
      D64_DOSDIRTRACK = 18;  // this track is always reserved
      CPM_SECSPERTRACK = 17; // for the whole disk
      CPM_SYSTRACKSECS = 21; // for the first two tracks only
      DIR_SECTORS = 8;
      DIR_ENTRIES = 64;

type allocvector = Array [0..15] of smallint;
var
  Form1: TForm1;
  blkbuf:array [0..1023] of byte;
  D64_SectorStart: Array [1..40] of longint;
  D64_SecsPerTrack: Array [1..40] of smallint;
  DIR_filename: Array [0..63] of string[12];
  DIR_extendno: Array [0..63] of smallint;
  DIR_parent: Array [0..63] of smallint;
  DIR_numberofextends: Array [0..63] of smallint;
  DIR_records: Array [0..63] of smallint;
  DIR_filesize: Array [0..63] of longint;
  DIR_allocunits: Array [0..63] of allocvector;
  totalallocunits: Integer;
  restallocunits: Integer;
  totaldirentries: Integer;
  experimental_write: boolean;

implementation

{$R *.dfm}

function SpacedStringR(str:string;lenstr:integer):string;
begin
  SpacedStringR:=StringOfChar(' ', lenstr-Length(str))+str;
end;

function SpacedStringL(str:string;lenstr:integer):string;
begin
  SpacedStringL:=str+StringOfChar(' ', lenstr-Length(str));
end;

function TempFileName : String;

const Unique : word = 0;

var pTempFileName : pchar;
    pTempFilePath : pchar;
    dummy         : word;
    Prefix : pChar;

begin
 Prefix := 'TMP';
 pTempFileName := StrAlloc(256);
 pTempFilePath := StrAlloc(256);
 dummy := GetTempPath(256,pTempFilePath);
 dummy := GetTempFileName(pTempFilePath, PreFix, Unique, pTempFileName);
 TempFileName := strpas(pTempFileName);
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
var secbuf:array [0..255] of char;
    result,i,j,k,dirsecs:integer;
    curr_direntry:integer;
    fname:string;
    F:File of char;
begin
  OpenDialog1.Filter:='D64-Files|*.D64|All|*.*';
  if OpenDialog1.Execute then
  begin
    Edit1.Text:=OpenDialog1.FileName;
    { StringGrid1.Clear fehlt }
    curr_direntry:=1;
    AssignFile(F,Edit1.Text);
    FileMode := 0;  {Set file access to read only }
    Reset(F);
    BlockRead(F,secbuf,SECSIZE,result);
    if result<SECSIZE then
      ShowMessage('Sector 0 read error')
    else
    begin
      // a few integrity checks must be there
      if not ((secbuf[$0A]='2') and (secbuf[$0B]='0') and
         (secbuf[$0C]='6') and (secbuf[$0D]='3')) then
         ShowMessage('Probably not an original C64 CP/M diskette !');
      // length of the file should also be validated (170 KB)
      // is missing here, do it later !
    end;
    memo1.Clear;
    totalallocunits:=0;
    totaldirentries:=0;
    for i:=0 to DIR_ENTRIES do
    begin
      DIR_filename[i]:='';
      DIR_extendno[i]:=0;
      DIR_filesize[i]:=0;
      DIR_records[i]:=0;
      DIR_parent[i]:=i;
      DIR_numberofextends[i]:=0;
      for j:=0 to 15 do
        DIR_allocunits[i][j]:=0;
    end;
    // very important position, the start of the directory
    Seek(F,SECSIZE*StrToInt(edit4.text)*CPM_SYSTRACKSECS);

    for dirsecs:=1 to DIR_SECTORS do
    begin
      BlockRead(F,secbuf,SECSIZE,result);
      if result<SECSIZE then // why not, but check it always
       ShowMessage('Directory read error')
      else
      begin
        for i:=0 to StrToInt(edit3.text)-1 do // default = 8 dir entries
        begin
          if Ord(secbuf[i*32])<>$E5 then // not deleted/unused dir slot
          begin
            fname:=''; // initial value
            for j:=1 to 8 do
              if Ord(secbuf[j+i*32])<32 then
                fname:=fname+'?'
              else if Ord(secbuf[j+i*32])>32 then
                fname:=fname+secbuf[j+i*32];

            fname:=fname+'.';

            for j:=9 to 11 do
              if Ord(secbuf[j+i*32])<32 then
                fname:=fname+'?'
              else if Ord(secbuf[j+i*32])>32 then
                fname:=fname+secbuf[j+i*32];

            DIR_filename[curr_direntry-1]:=fname;

            if ord(secbuf[12+i*32])<>0 then
            begin
              DIR_extendno[curr_direntry-1]:=ord( secbuf[12+i*32] );
            end;

            if ord(secbuf[15+i*32])<>0 then
            begin
              DIR_records[curr_direntry-1]:=ord( secbuf[15+i*32] );
            end;

            DIR_filesize[curr_direntry-1]:= ord(secbuf[15+i*32])*128;

            for k:=0 to 15 do
            begin
              if ord(secbuf[16+k+i*32])<>0 then
              begin
                DIR_allocunits[curr_direntry-1][k]:=ord( secbuf[16+k+i*32] );
                inc(totalallocunits);
              end;
            end; // end for
            curr_direntry:=curr_direntry+1;
          end; { dirslot seems to be used }
        end;
      end; { sector read was ok }
    end; { for dirsecs }
    CloseFile(F);
    // find the files with more than one "Extend"
    totaldirentries:= curr_direntry-1;

    for i:=0 to totaldirentries-1 do
    begin
      if DIR_extendno[i]>0 then
      begin
        for j:=0 to totaldirentries-1 do
          if (DIR_filename[i]=DIR_filename[j]) and (DIR_extendno[j]=0) then
          begin
//          ShowMessage(DIR_filename[i]+' has an EXTEND. Size was='+IntToStr(DIR_filesize[j])+
//                      ' and '+IntToStr(DIR_filesize[i])+' will be added.');
            DIR_filesize[j]:=DIR_filesize[j]+DIR_filesize[i];
            DIR_filesize[i]:=0;
            DIR_parent[i]:=j;
            inc(DIR_numberofextends[j]);
          end;
      end;
    end;
    // now show all relevant directory entries in the memo field
    for i:=0 to totaldirentries-1 do
    begin
      if DIR_extendno[i]=0 then
        Memo1.Lines.Add(SpacedStringL(DIR_filename[i],14)+SpacedStringR(IntToStr(DIR_filesize[i]),6)+' Bytes '+SpacedStringR(IntToStr(DIR_records[i]),3)+' Records')
      else
        Memo1.Lines.Add('*'+SpacedStringL(DIR_filename[i],12)+'   (Extend '+IntToStr(DIR_extendno[i])+') '+SpacedStringR(IntToStr(DIR_records[i]),3) +' Records'); // show Extends with '*'
    end;
    Memo1.SetFocus;
    Memo1.SelStart:=0;
    Memo1.Perform(EM_SCROLLCARET, 0, 0);
    Edit2.Text:=IntToStr(totalallocunits);
    restallocunits:=134-totalallocunits;
    Edit5.Text:=IntToStr(restallocunits);
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var i:integer;
    startaddr:longint;
begin
  startaddr:=0;
  for i:=1 to 17 do
  begin
    D64_SectorStart[i]:=startaddr;
    D64_SecsPerTrack[i]:=21;
    startaddr:=startaddr+21*SECSIZE;
  end;
  for i:=18 to 24 do
  begin
    D64_SectorStart[i]:=startaddr;
    D64_SecsPerTrack[i]:=19;
    startaddr:=startaddr+19*SECSIZE;
  end;
  for i:=25 to 30 do
  begin
    D64_SectorStart[i]:=startaddr;
    D64_SecsPerTrack[i]:=18;
    startaddr:=startaddr+18*SECSIZE;
  end;
  for i:=31 to 40 do
  begin
    D64_SectorStart[i]:=startaddr;
    D64_SecsPerTrack[i]:=17;
    startaddr:=startaddr+17*SECSIZE;
  end;
  experimental_write:=False;
end;

procedure TForm1.Label2Click(Sender: TObject);
begin

end;

// Row = Linenumber of current Memo1 cursor position -1
//       or better, Index of DIR_* arrays
procedure ClickOnLine(Row:integer);
var fname,tmpfname:string;
    startAU,cpmtrack,d64_start,rest,totalextends:integer;
    result,blksize,extends,i,j,k,DirIndex:integer;
    FR,FW:File;
begin
  fname:=DIR_Filename[Row];
  if not (fname='') then
  begin
    totalextends:=0;
    tmpfname:=TempFileName;
    AssignFile(FW,tmpfname);
    ReWrite(FW,1);
    for j:=0 to DIR_numberofextends[Row] do
    begin
      for k:=0 to DIR_ENTRIES-1 do
        if (DIR_extendno[k]=j) and (DIR_Parent[k]=Row) then
        begin
          // ShowMessage('Directory Slot '+IntToStr(k)+' must be used now.');
          DirIndex:=k;
          // extends = 128 Byte-Records
          extends:=DIR_records[DirIndex];
          totalextends:=totalextends+extends;

          AssignFile(FR,Form1.Edit1.Text); // disk image file
          FileMode := 0;  {Set file access to read only }
          Reset(FR,1);

          for i:=0 to 15 do
          begin
            if DIR_allocunits[DirIndex][i]>0 then
            begin
              startAU:=DIR_allocunits[DirIndex][i];
              cpmtrack:=StrToInt(Form1.edit4.text)+1+(startAU*4) DIV CPM_SECSPERTRACK;
              rest:=(startAU*4) MOD CPM_SECSPERTRACK;
              if cpmtrack>=D64_DOSDIRTRACK then
                cpmtrack:=cpmtrack+1; // because CMBDOS dir track reached
              D64_start:=D64_SectorStart[cpmtrack]+rest*SECSIZE;

              // ShowMessage('D64 Byteadr Block '+IntToStr(i)+' (T:'+IntToStr(cpmtrack)+',S:'+IntToStr(rest)+'):'+IntToStr(D64_Start));
              // D64_SecsPerTrack[cpmtrack] must be processed to wrap at the end of the CPM track to the next track
              // D64 track is most of the time bigger than the CPM track !

              Seek(FR,D64_start);
              case rest of
               14:blksize:=768;
               15:blksize:=512;
               16:blksize:=256;
              else
                blksize:=1024;
              end;
              BlockRead(FR,blkbuf,blksize,result);
              BlockWrite(FW,blkbuf,blksize,result);
              if blksize<1024 then
              begin
                cpmtrack:=cpmtrack+1;
                // exception here: if track reached is the CBMDOS dir track
                // it must be incremented again to jump over this track
                if cpmtrack=D64_DOSDIRTRACK then cpmtrack:=cpmtrack+1;
                Seek(FR,D64_SectorStart[cpmtrack]);
                BlockRead(FR,blkbuf,1024-blksize,result);
                BlockWrite(FW,blkbuf,1024-blksize,result);
              end;
            end;
          end; // for 0..15 (allocunits)
          CloseFile(FR);
        end; // end if DIR_extendno fits
    end; // for DIR_numberofextends[]
    CloseFile(FW);
    // now truncate the file if necessary
    AssignFile(FR,tmpfname);
    AssignFile(FW,fname);
    Filemode:=0;
    Reset(FR,1);
    ReWrite(FW,1);
    for i:=1 to totalextends do
    begin
      Blockread(FR,blkbuf,128,result);
      BlockWrite(FW,blkbuf,128,result);
    end;
    CloseFile(FW);
    CloseFile(FR);
    DeleteFile(tmpfname);
    ShowMessage('File '+fname+' written.');
end; // fname was valid
end;

// returns -1 if not allocated,
// returns positive number of the direntry if allocated
function is_allocated(lookup_allocunit:smallint):integer;
var direntrynumber:integer;
    i,j:integer;
begin
        direntrynumber:= -1;
        // probe a block
        i:=0;
        while ((i<DIR_ENTRIES) and (direntrynumber= -1)) do
        begin
          for j:=0 to 15 do // max blocks per DIR entry = 16
            if DIR_allocunits[i][j]=lookup_allocunit then
            begin
              direntrynumber:=i;
              break;
            end;
          inc(i);
        end;

        is_allocated:=direntrynumber;
end;

procedure TForm1.Memo1Click(Sender: TObject);
var lineno,i:integer;
begin
  lineno:=0;
  for i:=1 to Memo1.SelStart do
   if Copy(Memo1.Text,i,1)=Chr(13) then Inc(lineno);
  if DIR_filename[lineno]<>'' then
  begin
    if DIR_extendno[lineno]>0 then
      ShowMessage('This is a directory slot extend, use an other entry. Thanks.')
    else
      if MessageDlg('Extract '+DIR_filename[lineno]+' ?',mtConfirmation, [mbYes, mbNo],0)=mrYes then
        ClickOnLine(lineno);
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
var TmpStart:integer;
begin
  TmpStart:=Memo1.SelStart;
  Memo1.SelectAll;
  Memo1.CopyToClipboard;
  Memo1.SetFocus;
  Memo1.SelStart:=TmpStart;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  experimental_write:=NOT experimental_write;
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
var tmpfname,filename_filledup:string;
    FR,FW:FILE of char;
    CH:char;
    i,j,l,allocating,rest_of_file,result:integer;
    cpmtrack,rest_sec,D64_Start,blksize:integer;
    fsize:longint;
    direntrynumber:integer;
    lookup_block:smallint;
begin
  OpenDialog1.Filter:='CP/M files (8+3 naming convention !)|*.*';
  if OpenDialog1.Execute then
  begin
    tmpfname:=OpenDialog1.FileName;
    l:=Length(tmpfname);
    i:=l;
    while i>0 do
    begin
      if tmpfname[i]='\' then break;
      dec(i);
    end;
    if i>0 then
    begin
      tmpfname:=Copy(tmpfname,i+1,l-i);
    end;
    if Length(tmpfname)>12 then
      ShowMessage('Filename too long ('+IntToStr(Length(tmpfname))+'). Please rename it.')
    else if Edit1.Text='none' then
    begin
      ShowMessage('Pick a .D64 file first.')
    end
    else
    begin
      // First: Lookup filename to find the same name
      for i:=0 to totaldirentries-1 do
        if DIR_filename[i]=tmpfname then
        begin
          MessageDlg('Filename is already in use.',mtWarning,[mbOK],0);
          break;
        end;
      if i=totaldirentries then ShowMessage('Filename is not used, going on...');
      // The above line is just a reminder !

      AssignFile(FR,tmpfname);  // filename of file to add
      FileMode := 0;  {Set file access to read only }
      Reset(FR);
      fsize:=Filesize(FR);
      if restallocunits*1024-fsize<0 then
      begin
        ShowMessage(tmpfname+' is too big to fit onto the floppy image. Maximum is '+IntToStr(restallocunits*1024)+' KB.');
        CloseFile(FR);
      end
      else
      begin
        allocating:=fsize DIV 1024;
        rest_of_file:=1024-(fsize MOD 1024);
        // if not exactly modulo 1024, add an allocating unit
        if rest_of_file<>0 then allocating:=allocating+1;

        ShowMessage(tmpfname+' has '+IntToStr(allocating)+' alloc units.'+
                    chr(13)+chr(10)+'Rest (in 1024''er steps):'+IntToStr(rest_of_file));

        if experimental_write then
        begin
//        is an idea is to fill up the file to a rounded size in block size steps
          filename_filledup:=TempFileName;
          AssignFile(FW,filename_filledup);
          ReWrite(FW);  // new file
          while (not EOF(FR)) do
          begin
            Read(FR,CH);
            Write(FW,CH);
          end;
          CH:=Chr(26);
          for i:=1 to rest_of_file do  // fill the rest of the file with Ctrl-Z
          begin
            Write(FW,CH);
          end;
          CloseFile(FW);
          CloseFile(FR);
          ShowMessage('Temporary file "'+filename_filledup+'" generated.');

          AssignFile(FR,filename_filledup);
          FileMode := 0;  {Set file access to read only }
          Reset(FR);  // FR is still the file which should be added
        end;

        // lookup first free allocation unit
        //
        // DIR_allocunits[0-63][0-15] contents all used entries
        // after going through all entries it should be clear
        // what entries are NOT used - this is done in a function above
        //
        direntrynumber:= -1;
        for i:=2 to 134 do
        begin
          direntrynumber:=is_allocated(i);
          if direntrynumber= -1 then break; // first free one
        end;

        if direntrynumber>0 then
          MessageDlg('No free block !'+chr(13)+chr(10)+'(unknown reason - this should not occur)',mtWarning, [mbOk],0)
        else
          ShowMessage('First unallocated block:'+IntToStr(i));

        // we have now the first block which could be used
        // 'i' is the block number

        // calculate the CP/M track number first
        cpmtrack:=StrToInt(Form1.edit4.text)+1+(i*4) DIV CPM_SECSPERTRACK;
        // sector number
        rest_sec:=(i*4) MOD CPM_SECSPERTRACK;

        // test if CBMDOS directory track is used
        // if CBMDOS track, jump over it (+1)
        if cpmtrack>=D64_DOSDIRTRACK then
          cpmtrack:=cpmtrack+1;

        // calculate D64 image file address
        D64_start:=D64_SectorStart[cpmtrack]+rest_sec*SECSIZE;

        ShowMessage('D64 Byteadr Block '+IntToStr(i)+' (T:'+IntToStr(cpmtrack)+',S:'+IntToStr(rest_sec)+'):'+IntToStr(D64_Start));
        // D64_SecsPerTrack[cpmtrack] must be processed to wrap at the end of the CPM track to the next track
        // the D64 track has most of the time more sectors than the CPM track !!

        if experimental_write then
        begin
          AssignFile(FW,Edit1.text);  // filename of file to add
          FileMode := 2;  {Set file access to read-write }
          Reset(FW);  // of course NOT Rewrite() !

          Seek(FW,D64_start); // goto position in image file
        end;

        case rest_sec of  // calculate the blocksize on the track which could fit
          14:blksize:=768;
          15:blksize:=512;
          16:blksize:=256;
        else
          blksize:=1024; // else whole first block of file fits
        end;

        if experimental_write then
        begin
          BlockRead(FR,blkbuf,blksize,result);  // read one block of the file
          BlockWrite(FW,blkbuf,blksize,result);  // write one block into disk image which fits on the track
        end;

        if blksize<1024 then
        begin
          cpmtrack:=cpmtrack+1;
          // exception here: if track reached is the CBMDOS dir track
          // it must be incremented again to jump over this track
          if cpmtrack=D64_DOSDIRTRACK then cpmtrack:=cpmtrack+1;

          ShowMessage('D64 Byteadr (Rest) Blocksize '+IntToStr(blksize)+' (T:'+IntToStr(cpmtrack)+',S:0):' +IntToStr(D64_SectorStart[cpmtrack]) );
        end;

        if experimental_write then
        begin
          // goto the next proper start address of a cp/m track
          Seek(FW,D64_SectorStart[cpmtrack]);
          // read the rest of the first block
          BlockRead(FR,blkbuf,1024-blksize,result);
          // write the rest of the first block
          BlockWrite(FW,blkbuf,1024-blksize,result);
          ShowMessage('ToDo: Writing the rest of file missing ! Writing allocation missing ! Writing directory entry missing !');
          // ******************************************************************
          // many (important) things missing here:
          //
          // reading the rest of the file and writing it to the image file
          // writing the allocation of the blocks
          // writing the directory entry into image (and in all variables here)
          //
          CloseFile(FW);
        end;

        CloseFile(FR);

      end;              // else-Branch of file doesn't fit
    end;
  end;
end;

end.
