program IDE_Test_Programme;

(* written Q&D 920308 by Tilmann Reh *)
(* some modifications during 1992 & 1993 *)
(* translated and adapted to GIDE 950403 Tilmann Reh *)
(* variable base address added 951015 Tilmann Reh *)
(* added support for both ECB-IDE and GIDE by condition, 960204 TR *)
(* adding device select plus first ATAPI features 26 Mar 2000 Shawn Sijnstra *)
(* Preliminaries for extra ATAPI featurs 000327 SS *)
(* Implementing ATAPI features plus extra bits 000328-000331 SS bugs still exist *)
(* April 3 - more specific ATAPI stuff, April 4 expanded error messages *)
(* and added further functions - start/stop/eject, switchable delays *)
(* and also separated out functions into separate file *)

const  signon = ^m^j'IDE Harddisk Utility V0.9 000405 SS'^m^j'Originally by Tilman Reh'^m^j;

(* default geometry of connected harddisk *)
(* here: default mode Seagate ST3120A *)
(* enter real dimension, not maximum value! *)

const  cylinders   : integer = 1023;
       heads       : integer = 12;
       sectors     : integer = 17;

(* I/O addresses and commands of the IDE interface/drive *)
(* The I/O addresses are user selectable in steps of $10 *)

       GIDEbase    : integer = $80;   (* GIDE base address *)
       ECB_IDE     : boolean = false; (* ECB-Bus IDE I/F   *)

       cmd_readsector  = $20;
       cmd_writesector = $30;
       cmd_seek        = $70;
       cmd_diagnostics = $90;
       cmd_initialize  = $91;
       cmd_identify    = $EC;

       atapi_softreset = $08;
       atapi_identify  = $A1;
       atapi_command   = $A0;

       scsi_inquiry    = $12;
       scsi_startstop  = $1B;
       scsi_read       = $28;  (* 10 byte instruction version *)
       scsi_write      = $2A;  (* 10 byte - future expansion *)

(* variables *)

type   workstr        = string[30];
       buftype        = array[0..2047] of byte;
       str            = string[80];
       ATAPI_cmd_type = array[0..11] of byte;
       IDRecord       = record
                         config       : integer;
                         NumCyls      : integer;
                         NumCyls2     : integer;
                         NumHeads     : integer;
                         BytesPerTrk  : integer;
                         BytesPerSec  : integer;
                         SecsPerTrack : integer;
                         d1,d2,d3     : integer;
                         SerNo        : array [0..19] of char;
                         CtrlType     : integer;
                         BfrSize      : integer;
                         ECCBytes     : integer;
                         CtrlRev      : array [0..7] of char;
                         CtrlModl     : array [0..39] of char;
                         SecsPerInt   : integer;
                         DblWordFlag  : integer;
                         WrProtect    : integer;
                         res1         : integer;
                         PIOtiming    : integer;
                         DMAtiming    : integer;
                         res2         : integer;
                         CurCyls      : integer;
                         CurHeads     : integer;
                         CurSPT       : integer;
                        end;
       InquiryRecord  = record
                         res1         : array [0..7] of byte;
                         Manufacturer : array [0..7] of char;
                         Product      : array [0..15] of char;
                         Revision     : array [0..3] of char;
                         res2         : array [0..219] of byte;
                        end;
       CDRecord = record
                         cdtype       : byte;
                         id           : array [0..5] of char;
                         version      : byte;
                         res1         : byte;
                         system_id    : array [0..31] of char;
                         volume_id    : array [0..31] of char;
                         res2         : array [0..7] of byte;
                        end;

var    Alt_Status,IDE_Data,IDE_Error,
       IDE_SecCnt,IDE_SecNum,IDE_CylLow,
       ATAPI_CountLow,ATAPI_CountHigh,
       IDE_CylHigh,IDE_SDH,IDE_CmdStat : integer;

       secbuf,bakbuf   : buftype;
       i,j,k,l,m       : integer;
       func,c          : char;
       err,delayed     : boolean;
       timeouts        : boolean;
       s               : workstr;
       select          : byte;

(* use our own console status routine, since the one implemented in *)
(* Turbo-Pascal won't detect the "keypressed" status properly.      *)

function ConStat:boolean;
begin
  ConStat:=BIOS(1)>0;
  end;

(* translate numbers into their hex representation (as string). *)

function hexbyte(x:byte):workstr;
const nib : array[0..15] of char = '0123456789ABCDEF';
begin
  hexbyte:=nib[x shr 4]+nib[x and 15];
  end;

function hexword(x:integer):workstr;
begin
  hexword:=hexbyte(hi(x))+hexbyte(lo(x));
  end;


(* Set the port addresses for the various interface registers. *)
(* The addresses are kept in variables since they can be       *)
(* changed during run-time.                                    *)

procedure SetPorts(var base:integer);
begin
  base:=base and $F0;
  Alt_Status:=base+6;
  IDE_Data:=base+8;
  IDE_Error:=base+9;
  IDE_SecCnt:=base+10;
  IDE_SecNum:=base+11;
  IDE_CylLow:=base+12;
  ATAPI_CountLow:=base+12;
  IDE_CylHigh:=base+13;
  ATAPI_CountHigh:=base+13;
  IDE_SDH:=base+14;
  IDE_CmdStat:=base+15;
  write('Ports setup for ');
  if ECB_IDE then write('ECB-') else write ('G');
  write('IDE at base ',HexByte(base),'h, ');
  if ((select and 16) = 16) then write('slave') else write('master');
  writeln(' device selected.');
  write('Read delay is ');
  if delayed then write('on') else write('off');
  write(', time-outs are ');
  if timeouts then writeln('on.') else writeln('off.');
  end;


(* Translate an ARRAY OF CHAR from the drive into a Pascal-usable string. *)
(* (character pairs must be swapped for this.)                            *)

function st(s:str):str;
var s1 : str;
    i  : byte;
begin
  s1[0]:=s[0];
  for i:=0 to pred(length(s)) do s1[i+1]:=s[(i xor 1)+1];
  st:='>'+s1+'<';
end;

(* display error status *)

procedure Error(s:workstr; flag:boolean);
var i,j : byte;
begin
  i := port[ide_cmdstat];
  j := port[ide_error];
  writeln('  ',s,'; Status: ',hexbyte(i),
          ', Error: ',hexbyte(j));
  if flag then begin
    write('Status flags:');
      if (i and $80) = $80 then write (' BSY'); (* Busy *)
      if (i and $40) = $40 then write (' DRDY'); (* Drive Ready *)
      if (i and $20) = $20 then write (' DF'); (* Drive Fault *)
      if (i and $10) = $10 then write (' DSC'); (* Drive Seek Complete *)
      if (i and $08) = $08 then write (' DRQ'); (* Data Request *)
      if (i and $04) = $04 then write (' CORR'); (* Corrected Data *)
      if (i and $02) = $02 then write (' IDX'); (* Index *)
      if (i and $01) = $01 then write (' ERR'); (* Error *)
    write(^m^j,'Error flags (ATA):');
      if (j and $80) = $80 then write (' BBK'); (* Bad block detected *)
      if (j and $40) = $40 then write (' UNC'); (* Uncorrectable data error *)
      if (j and $20) = $20 then write (' MC'); (* Media Change *)
      if (j and $10) = $10 then write (' IDNF'); (* ID not found *)
      if (j and $08) = $08 then write (' MCR'); (* Media Change Requested *)
      if (j and $04) = $04 then write (' ABRT'); (* Aborted Command *)
      if (j and $02) = $02 then write (' TK0NF'); (* Track 0 Not Found *)
      if (j and $01) = $01 then write (' AMNF'); (* Address Mark Not Found *)
    write(^m^j,'Error flags (ATAPI): SCSI sense key ',(j shr 4),';');
      if (j and $08) = $08 then write (' MCR'); (* Media Change Requested *)
      if (j and $04) = $04 then write (' ABRT'); (* Aborted Command *)
      if (j and $02) = $02 then write (' EOM'); (* End Of Medium *)
      if (j and $01) = $01 then write (' ILI'); (* Illegal Length *)
    writeln('');
    halt;
    end;
end;

(* Wait until the drive is ready to accept a command.       *)
(* The timeout value may be changed according to the drive. *)
(* Remove the "i:=succ(i)" instruction to disable timeout.  *)

procedure wait_ready;
const timeout = 32000;
var i : integer;
begin
  i:=0;
  while (port[ide_cmdstat]>128) and (i<timeout) do if timeouts then i:=succ(i);
  if i=timeout then Error('WaitReady TimeOut',true);
  end;

(* Wait for the drive's Data Request (DRQ). *)
(* For the timeout, see above.              *)

procedure wait_drq;
const timeout = 32000;
var i : integer;
begin
  i:=0;
  while (port[ide_cmdstat] and 8=0) and (i<timeout) do if timeouts then i:=succ(i);
  if i=timeout then Error('WaitDRQ TimeOut',true);
  end;

procedure long_wait_drq;
begin
  while (port[ide_cmdstat] and 8=0) do;
  end;

(* write a command to the drive *)

procedure ide_command(cmd:byte);
begin
  wait_ready;
  port[ide_cmdstat]:=cmd;
  wait_ready;
  end;

(* Read the sector buffer from the drive. *)

function read_secbuf(var buf:buftype):boolean;
var i,j,k : integer;
begin
  wait_drq;
  if ECB_IDE then i:=port[ide_data]; (* ECB version: this sets LH *)
  for i:=0 to 511 do begin
   if delayed then for k:= 0 to 100 do j:= succ(k);
  buf[i]:=port[ide_data];
  end;
  read_secbuf:=port[ide_cmdstat] and $89=0;
  end;

(* Read half size sector buffer from the drive. *)

function read_halfbuf(var buf:buftype):boolean;
var i,j,k : integer;
begin
  wait_drq;
  j := 0;
  if ECB_IDE then i:=port[ide_data]; (* ECB version: this sets LH *)
  for i:=0 to 255 do begin
   if delayed then for k:= 0 to 100 do j:= succ(k);
   buf[i]:=port[ide_data];
   end;  (* maybe wait on INTRQ then DRQ each time? *)
  read_halfbuf:=port[ide_cmdstat] and $89=0;
  end;

(* Read 2k block buffer from the drive. *)

function read_bigsecbuf(var buf:buftype):boolean;
var i,j,k : integer;
begin
  wait_drq;
  (* if ECB_IDE then i:=port[ide_data];  ECB version: this sets LH *)
  for i:=0 to 2047 do begin
   if delayed then for k:= 0 to 100 do j:= succ(k);
   buf[i]:=port[ide_data];
   end;
  wait_ready;
  read_bigsecbuf:=port[ide_cmdstat] and $89=0;
  end;

(* Write the sector buffer to the drive. *)

function write_secbuf(var buf:buftype):boolean;
var i : integer;
begin
  wait_drq;
  for i:=0 to 511 do port[ide_data]:=buf[i];
  wait_ready;
  write_secbuf:=port[ide_cmdstat] and $89=0;
  end;

(* position the drive on the desired cylinder (seek) *)

function hd_seek(cyl:integer):boolean;
begin
  wait_ready;
  port[ide_cyllow]:=lo(cyl);
  port[ide_cylhigh]:=hi(cyl);
  port[ide_sdh]:=select;
  ide_command(cmd_seek);
  hd_seek:=port[ide_cmdstat] and $89=0;
  end;

(* Read a single sector from the drive. Retry up to 5 times on error. *)
(* Print the number of tries if above 1, and report errors.           *)

procedure hd_readsector(cyl,head,sec:integer; var buf:buftype);
var n : byte;
    b : boolean;
begin
  n:=0;
  repeat
    wait_ready;
    port[ide_error]:=$AA;
    port[ide_seccnt]:=1;
    port[ide_secnum]:=sec;
    port[ide_cyllow]:=lo(cyl);
    port[ide_cylhigh]:=hi(cyl);
    port[ide_sdh]:=select+head;
    ide_command(cmd_readsector);
    b:=read_secbuf(buf);
    n:=succ(n);
  until b or (n>5);
  if not b then Error('Read Sector',false) else if n>1 then writeln(n:5);
  end;

(* Write a single sector to the drive. No need for retries yet, *)
(* until now it was just a go/nogo behaviour.                   *)

procedure hd_writesector(cyl,head,sec:integer; var buf:buftype);
begin
  wait_ready;
  port[ide_seccnt]:=1;
  port[ide_secnum]:=sec;
  port[ide_cyllow]:=lo(cyl);
  port[ide_cylhigh]:=hi(cyl);
  port[ide_sdh]:=select+head;
  ide_command(cmd_writesector);
  if not write_secbuf(buf) then Error('Write Sector',false);
  end;

(* Write the ATAPI command to the drive. *)

procedure write_ATAPI_command(var cmd:ATAPI_cmd_type);
var i,j,k : integer;
begin
  wait_ready;
  port[ATAPI_countlow] := 0;  (* 16-bit max data to be received, in bytes *)
  port[ATAPI_counthigh] := 8;
  port[ide_cmdstat] := atapi_command;
  wait_drq;
  for i:=0 to 11 do begin
(*  for k:=1 to 100 do j:=succ(k);  Sony delay.... maybe set PIO mode to 3?*)
(* i.e. ATAPI set mode, mode 1 sets PIO to mode 3 instead of default *)
  port[ide_data]:=cmd[i];
  end;
  end;

{$I GIDE09.INC}

(* MAIN *)

begin
  constptr:=addr(constat);
  writeln(signon);
  select:=$A0;delayed:=false;timeouts:=true;
  SetPorts(GIDEbase);
{  hd_init(cylinders,heads,sectors); }   (* option *)
  repeat
    write(^m^j'Functions:'^m^j,
    '(0) Initialise drive             (5) Read disk randomly'^m^j,
    '(1) Read drive''s ID data         (6) Read/rewrite linear'^m^j,
    '(2) Execute drive''s selftest     (7) Read/rewrite randomly'^m^j,
    '(3) Random seek test             (8) Write/read linear (destructive)'^m^j,
    '(4) Read disk linear             (9) Write/read randomly (destructive)'^m^j,
    '(t) Toggle device number         (c) read CDROM/ATAPI ID data'^m^j,
    '(i) use ATAPI inquiry            (r) read ATAPI CDROM headers'^m^j,
    '(l) read ATAPI linear            (s) ATAPI soft reset'^m^j,
    '(e) ATAPI start/stop/eject CD    (d) read delay toggle'^m^j,
    '(w) toggle timeout (wait)'^m^j,
    '(p) Set port address             (x) Exit program'^m^j,
    'Input: ');
    repeat read(kbd,func); func:=upcase(func)
    until func in ['0'..'9','T','C','I','R','L','S','E','D','W','P','X'];
    write(func,^m^j^m^j);
    case func of
      '0' : begin
              write('No. of Cylinders (',cylinders:4,') : '); readln(cylinders);
              write('No. of Heads     (',heads:4,') : '); readln(heads);
              write('No. of Sectors   (',sectors:4,') : '); readln(sectors);
              hd_init(cylinders,heads,sectors);
              end;
      '1' : hd_identify;
      '2' : hd_diagnostics;
      '3' : hd_seekrandom;
      '4' : hd_readlinear;
      '5' : hd_readrandom;
      '6' : hd_rw_linear;
      '7' : hd_rw_random;
      '8' : hd_test_linear;
      '9' : hd_test_random;
      'T' : toggle_device;
      'C' : cd_identify;
      'I' : cd_inquiry;
      'R' : cd_headers;
      'L' : atapi_readlinear;
      'S' : ide_command(atapi_softreset);
      'E' : cd_eject;
      'D' : begin
              delayed := not delayed;
              SetPorts(GIDEbase);
              end;
      'W' : begin
              timeouts := not timeouts;
              SetPorts(GIDEbase);
              end;
      'P' : begin
              write('IDE base adress in hex (',HexByte(GIDEbase),') : ');
              readln(s);
              if length(s)>0 then begin
                val('$'+s,i,j);
                if j=0 then GIDEbase:=i;
                end;
              write('ECB-Bus IDE interface (Y/N) ? ');
              repeat
                read(kbd,c); c:=upcase(c)
              until (c='Y') or (c='N');
              writeln(c); ECB_IDE:=c='Y';
              SetPorts(GIDEbase);
              end;
      end;
  until func='X';
  end.
