% file ATRG.TRG                              GAE - March, 1982
     Inverse trig functions.
     This file can be compiled as-is.
     It requires TRGNEG.ALG.
--------------------------------------------------------------%

PION3: #PI/3 $
PION2: HALF*#PI $
PION4: HALF*PION2 $
PION6: HALF*PION3 $

ONRT2: HALF^HALF $
ROOT3: 3^HALF $
ONRT3: 1/ROOT3 $
RT3ON2: ROOT3*HALF $

FUNCTION IDPBRCH(EX1),
  WHEN PBRCH, EX1  EXIT,
ENDFUN $

FUNCTION COPBRCH(EX1),
  WHEN PBRCH, PION2-EX1  EXIT,
ENDFUN $

FUNCTION ASIN(EX1),
  WHEN NOT PBRCH, SIMPU('ASIN,EX1)  EXIT,
  EX1: TRGEXPD(EX1,-2),
  WHEN NEGLT(EX1), -ASIN(-EX1)  EXIT,
  WHEN ZERO(EX1), 0  EXIT,
  WHEN EX1=HALF, PION6  EXIT,
  WHEN EX1=ONRT2, PION4  EXIT,
  WHEN EX1=RT3ON2, POIN3  EXIT,
  WHEN EX1=1, PION2  EXIT,
  WHEN POSMULT(TRGEXPD,7), #I*LOG((1-EX1^2)^(1/2)-#I*EX1,#E)  EXIT,
  SIMPU('ASIN,EX1),
ENDFUN $

FUNCTION ATAN(EX1),
  WHEN NOT PBRCH, SIMPU('ATAN,EX1)  EXIT,
  EX1: TRGEXPD(EX1,-2),
  WHEN EX1=MINF, -PION2  EXIT,
  WHEN NEGLT(EX1), -ATAN(-EX1)  EXIT,
  WHEN ZERO(EX1), 0  EXIT,
  WHEN EX1=ONRT3, PION6  EXIT,
  WHEN EX1=1, PION4  EXIT,
  WHEN EX1=ROOT3, PION3  EXIT,
  WHEN EX1=PINF, PION2  EXIT,
  WHEN POSMULT(TRGEXPD,7), HALF*#I*LOG((#I+EX1)/(#I-EX1),#E)  EXIT,
  SIMPU('ATAN,EX1),
ENDFUN $

FUNCTION ACOS(EX1),
  PION2-ASIN(EX1),
ENDFUN $

FUNCTION ACOT(EX1),
  ATAN(1/EX1),
ENDFUN $

FUNCTION ASEC(EX1),
  PION2 - ASIN(1/EX1),
ENDFUN $

FUNCTION ACSC(EX1),
  ASIN(1/EX1),
ENDFUN $

PROPERTY ASIN, SIN, IDPBRCH $
PROPERTY ATAN, TAN, IDPBRCH $

PROPERTY ASIN, COS, COPBRCH $
PROPERTY ATAN, COT, COPBRCH $

RDS() $
