;	FILE:		ZEMLGO.ASM  Version 09
;	DATE:		April 16, 1987    
;	
;	RPMLGO - RP/M Load and Go Program.
;	The RP/M resident image is assumed to start at 0980H.
;
;	RPMLGO is the first code in the RPM.SYS file, which
;		permits RP/M to be coldbooted either from the RP/M
;		disk system tracks (RPMBOOT and RPMLDR), or from
;		an RPMLGO.COM file from PC DOS or MS DOS.
;		PCRPMLGO begins execution at CS=0100H in any segment
;		(64K space) available.  The RP/M coldboot from system
;		tracks places the segment at 0060H.  When booting 
;		RP/M from PC DOS or MS DOS, the segment address is
;		determined by DOS the same as a transient program,
;		and DOS remains in memory.
;
;
;	RPMLGO sets up the following interrupt vectors:
;		INT 80H at 0000:0200H, PCRPMLGO BRKEM to CBIOS80
;		INT 81H at 0000:0204H, CBIOS80  CALLN to CBIOS88
;		INT 82H at 0000:0208H, DISKBIOS at VSTART track 0.
;
;	GODOS sets up and executes the following interrupt vector:
;		INT 83H at 0000:020CH, to INT 20 in GODOS.COM
;	New version of GODOS executes a RETEM, which returns to
;		instruction following BRKEM in CBIOS88, where an
;		INT 20 is executed for returning to DOS.
;
;	RPMLGO then moves the RP/M system image (consisting of
;		RCP, RDOS, CBIOS80 and CBIOS88) from 0980H to
;		DC00H (the high end of the 64K segment), and also moves
;		the DISKBIOS code to track 0 space of the M: disk,
;		a warmboot copy of RCP and RDOS to the next contiguous
;		memory segment for warmbooting, initializes the
;		count of floppy disk drives, virtual disk maximum
;		block number, initializes the virtual disk, displays
;		MicroMethods, Inc. RP/M copyright logo, initializes
;		the Timer Tick interrupt vector for CBIOS88, then does
;		a BRKEM 80H to the coldboot entry of CBIOS80.
;
;--------------------------------------------------------
;	RPM.SYS file consists of:
;	 	RPMLGO		0100H	(8080)   (8088)
;		RCP		0980H	(DB00H)  (0000H)
;		RDOS		1180H	(E300H)  (0800H)
;		CBIOS80		1F80H	(F100H)  (1600H)
;		COMMON 		2880H	(FA00H)  (1F00H)
;		DOSDISK		2980H   (FB00H)  (2000H)
;		CBIOS88		2E80H  (10000H)  (2500H)
;		DISKBIOS(VDISK)	5080H  (1DB00H) (10000H)
;--------------------------------------------------------
;		WARMBOOT IMAGE	       (1C500H)  (EA00H) 	
;--------------------------------------------------------
;		VDISK(DISKBIOS track 0)(1DB00H) (10000H)
;--------------------------------------------------------
;
CIMAGE	EQU	0980H		;System image from disk load
IMAGE	EQU	0DB00H		;IMAGE FWA after move
RCPCNT	EQU	IMAGE+0DH	;byte count of RCP command buffer
RCPBUF	EQU	IMAGE+0EH	;command buffer in RCP
PDISK	EQU	003DH		;RCP path disk byte in page 0
RDOSIM	EQU	0E300H		;start of RDOS image
ROVEC	EQU	RDOSIM+0DAFH	;read/only vector in RDOS image
LGVEC	EQU	RDOSIM+0DB1H	;log vector in RDOS image
DOSDISK	EQU	0FB00H		;image location of DOSDISK
CDISK	EQU	DOSDISK+050H	;current disk in DOSDISK
CURDSK	EQU	0004H		;RCP current disk in page 0
RST7	EQU	0038H		;location of RST 7 in page 0
PTHDSK	EQU	003DH		;RCP path disk in page 0
ERRFLG	EQU	003EH		;error flag in page 0
SUBFLG	EQU	003FH		;submit flag in page 0
COMBFR	EQU	0080H		;command buffer in page 0
WBTSIZE	EQU	01600H		;WARM BOOT IMAGE SIZE
WBTSSIZ	EQU	WBTSIZE/16	;WARM BOOT IMAGE SIZE IN SEGMENT FORM
DIRSIZE	EQU	0800H		;BYTE SIZE OF DISK DIRECTORY
VDIRPTR	EQU	01000H		;VIRTUAL DISK DIRECTORY POINTER
VDSKSEG	EQU	0FA04H		;STARTING VIRTUAL DISK SEGMENT
VMAXSEG	EQU	0FA06H		;END OF MEMORY SEGMENT ADDRESS
VDSM	EQU	0FA08H		;VDISK MAX BLOCK NUMBER TO CBIOS88
FDSKS	EQU	0FA19H		;NUMBER OF FLOPPY DISKS TO CBIOS88
RPMSEG	EQU	0FA1AH		;RP/M2 segment address in COMMON
ASGNTB	EQU	0FA2DH		;Disk Assignment Table in COMMON
TETSEG	EQU	0FA80H		;Terminal Emulation Table Segment in COMMON
NRMATTR	EQU	0FA84H		;Normal character attribute byte in COMMON
ATTRIB	EQU	0FA85H		;Current character attribute byte in COMMON
PREVATT	EQU	0FA86H		;Previous character attribute byte in COMMON
GODOSF	EQU	0FABFH		;GODOS flag (return to DOS at warmboot if NZ)
DOSDSKF	EQU	0FADBH		;DOSDISK present flag (03H if present).
WBSEG	EQU	0FADCH		;Warm boot image segment address in COMMON
DMASEG	EQU	0FAF4H		;DMA segment address in COMMON
SLRFLG	EQU	0FF89H		;Set to 010H so SLR will run
BLKBYTE	EQU	01FFH		;OFFSET TO BOOTRECORD BLKSIZE BYTE
SSDD	EQU	00H		;SSDD DESIGNATOR = 1K BLOCKSIZE
DSDD	EQU	01H		;DSDD DESIGNATOR = 2K BLOCKSIZE
INT8080	EQU	0200H		;LOCATION OF INT 80H
CBIOS88	EQU	01F00H		;LOCATION OF CBIOS88 in 8088 segment
CBINT	EQU	080H		;COLD BOOT INTERRUPT NUMBER
CNINT	EQU	081H		;CALLN     INTERRUPT NUMBER
STKSIZ	EQU	0100H		;STACK SIZE 1000H (SEGMENT REG VALUE)
STACK	EQU	STKSIZ*16	;STACK POINTER
CR	EQU	0DH		;CARRIAGE RETURN
LF	EQU	0AH		;LINE FEED
ESPREFX	EQU	026H		;ES: PREFIX
MOVAX	EQU	0A1H		;MOVAX INSTRUCTION
;
RPMBOOT	EQU	01FD8H		;CBIOS88 ENTRY POINT, COLD BOOT RP/M2
TIMEINT	EQU	01F16H		;CBIOS88 ENTRY POINT, TIMER SERVICE
INT01CH	EQU	00070H		;LOCATION OF INT 01CH TIMER TICKS
INT1CHO	EQU	0FAB0H		;Save Int 1CH offset in Common Data Area
INT1CHS	EQU	0FAB2H		;Save Int 1CH Segment in Common Data Area
;
XCPFWA	EQU	0FB00H		;fwa of DOSDISK
RDOFWA	EQU	0E300H		;fwa of RDOS
RDOSEP	EQU	RDOFWA+06H	;RDOS entry point
RFCB	EQU	005CH		;Resident file control block.
;
	ORG	0100H
;
	JMP	LGO		;LGO RP/M ENTRY POINT
;
RCPFWA	.WORD	0		;RCP FWA (MOVE DESTINATION ADDRESS)
CBTSIZE	.WORD	04800H 	 	;SIZE OF COLD BOOT IMAGE
TOPMEM	.WORD	0		;TOP OF MEMORY SEGMENT ADDRESS
EQUIP	.WORD	0		;SAVE OF EQUIPMENT SWITCH SETTINGS
VMAX	.WORD	0		;VDISK MAX ADDRESS / SS ADDRESS
VSTART	.WORD	0		;SAVE OF VDISK STARTING ADDRESS
VSIZE	.WORD	0		;VDISK SIZE
VBLKMX	.WORD	0		;VDISK MAXIMUM BLOCK NUMBER
ZEMSEG	.WORD	0		;segment of Z80 emulator
LOADRS	.WORD	0		;save object load address for relocation
;
	.BYTE	'ZEMLGO - Load & Go 04-16-87 V.09',CR,LF
	.BYTE	'(C) 1987 by MicroMethods, Inc.',CR,LF
	.BYTE	'118 S.W. 1st, P. O. Box G',CR,LF
	.BYTE	'Warrenton, Oregon  97146',CR,LF,0,0
;
	ORG	0200H
;
LGO:	MOV	AX,CS		;INITIALIZE DS SAME AS CS
	MOV	DS,AX		;DATA SEGMENT
;
	MOV	BYTE PTR CURDSK,00H	;init RCP current disk to A:
	MOV	BYTE PTR PTHDSK,01H	;init RCP path disk to A:
	MOV	BYTE PTR ERRFLG,00H	;init error flag to 0
	MOV	BYTE PTR SUBFLG,00H	;init submit flag to 0
;
	CMP	AX,0060H	;see if running stand-alone
	JZ	LGO4		;yes
;
	MOV	AH,019H		;current disk function
	INT	021H		;get current disk from DOS
	ADD	AL,041H		;convert result to ASCII
	MOV	CRNDSK,AL	;save it
	MOV	AX,CS
	MOV	ES,AX		;our segment in ES
	MOV	BX,09FFFH	;maximum line address in memory
LGO1:	EQU	$
	MOV	AH,04AH		;DOS memory allocation function
	INT	021H
	JNC	LGO2		;if allocation successful
	CMP	AX,0008H	;see if insufficient memory
	JZ	LGO1		;yes - go get what is available
;
	MOV	SI,OFFSET ALCERR	;address of allocation error msg
ERROUT:	EQU	$
	CALL	SENDMS		;display error message
	INT	020H		;terminate and return to DOS
;
LGO2:	EQU	$
	CMP	BX,03000H	;check if allocation sufficient
	JNC	LGO3		;yes - continue
	MOV	SI,OFFSET INSMEM	;no - error out
	JMP	ERROUT
;
LGO3:	EQU	$
	ADD	AX,BX		;calculate top of memory address
	JMP	LGO5
;
LGO4:	EQU	$		;we are running stand-alone
	INT	012H		;GET MEM SIZE FROM ROM BIOS
	MOV	CL,6		;SHIFT IT TO SEGMENT ADDRESS
	SHL	AX,CL
;
LGO5:	EQU	$
	MOV	TOPMEM,AX	;SAVE TOP OF MEMORY ADDRESS
	SUB	AX,STKSIZ	;SUBTRACT SIZE OF STACK AREA
	MOV	VMAX,AX		;THIS IS SS AND MAX VIRT DISK ADDRESS
;
	CLI			;DISABLE INTERRUPTS
;
	MOV	SS,AX		;INITIALIZE STACK SEGMENT REGISTER
	MOV	SP,STKSIZ	;AND STACK POINTER
	MOV	BP,0100H	;SET INITIAL STACK FOR CBIOS80
	MOV	AX,CS		;SET SEGMENT REGISTERS
	MOV	DS,AX
	MOV	AX,0
	MOV	ES,AX		;FOR STORING INT VECTOR
	MOV	SI,CIMAGE+2
	MOV	BH,[SI]			;GET RCP FWA
	SUB	BH,3
	MOV	BL,0
;
	MOV	RCPFWA,BX	;SAVE RCP FWA
;
	MOV	DX,01600H	;GET CBIOS80 FWA IN DX
	ADD	DX,BX		;ADD RCP
	MOV	DI,DX		;WHICH IS MOVE DESTINATION
;
;	.BYTE	ESPREFX		;ES: PREFIX
;	MOV	INT8080,DX	;SET COLD BOOT INTERRUPT
;	.BYTE	ESPREFX		;ES: PREFIX
;	MOV	INT8080+2,CS
;  Set up CALLN (INT 81H) to CBIOS88
	MOV	DX,CBIOS88	;LOCATION OF CBIOS88 AFTER MOVE
	.BYTE	ESPREFX		;ES: PREFIX
	MOV	INT8080+4,DX	;SET CALLN INTERRUPT FOR CBIOS80
	MOV	DX,CS		;Develop CBIOS88 segment address
	ADD	DX,0DB0H
	MOV	CB88SEG,DX	;Save for cold boot jump.
	.BYTE	ESPREFX		;ES: PREFIX
	MOV	INT8080+6,DX
;
	STI			;ENABLE INTERRUPTS
;
	NOP
	NOP
	NOP			
        NOP			
	NOP
;
;	MOVE COLD BOOT SYSTEM IMAGE TO EXECUTION LOCATION
;
	MOV	AX,CS		;Develop Destination Segment Address
	MOV	CL,4
	SHR	BX,CL		;Shift RCPFWA right 4 bits.
	ADD	AX,BX		;Add to RP/M segment address.
	MOV	ES,AX
	MOV	SI,CIMAGE	;SOURCE IMAGE ADDRESS
	MOV	DI,0 		;RCP FWA TO DESTINATION INDEX
	MOV	CX,CBTSIZE	;MOVE BYTE COUNT
	CALL	MMV		;MOVE COLD BOOT IMAGE
	MOV	AX,CS		;RP/M segment address
	MOV	WORD PTR RPMSEG,AX	;save in COMMON locations
	MOV	WORD PTR DMASEG,AX
	MOV	BX,XCPFWA+6+9	
	MOV	BX,[BX]		;.DSEG in DOSDISK register array
	MOV	[BX],AX		;save in DOSDISK register array
	MOV	BYTE PTR XCPFWA,0C9H	;disable DOSDISK wmboot msg
	CMP	AX,0060H	;see if running stand-alone
	JZ	MWB		;yes, cannot invoke DOSDISK
	CALL	DOSDSK		;set up DOSDISK if requested
;
;	MOVE WARM BOOT RCP/RDOS IMAGE TO SECOND SEGMENT
;
MWB:	EQU	$
	MOV	AX,CS		;SET UP ES REGISTER TO WARMBOOT SEGMENT
	ADD	AX,01C50H
	MOV	WORD PTR WBSEG,AX	;save in COMMON location.
	MOV	ES,AX
	ADD	AX,WBTSSIZ	;CALCULATE STARTING VDISK SEGMENT
	MOV	WORD PTR ZEMSEG,AX	;Store Z80 emulator segment
	ADD	AX,01000H	;Calculate M: disk segment
	MOV	WORD PTR VDSKSEG,AX	;STORE IT IN CBIOS88 IMAGE
	MOV	VSTART,AX	;SAVE IT HERE ALSO
	MOV	SI,IMAGE	;SOURCE IMAGE ADDRESS
	MOV	DI,0		;START AT ZERO IN SECOND SEGMENT
	MOV	CX,WBTSIZE	;NUMBER OF BYTES TO MOVE
	CALL	MMV		;MOVE WARM BOOT IMAGE
;
	MOV	AX,VMAX		;GET SS/VMAX ADDRESS
	MOV	WORD PTR VMAXSEG,AX	;GIVE IT TO CBIOS88
;
;	CALCULATE AND GIVE TO CBIOS88 VDISK MAX BLOCK NUMBER
;
	MOV	AX,VMAX		;END OF VDISK ADDRESS
	SUB	AX,VSTART	;START OF VDISK ADDRESS SPACE
	MOV	VSIZE,AX	;SAVE SIZE
	MOV	CL,6		;SHIFT COUNT
	SHR	AX,CL		;POSITION BITS FOR BLOCK COUNT
	SUB	AX,5		;SUBTRACT 5 BLOCKS (TRK 1 AND 1)
	SHR	AX		;DIVIDE BY TWO
	DEC	AX		;Decrement to Maximum Block Number
	MOV	VBLKMX,AX	;SAVE HERE
	MOV	WORD PTR VDSM,AX	;TO CBIOS88 FOR CBIOS80
;
;	INITIALIZE VIRTUAL DISK BOOTRECORD AND DIRECTORY
;
	.BYTE	MOVAX		;MOV AX,WORD PTR VDSKSEG
	.WORD	VDSKSEG
	MOV	ES,AX		;VIRTUAL DISK SEGMENT ADDRESS
	MOV	DI,BLKBYTE
	.BYTE	ESPREFX		;ES: PREFIX
	MOV	[DI],BYTE PTR SSDD	;1K BLOCKSIZE DESIGNATOR
;
	MOV	DI,VDIRPTR	;VIRTUAL DISK DIRECTORY POINTER
	MOV	CX,DIRSIZE	;DIRECTORY BYTE COUNT
	MOV	AL,0E5H		;EMPTY FILE DESIGNATOR
DIRE5S:	EQU	$
	.BYTE	ESPREFX		;ES: PREFIX
	MOV	[DI],AL		;FILL DIRECTORY WITH E5'S
	INC	DI
	DEC	CX		;DECREMENT BYTE COUNT
	JNZ	DIRE5S		;LOOP TO INITIALIZE DIRECTORY
;
;	Initialize M: disk directory for date & time stamps.
;
	MOV	DI,VDIRPTR+060H	;M: disk directory init pointer
	MOV	CX,DIRSIZE-060H	;byte count
	MOV	AL,021H		;date-time init byte
DINIT:	EQU	$
	.BYTE	ESPREFX
	MOV	[DI],AL
	ADD	DI,080H
	SUB	CX,080H
	JNC	DINIT
;
;	MOVE DISKBIOS CODE TO TRACK ZERO OF VIRTUAL DISK
;	AND INITIALIZE INT 82H VECTOR AT 0000:0208H
;
	MOV	AX,0000H	;Zero segment (interrupts)
	MOV	ES,AX		;to ES register
	MOV	DX,0000H	;DISKBIOS offset address.
	.BYTE	ESPREFX		;ES: Prefix
	MOV	INT8080+8,DX	;Init INT 82H offset adrs at 0208H.
	MOV	DX,VSTART	;Segment adrs of VDISK, track 0.
	.BYTE	ESPREFX		;ES: Prefix
	MOV	INT8080+10,DX	;Init INT 82H segment adrs at 020AH.
;
	MOV	AX,VSTART	;VDISK track 0 destination segment.
	MOV	ES,AX		;to ES register
	MOV	DI,0000H	;VDISK track 0 destination offset.
	MOV	SI,05080H	;location of DISKBIOS in image
	MOV	CX,03A0H	;Size of DISKBIOS image 
	CALL	MMV		;Move DISKBIOS to VDISK track 0.
;
;	DETERMINE NUMBER OF FLOPPY DISKS FOR CBIOS
;
	INT	011H		;ROM BIOS EQUIPMENT CHECK
	MOV	EQUIP,AX	;SAVE SWITCH SETTINGS
	AND	AX,00C0H	;MASK NUMBER OF FLOPPY DRIVES
	MOV	CL,6		;SHIFT COUNT
	SHR	AX,CL		;TO POSITION NUMBER
	INC	AX		;BUMP TO ACTUAL NUMBER
	MOV	BYTE PTR FDSKS,AL	;NO. FLOPPIES TO CBIOS88
;
;	INITIALIZE DISPLAY ATTRIBUTE BYTES IN COMMON DATA AREA
;
	MOV	AH,0FH		;ROM BIOS display status
	INT	010H		; gets current page number in BH
	MOV	AH,3		;ROM BIOS read cursor position
	INT	010H		; into DX register
	MOV	AH,8		;ROM BIOS Video read char/attribute byte
	INT	010H		;returns attribute byte in AH register
	MOV	BYTE PTR NRMATTR,AH	;save in COMMON
	MOV	BYTE PTR ATTRIB,AH
	MOV	BYTE PTR PREVATT,AH
;
	MOV	DX,CB88SEG	;Save CBIOS88 segment address in
	MOV	TETSEG,DX	;TETSEG of Common Data Area.
;
;
;	DISPLAY MICROMETHODS INC. RP/M COPYRIGHT LOGO/BANNER
;
	MOV	SI,OFFSET LOGO	;COPYRIGHT LOGO MESSAGE
	CALL	SENDMS
;
;	INITIALIZE TIMER TICK INTERRUPT 01CH TO CBIOS88
;
	NOP
	NOP
	NOP
	CLI			;DISABLE INTERRUPTS
	MOV	DX,021H		;8259 PORT
	IN	AL,DX		;READ INTERRUPT MASK REGISTER
	OR	AL,01H		;MASK TIMER INTERRUPT OFF
	OUT	DX,AL		;DO IT
;
	MOV	AX,0		;SET UP USER TIMER TICK (01CH)
	MOV	ES,AX		;INTERRUPT VECTOR IN SEGMENT ZERO
;
	.BYTE	ESPREFX		;ES: Prefix
	.BYTE	0A1H		;MOV AX,
	.WORD	INT01CH		;INT01CH - get INT 1CH offset.
	MOV	INT1CHO,AX	;Save offset in CBIOS88 common.
	.BYTE	ESPREFX		;ES: Prefix
	.BYTE	0A1H		;MOV AX,
	.WORD	INT01CH+2	;INT01CH+2 - get INT 1CH segment.
	MOV	INT1CHS,AX	;Save segment in CBIOS88 common.
	NOP
	NOP
	NOP
;
	MOV	DX,TIMEINT	;LOCATION OF CBIOS88 TIMER ENTRY PT
;
	.BYTE	ESPREFX		;ES: PREFIX
	MOV	INT01CH,DX	;PUT CBIOS88 TIMER ADR IN 0070H
	MOV	DX,CB88SEG	;CBIOS88 segment address
	.BYTE	ESPREFX		;ES: PREFIX
	MOV	INT01CH+2,DX	;PUT RP/M SEGMENT ADR IN 0072H
;
	MOV	DX,021H		;8259 PORT
	IN	AL,DX		;READ INTERRUPT MASK REGISTER
	AND	AL,0FEH		;SET TIMER INTERRUPT BIT BACK ON
	OUT	DX,AL		;ENABLE TIMER INTERRUPT
	STI			;ENABLE INTERRUPTS
;
;
;	INITIALIZE PRINTER (PARALLEL) PORTS
;
	MOV	AX,CS
	CMP	AX,0060H	;see if we are running stand-alone
	JNZ	ZLOAD		;no, otherwise init printers
	MOV	DX,0		;LPT1
	MOV	AH,01H
	INT	017H
	MOV	DX,1		;LTP2
	MOV	AH,01H
	INT	017H
	MOV	DX,2		;LPT3
	MOV	AH,01H
	INT	017H
;
ZLOAD:	EQU	$
	NOP
	NOP
	NOP
	MOV	AX,0000H	;set up INT 80H
	MOV	ES,AX
	MOV	AX,0000H	;offset into Z80 emulator NOP for startup
	.BYTE	ESPREFX
	MOV	INT8080,AX
	MOV	AX,ZEMSEG	;segment of Z80 emulator
	.BYTE	ESPREFX
	MOV	INT8080+2,AX
;
;
	NOP
	NOP
	NOP
	MOV	ES,AX		;Z80 emulator segment in ES register
	MOV	DI,0000H	;start at offset zero
	MOV	CX,0FFFFH	;count of all bytes in Z80 emulator segment
	MOV	AL,00H		;get 00H in AL for storing in segment
INITZ:	EQU	$
	.BYTE	ESPREFX
	MOV	[DI],AL		;Store zeroes in Z80 emulator segment
	INC	DI		;bump store pointers
	DEC	CX		;decrement byte count
	JNZ	INITZ		;loop for byte count	
; Initialize segment with RST 7 code for illegal ops ...........
	MOV	DX,0000H	;starting destination
NXTPG:	EQU	$
	MOV	DI,DX
	MOV	BL,6		;6 RST 7 places per page
NXTOFS:	EQU	$
	MOV	SI,JMPRST7	;location of RST 7 for illegal ops
	MOV	CX,5		;5 bytes in RST 7 code
	CALL	MMV		;move RST 7 code
	ADD	DX,02AH		;increment to next RST 7 location
	MOV	DI,DX
	DEC	BL		;decrement count
	JNZ	NXTOFS		;loop for places in each page
	AND	DX,0FF00H	;clear offset
	ADD	DX,0100H	;bump to next page
	CMP	DX,0000H
	JZ	OBJLOD		;done - go load object code
	JMP	NXTPG		;proceed to next page
OBJLOD:	EQU	$
	MOV	SI,ZOBJ		;Pointer to object code in SI
OBJRCD	EQU	$
	MOV	AH,00H		;Initialize checksum accumulator
	MOV	BL,[SI]		;Get record type in BL
	CMP	BL,08AH		;see if we are done
	JZ	ZDONE		;yes
	CMP	BL,09CH		;see if relocation record
	JNZ	OBJ0		;no
	JMP	RELOCA		;yes
OBJ0	EQU	$
	ADD	AH,BL		;accumulate checksum
	INC	SI
	MOV	CL,[SI]		;Get byte count in CL
	ADD	AH,CL		;accumulate checksum
	INC	SI
	CMP	BL,0A0H		;see if this is load record
	JZ	OBJ1		;yes
	MOV	CH,00H
	ADD	SI,CX		;no - bump source pointer by byte count
	INC	SI		;bump SI for checksum byte
	JMP	OBJRCD		;and get next object record
OBJ1	EQU	$
	ADD	AH,[SI]		;accumulate checksum
	INC	SI
	DEC	CL
	ADD	AH,[SI]		;next two bytes
	INC	SI
	DEC	CL
	MOV	DL,[SI]		;get load address in DX
	ADD	AH,DL		;accumulate checksum
	INC	SI
	DEC	CL
	MOV	DH,[SI]		;load address now in DX
	MOV	DI,DX		;put load address in DI
	MOV	LOADRS,DX	;save load address for relocation record
	ADD	AH,DH
	INC	SI
	DEC	CL
OBJ2	EQU	$
	TEST	BYTE PTR [DI],00H	;see if byte is free (not code)
	JNZ	LODERR		;overlaying previous code - load error
	CALL	OBJLDR		;loads one byte
	JNZ	OBJ2		;loop for byte count
	ADD	AH,[SI]		;add checksum byte to accumulator
	JNZ	CKSMERR		;if checksum error
	INC	SI		;bump SI for checksum byte
	JMP	OBJRCD		;get next object record
ZDONE	EQU	$
	NOP			
	NOP
	NOP
	MOV	BYTE PTR SLRFLG,010H	;So SLR will run.
	MOV	BYTE PTR RST7,0C9H	;Set RET at RST 7 location in page 0.
;
;	Far Jump to CBIOS88 Cold Boot code which will execute the
;	INT 80H to CBIOS80 cold boot.
;
	.BYTE	0EAH		;Far Jump Instruction
	.WORD	RPMBOOT     	;IP = Offset to RPMBOOT in CBIOS88.
CB88SEG:	EQU	$
	.WORD	0		;CS = CBIOS88 segment address.
	HLT			;should never get here
;
JMPRST7:	EQU	$
	MOV	CX,FF00H	;Location of RST 7 instruction code
	JMP	CX		;if illegal op code, execute RST 7
;
ZOBJ	EQU	05480H		;location of Z80EM.OBJ code in this image
;
LODERR:	EQU	$
	MOV	DX,OFFSET LDERR		;error message
	JMP	EREXIT
;
DFLTDOS	EQU	$
	.BYTE	01H		;byte count
CRNDSK:	EQU	$
	.BYTE	00H		;current disk default
	.BYTE	0DH
	.BYTE	0,0,0,0,0,0,0,0
;
CKSMERR:	EQU	$
	MOV	DX,OFFSET CKSERR	;error message
EREXIT:	EQU	$
	MOV	AH,09H
	INT	021H
	INT	020H		;exit to DOS
;
CKSERR:	.BYTE	CR,LF,'Checksum error loading Z80 emulator.',CR,LF,'$'
LDERR:	.BYTE	CR,LF,'Code overlaid during load process.',CR,LF,'$'
;
;	OBJLDR - OBJ file loader (one byte per call).
;		Entry:  ES = destination segment
;			DI = destination offset
;			SI = source offset
;
OBJLDR:	EQU	$
	MOV	AL,[SI]		;byte from object record
	ADD	AH,AL		;accumulate checksum
	.BYTE	ESPREFX
	MOV	[DI],AL		;store byte at destination
	INC	SI		;bump pointers
	INC	DI
	DEC	CL		;decrement record byte count
	RET
;
RELOCA	EQU	$
	INC	SI		;bump over record type byte
	MOV	CL,[SI]		;get record byte count
	ADD	CL,2		;adjust byte count for processing
RELOC	EQU	$
	ADD	SI,2
	SUB	CL,2
	CMP	CL,01H		;see if only checksum byte left
	JZ	RELOCX		;no more bytes in record
RELOC1	EQU	$
	MOV	BH,[SI]		;get relocation type byte
	CMP	BH,0C4H		;the one we want
	JZ	RELOC2
	CMP	BH,084H		;also this one
	JZ	RELOC2
	JMP	RELOC4		;no
RELOC2	EQU	$
	INC	SI		;bump past type byte
	DEC	CL
	MOV	AX,[SI]		;get offset value
	ADD	AX,LOADRS	;add to last load record address
	MOV	DI,AX		;get result in DI
	ADD	SI,4		;bump to relocation word contents in record
	SUB	CL,4
	MOV	AX,[SI]		;get relocation word contents
	.BYTE	ESPREFX
	MOV	BX,[DI]		;check destination location
	OR	BX,BX
	JZ	RELOC3		;nothing there is OK
	JMP	LODERR		;if code there, load error
RELOC3	EQU	$
	.BYTE	ESPREFX
	MOV	[DI],AX		;put contents in destination location
	JMP	RELOC		;loop until all 84 & C4 types processed
;
RELOC4	EQU	$
	ADD	SI,7		;bump to next relocation type byte
	SUB	CL,7		
	CMP	CL,01H		;see if only checksum byte left
	JZ	RELOCX		;if done
	JMP	RELOC1		;process next relocation type
;
RELOCX	EQU	$
	INC	SI		;bump past checksum byte
	JMP	OBJRCD		;process next object record
;
;	
;
;	MMV - MEMORY MOVE
;
;		Entry:  ES = Destination Segment
;			SI = Source Image Address
;			DI = Destination Image Address
;			CX = Move byte count.
;
MMV:	MOV	AL,[SI]		;GET AND
	.BYTE	ESPREFX		;ES: PREFIX
	MOV	[DI],AL		;STORE BYTE
	INC	SI		;BUMP SOURCE ADDRESS
	INC	DI		;BUMP DESTINATION ADDRESS
	DEC	CX		;DECREMENT BYTE COUNT
	JNZ	MMV		;LOOP FOR COUNT
	RET
;
;	SEND MESSAGE ROUTINE
;
SENDMS:	MOV	AH,0EH		;ROM BIOS TTY DISPLAY FUNCTION
	MOV	AL,[SI]		;CHARACTER TO DISPLAY
	CMP	AL,0		;CHECK END OF MESSAGE
	JZ	SENDX		;DONE
	INT	010H		;ROM BIOS VIDEO I/O
	INC	SI		;BUMP MESSAGE POINTER
	JMP	SENDMS		;LOOP UNTIL ZERO IN STRING
;
SENDX:	RET			;DONE
;
;	DOSDSK - Install DOSDISK, if requested in command line.
;
DOSDSK:	EQU	$
	PUSH	ES
	MOV	ES,AX		;RP/M segment to ES
	MOV	DL,8		;maximum arguments
	MOV	BX,XCPFWA+6+9+(2*2)	;.XDISK pointer
	MOV	BX,[BX]
	MOV	DI,BX		;address of disk assignment table
	MOV	BX,OFFSET COMBFR
	MOV	AL,[BX]  	;see if any arguments
	CMP	AL,00H		;byte count if any arguments
	JNZ	DOSDSK1		;yes
	MOV	BX,OFFSET DFLTDOS	;none - use default 
	MOV	AL,[BX]		;default byte count
	JMP	DOSDSK1
DOSDSKX:	EQU	$
	POP	ES
	RET			;no arguments, just return
;
DOSDSK1:	EQU	$
	MOV	BYTE PTR [DI],0FFH	;preset DOS end of table byte
	MOV	CL,AL		;byte count in CL
	INC	BX
DOSDSK1A:	EQU	$
	MOV	AL,[BX]
	CMP	AL,' '		;see if blank
	JNZ	NBLNK		;no
	INC	DL		;yes - adjust dest count
	JMP	BLANK
NBLNK:	EQU	$
	CMP	AL,':'		;see if colon
	JZ	DOSDSK2		;yes - end of DOS disk assignments
	AND	AL,05FH		;fold to uppercase
	CMP	AL,'X'		;see if return to DOS desired at warmboot
	JNZ	NOX		;no
	MOV	BYTE PTR GODOSF,AL	;yes - set GODOS flag in common
	JMP	BLANK
NOX:	EQU	$
	CMP	AL,'A'		;see if A: disk included
	JNZ	NOADSK	;no
	MOV	WORD PTR ROVEC,0001H	;set RDOS A: to read/only
	MOV	WORD PTR LGVEC,0001H	;set RODS A: logged in
NOADSK:	EQU	$
	MOV	[DI],AL		;set drive letter in DOSDISK table.
	AND	AL,0FH		;mask to disk number
	MOV	BYTE PTR CDISK,AL	;set current disk in DOSDISK
	MOV	BYTE PTR PDISK,AL	;set path disk in RCP
	SUB	AL,1		;convert to current disk number
	MOV	BYTE PTR CURDSK,AL	;set current disk in page 0, loc 4
	INC	DI
	MOV	BYTE PTR [DI],0FFH	;set end of table byte
BLANK:	EQU	$
	INC	BX
	DEC	CL		;decrement byte count
	JZ	DOSDSK4		;end of argument bytes
	DEC	DL
	JNZ	DOSDSK1A	;loop for 8 assignments maximum	
	MOV	[DI],AL		;next character
	CMP	AL,':'		;must be a colon to continue
	JNZ	DOSDSK4		;no colon - end of arguments
	INC	DI
DOSDSK2:	EQU	$
	DEC	CL
	JZ	DOSDSK4		;no more chars
	MOV	DI,OFFSET RCPCNT
	MOV	BYTE PTR [DI],CL	;command list byte count to RCP
	INC	DI			;point to RCP command buffer
	INC	BX
DOSDSK3:	EQU	$
	MOV	BYTE PTR [DI],00H	;preset end of RCP command buffer
	MOV	AL,[BX]		;get command character
	CMP	AL,'a'
	JC	NOUPC		;if < 'a'
	CMP	AL,'z'+1
	JNC	NOUPC		;if > 'z'
	AND	AL,05FH		;fold lowercase a-z to uppercase A-Z
NOUPC:	EQU	$
	CMP	AL,0DH		;see if at end
	JZ	ENDBFR		;yes
	MOV	[DI],AL		;store in RCP command buffer
	INC	DI
	INC	BX
	DEC	CL
	JNZ	DOSDSK3
ENDBFR:	EQU	$
	MOV	BYTE PTR [DI],00H	;set end of command buffer
DOSDSK4:	EQU	$
	MOV	BX,RDOSEP+1	;point to vector in RDOS
	MOV	DX,[BX]		;get original RDOS vector
	MOV	BYTE PTR XCPFWA+6+3+1,DX   ;save original vector in DOSDISK
	MOV	AX,XCPFWA+6	;vector into DOSDISK
	MOV	[BX],AX		;point RDOS vector to DOSDISK
	MOV	BYTE PTR XCPFWA,0C3H	;turn on DOSDISK warm boot message.
	MOV	BYTE PTR DOSDSKF,03H	;set DOSDISK present flag in COMMON.
	JMP	DOSDSKX		;done		
;
LOGO	.BYTE	CR,LF
	.BYTE	'>>>>>>>>>>>>>>> CP/M 2.2 Compatible <<<<<<<<<<<<<<<'
	.BYTE	CR,LF
	.BYTE	'>>                                               <<'
	.BYTE	CR,LF
	.BYTE	'>>   RP/M2 Operating System for IBM PC, Ver 2.1  <<'
	.BYTE	CR,LF
	.BYTE	'>>         (C) 1987 by MicroMethods, Inc.        <<'
	.BYTE	CR,LF
	.BYTE	'>>                                               <<'
	.BYTE	CR,LF
	.BYTE	'<<<<<<<<<<<<<<<<<< Z80 EMULATOR >>>>>>>>>>>>>>>>>>>'
	.BYTE	CR,LF,0,0
;
ALCERR	.BYTE	CR,LF
	.BYTE	'DOS Memory Allocation Error - cannot load PC RP/M2.'
	.BYTE	CR,LF,0,0
;
INSMEM	.BYTE	CR,LF
	.BYTE	'Insufficient Memory available to run PC RP/M2.'
	.BYTE	CR,LF,0,0
;
	END
