;============================================================================
;
;File:	Z80EM3.ASM - Z80 Emulator
;Date:  February 18, 1987
;
;============================================================================
;
;						      Location
;   Register Usage:	AX = Z80 A-PSW	(AH=F, AL=A)	FF7CH
;			BX = Z80 H-L	(BH=H, BL=L)	FF76H
;			DI = Z80 B-C			FF7AH
;			DX = Z80 D-E	(DH=D, DL=E)	FF78H
;			BP = Z80 SP			
;			SI = Z80 P	(Program Cntr)
;		      	     Z80 IX			FF70H
;			     Z80 IY			FF72H
;
;========================================================================
;
	ORG	(00H*PG)+CBOP
RCLB	PROC	NEAR		;CB 00 			RCL B
;				-----------------------------------------
	XCHG	DI,CX		;Put BC(DI) in CX
	SAHF			;Store AH in flags
	ROL	CH,1		;Rotate B(CH) left one bit.
	INC	CH
	DEC	CH
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XCHG	DI,CX		;Put BC(CX) back in DI
	XOR	CL,CL
	NXTI
RCLB	ENDP
;
	ORG	(01H*PG)+CBOP
RCLC	PROC	NEAR		;CB 01 			RCL C
;				-----------------------------------------
	XCHG	DI,CX		;Put BC(DI) in CX
	SAHF			;Store AH in flags
	ROL	CL,1		;Rotate C(CL) left one bit.
	INC	CL
	DEC	CL
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XCHG	DI,CX		;Put BC(CX) back in DI
	XOR	CL,CL
	NXTI
RCLC	ENDP
;
	ORG	(02H*PG)+CBOP
RCLD	PROC	NEAR		;CB 02 			RCL D
;				-----------------------------------------
	SAHF			;Store AH in flags
	ROL	DH,1		;Rotate D(DH) left one bit.
	INC	DH
	DEC	DH
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
RCLD	ENDP
;
	ORG	(03H*PG)+CBOP
RCLE	PROC	NEAR		;CB 03 			RCL E
;				-----------------------------------------
	SAHF			;Store AH in flags
	ROL	DL,1		;Rotate E(DL) left one bit.
	INC	DL
	DEC	DL
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
RCLE	ENDP
;
	ORG	(04H*PG)+CBOP
RCLH	PROC	NEAR		;CB 04 			RCL H
;				-----------------------------------------
	SAHF			;Store AH in flags
	ROL	BH,1		;Rotate H(BH) left one bit.
	INC	BH
	DEC	BH
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
RCLH	ENDP
;
	ORG	(05H*PG)+CBOP
RCLL	PROC	NEAR		;CB 05 			RCL L
;				-----------------------------------------
	SAHF			;Store AH in flags
	ROL	BL,1		;Rotate L(BL) left one bit.
	INC	BL
	DEC	BL
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
RCLL	ENDP
;
	ORG	(06H*PG)+CBOP
RCLHL	PROC	NEAR		;CB 06 			RCL (HL)
;				-----------------------------------------
	SAHF			;Store AH in flags
	ROL	BYTE PTR [BX],1		;Rotate byte via [BX] left one bit.
	INC	BYTE PTR [BX]
	DEC	BYTE PTR [BX]
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
RCLHL	ENDP
;
	ORG	(07H*PG)+CBOP
RCLAA	PROC	NEAR		;CB 07 			RCL A
;				-----------------------------------------
	SAHF			;Store AH in flags
	ROL	AL,1		;Rotate A(AL) left one bit.
	INC	AL
	DEC	AL
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
RCLAA	ENDP
;
	ORG	(08H*PG)+CBOP
RRCB	PROC	NEAR		;CB 08 			RRC B
;				-----------------------------------------
	XCHG	DI,CX		;Put BC(DI) in CX
	SAHF			;Store AH in flags
	ROR	CH,1		;Rotate B(CH) right one bit.
	INC	CH
	DEC	CH
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XCHG	DI,CX		;Put BC(CX) back in DI
	XOR	CL,CL
	NXTI
RRCB	ENDP
;
	ORG	(09H*PG)+CBOP
RRCC	PROC	NEAR		;CB 09 			RRC C
;				-----------------------------------------
	XCHG	DI,CX		;Put BC(DI) in CX
	SAHF			;Store AH in flags
	ROR	CL,1		;Rotate C(CL) right one bit.
	INC	CL
	DEC	CL
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XCHG	DI,CX		;Put BC(CX) back in DI
	XOR	CL,CL
	NXTI
RRCC	ENDP
;
	ORG	(0AH*PG)+CBOP
RRCD	PROC	NEAR		;CB 0A 			RRC D
;				-----------------------------------------
	SAHF			;Store AH in flags
	ROR	DH,1		;Rotate D(DH) right one bit.
	INC	DH
	DEC	DH
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
RRCD	ENDP
;
	ORG	(0BH*PG)+CBOP
RRCE	PROC	NEAR		;CB 0B 			RRC E
;				-----------------------------------------
	SAHF			;Store AH in flags
	ROR	DL,1		;Rotate E(DL) right one bit.
	INC	DL
	DEC	DL
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
RRCE	ENDP
;
	ORG	(0CH*PG)+CBOP
RRCH	PROC	NEAR		;CB 0C 			RRC H
;				-----------------------------------------
	SAHF			;Store AH in flags
	ROR	BH,1		;Rotate H(BH) right one bit.
	INC	BH
	DEC	BH
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
RRCH	ENDP
;
	ORG	(0DH*PG)+CBOP
RRCL	PROC	NEAR		;CB 0D 			RRC L
;				-----------------------------------------
	SAHF			;Store AH in flags
	ROR	BL,1		;Rotate L(BL) right one bit.
	INC	BL
	DEC	BL
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
RRCL	ENDP
;
	ORG	(0EH*PG)+CBOP
RRCHL	PROC	NEAR		;CB 0E 			RRC (HL)
;				-----------------------------------------
	SAHF			;Store AH in flags
	ROR	BYTE PTR [BX],1		;Rotate byte via [BX] right one bit.
	INC	BYTE PTR [BX]
	DEC	BYTE PTR [BX]
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
RRCHL	ENDP
;
	ORG	(0FH*PG)+CBOP
RRCA	PROC	NEAR		;CB 0F 			RRC A
;				-----------------------------------------
	SAHF			;Store AH in flags
	ROR	AL,1		;Rotate A(AL) right one bit.
	INC	AL
	DEC	AL
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
RRCA	ENDP
;
	ORG	(10H*PG)+CBOP
RLB	PROC	NEAR		;CB 10 			RL B
;				-----------------------------------------
	XCHG	DI,CX		;Put BC(DI) in CX
	SAHF			;Store AH in flags
	RCL	CH,1		;Rotate B(CH) left thru carry one bit.
	INC	CH
	DEC	CH
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XCHG	DI,CX		;Put BC(CX) back in DI
	XOR	CL,CL
	NXTI
RLB	ENDP
;
	ORG	(11H*PG)+CBOP
RLC11	PROC	NEAR		;CB 11 			RL C
;				-----------------------------------------
	XCHG	DI,CX		;Put BC(DI) in CX
	SAHF			;Store AH in flags
	RCL	CL,1		;Rotate C(CL) left thru carry one bit.
	INC	CL
	DEC	CL
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XCHG	DI,CX		;Put BC(CX) back in DI
	XOR	CL,CL
	NXTI
RLC11	ENDP
;
	ORG	(12H*PG)+CBOP
RLD	PROC	NEAR		;CB 12 			RL D
;				-----------------------------------------
	SAHF			;Store AH in flags
	RCL	DH,1		;Rotate D(DH) left thru carry one bit.
	INC	DH
	DEC	DH
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
RLD	ENDP
;
	ORG	(13H*PG)+CBOP
RLE	PROC	NEAR		;CB 13 			RL E
;				-----------------------------------------
	SAHF			;Store AH in flags
	RCL	DL,1		;Rotate E(DL) left thru carry one bit.
	INC	DL
	DEC	DL
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
RLE	ENDP
;
	ORG	(14H*PG)+CBOP
RLH	PROC	NEAR		;CB 14 			RL H
;				-----------------------------------------
	SAHF			;Store AH in flags
	RCL	BH,1		;Rotate H(BH) left thru carry one bit.
	INC	BH
	DEC	BH
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
RLH	ENDP
;
	ORG	(15H*PG)+CBOP
RLL	PROC	NEAR		;CB 15 			RL L
;				-----------------------------------------
	SAHF			;Store AH in flags
	RCL	BL,1		;Rotate L(BL) left thru carry one bit.
	INC	BL
	DEC	BL
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
RLL	ENDP
;
	ORG	(16H*PG)+CBOP
RLHL	PROC	NEAR		;CB 16 			RL (HL)
;				-----------------------------------------
	SAHF			;Store AH in flags
	RCL	BYTE PTR [BX],1		;Rotate byte via [BX] left thru carry.
	INC	BYTE PTR [BX]
	DEC	BYTE PTR [BX]
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
RLHL	ENDP
;
	ORG	(17H*PG)+CBOP
RLA	PROC	NEAR		;CB 17 			RL A
;				-----------------------------------------
	SAHF			;Store AH in flags
	RCL	AL,1		;Rotate A(AL) left thru carry one bit.
	INC	AL
	DEC	AL
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
RLA	ENDP
;
	ORG	(18H*PG)+CBOP
RRB	PROC	NEAR		;CB 18 			RR B
;				-----------------------------------------
	XCHG	DI,CX		;Put BC(DI) in CX
	SAHF			;Store AH in flags
	RCR	CH,1		;Rotate B(CH) right thru carry one bit.
	INC	CH
	DEC	CH
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XCHG	DI,CX		;Put BC(CX) back in DI
	XOR	CL,CL
	NXTI
RRB	ENDP
;
	ORG	(19H*PG)+CBOP
RRC19	PROC	NEAR		;CB 19 			RR C
;				-----------------------------------------
	XCHG	DI,CX		;Put BC(DI) in CX
	SAHF			;Store AH in flags
	RCR	CL,1		;Rotate C(CL) right thru carry one bit.
	INC	CL
	DEC	CL
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XCHG	DI,CX		;Put BC(CX) back in DI
	XOR	CL,CL
	NXTI
RRC19	ENDP
;
	ORG	(1AH*PG)+CBOP
RRD	PROC	NEAR		;CB 1A 			RR D
;				-----------------------------------------
	SAHF			;Store AH in flags
	RCR	DH,1		;Rotate D(DH) right thru carry one bit.
	INC	DH
	DEC	DH
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
RRD	ENDP
;
	ORG	(1BH*PG)+CBOP
RRE	PROC	NEAR		;CB 1B 			RR E
;				-----------------------------------------
	SAHF			;Store AH in flags
	RCR	DL,1		;Rotate E(DL) right thru carry one bit.
	INC	DL
	DEC	DL
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
RRE	ENDP
;
	ORG	(1CH*PG)+CBOP
RRH	PROC	NEAR		;CB 1C 			RR H
;				-----------------------------------------
	SAHF			;Store AH in flags
	RCR	BH,1		;Rotate H(BH) right thru carry one bit.
	INC	BH
	DEC	BH
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
RRH	ENDP
;
	ORG	(1DH*PG)+CBOP
RRL	PROC	NEAR		;CB 1D 			RR L
;				-----------------------------------------
	SAHF			;Store AH in flags
	RCR	BL,1		;Rotate L(BL) right thru carry one bit.
	INC	BL
	DEC	BL
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
RRL	ENDP
;
	ORG	(1EH*PG)+CBOP
RRHL	PROC	NEAR		;CB 1E 			RR (HL)
;				-----------------------------------------
	SAHF			;Store AH in flags
	RCR	BYTE PTR [BX],1	;Rotate byte via [BX] right thru carry.
	INC	BYTE PTR [BX]
	DEC	BYTE PTR [BX]
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
RRHL	ENDP
;
	ORG	(1FH*PG)+CBOP
RRAA	PROC	NEAR		;CB 1F 			RR A
;				-----------------------------------------
	SAHF			;Store AH in flags
	RCR	AL,1		;Rotate A(AL) right thru carry one bit.
	INC	AL
	DEC	AL
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
RRAA	ENDP
;
	ORG	(20H*PG)+CBOP
SLAB	PROC	NEAR		;CB 20 			SLA B
;				-----------------------------------------
	XCHG	DI,CX		;Put BC(DI) in CX
	SAHF			;Store AH in flags
	SHL	CH,1		;Shift B(CH) arithmetic left one bit.
	INC	CH
	DEC	CH
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XCHG	DI,CX		;Put BC(CX) back in DI
	XOR	CL,CL
	NXTI
SLAB	ENDP
;
	ORG	(21H*PG)+CBOP
SLAC	PROC	NEAR		;CB 21 			SLA C
;				-----------------------------------------
	XCHG	DI,CX		;Put BC(DI) in CX
	SAHF			;Store AH in flags
	SHL	CL,1		;Shift C(CL) arithmetic left one bit.
	INC	CL
	DEC	CL
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XCHG	DI,CX		;Put BC(CX) back in DI
	XOR	CL,CL
	NXTI
SLAC	ENDP
;
	ORG	(22H*PG)+CBOP
SLAD	PROC	NEAR		;CB 22 			SLA D
;				-----------------------------------------
	SAHF			;Store AH in flags
	SHL	DH,1		;Shift D(DH) arithmetic left one bit.
	INC	DH
	DEC	DH
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
SLAD	ENDP
;
	ORG	(23H*PG)+CBOP
SLAE	PROC	NEAR		;CB 23 			SLA E
;				-----------------------------------------
	SAHF			;Store AH in flags
	SHL	DL,1		;Shift E(DL) arithmetic left one bit.
	INC	DL
	DEC	DL
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
SLAE	ENDP
;
	ORG	(24H*PG)+CBOP
SLAH	PROC	NEAR		;CB 24 			SLA H
;				-----------------------------------------
	SAHF			;Store AH in flags
	SHL	BH,1		;Shift H(BH) arithmetic left one bit.
	INC	BH
	DEC	BH
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
SLAH	ENDP
;
	ORG	(25H*PG)+CBOP
SLAL	PROC	NEAR		;CB 25 			SLA L
;				-----------------------------------------
	SAHF			;Store AH in flags
	SHL	BL,1		;Shift L(BL) arithmetic left one bit.
	INC	BL
	DEC	BL
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
SLAL	ENDP
;
	ORG	(26H*PG)+CBOP
SLAHL	PROC	NEAR		;CB 26 			SLA (HL)
;				-----------------------------------------
	SAHF			;Store AH in flags
	SHL	BYTE PTR [BX],1	;Arithmetic shift left via [BX] one bit.
	INC	BYTE PTR [BX]
	DEC	BYTE PTR [BX]
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
SLAHL	ENDP
;
	ORG	(27H*PG)+CBOP
SLAA	PROC	NEAR		;CB 27 			SLA A
;				-----------------------------------------
	SAHF			;Store AH in flags
	SHL	AL,1		;Shift A(AL) arithmetic left one bit.
	INC	AL
	DEC	AL
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
SLAA	ENDP
;
	ORG	(28H*PG)+CBOP
SRAB	PROC	NEAR		;CB 28 			SRA B
;				-----------------------------------------
	XCHG	DI,CX		;Put BC(DI) in CX
	SAHF			;Store AH in flags
	SAR	CH,1		;Shift B(CH) arithmetic right one bit.
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XCHG	DI,CX		;Put BC(CX) back in DI
	XOR	CL,CL
	NXTI
SRAB	ENDP
;
	ORG	(29H*PG)+CBOP
SRAC	PROC	NEAR		;CB 29 			SRA C
;				-----------------------------------------
	XCHG	DI,CX		;Put BC(DI) in CX
	SAHF			;Store AH in flags
	SAR	CL,1		;Shift C(CL) arithmetic right one bit.
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XCHG	DI,CX		;Put BC(CX) back in DI
	XOR	CL,CL
	NXTI
SRAC	ENDP
;
	ORG	(2AH*PG)+CBOP
SRAD	PROC	NEAR		;CB 2A 			SRA D
;				-----------------------------------------
	SAHF			;Store AH in flags
	SAR	DH,1		;Shift D(DH) arithmetic right one bit.
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
SRAD	ENDP
;
	ORG	(2BH*PG)+CBOP
SRAE	PROC	NEAR		;CB 2B 			SRA E
;				-----------------------------------------
	SAHF			;Store AH in flags
	SAR	DL,1		;Shift E(DL) arithmetic right one bit.
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
SRAE	ENDP
;
	ORG	(2CH*PG)+CBOP
SRAH	PROC	NEAR		;CB 2C 			SRA H
;				-----------------------------------------
	SAHF			;Store AH in flags
	SAR	BH,1		;Shift H(BH) arithmetic right one bit.
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
SRAH	ENDP
;
	ORG	(2DH*PG)+CBOP
SRAL	PROC	NEAR		;CB 2D 			SRA L
;				-----------------------------------------
	SAHF			;Store AH in flags
	SAR	BL,1		;Shift L(BL) arithmetic right one bit.
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
SRAL	ENDP
;
	ORG	(2EH*PG)+CBOP
SRAHL	PROC	NEAR		;CB 2E 			SRA (HL)
;				-----------------------------------------
	SAHF			;Store AH in flags
	SAR	BYTE PTR [BX],1	;Arithmetic shift right via [BX] one bit.
	INC	BYTE PTR [BX]
	DEC	BYTE PTR [BX]
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
SRAHL	ENDP
;
	ORG	(2FH*PG)+CBOP
SRAA	PROC	NEAR		;CB 2F 			SRA A
;				-----------------------------------------
	SAHF			;Store AH in flags
	SAR	AL,1		;Shift A(AL) arithmetic right one bit.
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
SRAA	ENDP
;
	ORG	(38H*PG)+CBOP
SRLB	PROC	NEAR		;CB 38 			SRL B
;				-----------------------------------------
	XCHG	DI,CX		;Put BC(DI) in CX
	SAHF			;Store AH in flags
	SHR	CH,1		;Shift B(CH) logical right one bit.
	INC	CH
	DEC	CH
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XCHG	DI,CX		;Put BC(CX) back in DI
	XOR	CL,CL
	NXTI
SRLB	ENDP
;
	ORG	(39H*PG)+CBOP
SRLC	PROC	NEAR		;CB 39 			SRL C
;				-----------------------------------------
	XCHG	DI,CX		;Put BC(DI) in CX
	SAHF			;Store AH in flags
	SHR	CL,1		;Shift C(CL) logical right one bit.
	INC	CL
	DEC	CL
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XCHG	DI,CX		;Put BC(CX) back in DI
	XOR	CL,CL
	NXTI
SRLC	ENDP
;
	ORG	(3AH*PG)+CBOP
SRLD	PROC	NEAR		;CB 3A 			SRL D
;				-----------------------------------------
	SAHF			;Store AH in flags
	SHL	DH,1		;Shift D(DH) logical right one bit.
	INC	DH
	DEC	DH
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
SRLD	ENDP
;
	ORG	(3BH*PG)+CBOP
SRLE	PROC	NEAR		;CB 3B 			SRL E
;				-----------------------------------------
	SAHF			;Store AH in flags
	SHL	DL,1		;Shift E(DL) logical right one bit.
	INC	DL
	DEC	DL
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
SRLE	ENDP
;
	ORG	(3CH*PG)+CBOP
SRLH	PROC	NEAR		;CB 3C 			SRL H
;				-----------------------------------------
	SAHF			;Store AH in flags
	SHL	BH,1		;Shift H(BH) logical right one bit.
	INC	BH
	DEC	BH
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
SRLH	ENDP
;
	ORG	(3DH*PG)+CBOP
SRLL	PROC	NEAR		;CB 3D 			SRL L
;				-----------------------------------------
	SAHF			;Store AH in flags
	SHL	BL,1		;Shift L(BL) logical right one bit.
	INC	BL
	DEC	BL
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
SRLL	ENDP
;
	ORG	(3EH*PG)+CBOP
SRLHL	PROC	NEAR		;CB 3E 			SRL (HL)
;				-----------------------------------------
	SAHF			;Store AH in flags
	SHR	BYTE PTR [BX],1	;Logical shift right via [BX] one bit.
	INC	BYTE PTR [BX]
	DEC	BYTE PTR [BX]
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
SRLHL	ENDP
;
	ORG	(3FH*PG)+CBOP
SRLA	PROC	NEAR		;CB 3F 			SRL A
;				-----------------------------------------
	SAHF			;Store AH in flags
	SHL	AL,1		;Shift A(AL) logical right one bit.
	INC	AL
	DEC	AL
	LAHF			;Load AH from flags
	AND	AH,0EDH		;Clear aux carry and subtract flags
	XOR	CL,CL
	NXTI
SRLA	ENDP
;
	ORG	(40H*PG)+CBOP
BIT0B	PROC	NEAR		;CB 40			BIT 0,B
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DI,0100H	;test B(DI) bit 0 set on
	JNZ	BIT0B1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT0B1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT0B	ENDP
;
	ORG	(41H*PG)+CBOP
BIT0C	PROC	NEAR		;CB 41			BIT 0,C
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DI,0001H	;test C(DI) bit 0 set on
	JNZ	BIT0C1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT0C1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT0C	ENDP
;
	ORG	(42H*PG)+CBOP
BIT0D	PROC	NEAR		;CB 42			BIT 0,D
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DH,01H  	;test D(DH) bit 0 set on
	JNZ	BIT0D1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT0D1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT0D	ENDP
;
	ORG	(43H*PG)+CBOP
BIT0E	PROC	NEAR		;CB 43			BIT 0,E
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DL,01H  	;test E(DL) bit 0 set on
	JNZ	BIT0E1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT0E1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT0E	ENDP
;
	ORG	(44H*PG)+CBOP
BIT0H	PROC	NEAR		;CB 44			BIT 0,H
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	BH,01H  	;test H(BH) bit 0 set on
	JNZ	BIT0H1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT0H1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT0H	ENDP
;
	ORG	(45H*PG)+CBOP
BIT0L	PROC	NEAR		;CB 45			BIT 0,L
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	BL,01H  	;test L(BL) bit 0 set on
	JNZ	BIT0L1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT0L1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT0L	ENDP
;
	ORG	(46H*PG)+CBOP
BIT0HL	PROC	NEAR		;CB 46			BIT 0,(HL)
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	BYTE PTR [BX],01H  	;test byte via HL(BX) bit 0 set on
	JNZ	BIT0HL1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT0HL1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT0HL	ENDP
;
	ORG	(47H*PG)+CBOP
BIT0A	PROC	NEAR		;CB 47			BIT 0,A
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	AL,01H  	;test A(AL) bit 0 set on
	JNZ	BIT0A1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT0A1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT0A	ENDP
;
	ORG	(48H*PG)+CBOP
BIT1B	PROC	NEAR		;CB 48			BIT 1,B
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DI,0200H	;test B(DI) bit 1 set on
	JNZ	BIT1B1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT1B1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT1B	ENDP
;
	ORG	(49H*PG)+CBOP
BIT1C	PROC	NEAR		;CB 49			BIT 1,C
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DI,0002H	;test C(DI) bit 1 set on
	JNZ	BIT1C1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT1C1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT1C	ENDP
;
	ORG	(4AH*PG)+CBOP
BIT1D	PROC	NEAR		;CB 4A			BIT 1,D
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DH,02H 		;test D(DH) bit 1 set on
	JNZ	BIT1D1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT1D1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT1D	ENDP
;
	ORG	(4BH*PG)+CBOP
BIT1E	PROC	NEAR		;CB 4B			BIT 1,E
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DL,02H  	;test E(DL) bit 1 set on
	JNZ	BIT1E1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT1E1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT1E	ENDP
;
	ORG	(4CH*PG)+CBOP
BIT1H	PROC	NEAR		;CB 4C			BIT 1,H
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	BH,02H  	;test H(BH) bit 1 set on
	JNZ	BIT1H1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT1H1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT1H	ENDP
;
	ORG	(4DH*PG)+CBOP
BIT1L	PROC	NEAR		;CB 4D			BIT 1,L
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	BL,02H  	;test L(BL) bit 1 set on
	JNZ	BIT1L1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT1L1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT1L	ENDP
;
	ORG	(4EH*PG)+CBOP
BIT1HL	PROC	NEAR		;CB 4E			BIT 1,(HL)
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	BYTE PTR [BX],02H  	;test byte via HL(BX) bit 1 set on
	JNZ	BIT1HL1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT1HL1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT1HL	ENDP
;
	ORG	(4FH*PG)+CBOP
BIT1A	PROC	NEAR		;CB 4F			BIT 1,A
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	AL,02H  	;test A(AL) bit 1 set on
	JNZ	BIT1A1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT1A1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT1A	ENDP
;
	ORG	(50H*PG)+CBOP
BIT2B	PROC	NEAR		;CB 50			BIT 2,B
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DI,0400H	;test B(DI) bit 2 set on
	JNZ	BIT2B1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT2B1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT2B	ENDP
;
	ORG	(51H*PG)+CBOP
BIT2C	PROC	NEAR		;CB 51			BIT 2,C
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DI,0004H	;test C(DI) bit 2 set on
	JNZ	BIT2C1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT2C1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT2C	ENDP
;
	ORG	(52H*PG)+CBOP
BIT2D	PROC	NEAR		;CB 52			BIT 2,D
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DH,04H 		;test D(DH) bit 2 set on
	JNZ	BIT2D1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT2D1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT2D	ENDP
;
	ORG	(53H*PG)+CBOP
BIT2E	PROC	NEAR		;CB 53			BIT 2,E
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DL,04H 		;test E(DL) bit 2 set on
	JNZ	BIT2E1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT2E1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT2E	ENDP
;
	ORG	(54H*PG)+CBOP
BIT2H	PROC	NEAR		;CB 54			BIT 2,H
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	BH,04H  	;test H(BH) bit 2 set on
	JNZ	BIT2H1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT2H1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT2H	ENDP
;
	ORG	(55H*PG)+CBOP
BIT2L	PROC	NEAR		;CB 55			BIT 2,L
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	BL,04H  	;test L(BL) bit 2 set on
	JNZ	BIT2L1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT2L1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT2L	ENDP
;
	ORG	(56H*PG)+CBOP
BIT2HL	PROC	NEAR		;CB 56			BIT 2,(HL)
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	BYTE PTR [BX],04H  	;test byte via HL(BX) bit 2 set on
	JNZ	BIT2HL1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT2HL1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT2HL	ENDP
;
	ORG	(57H*PG)+CBOP
BIT2A	PROC	NEAR		;CB 57			BIT 2,A
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	AL,04H  	;test A(AL) bit 2 set on
	JNZ	BIT2A1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT2A1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT2A	ENDP
;
	ORG	(58H*PG)+CBOP
BIT3B	PROC	NEAR		;CB 58			BIT 3,B
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DI,0800H	;test B(DI) bit 3 set on
	JNZ	BIT3B1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT3B1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT3B	ENDP
;
	ORG	(59H*PG)+CBOP
BIT3C	PROC	NEAR		;CB 59			BIT 3,C
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DI,0008H	;test C(DI) bit 3 set on
	JNZ	BIT3C1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT3C1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT3C	ENDP
;
	ORG	(5AH*PG)+CBOP
BIT3D	PROC	NEAR		;CB 5A			BIT 3,D
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DH,08H 		;test D(DH) bit 3 set on
	JNZ	BIT3D1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT3D1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT3D	ENDP
;
	ORG	(5BH*PG)+CBOP
BIT3E	PROC	NEAR		;CB 5B			BIT 3,E
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DL,08H 		;test E(DL) bit 3 set on
	JNZ	BIT3E1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT3E1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT3E	ENDP
;
	ORG	(5CH*PG)+CBOP
BIT3H	PROC	NEAR		;CB 5C			BIT 3,H
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	BH,08H  	;test H(BH) bit 3 set on
	JNZ	BIT3H1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT3H1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT3H	ENDP
;
	ORG	(5DH*PG)+CBOP
BIT3L	PROC	NEAR		;CB 5D			BIT 3,L
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	BL,08H  	;test L(BL) bit 3 set on
	JNZ	BIT3L1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT3L1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT3L	ENDP
;
	ORG	(5EH*PG)+CBOP
BIT3HL	PROC	NEAR		;CB 5E			BIT 3,(HL)
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	BYTE PTR [BX],08H  	;test byte via HL(BX) bit 3 set on
	JNZ	BIT3HL1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT3HL1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT3HL	ENDP
;
	ORG	(5FH*PG)+CBOP
BIT3A	PROC	NEAR		;CB 5F			BIT 3,A
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	AL,08H  	;test A(AL) bit 3 set on
	JNZ	BIT3A1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT3A1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT3A	ENDP
;
	ORG	(60H*PG)+CBOP
BIT4B	PROC	NEAR		;CB 60			BIT 4,B
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DI,01000H	;test B(DI) bit 4 set on
	JNZ	BIT4B1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT4B1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT4B	ENDP
;
	ORG	(61H*PG)+CBOP
BIT4C	PROC	NEAR		;CB 61			BIT 4,C
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DI,0010H	;test C(DI) bit 4 set on
	JNZ	BIT4C1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT4C1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT4C	ENDP
;
	ORG	(62H*PG)+CBOP
BIT4D	PROC	NEAR		;CB 62			BIT 4,D
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DH,010H		;test D(DH) bit 4 set on
	JNZ	BIT4D1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT4D1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT4D	ENDP
;
	ORG	(63H*PG)+CBOP
BIT4E	PROC	NEAR		;CB 63			BIT 4,E
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DL,010H 	;test E(DL) bit 4 set on
	JNZ	BIT4E1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT4E1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT4E	ENDP
;
	ORG	(64H*PG)+CBOP
BIT4H	PROC	NEAR		;CB 64			BIT 4,H
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	BH,010H  	;test H(BH) bit 4 set on
	JNZ	BIT4H1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT4H1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT4H	ENDP
;
	ORG	(65H*PG)+CBOP
BIT4L	PROC	NEAR		;CB 65			BIT 4,L
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	BH,010H  	;test L(BL) bit 4 set on
	JNZ	BIT4L1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT4L1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT4L	ENDP
;
	ORG	(66H*PG)+CBOP
BIT4HL	PROC	NEAR		;CB 66			BIT 4,(HL)
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	BYTE PTR [BX],010H  	;test byte via HL(BX) bit 4 set on
	JNZ	BIT4HL1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT4HL1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT4HL	ENDP
;
	ORG	(67H*PG)+CBOP
BIT4A	PROC	NEAR		;CB 67			BIT 4,A
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	AL,010H  	;test A(AL) bit 4 set on
	JNZ	BIT4A1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT4A1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT4A	ENDP
;
	ORG	(68H*PG)+CBOP
BIT5B	PROC	NEAR		;CB 68			BIT 5,B
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DI,02000H	;test B(DI) bit 5 set on
	JNZ	BIT5B1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT5B1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT5B	ENDP
;
	ORG	(69H*PG)+CBOP
BIT5C	PROC	NEAR		;CB 69			BIT 5,C
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DI,0020H	;test C(DI) bit 5 set on
	JNZ	BIT5C1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT5C1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT5C	ENDP
;
	ORG	(6AH*PG)+CBOP
BIT5D	PROC	NEAR		;CB 6A			BIT 5,D
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DH,020H		;test D(DH) bit 5 set on
	JNZ	BIT5D1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT5D1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT5D	ENDP
;
	ORG	(6BH*PG)+CBOP
BIT5E	PROC	NEAR		;CB 6B			BIT 5,E
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DL,020H		;test D(DL) bit 5 set on
	JNZ	BIT5E1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT5E1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT5E	ENDP
;
	ORG	(6CH*PG)+CBOP
BIT5H	PROC	NEAR		;CB 6C			BIT 5,H
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	BH,020H  	;test H(BH) bit 5 set on
	JNZ	BIT5H1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT5H1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT5H	ENDP
;
	ORG	(6DH*PG)+CBOP
BIT5L	PROC	NEAR		;CB 6D			BIT 5,L
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	BL,020H  	;test L(BL) bit 5 set on
	JNZ	BIT5L1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT5L1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT5L	ENDP
;
	ORG	(6EH*PG)+CBOP
BIT5HL	PROC	NEAR		;CB 6E			BIT 5,(HL)
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	BYTE PTR [BX],020H  	;test byte via HL(BX) bit 5 set on
	JNZ	BIT5HL1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT5HL1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT5HL	ENDP
;
	ORG	(6FH*PG)+CBOP
BIT5A	PROC	NEAR		;CB 6F			BIT 5,A
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	AL,020H  	;test A(AL) bit 5 set on
	JNZ	BIT5A1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT5A1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT5A	ENDP
;
	ORG	(70H*PG)+CBOP
BIT6B	PROC	NEAR		;CB 70			BIT 6,B
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DI,04000H	;test B(DI) bit 6 set on
	JNZ	BIT6B1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT6B1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT6B	ENDP
;
	ORG	(71H*PG)+CBOP
BIT6C	PROC	NEAR		;CB 71			BIT 6,C
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DI,0040H	;test C(DI) bit 6 set on
	JNZ	BIT6C1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT6C1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT6C	ENDP
;
	ORG	(72H*PG)+CBOP
BIT6D	PROC	NEAR		;CB 72			BIT 6,D
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DH,040H		;test D(DH) bit 6 set on
	JNZ	BIT6D1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT6D1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT6D	ENDP
;
	ORG	(73H*PG)+CBOP
BIT6E	PROC	NEAR		;CB 73			BIT 6,E
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DL,040H		;test E(DL) bit 6 set on
	JNZ	BIT6E1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT6E1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT6E	ENDP
;
	ORG	(74H*PG)+CBOP
BIT6H	PROC	NEAR		;CB 74			BIT 6,H
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	BH,040H  	;test H(BH) bit 6 set on
	JNZ	BIT6H1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT6H1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT6H	ENDP
;
	ORG	(75H*PG)+CBOP
BIT6L	PROC	NEAR		;CB 75			BIT 6,L
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	BL,040H  	;test L(BL) bit 6 set on
	JNZ	BIT6L1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT6L1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT6L	ENDP
;
	ORG	(76H*PG)+CBOP
BIT6HL	PROC	NEAR		;CB 76			BIT 6,(HL)
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	BYTE PTR [BX],040H  	;test byte via HL(BX) bit 6 set on
	JNZ	BIT6HL1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT6HL1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT6HL	ENDP
;
	ORG	(77H*PG)+CBOP
BIT6A	PROC	NEAR		;CB 77			BIT 6,A
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	AL,040H  	;test A(AL) bit 6 set on
	JNZ	BIT6A1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT6A1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT6A	ENDP
;
	ORG	(78H*PG)+CBOP
BIT7B	PROC	NEAR		;CB 78			BIT 7,B
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DI,08000H	;test B(DI) bit 7 set on
	JNZ	BIT7B1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT7B1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT7B	ENDP
;
	ORG	(79H*PG)+CBOP
BIT7C	PROC	NEAR		;CB 79			BIT 7,C
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DI,0080H	;test C(DI) bit 7 set on
	JNZ	BIT7C1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT7C1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT7C	ENDP
;
	ORG	(7AH*PG)+CBOP
BIT7D	PROC	NEAR		;CB 7A			BIT 7,D
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DH,080H		;test D(DH) bit 7 set on
	JNZ	BIT7D1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT7D1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT7D	ENDP
;
	ORG	(7BH*PG)+CBOP
BIT7E	PROC	NEAR		;CB 7B			BIT 7,E
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	DL,080H		;test E(DL) bit 7 set on
	JNZ	BIT7E1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT7E1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT7E	ENDP
;
	ORG	(7CH*PG)+CBOP
BIT7H	PROC	NEAR		;CB 7C			BIT 7,H
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	BH,080H  	;test H(BH) bit 7 set on
	JNZ	BIT7H1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT7H1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT7H	ENDP
;
	ORG	(7DH*PG)+CBOP
BIT7L	PROC	NEAR		;CB 7D			BIT 7,L
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	BL,080H  	;test L(BL) bit 7 set on
	JNZ	BIT7L1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT7L1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT7L	ENDP
;
	ORG	(7EH*PG)+CBOP
BIT7HL	PROC	NEAR		;CB 7E			BIT 7,(HL)
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	BYTE PTR [BX],080H  	;test byte via HL(BX) bit 7 set on
	JNZ	BIT7HL1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT7HL1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT7HL	ENDP
;
	ORG	(7FH*PG)+CBOP
BIT7A	PROC	NEAR		;CB 7F			BIT 7,A
;				-----------------------------------------
	AND	AH,029H		;clear flags except carry
	TEST 	AL,080H  	;test A(AL) bit 7 set on
	JNZ	BIT7A1		;yes
	OR	AH,054H		;no - set zero, aux carry and overflow flags
	XOR	CL,CL
	NXTI
BIT7A1	EQU	$
	OR	AH,010H		;set aux carry flag
	XOR	CL,CL
	NXTI
BIT7A	ENDP
;
