/* 
** LGO.C -- Small-Mac Load-and-Go Loader
**
**               Copyright 1985 J. E. Hendrix
**
** Usage: LGO [-G] [-M] program
**
** -G     Execute program after loading.
**
** -M     Monitor load address and size.
**
** "Program" is a file specifier for the program being loaded.
** Default, and only allowed, extension is LGO.
**
** Enter control-S to pause and control-C to abort.
*/
#include <stdio.h>
#include "notice.h"

#define NOCCARGC		/* don't pass arg counts to functions */

#define NAMESIZE   15
#define STACK     256		/* allow for stack space */
#define RET       201		/* RET instruction */
#define LGOEXT  ".LGO"

/*
** global variables
*/
char
 *base,			/* base address */
 *start,		/* starting address */
  infn[NAMESIZE];	/* input filename */

int
  infd,			/* input fd */
  size,			/* program size */
  monitor,		/* monitor activity? */
  go;			/* execute? */

/*
** load program.LGO with format:
**
**            RET <start> <base> <size> <program>
*/
main(argc,argv) int argc, argv[]; {
  int i; char str[5];
  fputs("Small-Mac Load-and-Go Loader, ", stderr); fputs(VERSION, stderr);
  fputs(CRIGHT1, stderr);
  getsw(argc, argv);				/* process switches */
  i = 0;
  while(getarg(++i, infn, NAMESIZE, argc, argv) != EOF)	/* get fn */
    if(infn[0] != '-') {i = 0; break;}
  if(i) usage();
  extend(infn, LGOEXT, LGOEXT);
  infd = open(infn, "r");
  read(infd, &base, 1);
  if(base != RET) error("- Invalid LGO Format");
  read(infd, &start, 2);			/* get starting address */
  read(infd, &base,  2);			/* get base address */
  read(infd, &size,  2);			/* get program size */
  if(monitor) {					/* monitor? */
    fputs("From ",    stdout); itox(base,      str, 5); fputs(str, stdout);
    fputs(", To ",    stdout); itox(base+size, str, 5); fputs(str, stdout);
    fputs(", Size ",  stdout); itox(size,      str, 5); fputs(str, stdout);
    fputs(", Start ", stdout); itox(start,     str, 5);  puts(str);
    }
  malloc(STACK);	/* new machine stack */
  malloc(1);		/* leaves new stack address in HL */
  #asm
  SPHL			; move stack
  LXI H,0		; CP/M return
  PUSH H		; re-stack CP/M return
  #endasm
  read(infd, base, size);			/* load program */
  if(ferror(infd)) error2("- Error Reading ", infn);
  if(go) {		/* execute program? */
    start;		/* leaves starting address in HL */
    #asm
    PCHL		; Jump to start address with
			; CP/M return on top of this stack.
    #endasm
    }
  exit(0);
  }

/*
** get switches from command line
*/
getsw(argc, argv) int argc, *argv; {
  char arg[NAMESIZE];
  int argnbr; argnbr = 0;
  while(getarg(++argnbr, arg, NAMESIZE, argc, argv) != EOF) {
    if(arg[0] != '-') continue;			/* skip file names */
    if(toupper(arg[1]) == 'G') go = YES;
    else if(toupper(arg[1]) == 'M') monitor = YES;
    else usage();
    }
  }

/*
** abort with a usage message
*/
usage() {
  error("Usage: LGO [-G] [-M] program");
  }
