
#include <stdio.h>
#define CH_ARG 1
#define RT_ARG 2
#define BT_ARG 3
#define ST_ARG 4
#define PY_ARG 5
/******************************************************************************
*
* setport : Provides a command line interface for setcom(). This driver allows
*           the use of the defaults provided for in the setcom routines. The
*           syntax is as follows:
*
*               setport channel <baud> <bits> <stop bits> <parity>
*
*           where channel = Interfacer user number or -1 for System Support bd.
*                 baud = Baud rate 300, 1200 ... or 0 for default.
*                 bits = Number of bits per character 5..8 or 0 for default.
*                 stop bits = Number of stop bits 1..2 or 0 for default
*                 parity = Type of parity to use. E,e,O,oN,n or 0 for default.
* Examples:
*               setport 5 1200 8 1 E            All specified
*               setport 5 1200 8 1              Use default parity
*               setport 5 1200 8                Use default parity and stop
*               setport 5 1200                  Use def parity, stop, length
*               setport 5                       Use defaults for everything.
*               setport 5 0 0 0 E               Spec parity all else defaults.
*
* written by: Bob Harbour  CP Systems   12/14/88
* modifications:
*
*******************************************************************************/

main ( argc, argv )
int argc;
char *argv[];
{
  int channel, rate, nbits, nstop, ptype;

  switch ( argc )                       /* use available args only */
  {
    case 1: fputs ("invalid usage:   setport ch <baud> <bits>",stderr );
            fputs (" <stop bits> <parity>\n",stderr );
            exit ( );

    case 2: channel = atoi ( argv [ CH_ARG ] );         /* 1 arg */
            rate = 0;
            nbits = 0;
            nstop = 0;
            ptype = 0;
            printf ("channel = %d  rate = DEF  nbits = DEF  ", channel );
            printf ("stop bits = DEF  parity = DEF \n" ); 
            break;

    case 3: channel = atoi ( argv [ CH_ARG ] );         /* 2 args */
            rate = atoi ( argv [ RT_ARG ] );
            nbits = 0;
            nstop = 0;
            ptype = 0;
            printf ("channel = %d  rate = %d  nbits = DEF  ", channel,rate );
            printf ("stop bits = DEF  parity = DEF \n" ); 
            break;

    case 4: channel = atoi ( argv [ CH_ARG ] );         /* 3 args */
            rate = atoi ( argv [ RT_ARG ] );
            nbits = atoi ( argv [ BT_ARG ] );
            nstop = 0;
            ptype = 0;
            printf ("channel = %d rate = %d nbits = %d  ",channel,rate,nbits);
            printf ("stop bits = DEF  parity = DEF \n" ); 
            break;

    case 5: channel = atoi ( argv [ CH_ARG ] );         /* 4 args */
            rate = atoi ( argv [ RT_ARG ] );
            nbits = atoi ( argv [ BT_ARG ] );
            nstop = atoi ( argv [ ST_ARG ] );
            ptype = 0;
            printf ("channel = %d rate = %d nbits = %d  ",channel,rate,nbits);
            printf ("stop bits = %d  parity = DEF \n", nstop ); 
            break;

    case 6: channel = atoi ( argv [ CH_ARG ] );         /* 5 args */
            rate = atoi ( argv [ RT_ARG ] );
            nbits = atoi ( argv [ BT_ARG ] );
            nstop = atoi ( argv [ ST_ARG ] );
            ptype = *argv[ PY_ARG ];
            printf ("channel = %d rate = %d nbits = %d  ",channel,rate,nbits);
            printf ("stop bits = %d  parity = %c \n", nstop, ptype ); 
            break;

    default:fputs ("invalid usage:  setport ch <baud> <bits>", stderr );
            fputs (" <stop bits> <parity>\n",stderr );
            exit ();
  }

  setcom ( channel, rate, nbits, nstop, ptype );

  exit ();
}


