
#include <com.h>
#include <stdio.h>
/******************************************************************************
*
* setcom : set the communication parameters for the serial ports on Compupro
*          Interfacer boards or System Support 1 boards. Defaults may be used
*          for any parameter except the channel or user number. In order to use
*          the default, put a 0 in the desired parameter in the calling
*          statement. Supports all 32 Interfacer ports by specifying the user
*          number of the desired port or the System Support board by using -1 
*          in the channel or user number. Definitions and default values are in
*          the file com.h
*
* Written by: Bob Harbour   CP Systems  10/4/88
* calls:   gen_1mode(), gen_2mode()
* modifications :
*
******************************************************************************/

setcom ( channel, rate, nbits, nstop, ptype )
int channel, rate, nbits, nstop, ptype;
{
  BYTE *int_select = 0XFF0017,          /* interfacer ch select port ptr */
       *int_mode = 0XFF0012,            /* "        " mode byte "      " */
       *int_command = 0XFF0013,         /* "        " command   "      " */
       *sys_mode = 0XFF005E,            /* system support mode byte port ptr */
       *sys_command = 0XFF005F;         /* "            " command   "      " */

  UBYTE mode1, gen_1mode(), mode2, gen_2mode(), command;

  mode1 = gen_1mode ( nstop, ptype, nbits );    /* get mode 1 byte */
  mode2 = gen_2mode ( rate );                   /* get mode 2 byte */
  command = C_NORM | C_RTS | C_DTR ;            /* make up command byte */

  if ( channel == SYS_SUPPORT )         /* hit the system support bd? */
  {                                     /* yes, send parameters to it */
    *sys_mode = mode1;
    *sys_mode = mode2;
    *sys_command = command;
  }
  else                                  /* wasn't sys sup, try interfacer */
  {
    if (( channel >= MIN_CHAN ) && ( channel <= MAX_CHAN ))
    {                                   /* channel number ok, use it */
      *int_select = ( UBYTE )channel;   /* set the channel to hit */
      *int_mode = mode1;
      *int_mode = mode2;
      *int_command = command;
    }
    else                                /* channel number no good */
    {
      fputs ("invalid channel number, no changes made\n",stderr );
      return ( ERROR );
    }
  }
  return ( OK );
}


/******************************************************************************
*
* gen_1mode : Compose a mode 1 mode byte for 2651 USART's from the input
*             parameters. Zeros in any parameter will cause the default
*             for that parameter to be used in composing the byte.
*
* Written by: Bob Harbour   CP Systems  10/4/88
* calls: none   
* modifications :
*
******************************************************************************/

UBYTE gen_1mode ( nstop, ptype, nbits )
int nstop, ptype, nbits;
{
  UBYTE stop, par, bits;

  switch ( nstop )                      /* get bit pattern for stop bits */
  {
    case 0:  stop = STOP_DEF;           /* use default for 0 input */
             break;
    case 1:  stop = 0X40;               /* set for 1 stop bit */
             break;
    case 2:  stop = 0XC0;               /* set for 2 stop bits */
             break;
    case 3:  stop = 0X80;               /* this is really 1.5 stop bits */
             break;
    default: stop = STOP_DEF;           /* erroneous inputs use this value */
             fputs ("invalid number of stop bits:  used default\n",stderr );
             break;
  }

  switch ( ptype )                      /* get bit pattern for parity now */
  {
    case  0 : par = PAR_DEF;            /* use default here for 0 input */
              break;
    case 'N':                           /* no parity */
    case 'n': par = 0X00;
              break;
    case 'E':                           /* even parity */
    case 'e': par = 0X30;
              break;
    case 'O':                           /* odd parity */
    case 'o': par = 0X10;
              break;
    default : par = PAR_DEF;            /* use default here for error in  */
              fputs ("invalid parity type:   used default\n", stderr );
              break;
  }

  switch ( nbits )                      /* get bit pattern for char length */
  {
    case 0: bits = BITS_DEF;            /* use default char length */
            break;
    case 5: bits = 0X00;                /* 5 bit characters */
            break;
    case 6: bits = 0X04;                /* 6 bit characters */
            break;
    case 7: bits = 0X08;                /* 7 bit characters */
            break;
    case 8: bits = 0X0C;                /* 8 bit characters */
            break;
    default : bits = BITS_DEF;          /* use default char length for error */
              fputs ("invalid word length:  used default\n",stderr );
              break;
  }
  return ( ASYN16 | stop | par | bits );        /* combine fields */
}


/******************************************************************************
*
* gen_2mode : Compose a mode 2 mode byte for 2651 USART's from the baud rate
*             input parameter. Zero in the input rate will cause the default
*             baud rate to be used in composing the byte.
*
* Written by: Bob Harbour   CP Systems  10/4/88
* calls: none   
* modifications :
*
******************************************************************************/

UBYTE gen_2mode ( rate )
int rate;
{
  UBYTE retval;

  switch ( rate )               /* translate to bit pattern for baud rate */
  {
    case 0: retval = RATE_DEF;          /* set the default */
            break;
    case 50: retval = 0X70;
             break;
    case 75: retval = 0X71;
             break;
    case 110: retval = 0X72;
              break;
    case 134: retval = 0X73;
              break;
    case 150: retval = 0X74;
              break;
    case 300: retval = 0X75;
              break;
    case 600: retval = 0X76;
              break;
    case 1200: retval = 0X77;
               break;
    case 1800: retval = 0X78;
               break;
    case 2000: retval = 0X79;
               break;
    case 2400: retval = 0X7A;
               break;
    case 3600: retval = 0X7B;
               break;
    case 4800: retval = 0X7C;
               break;
    case 7200: retval = 0X7D;
               break;
    case 9600: retval = 0X7E;
               break;
    case 19200: retval = 0X7F;
                break;
    default : retval = RATE_DEF;
              fputs ("invalid baud rate:  used default value\n",stderr );
              break;
  }
  return ( retval );                    /* send it back */
}


