;DIABLO.ASM VERSION 2.0  11/28/77
;DIABLO.ASM  VERSION 1.9  JRB  11/21/77

; IMDOS FILE LIST TRANSIENT,
;    MODIFIED TO DRIVE DIABLO PRINTER.
;    CHANGES TO LIST CODE NOTED WITH ******
;    ALSO DIABLO DRIVER APPENDED AT END.
;
; FCB FOR FILE MUST BE SET UP BEFORE ENTRY,
; AS FROM CCP "DIABLO NAME.TYP" COMMAND
; OR DDT "INAME.TYP" COMMAND.
; LISTING CAN BE ABORTED BY TYPING RUBOUT.
;
; COPYRIGHT (C) 1976,1977
; IMSAI MANUFACTURING COMPANY, 14860 WICKS BLVD, SAN LEANDRO, CA 94577
;
;
PGSIZ	EQU  60		;NUMBER OF LINES PER PAGE
		;ABOVE CHANGED FROM 66 CAUSE DIABLO  ******
		;DRIVER ADDS 6 LINE FEEDS AFTER 60TH ONE ON PAGE. ******
PRINTPERPAGE EQU 60	;NUMBER OF LINES TO PRINT PER PAGE
PAGNUMCOL EQU 64	;COLUMN FOR WORD "PAGE" AND NUMBER
		;NOTE: A LONG TITLE (SPACES OR TABS WORK) PUSHES PAGE NUMBER TO RIGHT.
;
;
ENTRY	EQU  5
;
FCB	EQU  5CH	;SYSTEM DEFAULT FILE CONTROL BLOCK
NR	EQU  FCB+32	;NEXT RECORD TO READ
;
TBUFF	EQU  80H	;WHERE CCP PUTS COMMAND LINE
;
DMA	EQU  80H	;WHERE SECTORS ARE READ
;
TBASE	EQU  100H	;TRANSIENT PROGRAM BASE
;
;EQUATES FOR ASCII CONTROL CHARACTERS
TABC	EQU  9		;^I. TAB.
LFC	EQU   0AH	;LINE FEED
FFC	EQU  0CH	;FORM FEED
ALTFFC	EQU  0BH	;ALSO TAKE VTAB (^K) AS FORM FEED CAUSE OF EDITOR BUG
CRC	EQU  0DH	;CARRIAGE RETURN
CTRLZ	EQU  1AH	;CONTROL Z. EOF.
;
POFF	EQU  82H	;CHARACTER TO TURN LINE PRINTER OFF

	;NOTE: AFTER THE WORD "PAGE" THERE IS A CONTROL-K, WHICH CAUSES A FORM
	;FEED WHEN LISTED WITH THIS PROGRAM OR WITH LIST.
	;PAGE
	ORG  TBASE
;
; ENTRY POINTS
;
LISTER:	JMP  LIST	;NORMAL ENTRY
	LXI  SP,DSTACK	;DDT DEBUGGING ENTRY
	CALL LIST	;USE "I" COMMAND TO SET FILE NAME
	RST  7		;RETURN TO DDT
;
;
;  OBJECT COPYRIGHT NOTICE
	DB 'COPYRIGHT (C) 1977, IMSAI MFG CORP, MADE IN USA'

;FORMAT CONTROL FLAGS. YOU CAN CHANGE THESE WITH DDT OR BY EDIT-ASSEMBLE.
TITLFLAG:   DB  0FFH	;MAKE 0 TO SUPPRESS TITLE
PAGNUMFLAG: DB  0FFH	;MAKE 0 TO SUPPRESS PAGE NUMBERS

;POINTER TO TITLE BUFFER. YOU CAN CHANGE THIS TO POINT AT TEXT ASSEMBLED
; ELSEWHERE IN PROGRAM, OR ADD CUSTOM TEXT AT REGULAR BUFFER.
;SEE COMMENTS AT TITLBUF (AT END).
TITLPOINT:  DW  TITLBUF


; *****************************************************************

;
; MAIN PROGRAM BEGINS HERE
;
LIST:	LXI  H,0! DAD  SP! SHLD CALLERSP! LXI  SP,STACK
;
; GIVE SIGN-ON MESSAGE
	CALL INLMSG! DB 'IMSAI DIABLO VERS 2.0 ',CRC,LFC,'$'
;
;
;CLEAR INPUT BUFFER SO DOUBLE-ENTERED CR AFTER COMMAND WON'T ABORT LIST
	MVI C,11! CALL ENTRY! RAR! JNC CIB9	;IF NO CHARACTER
	MVI C,1! CALL ENTRY		;GET (AND IGNORE) CHARACTER
CIB9:
;
; SET UP TITL: DEFAULT TO WHAT WAS TYPED AFTER "LIST".
;
;THUS TITL CONSISTS OF FILE NAME AND ANYTHING USER TYPES AFTER IT
	LHLD TITLPOINT! XCHG	;WHERE TO PUT TEXT
	LXI H,TBUFF		;WHERE CCP LEFT TEXT
	MOV C,M			;NUMBER OF CHARS IN TBUFF
	MVI B,123		;MAX # CHARS TO USE
	LDAX D! ORA A! JNZ TITL9  ;IF OTHER TEXT IS THERE, LEAVE IT
				;ABOVE IS A PROVISION FOR USER MODIFICATION
;COPY TEXT
TITLUP:	DCR C! JM TITL2	;STOP IF INPUT USED UP
	INX H! MOV A,M! STAX D! INX D	;MOVE 1 CHARACTER
	DCR B! JNZ TITLUP	;STOP AT MAX # CHARS
;TERMINATE WITH 0
TITL2:	XRA A!	STAX D
TITL9:

	;PAGE
;
;INIT INPUT
;
; CHECK FOR NO ?'S IN FILE NAME, BECAUSE THEY RESULT IN DISASTER IF FILE IS MORE
; THAN ONE EXTENT LONG. (CCP TRANSLATES * TO MULTIPLE ?'S B4 DIABLO IS ENTERED.)
	LXI H,FCB		;WHERE TO CHECK
	MVI C,11		;HOW MANY CHARS TO CHECK
	LXI D,EMQUES		;ERR MSG TEXT TO USE IF ? FOUND
QLUP:	INX H
	MOV A,M
	CPI '?'
	JZ TERM
	DCR C
	JNZ QLUP
; OPEN FILE
	MVI  C,15
	LXI  D,FCB
	CALL ENTRY	;CALL SYSTEM
	CPI  255
	LXI  D,EMFNF	;MESSAGE IF ERROR
	JZ   TERM	;IF NOT FOUND, ERROR EXIT
	XRA  A
	STA  NR		;SAY START AT RECORD 0
	STA ICOUNT	;SAY EMPTY INPUT BUFFER
;
; INIT OUTPUT
;
	CALL INIT			;INIT DIABLO DRIVER *******
	XRA A!	STA COL! STA LINE	;INIT CURSOR POSITION
	STA PAGE+1! INR A! STA PAGE	;.. PAGE STARTS AT DW 1
	;MVI A,FFC!; CALL LOCH		;SEND HARDWARE FORM FEED
					;(NOP TO TTY; NOP TO LPT:
					;IF ALREADY AT TOP OF FORM)
		;FF SUPPRESSED CAUSE DIABLO WILL PROBOBLY FEED *******
; PRINT TITL FOR FIRST PAGE
	CALL PTITL
;IGNORE FORM FEEDS, CR'S, ETC AT BEGINNING OF FILE:
; A FORM FEED HERE JUST PRODUCES A BLANK PAGE 1
	CALL IGNORE		;IGNORE FORM FEED ETC, GET 1ST READ CHAR IN A
	JMP CLOOP1		;ENTER CHARACTER LISTING LOOP
;
; LIST RECORD -- OUTPUT CHARACTER LOOP
;
CLOOP:	CALL INCH		;GET CHARACTER
CLOOP1:	PUSH B! PUSH H
	CALL LSTCH		;PROCESS  & LIST 1 CHAR
;  CHECK CONSOLE STATUS, ABORT IF CHAR TYPED
	MVI  C,11
	CALL ENTRY
	RAR		;TEST LSB
	JC   EOF
	POP  H
	POP  B
	JMP  CLOOP

	;PAGE
;
; END OF FILE.  FORM FEED AND EXIT.
;
EOF:	CALL LISFFSUB	;OUTPUT FF WITHOUT TITLE AND WO INF LOOPS
;TURN LPT MOTOR OFF. SHOULDN'T BOTHER OTHER DEVICES.
	;MVI A,POFF!; CALL LOCH
			;ABOVE SUPPRESSED CAUSE IT MAKES DIABLO PRINT A "W"******
;EXIT ROUTINE
EXIT:	LHLD CALLERSP
	SPHL		;RESET SP FOR CCP
	MVI  A,0	;SAY NO ERROR
	RET
;
; ERROR STUFF
;
NSERR:	LXI  D,MERR	;MISCELLANEOUS ERRORS
TERM:	;COME HERE W/ DE POINTING TO TEXT
	MVI  C,9
	CALL ENTRY
	JMP  EXIT
;
MERR:	DB  CRC,LFC,'SOME KIND OF ERROR',CRC,LFC,'$'
EMFNF:	DB  LFC,'FILE NOT FOUND',CRC,LFC,'$'
EMQUES:	DB  LFC,'NO *''S OR ?''S PLEASE!',CRC,LFC,'$'

;
; ******************************
;
; INPUT CHARACTER TO A SUBROUTINE
;
NEWREC:	MVI C,20! LXI D,FCB! CALL ENTRY	;READ RECORD
	CPI 1! JZ EOF			;IF END OF FILE
	ORA A!	JNZ NSERR		;CHECK FOR GOOD RETURN FROM BDOS
	LXI H,ICOUNT! MVI M,128		;INITBUFFER COUNTER
	LXI H,DMA! SHLD IPOINT		;INIT BUFFFER POINTER
	POP H
;ENTRY POINT:
INCH:	PUSH H! LXI H,ICOUNT! DCR M	;COUNT CHARS USED FROM RECORD
	JM NEWREC			;IF RECORD USED UP, GET ANOTHER
	LHLD IPOINT			;GET BUFFER POINTER
	MOV A,M				;FETCH CHARACTER
	CPI CTRLZ! JZ EOF		;ON EOF GO DIRECT TO EOF ROUTINE
	INX H! SHLD IPOINT		;POINT NEXT
	POP H! RET

	;PAGE
;
; ***********************************
;
; LIST CHAR IN A WITH PROCESSING OF SPECIAL CHARS
;
;  KEEPS TRACK OF COLUMN, LINE, PAGE.
;  EXPANDS TABS WITH STOPS EVERY 8 COLUMNS
;  SIMULATES FORM FEEDS WITH LINE FEEDS.
;
LSTCH:
;INCREMENT COLUMN COUNTER
	LXI  H,COL
	INR  M
	ANI  7FH	;IGNORE PARITY BIT. FIXES INFINITE
			;LOOPS ON CERTAIN BYTE VALUES
;SPACE OR GREATER ASCII CODE JUST GETS PRINTED
	CPI  ' '
	JP   LOCH	;GO PRINT IT
	DCR  M		;ELSE RESTORE COLUMN COUNTER
;PROCESS SPECIALS
	PUSH PSW
;
	CPI  CRC
	JNZ  LSC2
	XRA  A
	STA  COL
POPLOC:	POP  PSW	;GET CHAR BACK
	JMP  LOCH	;GO LIST IT
;
LSC2:	CPI  LFC
	JNZ  LSC3
	LDA  LINE
	CPI PRINTPERPAGE-1
	JP LISFF		;PAGE FULL, MAKE LIKE FORM FEED
	POP PSW			;NORMAL CASE:CLEAR STACK AND...

	;PAGE

;PROCESS AND PRINT LINE FEED
LISLF:	PUSH PSW! MVI A,LFC! CALL LOCH	;OUTPUT LINE FEED
	LDA LINE! INR A		;LINE+1
	CPI PGSIZ! JM LSC2A	;BUT IF BOTTOM OF PAGE, MAKE IT...
	XRA A! LHLD PAGE! INX H! SHLD PAGE  ;...TOP OF NEXT PAGE
LSC2A:	STA LINE! POP PSW! RET
;
LSC3:	CPI ALTFFC! JZ LISFF	;ALTERNATE FORM FEED
	CPI  FFC
	JNZ  LSC4
;PRINT CR, LF'S TILL LINE=0
LISFF:	CALL LISFFSUB		;SIMULATE FFORM FEED
;NEED A TITLE AT TOP OF NEXT PAGE, BUT FIRST SEE IF ANY MORE
;NON-CR, NON-LF, NON-FF CHARACTERS IN FILE.
;THIS IT AVOIDS BLANK SPACE AT TOP OF PAGE.
	CALL IGNORE		;IGNORE TIL NOT CR, LF, FF
;IF HERE, NOT AT EOF AND NEXT CHAR IS IN A
	CALL PTITL		;PRINT TITLE
	POP H! JMP LSTCH	;CLEAR STACK, GO LIST CHAR
;
LSC4:	CPI  TABC
	JNZ  LSC5
;PRINT SPACES TILL LO 3 BITS OF COL = 0
LSC4A:	MVI  A,' '! CALL LSTCH! LDA  COL! ANI  7! JNZ  LSC4A
LPOPX:	POP  PSW! RET
;
LSC5:	;ADD CHARACTERS HERE
;
;MISCELLANEOUS CHARACTERS, PRINT ^ AND LETTER
	MVI  A,'^'! CALL LSTCH! POP  PSW! ORI  40H! JMP  LSTCH
;
; PROCESS AND OUTPUT (SIMULATED) FORM FEED
LISFFSUB:  MVI A,CRC! CALL LSTCH
LSFF2:	LDA LINE! ORA A! CNZ LISLF! JNZ LSFF2
	RET

;SUBROUTINE TO PASS CR'S, LF'S, FORM FEEDS, RETURN 1ST CHARACTER
;THAT IS NONE OF THE ABOVE IN A.
;CALLED AT TOP OF EACH PAGE. DOES NOT RETURN IF END OF FILE.
IGNORE:	CALL INCH		;NEXT INPUT CHARACTER TO A
	CPI CRC! JZ IGNORE! CPI LFC! JZ IGNORE
	CPI FFC! JZ IGNORE! CPI ALTFFC! JZ IGNORE
	RET			;CHARACTER IS IN A

	;PAGE
;
;LIST OUTPUT CHAR IN A, WITHOUT PROCESSING
;
LOCH:	PUSH B			;THIS ROUTINE CHANGED   ******
	MOV B,A			;TO INTERFACE TO	******
	CALL PRINT		;DIABLO DRIVER		******
	POP B			;			******
	RET



;
; SUBROUTINE TO PRINT PAGE TITL
;
PTITL:	PUSH PSW! PUSH H!
;TITLE TEXT
	LDA TITLFLAG! ORA A! JZ NOTITL
	LHLD TITLPOINT! CALL LSTRING
NOTITL:
;PAGE NUMBER
	LDA PAGNUMFLAG! ORA A! JZ NOPAGNUM
	;SPACE TO COLUMN
PAGN1:	MVI A,' '! CALL LSTCH		;MINIMUM ONE SPACE
	LDA COL! SBI PAGNUMCOL! JM PAGN1
	;"PAGE" TEXT
	LXI H,PAGETXT! CALL LSTRING
	;NUMBER
	LHLD PAGE! CALL DECPR
NOPAGNUM:
;TEST IF EITHER OF ABOVE WAS PRINTED
	LHLD TITLFLAG! LDA PAGNUMFLAG! ORA L
	JZ PTITLEX			;NO, NEED NO CRLF'S
;CR AND 2 LF'S
	MVI A,CRC! CALL LSTCH
	MVI A,LFC! CALL LSTCH! MVI A,LFC! CALL LSTCH
PTITLEX: POP H! POP PSW! RET
;
PAGETXT: DB 'PAGE ',0


;SUBR TO LIST STRING (HL) TO NULL
LSTRING: MOV A,M! ORA A! RZ! INX H
	PUSH H! CALL LSTCH! POP H! JMP LSTRING

	;PAGE
;
; DECIMAL PRINT HL, UNSIGNED
;
DECPR:	PUSH B! PUSH D! PUSH H
	LXI B,-10		;MINUS RADIX
	LXI D,-1		;BECOMES NUMBER DIVIDED BY RADIX
DECPR1:	DAD B! INX D! JC DECPR1	;SUBTRACT TILL NEGATIVE
	LXI B,10! DAD B		;AD RADIX BACK ONCE
	XCHG			;HAVE N/10 IN HL, REMAINDER IN DE
	MOV A,H! ORA L
	CNZ DECPR		;PRINT DIGITS LEFT OF THIS IF ANY
	MOV A,E! ADI '0'! CALL LOCH   ;PRINT THIS DIGIT
	POP H! POP D! POP B! RET
;
; OUTPUT IN-LONE MESSAGE TO CONSOLE
;
INLMSG: XTHL		;SAVE H, GET TEXT LOCATION
	PUSH PSW
	MOV A,M
INLML:	CALL CONO
	INX H! MOV A,M! CPI '$'! JNZ INLML   ;$ ENDS TEXT
	INX H! POP PSW!
	XTHL!  RET	;RETURN AFTER TEXT
; OUPUT CHAR FROM A
CONO:	PUSH PSW! PUSH B! PUSH D! PUSH H!
	MOV E,A
	MVI C,2
CALLEN: CALL ENTRY
RETREGS: POP H! POP D! POP B! POP PSW!
	RET




;
;IF YOU WANT A SPECIAL TITLE, PATCH OR ASSEMBLE TEXT IN HERE
;TERMINATE WITH 0.
;IF BUFFER BEGINS WITH 0, INIT CODE COPIES OPERATOR'S TITLE IN.
TITLBUF: DB  0		;SAYS NO TITLE HERE YET
	DS   100H		;REST OF TITLE BUFFFER
;
IPOINT:	DS  2	;INPUT BUFFER POINTER
ICOUNT:	DS  1	;INPUT BUFFER DOWN-COUNTER
;
COL:	DS  1
LINE:	DS  1
PAGE:	DS  2

CALLERSP: DS 2	;CALLER'S STACK POINTER
;
;
RAM:				;STORAGE FFOR DIABLO DRIVER  ******
	DS  80
STACK:	DS  4
DSTACK:	DS  2
;

	;PAGE
;
;
; IMDOS DIABLO DRIVER
;
;PIO BOARD FOR PRINTER SHOULD HAVE JUMPERS
;IN IT FOR ADDRESS 0FAH.
;ACTUALLY LO 2 BITS OF THESE JUMPERS
;SET UP BOARD FOR IO INSTRUCTIONS RATHER THAN
;MEMORY MAPPING, WHICH IS APPROPRIATE.
;
;
;
;FOLLOWING IS ADAPTED FROM PRINTER DRIVER
; MEANT TO INTERFACE TO SCS-2
;CODE DELETED BY JRB HAS  IF 0 - ENDIF  AROUND FRONT OF IT
;

; ******** DIABLO HYTYPE PRINTER DRIVER ********
;
; REVISION 0	18 JUL 76	BRH
;
	 IF 0
	ORG	0FE00H	;ADDRESS OF DRIVER NAME
RAM	EQU	0D3F0H	;ADDRESS OF LOCAL RAM
	 ENDIF
;
; I/O PORTS
;
DATAL	EQU	0F8H	;LOW ORDER DATA LINES
DATAH	EQU	0F9H	;HIGH ORDER DATA LINES
CMAND	EQU	0FAH	;COMMAND PORT
STATS	EQU	0F8H	;STATUS PORT
;
; COMMAND BITS
;
RESTR	EQU	1	;RESTORE CARRIAGE
CHSTB	EQU	2	;CHARACTER STROBE
XSTB	EQU	4	;CARRIAGE STROBE
YSTB	EQU	8	;PAPER FEED STROBE
SELPR	EQU	10H	;SELECT PRINTER
SELRY	EQU	20H	;SELECT READY
RBLFT	EQU	40H	;RIBBON LIFT
CMASK	EQU	(-1-SELPR-RBLFT)AND 0FFH	;COMMAND MASK
			; AND 0FFH HAD TO BE ADDED FOR IMDOS ASM.
;
; STATUS BITS
;
CHECK	EQU	2	;CHECK STATUS
CHRDY	EQU	8	;CHARACTER READY
XRDY	EQU	10H	;CARRIAGE READY
YRDY	EQU	20H	;PAPER FEED READY

	;PAGE
;
; SPECIAL CHARACTERS
;
NULL	EQU	0
BS	EQU	8	;BACKSPACE
TAB	EQU	9	;TAB
LF	EQU	0AH	;LINE FEED
FF	EQU	0CH	;FORM FEED
CR	EQU	0DH	;CARRIAGE RETURN
SPACE	EQU	20H
;
; SPECIAL VALUES
;
BLANK	EQU	6	;WIDTH OF CHARACTER
HIGHT	EQU	8	;HEIGHT OF CHARACTER
PAGER	EQU	480	;HEIGHT OF PRINT REGION (60*HIGHT)
PAGSZ	EQU	528	;HEIGHT OF WHOLE PAGE (66*HIGHT)
LINSZ	EQU	792	;LENGTH OF LINE
;
; VARIABLES
;
XPOS	EQU	RAM	;PHYSICAL X POSITION
NEWX	EQU	XPOS+2	;LOGICAL X POSITION
YPOS	EQU	NEWX+2	;PHYSICAL Y POSITION
NEWY	EQU	YPOS+2	;LOGICAL Y POSITION
;
	 IF 0	;FOLLOWING RELATES TO SCS-2 ONLY
; NAME OF DRIVER
;
	DB	'PTR30'
;
; ENTRY POINTS
;
	JMP	PRINT	;PRINT A CHAR AND MOVE
	NOP		;CAN'T INPUT...
	NOP
	RET
	JMP	INIT	;INIT DRIVER AND PRINTER
	JMP	STROT	;PRINT A STRING
	NOP		;CAN'T INPUT...
	NOP
	RET
	NOP		;NO COMMANDS...
	NOP
	RET
	NOP		;CAN'T BOOT...
	NOP
	RET
	JMP	TEST	;TEST DRIVER AND PRINTER
	 ENDIF

	;PAGE
;
; INITIALIZATION ROUTINE
;
INIT:	PUSH	PSW	;SAVE REGISTERS TO BE USED...
	PUSH	H
	LXI	H,0	;RESET LOC VARIABLES...
SHLD	XPOS
	SHLD	NEWX
	SHLD	YPOS
	SHLD	NEWY
	MVI	A,CMASK-RESTR
	CALL	CMOUT	;ISSUE RESTORE COMMAND
	POP	H	;RESTORE REGISTERS...
	POP	PSW
	RET
;
; COMMAND ROUTINE. WAIT UNTIL PRINTER IS READY,
;	THEN ISSUE COMMAND IN C. B HOLDS READY BIT.
;	ANY DATA MUST ALREADY BE OUT.
;
CMOUR:	MVI	A,CMASK-SELRY	;REQUEST STATUS...
	OUT	CMAND
CMOUS:	IN	STATS	;READ STATUS
	PUSH	PSW	;SAVE IT
	ANI	CHECK	;RESTR NECESSARY?
	CZ	INIT	;RE-INIT IF SO
	POP	PSW	;GET STATUS BACK
	ANA	B	;CHECK READY AND CLEAR CARRY
	JNZ	CMOUS	;LOOP UNTIL READY
	MOV	A,C	;PUT COMMAND IN A
CMOUT:	OUT	CMAND	;ISSUE COMMAND
	MVI	A,CMASK ;GET HIGH AGAIN...
	OUT	CMAND
	RET

	;PAGE
;
; PRINT A CHARACTER. PERFORM ALL ACCUMULATED X AND Y
;	MOTION, PRINT THE CHAR IN B, AND ACCUMULATE SPACE.
;
PRINT:	PUSH	B	;SAVE ALL REGISTERS...
	PUSH	D
	PUSH	H
	PUSH	PSW
	MOV	A,B	;PUT CHAR IN A
	CPI	BS	;IS IT A BACKSPACE?
	JZ	PBS	;IF YES, PRINT IT
	CPI	TAB	;IS IT A TAB?
	JZ	PTAB	;IF YES, PRINT IT
	CPI	LF	;IS IT A LINE FEED?
	JZ	PLF	;IF YES, PRINT IT
	CPI	FF	;IS IT A FORM FEED?
	JZ	PFF	;IF YES, PRINT IT
	CPI	CR	;IS IT A C/R?
	JZ	PCR	;IF YES, PRINT IT
	CPI	SPACE	;IS IT A ACE?
	JZ	PSPAC	;IF YES, PRINT IT
	JM	PRET	;RETURN IF OTHER CONTROL CHAR
	PUSH	PSW	;SOLID CHAR, STACK IT
	CALL	MOVX	;MOVE TO LOGICAL CARRIAGE LOC
	JNC	PRXOK	;IF VALID, DO Y MOTION
	POP	PSW	;ATTEMPT TO MOVE PAST RIGHT MARGIN
	JMP	PRET
PRXOK:	CALL	MOVY	;MOVE TO LOGICAL PAPER LOC
	POP	PSW	;GET CHAR BACK
	CMA		;INVERT IT
	OUT	DATAL	;ISSUE IT
	MVI	B,CHRDY ;GET CHARACTER READY BIT
	MVI	C,CMASK-CHSTB	;CHAR COMMAND
	CALL	CMOUR	;ISSUE COMMAND
	JMP	PSPAC	;PRINT SPACE AND RETURN
;
; LINE FEED ROUTINE
;
PLF:	LXI	D,HIGHT ;GET CHAR HEIGHT
	LHLD	NEWY	;GET LOG PAPER LOC
	DAD	D	;UPDATE IT
	SHLD	NEWY	;STORE NEW LOC
	LXI	D,-PAGER ;GET PRINT REGION SIZE
	DAD	D	;COMPARE
	JNC	PRET	;RETURN IF OKAY

	;PAGE
;
; FORM FEED ROUTINE
;
PFF:	LXI	H,PAGSZ ;GET PAGE SIZE
	SHLD	NEWY	;STORE NEW LOG LOC
	CALL	MOVY	;MOVE THERE
	LXI	H,0	;RESET Y LOC VARS...
	SHLD	YPOS
	SHLD	NEWY
	JMP	PRET	;RETURN
;
; SPACE ROUTINE
;
PSPAC:	LXI	B,BLANK ;GET CHAR WIDTH
	LHLD	NEWX	;GET LOG CARRIAGE LOC
	DAD	B	;UPDATE IT
	SHLD	NEWX	;STORE NEW LOC
	JMP	PRET
;
; BACKSPACE ROUTINE
;
PBS:	LXI	B,-BLANK ;GET -CHAR WIDTH
	LHLD	NEWX	;GET LOG CARRIAGE LOC
	DAD	B	;UPDATE IT. OK?
	JC	PCRX	;YES, DON'T RESET
;
; CARRIAGE RETURN ROUTINE
;
PCR:	LXI	H,0	;RESET LOG CARRIAGE LOC
PCRX:	SHLD	NEWX	;STORE NEW LOC
	JMP	PRET	;RETURN
;
; TAB ROUTINE
;
PTAB:	LHLD	NEWX	;GET LOG CARRIAGE LOC
	XCHG		;INTO DE
	LXI	B,-48	;GET TAB WIDTH (8*BLANK)
	LXI	H,0	;PUSH FIRST TAB STOP...
	PUSH	H
PTAB0:	POP	H	;POP LAST TAB STOP
	DAD	B	;MAKE NEXT TAB STOP
	PUSH	H	;PUSH IT
	DAD	D	;PAST CURRENT LOC?
	JC	PTAB0	;REPEAT IF NOT
	POP	H	;ELSE GET TAB STOP
	MOV	A,L	;MAKE IT POSITIVE
	CMA
	MOV	L,A
	MOV	A,H
 	CMA
	MOV	H,A
	INX	H
	SHLD	NEWX	;STORE NEW CARRIAGE LOC

	;PAGE
;
; RETURN FROM PRINT ROUTINE
;
PRET:	POP	PSW	;RESTORE ALL REGISTERS AND
	POP	H	;	RETURN...
	POP	D
	POP	B
	RET
;
; MOTION ROUTINES. THESE ROUTINES MOVE EITHER THE
;	CARRIAGE OR THE PAPER TO THE LOCATION IN NEWX OR
;	NEWY, RESPECTIVELY.
;
;	MOVX - MOVES THE CARRIAGE. IF THE LOCATION IN NEWX
;	IS PAST THE END OF THE LINE, CARRY IS SET
;	AND NO MOTION TAKES PLACE.
;
;	MOVY - MOVES THE PAPER.
;
MOVX:	LHLD	NEWX	;GET NEW LOC
	XCHG		;INTO DE
	LXI	H,-1-LINSZ
	DAD	D	;PAST END OF LINE?
	RC	;YES, ABORT
	LHLD	XPOS	;GET CURRENT LOC
	XCHG		;INTO DE
	SHLD	XPOS	;STORE NEW LOC
	MVI	B,XRDY	;GET BIT FOR WAIT LOOP
	MVI	C,CMASK-XSTB	;MOVE CARRIAGE COMMAND
	JMP	MOVXY	;GO TO COMMON ROUTINE
MOVY:	LHLD	YPOS	;GET CURRENT LOC
	XCHG		;INTO DE
	LHLD	NEWY	;GET NEW LOC
	SHLD	YPOS	;STORE NEW LOC
	MVI	B,YRDY	;GET BIT FOR WAIT LOOP
	MVI	C,CMASK-YSTB	;MOVE PAPER COMMAND
MOVXY:	MOV	A,E	;CALCULATE NEG OF DISTANCE
	SUB	L	;	TO MOVE (DE-HL) AND PUT
	MOV	L,A	;	IN HL...
	MOV	A,D
	SBB	H
	MOV	H,A
	DCX	H	;COMPLEMENT OF DISTANCE
	JM	MOVZZ	;IF NEG, PUT ON BUS
	INX	H	;DISTANCE IN OION
	MOV	A,L	;COMPLEMENT LOW BYTE...
	CMA
	MOV	L,A
	MOV	A,H	;COMPLEMENT HIGH BYTE, BUT
	XRI	0FBH	;	SET NEG MOTION BIT...
	MOV	H,A
MOVZZ:	MOV	A,L	;PUT DATA ON BUS...
	OUT	DATAL
	MOV	A,H
	OUT	DATAH
	JMP	CMOUR	;ISSUE COMMAND

	;PAGE
	 IF 0   ;FUNCTIONS NOT USED WIIMDOS DIABLO COMMAND
;
|~S>)~q/G_d|+Qx??$OʟjOO|rbaphQhRzJ;SAVE REGISTERS TO BE USED...
	PUSH	PSW
STRT0:	MOV	A,M	;GET THE CHAR
	INX	H	;BUMP POINTER
	CPI	NULL	;IS CHAR NULL?
	JNZ	STRT1	;NO, CONTINUE
	POP	PSW	;NORMAL RETURN...
	POP	B
	RET
STRT1:	MOV	B,A	
	CALL	PRINT	;PRINT IT
	JNC	STRT0	;GET NEXT CHAR, UNLESS ERROR
	POP	B	;ERROR RETURN...
	POP	B
	RET
;
; TEST DRIVER AND PRINTER. PRINT MESSAGE UNTIL B7
;	OF PROGRAMMED INPUT IS SET.
;
TEST:	PUSH	PSW	;SAVE REGISTERS TO BE USED...
	PUSH	H
	CALL	INIT	;INIT DRIVER AND PRINTER
TEST0:	LXI	H,TESTM ;GET ADDRESS OF MESSAGE
	CALL	STROT	;OUTPUT MESSAGE
; ADDITION FOR CP/M DIABLO TESTER  JRB :
	   MVI C,11
	   CALL ENTRY	;INTEROGATE CONSOLE CHAR WAITING
	   RAR		;TEST LSB
	   JC EXIT	;IF CHAR WAITING, STOP
	IN	0FFH	;READ SWITCHES
	RAL		;PUT B7 IN CARRY
	JNC	TEST0	;LOOP UNTIL SWITCH SET
EXIT:	   EQU $	;ADDED BY JRB
	POP	H	;RESTORE SAVED REGISTERS...
	POP	PSW
	RET
TESTM:	DB	'DIABLO PRINTER DRIVER TEST '
	DB	'SUCCESSFUL',CR,LF,0

	 ENDIF
;
	END LISTER
