/*	@(#)ibmtovm.c	1.2		*/
/*
 *	ibmtovm
 *
 *	This 256 byte table is used to convert the ibm monochrome
 *	monitor attribute byte to VME/10 attributes.
 *
 *	It is indexed by the ibm attribute byte.
 */

#include "portab.h"
#include "vmconmd.h"

#define V_NOSEE		V_DEFAULT	/* for clarity, we have a "no see" define */

#define V_DEFAULT	INITATTR	/* when not defined for ibm monitor */

BYTE	ibmtovm[256] =
{
	V_NOSEE,					/* 00 00000000 */
	V_DEFAULT,					/* 01 00000001 */
	V_DEFAULT,					/* 02 00000010 */
	V_DEFAULT,					/* 03 00000011 */
	V_DEFAULT,					/* 04 00000100 */
	V_DEFAULT,					/* 05 00000101 */
	V_DEFAULT,					/* 06 00000110 */
	V_LOWINTENSE|V_CHARON,				/* 07 00000111 */
	V_NOSEE,					/* 08 00001000 */
	V_DEFAULT,					/* 09 00001001 */
	V_DEFAULT,					/* 0a 00001010 */
	V_DEFAULT,					/* 0b 00001011 */
	V_DEFAULT,					/* 0c 00001100 */
	V_DEFAULT,					/* 0d 00001101 */
	V_DEFAULT,					/* 0e 00001110 */
	V_HIGHINTENSE|V_CHARON,				/* 0f 00001111 */
	V_DEFAULT,					/* 10 00010000 */
	V_DEFAULT,					/* 11 00010001 */
	V_DEFAULT,					/* 12 00010010 */
	V_DEFAULT,					/* 13 00010011 */
	V_DEFAULT,					/* 14 00010100 */
	V_DEFAULT,					/* 15 00010101 */
	V_DEFAULT,					/* 16 00010110 */
	V_DEFAULT,					/* 17 00010111 */
	V_DEFAULT,					/* 18 00011000 */
	V_DEFAULT,					/* 19 00011001 */
	V_DEFAULT,					/* 1a 00011010 */
	V_DEFAULT,					/* 1b 00011011 */
	V_DEFAULT,					/* 1c 00011100 */
	V_DEFAULT,					/* 1d 00011101 */
	V_DEFAULT,					/* 1e 00011110 */
	V_DEFAULT,					/* 1f 00011111 */
	V_DEFAULT,					/* 20 00100000 */
	V_DEFAULT,					/* 21 00100001 */
	V_DEFAULT,					/* 22 00100010 */
	V_DEFAULT,					/* 23 00100011 */
	V_DEFAULT,					/* 24 00100100 */
	V_DEFAULT,					/* 25 00100101 */
	V_DEFAULT,					/* 26 00100110 */
	V_DEFAULT,					/* 27 00100111 */
	V_DEFAULT,					/* 28 00101000 */
	V_DEFAULT,					/* 29 00101001 */
	V_DEFAULT,					/* 2a 00101010 */
	V_DEFAULT,					/* 2b 00101011 */
	V_DEFAULT,					/* 2c 00101100 */
	V_DEFAULT,					/* 2d 00101101 */
	V_DEFAULT,					/* 2e 00101110 */
	V_DEFAULT,					/* 2f 00101111 */
	V_DEFAULT,					/* 30 00110000 */
	V_DEFAULT,					/* 31 00110001 */
	V_DEFAULT,					/* 32 00110010 */
	V_DEFAULT,					/* 33 00110011 */
	V_DEFAULT,					/* 34 00110100 */
	V_DEFAULT,					/* 35 00110101 */
	V_DEFAULT,					/* 36 00110110 */
	V_DEFAULT,					/* 37 00110111 */
	V_DEFAULT,					/* 38 00111000 */
	V_DEFAULT,					/* 39 00111001 */
	V_DEFAULT,					/* 3a 00111010 */
	V_DEFAULT,					/* 3b 00111011 */
	V_DEFAULT,					/* 3c 00111100 */
	V_DEFAULT,					/* 3d 00111101 */
	V_DEFAULT,					/* 3e 00111110 */
	V_DEFAULT,					/* 3f 00111111 */
	V_DEFAULT,					/* 40 01000000 */
	V_DEFAULT,					/* 41 01000001 */
	V_DEFAULT,					/* 42 01000010 */
	V_DEFAULT,					/* 43 01000011 */
	V_DEFAULT,					/* 44 01000100 */
	V_DEFAULT,					/* 45 01000101 */
	V_DEFAULT,					/* 46 01000110 */
	V_DEFAULT,					/* 47 01000111 */
	V_DEFAULT,					/* 48 01001000 */
	V_DEFAULT,					/* 49 01001001 */
	V_DEFAULT,					/* 4a 01001010 */
	V_DEFAULT,					/* 4b 01001011 */
	V_DEFAULT,					/* 4c 01001100 */
	V_DEFAULT,					/* 4d 01001101 */
	V_DEFAULT,					/* 4e 01001110 */
	V_DEFAULT,					/* 4f 01001111 */
	V_DEFAULT,					/* 50 01010000 */
	V_DEFAULT,					/* 51 01010001 */
	V_DEFAULT,					/* 52 01010010 */
	V_DEFAULT,					/* 53 01010011 */
	V_DEFAULT,					/* 54 01010100 */
	V_DEFAULT,					/* 55 01010101 */
	V_DEFAULT,					/* 56 01010110 */
	V_DEFAULT,					/* 57 01010111 */
	V_DEFAULT,					/* 58 01011000 */
	V_DEFAULT,					/* 59 01011001 */
	V_DEFAULT,					/* 5a 01011010 */
	V_DEFAULT,					/* 5b 01011011 */
	V_DEFAULT,					/* 5c 01011100 */
	V_DEFAULT,					/* 5d 01011101 */
	V_DEFAULT,					/* 5e 01011110 */
	V_DEFAULT,					/* 5f 01011111 */
	V_DEFAULT,					/* 60 01100000 */
	V_DEFAULT,					/* 61 01100001 */
	V_DEFAULT,					/* 62 01100010 */
	V_DEFAULT,					/* 63 01100011 */
	V_DEFAULT,					/* 64 01100100 */
	V_DEFAULT,					/* 65 01100101 */
	V_DEFAULT,					/* 66 01100110 */
	V_DEFAULT,					/* 67 01100111 */
	V_DEFAULT,					/* 68 01101000 */
	V_DEFAULT,					/* 69 01101001 */
	V_DEFAULT,					/* 6a 01101010 */
	V_DEFAULT,					/* 6b 01101011 */
	V_DEFAULT,					/* 6c 01101100 */
	V_DEFAULT,					/* 6d 01101101 */
	V_DEFAULT,					/* 6e 01101110 */
	V_DEFAULT,					/* 6f 01101111 */
	V_INVERSE|V_LOWINTENSE|V_CHARON,		/* 70 01110000 */
	V_DEFAULT,					/* 71 01110001 */
	V_DEFAULT,					/* 72 01110010 */
	V_DEFAULT,					/* 73 01110011 */
	V_DEFAULT,					/* 74 01110100 */
	V_DEFAULT,					/* 75 01110101 */
	V_DEFAULT,					/* 76 01110110 */
	V_DEFAULT,					/* 77 01110111 */
	V_INVERSE|V_HIGHINTENSE|V_CHARON,		/* 78 01111000 */
	V_DEFAULT,					/* 79 01111001 */
	V_DEFAULT,					/* 7a 01111010 */
	V_DEFAULT,					/* 7b 01111011 */
	V_DEFAULT,					/* 7c 01111100 */
	V_DEFAULT,					/* 7d 01111101 */
	V_DEFAULT,					/* 7e 01111110 */
	V_DEFAULT,					/* 7f 01111111 */
	V_BLINK|V_NOSEE,				/* 80 10000000 */
	V_DEFAULT,					/* 81 10000001 */
	V_DEFAULT,					/* 82 10000010 */
	V_DEFAULT,					/* 83 10000011 */
	V_DEFAULT,					/* 84 10000100 */
	V_DEFAULT,					/* 85 10000101 */
	V_DEFAULT,					/* 86 10000110 */
	V_BLINK|V_LOWINTENSE|V_CHARON,			/* 87 10000111 */
	V_BLINK|V_NOSEE,				/* 88 10001000 */
	V_DEFAULT,					/* 89 10001001 */
	V_DEFAULT,					/* 8a 10001010 */
	V_DEFAULT,					/* 8b 10001011 */
	V_DEFAULT,					/* 8c 10001100 */
	V_DEFAULT,					/* 8d 10001101 */
	V_DEFAULT,					/* 8e 10001110 */
	V_BLINK|V_HIGHINTENSE|V_CHARON,			/* 8f 10001111 */
	V_DEFAULT,					/* 90 10010000 */
	V_DEFAULT,					/* 91 10010001 */
	V_DEFAULT,					/* 92 10010010 */
	V_DEFAULT,					/* 93 10010011 */
	V_DEFAULT,					/* 94 10010100 */
	V_DEFAULT,					/* 95 10010101 */
	V_DEFAULT,					/* 96 10010110 */
	V_DEFAULT,					/* 97 10010111 */
	V_DEFAULT,					/* 98 10011000 */
	V_DEFAULT,					/* 99 10011001 */
	V_DEFAULT,					/* 9a 10011010 */
	V_DEFAULT,					/* 9b 10011011 */
	V_DEFAULT,					/* 9c 10011100 */
	V_DEFAULT,					/* 9d 10011101 */
	V_DEFAULT,					/* 9e 10011110 */
	V_DEFAULT,					/* 9f 10011111 */
	V_DEFAULT,					/* a0 10100000 */
	V_DEFAULT,					/* a1 10100001 */
	V_DEFAULT,					/* a2 10100010 */
	V_DEFAULT,					/* a3 10100011 */
	V_DEFAULT,					/* a4 10100100 */
	V_DEFAULT,					/* a5 10100101 */
	V_DEFAULT,					/* a6 10100110 */
	V_DEFAULT,					/* a7 10100111 */
	V_DEFAULT,					/* a8 10101000 */
	V_DEFAULT,					/* a9 10101001 */
	V_DEFAULT,					/* aa 10101010 */
	V_DEFAULT,					/* ab 10101011 */
	V_DEFAULT,					/* ac 10101100 */
	V_DEFAULT,					/* ad 10101101 */
	V_DEFAULT,					/* ae 10101110 */
	V_DEFAULT,					/* af 10101111 */
	V_DEFAULT,					/* b0 10110000 */
	V_DEFAULT,					/* b1 10110001 */
	V_DEFAULT,					/* b2 10110010 */
	V_DEFAULT,					/* b3 10110011 */
	V_DEFAULT,					/* b4 10110100 */
	V_DEFAULT,					/* b5 10110101 */
	V_DEFAULT,					/* b6 10110110 */
	V_DEFAULT,					/* b7 10110111 */
	V_DEFAULT,					/* b8 10111000 */
	V_DEFAULT,					/* b9 10111001 */
	V_DEFAULT,					/* ba 10111010 */
	V_DEFAULT,					/* bb 10111011 */
	V_DEFAULT,					/* bc 10111100 */
	V_DEFAULT,					/* bd 10111101 */
	V_DEFAULT,					/* be 10111110 */
	V_DEFAULT,					/* bf 10111111 */
	V_DEFAULT,					/* c0 11000000 */
	V_DEFAULT,					/* c1 11000001 */
	V_DEFAULT,					/* c2 11000010 */
	V_DEFAULT,					/* c3 11000011 */
	V_DEFAULT,					/* c4 11000100 */
	V_DEFAULT,					/* c5 11000101 */
	V_DEFAULT,					/* c6 11000110 */
	V_DEFAULT,					/* c7 11000111 */
	V_DEFAULT,					/* c8 11001000 */
	V_DEFAULT,					/* c9 11001001 */
	V_DEFAULT,					/* ca 11001010 */
	V_DEFAULT,					/* cb 11001011 */
	V_DEFAULT,					/* cc 11001100 */
	V_DEFAULT,					/* cd 11001101 */
	V_DEFAULT,					/* ce 11001110 */
	V_DEFAULT,					/* cf 11001111 */
	V_DEFAULT,					/* d0 11010000 */
	V_DEFAULT,					/* d1 11010001 */
	V_DEFAULT,					/* d2 11010010 */
	V_DEFAULT,					/* d3 11010011 */
	V_DEFAULT,					/* d4 11010100 */
	V_DEFAULT,					/* d5 11010101 */
	V_DEFAULT,					/* d6 11010110 */
	V_DEFAULT,					/* d7 11010111 */
	V_DEFAULT,					/* d8 11011000 */
	V_DEFAULT,					/* d9 11011001 */
	V_DEFAULT,					/* da 11011010 */
	V_DEFAULT,					/* db 11011011 */
	V_DEFAULT,					/* dc 11011100 */
	V_DEFAULT,					/* dd 11011101 */
	V_DEFAULT,					/* de 11011110 */
	V_DEFAULT,					/* df 11011111 */
	V_DEFAULT,					/* e0 11100000 */
	V_DEFAULT,					/* e1 11100001 */
	V_DEFAULT,					/* e2 11100010 */
	V_DEFAULT,					/* e3 11100011 */
	V_DEFAULT,					/* e4 11100100 */
	V_DEFAULT,					/* e5 11100101 */
	V_DEFAULT,					/* e6 11100110 */
	V_DEFAULT,					/* e7 11100111 */
	V_DEFAULT,					/* e8 11101000 */
	V_DEFAULT,					/* e9 11101001 */
	V_DEFAULT,					/* ea 11101010 */
	V_DEFAULT,					/* eb 11101011 */
	V_DEFAULT,					/* ec 11101100 */
	V_DEFAULT,					/* ed 11101101 */
	V_DEFAULT,					/* ee 11101110 */
	V_DEFAULT,					/* ef 11101111 */
	V_BLINK|V_INVERSE|V_LOWINTENSE|V_CHARON,	/* f0 11110000 */
	V_DEFAULT,					/* f1 11110001 */
	V_DEFAULT,					/* f2 11110010 */
	V_DEFAULT,					/* f3 11110011 */
	V_DEFAULT,					/* f4 11110100 */
	V_DEFAULT,					/* f5 11110101 */
	V_DEFAULT,					/* f6 11110110 */
	V_DEFAULT,					/* f7 11110111 */
	V_BLINK|V_INVERSE|V_HIGHINTENSE|V_CHARON,	/* f8 11111000 */
	V_DEFAULT,					/* f9 11111001 */
	V_DEFAULT,					/* fa 11111010 */
	V_DEFAULT,					/* fb 11111011 */
	V_DEFAULT,					/* fc 11111100 */
	V_DEFAULT,					/* fd 11111101 */
	V_DEFAULT,					/* fe 11111110 */
	V_DEFAULT,					/* ff 11111111 */
};
* fc 11111100 */
	V_DEFAULT,					/* fd 11111101 */