\   ͻ
\                                                                      
\              FULL SCREEN TEXT EDITOR  BY WELDON BAILEY               
\    BY Weldon Bailey, 5415 Aldine Mail Route, Houston, Tx 77039, USA  
\              WITH a little help form Christy Gemmell, GB             
\                                                                      
\   ͼ
\   Ŀ
\                      USER SPECIFIED CONSTANTS                        
\   

REM LINK86 EDIT,DOSCALLS.L86,VIDEO.L86,PCSCRN.L86

        HELLO1$ =  "EDIT Version 2.04 Text Editor "
        HELLO2$ =  "In CB86. By Weldon Bailey. USA"
        MAX.LINES% = 1500
        MAX.BUFFER.LINES% = 75
        DIM TEXT$(MAX.LINES%)
        DIM BUFFER$(MAX.BUFFER.LINES%)
        DES.BACK.SPACE$ = CHR$(8) + " " + CHR$(8) REM DESTRUCTIVE BACKSPACE
        VIS.CR$ = CHR$(126)             REM MARKS END OF PARAGRAPH
        BELL$ = CHR$(7)
        SCREEN.LINES% = 25 -1           REM ONE LESS THAN ACTUAL
        BOTTOM.LINE% = 25               REM USED FOR MESSAGES ON TEXT SCREEN
        SCREEN.COLS% = 80
        TRUE% = NOT FALSE%
        DONT.BLANK.PACK% = TRUE%
        LINES.PER.PAGE% = 55            REM FOR PRINTER/SPOOLER
        FORM.FEED% = 12                 REM FOR PRINTER/SPOOLER
        SA% = 31                        REM SCREEN ATTRIBUTE
        RA% = 249                       REM REVERSE ATTRIBUTE
        CUR.KEY% = 120                  REM FUN KEYS ACCESS CHR$ 127 - 255
        REM THIS CONTROL$ CONTAINS CONTROL CODES(+ 64) IN THE ORDER :
        REM LEFT CURSOR(^U)             RIGHT CURSOR(^F)
        REM UP CURSOR(^Z)               DOWN CURSOR(^J)
        REM HOME CURSOR(^A)             TAB(^I)
        REM WORD TAB(^L)                
        REM FORWARD PAGE SCROLL(^C)   REMOVED FOR SAFTEY
        REM BACKWARD PAGE SCROLL(^R)
        REM TOP OF TEXT(^T)             BOTTOM OF TEXT(^B)
        REM CARRIAGE RETURN(^M)         CHAR INSERT(^V)
        REM BACK SPACE(^H)              DELETE CHAR(CHR$(127)
        REM DELETE WORD(^Y)             DELETE LINE (^N)
        REM MOVE TO BUFFER(^X)          COPY TO BUFFER(^K)
        REM INSERT BUFFER(^W)           CLEAR BUFFER(^D)
        REM BEGIN END MACRO(^P)         EXECUTE MACRO ONCE(^E)
        REM EXECUTE MACRO MANY(^Q)      
        REM SEARCH FOR(^G)              REPEAT SEARCH(^S) CHANGED TO ALT S
        REM MARK FOR DELETE/MOVE(^O)    COMMAND LOOP (COMMAND SCREEN)(ESC)
        REM EXCHANGE CAP/LOWER CASE(^@)
        REM USER CAN CHANGE CONTROL$ TO REDEFINE CONTROL KEY MEANING
        CONTROL$ = "UFZJAIL@RTBMVH" +CHR$(127+64) + \   REM C DISABLED
         "YNXKWDPEQGSO" + CHR$(27+64) + "@"

\   Ŀ
\                      PROGRAM CONSTANTS                               
\   

        COMMAND.SCREEN$ = "02END03QUIT04NAME05BPN06BPY07ZZ08HELP09PRINT" + \
         "10SPOOL ON11SPOOL OFF12PUT MAC13GET MAC14INCLUDE15READ 16WRITE " + \
         "17LINE 18DELETE 19MOVE20STOP21MBN22MBY23SA24RA"
        REM USED AT COMMAND.SCREEN% FUNCTION TO TRANSLATE COMMANDS

        CR% = ASC(MID$(CONTROL$,12,1)) -64
        CR$ = CHR$(CR%)
        SEARCH.FOR% = ASC(MID$(CONTROL$,25,1)) -64
        BACK.SPACE% = ASC(MID$(CONTROL$,14,1)) -64
        EXECUTE.MACRO.MANY% = ASC(MID$(CONTROL$,24,1)) -64
        COPY.TO.BUFFER% = ASC(MID$(CONTROL$,19,1)) -64
        BEG.END.MACRO% = ASC(MID$(CONTROL$,22,1)) -64
        EXECUTE.MACRO.ONCE% = ASC(MID$(CONTROL$,23,1)) -64
        ESC% = ASC(MID$(CONTROL$,28,1)) -64
        ESC$ = CHR$(27)
        BACK.FILE% = 1    : WORK.FILE% = 2  : UPDATE.FILE% = 3
        INCLUDE.FILE% = 4 : SPOOL.FILE% = 5 : DO.FILE% = 6
        HELP.FILE% = 7    : MACRO.FILE% = 8
        ON ERROR GOTO RECOVER
        IF END # MACRO.FILE% THEN GET.PUT.END
        PRINT.ON% = TRUE%
        SPOOL.CHAR% = FORM.FEED%        REM FOR SPOOLER
        SPOOL.CT% = 1                   REM FOR SPOOLER
        TEXT.0% = VARPTR(TEXT$(0))
        CUR.ROW% = 1
        CUR.COLUMN% = 1
        CUR.TOP.LINE% = 1
        SPACE80$ = STRING$(80," ")
        SPACE256$ = STRING$(512," ")

\   Ŀ
\                      FUNCTIONS                                       
\   

\   Ŀ
    DEF MAKE.ROOM EXTERNAL                                          REM 
\   
        INTEGER MAKE.ROOM
        FEND
        AX% = MAKE.ROOM

\   Ŀ
    DEF KEYPRESS EXTERNAL                                           REM 
\   
        INTEGER KEYPRESS
        FEND

\   Ŀ
    DEF KEYIN                                                       REM 
\   
        INTEGER KEYIN,AX
        AX = KEYPRESS
        SCAN% = AX/256
        KEY% = AX - SCAN%*256
        IF KEY% = -243 THEN KEY% = 13
        IF KEY% = -209 THEN KEY% = 47
        FEND

\   Ŀ
    DEF PRINTCHAR(ASCIIVALUE) EXTERNAL                              REM 
\   
        INTEGER PRINTCHAR,ASCIIVALUE
        FEND

\   Ŀ
    DEF DISPLAY (P0,P1,P2,P3,P4) EXTERNAL                           REM 
\   
        INTEGER DISPLAY,P0,P1,P2,P3,P4
        FEND

\   Ŀ
    DEF SPRINT (ROW,COL,S$,ATTRIB)                                  REM 
\   
        INTEGER SPRINT,ROW,COL,SLOC,ATTRIB
        ROW = ROW-1:IF ROW < 0 THEN ROW = 0
        COL = COL-1:IF COL < 0 THEN COL = 0
        SLOC=SADD(S$)
        IF SLOC <> 0 THEN CALL DISPLAY(3,ROW,COL,SLOC,ATTRIB)
        FEND

\   Ŀ
    DEF APRINT(ROW,COL,S$,ATTRIB)                                   REM 
\   
        INTEGER APRINT,ROW,COL,ATTRIB
        IF S$ = NULL$ THEN S$ = " "
        CALL SPRINT(ROW,COL,S$,ATTRIB)
        FEND

\   Ŀ
    DEF PEEKSCREEN(ROW,COL) EXTERNAL                                REM 
\   
        INTEGER PEEKSCREEN,ROW,COL
        FEND

\   Ŀ
    DEF GETSCREEN(ROW,COL)                                          REM 
\   
        INTEGER GETSCREEN,ROW,COL,AX
        AX = PEEKSCREEN(ROW,COL)
        ATTRIBUTE% = AX/256
        SCREENCHAR% = AX - ATTRIBUTE%*256
        FEND

\   Ŀ
    DEF CURSOR.ON EXTERNAL                                          REM 
\   
        INTEGER CURSOR.ON
        FEND

\   Ŀ
    DEF CURSOR.OFF EXTERNAL                                         REM 
\   
        INTEGER CURSOR.OFF
        FEND

        CALL CURSOR.OFF

\   Ŀ
    DEF SETCUR(ROW,COL) EXTERNAL                                    REM 
\   
        INTEGER SETCUR, ROW, COL
        FEND

\   Ŀ
    DEF LOCCUR(ROW,COL)                                             REM 
\   
        INTEGER LOCCUR,ROW,COL
        ROW = ROW-1:IF ROW<0 THEN ROW = 0
        COL = COL-1:IF COL<0 THEN COL = 0
        CALL SETCUR (ROW,COL)
        FEND

\   Ŀ
    DEF CLEAR.SCREEN(COLOUR) EXTERNAL                               REM 
\   
        INTEGER CLEAR.SCREEN,COLOUR
        FEND

\   Ŀ
    DEF CLS                                                         REM 
\   
        INTEGER CLS
        CALL CLEAR.SCREEN(0)
        FEND

\   Ŀ
    DEF ERAEOL EXTERNAL                                             REM 
\   
        INTEGER ERAEOL
        FEND

\   Ŀ
    DEF EXEC(DOS.COMMAND$) EXTERNAL                                 REM 
\   
        INTEGER EXEC
        FEND

        CALL EXEC("CD > HOMEDRIV.E")
        OPEN "HOMEDRIV.E" AS 1
        READ #1;HOME$
        DELETE 1
        HOME.DRIVE$ = LEFT$(HOME$,2)

\   Ŀ
    DEF PSITION  REM ROUTINE TO POSITION CURSOR                         
\   
        IF NOT PRINT.ON% THEN RETURN
        CALL LOCCUR(CUR.ROW%,CUR.COLUMN%)
        FEND

\   Ŀ
    DEF TEMP.PSITION(ROW%,COL%)                                     REM 
\   
        IF PRINT.ON% THEN CALL LOCCUR(ROW%,COL%)
        FEND

\   Ŀ
    DEF L.UCASE$(ARGUMENT$) = UCASE$(LEFT$(ARGUMENT$,1))            REM 
\   
\   Ŀ
    DEF MIN%(A%,B%) = -(A%<=B%)*A% - (B%<A%)*B%                     REM 
\   
\   Ŀ
    DEF NON.ZERO.MIN%(A%,B%) = MIN%(A%,B%)-(A%=0)*B%-(B%=0)*A%      REM 
\   
\   Ŀ
    DEF MAX%(A%,B%) = -(A%>=B%)*A% - (B%>A%)*B%                     REM 
\   

\   Ŀ
    DEF CURRENT%    REM RETURNS CURRENT TEXT$ LINE NUMBER               
\   
        CUR%  = CUR.ROW% + CUR.TOP.LINE% -1
        BOTTOM.TEXT.LINE% = MAX%(BOTTOM.TEXT.LINE%,CUR%)
        CURRENT% = CUR%
        FEND

\   Ŀ
    DEF GET.SPOOL.CHAR%     REM RETURNS CHAR FOR PRINT SPOOLER          
\   
TAB.SPACE:
        IF SPACE% > 0 THEN \
         GET.SPOOL.CHAR% = 32:SPOOL.CT% = SPOOL.CT%+1:\
         SPACE% = SPACE%-1:RETURN
        IF END # SPOOL.FILE% THEN SPOOL.EOF
        SPOOL.CHAR% = GET(SPOOL.FILE%)
        IF SPOOL.CHAR% = 9 THEN SPACE% = 9-MOD(SPOOL.CT%,8):GOTO TAB.SPACE
        SPOOL.CT% = SPOOL.CT% + 1
        IF SPOOL.CHAR% = 10 THEN SPOOL.CT% = 1:LINES% = LINES% + 1:\
         IF LINES% > LINES.PER.PAGE% THEN LINES% = 0:\
          GET.SPOOL.CHAR% = FORM.FEED%:RETURN
        GET.SPOOL.CHAR% = SPOOL.CHAR%
        RETURN
SPOOL.EOF:
        SPOOLING% = FALSE%
        SPOOL.CHAR% = FORM.FEED%
        FEND

\   Ŀ
    DEF CONSOLE.CHAR%                                               REM 
\   
        WHILE TRUE%
        IF NOT GETTING.INPUT% THEN \
         CALL GETSCREEN(CUR.ROW%,CUR.COLUMN%):\
         CALL APRINT(CUR.ROW%,CUR.COLUMN%,CHR$(SCREENCHAR%),RA%)
        IF CONSTAT% OR (NOT SPOOLING%) THEN \
         CALL KEYIN:CONSOLE.CHAR% = KEY%: \
          IF NOT GETTING.INPUT% THEN \
          CALL APRINT(CUR.ROW%,CUR.COLUMN%,CHR$(SCREENCHAR%),SA%):\
          RETURN ELSE RETURN
        CALL PRINTCHAR(SPOOL.CHAR%)
        SPOOL.CHAR% = GET.SPOOL.CHAR%
        WEND
        FEND

\   Ŀ
    DEF CONSOLE.INPUT%   REM PROVIDES CONSOLE CHAR WHILE SPOOLING       
\   
        WHILE NOT EXECUTE.MACRO%
        KEY% = CONSOLE.CHAR%
        CONSOLE.INPUT% = KEY%
        IF KEY% = BEG.END.MACRO% OR KEY% = EXECUTE.MACRO.ONCE% \
         OR KEY% = EXECUTE.MACRO.MANY% THEN RETURN
        IF SAVE.MACRO% THEN MACRO$ = MACRO$ + CHR$(KEY%):\
         IF KEY% = 0 THEN MACRO$ = MACRO$ + CHR$(SCAN%)
        RETURN
        WEND

        IF MACRO$ = NULL$ THEN EXECUTE.MACRO% = FALSE%:\
         REFRESH% = TRUE% :PRINT.ON% = TRUE%:RETURN
        IF MACRO.KEY.MARKER% >= LEN(MACRO$) THEN MACRO.KEY.MARKER% = 0:\
         MACRO.USED% = MACRO.USED% + 1
        IF MACRO.USED% >= MACRO.TIMES% THEN EXECUTE.MACRO% = FALSE%:\
         REFRESH% = MACRO.TIMES%-1:CONSOLE.INPUT% = 28:\
         PRINT.ON% = TRUE%: RETURN
        MACRO.KEY.MARKER% = MACRO.KEY.MARKER% + 1
        KEY% = ASC(MID$(MACRO$,MACRO.KEY.MARKER%,1))
        CONSOLE.INPUT% = KEY%
        IF KEY% = 0 THEN MACRO.KEY.MARKER% = MACRO.KEY.MARKER% + 1:\
         SCAN% = ASC(MID$(MACRO$,MACRO.KEY.MARKER%,1))
        RETURN
        FEND

\   Ŀ
    DEF GET.INPUT$(PROMPT$) REM GET CONSOLE INPUT A LINE AT A TIME      
\   
        IF PRINT.ON% THEN PRINT PROMPT$;:CALL CURSOR.ON
        GET$ = NULL$
        GETTING.INPUT% = TRUE% 
        WHILE TRUE%
        KEY% = CONSOLE.INPUT%
        GET.LEN% = LEN(GET$)
        IF KEY% = ESC% THEN GET.INPUT$ = NULL$: GOTO EXIT
        IF KEY% = CR% OR KEY% = SEARCH.FOR% THEN GET.INPUT$ = GET$: GOTO EXIT
        IF KEY% > 31 AND KEY% < 127 THEN \
         GET$ = GET$ + CHR$(KEY%): IF PRINT.ON% THEN \
         PRINT CHR$(KEY%);
        IF KEY% = BACK.SPACE% AND GET.LEN% > 0 THEN \
         GET$ = LEFT$(GET$,GET.LEN%-1):\
          IF PRINT.ON% THEN PRINT DES.BACK.SPACE$;
        WEND
EXIT:
        GETTING.INPUT% = FALSE%
        CALL CURSOR.OFF
        FEND

\   Ŀ
    DEF COMMAND.SCREEN%     REM PRINTS COMMAND SCREEN WITH STATS & DOES 
\                          DOS COMMAND, PROGRAM OR RETS ACTION VALUE.  
\   
        CALL CLS:CALL APRINT(1,1,HELLO1$,SA%)
        CALL APRINT(2,1,HELLO2$,SA%)
        IF FRE < 0 THEN MEM = 65536 + FRE ELSE MEM = FRE
        IF MFRE < 0 THEN MEM2 = 65536 + MFRE ELSE MEM2 = MFRE
        CALL APRINT(3,1, "      Memory : "+STR$(MEM)+" "+STR$(MEM2),SA%)
        CALL APRINT(4,1, "    Updating : "+UPDATE.FILE$ ,SA%)
        CALL APRINT(5,1, "Working File : "+WORK.FILE$ ,SA%)
        CALL APRINT(6,1, " Backup File : "+BACK.FILE$ ,SA%)
        CALL APRINT(7,1, "Include File : "+INCLUDE.FILE$ ,SA%)
        CALL APRINT(8,1, "  Spool File : "+SPOOL.FILE$ ,SA%)
        CALL APRINT(9,1, "  Macro File : "+MACRO.FILE$ ,SA%)
        IF SPACE256$ = NULL$ THEN IF MFRE > 511 THEN \
         SPACE256$ = STRING$(512," "):ERR% = FALSE% ELSE ERR% = TRUE%
        IF ERR% THEN CALL APRINT(10,1, "ERROR IS "+ERR,SA%)
        ERR% = FALSE%
        IF MORE.TEXT% THEN CALL APRINT(11,1, "MORE TEXT ON FILE" ,SA%)
        CALL APRINT(12,1, STR$(BOTTOM.TEXT.LINE%)+"<total LINES on>"+STR$(CURRENT%),SA%)
        CALL APRINT(13,1, "Blank Packing:" ,SA%)
        IF DONT.BLANK.PACK% THEN CALL APRINT(13,15," No",SA%) ELSE \
         CALL APRINT (13,15, " Yes"  ,SA%)
COMMAND.INPUT:
        CALL TEMP.PSITION(14,1)
COMMAND.INPUT2:
        AA$ = GET.INPUT$("Enter Command or HELP ")
        PRINT
        A$ = AA$
        IF A$ = NULL$ THEN COMMAND.SCREEN% = 1: RETURN
        A$ = UCASE$(A$)
        M% = MATCH("#",A$,1)
        IF M% THEN LINES%= VAL(MID$(A$+"     ",M%,6)) ELSE LINES% = 0
        IF M% THEN A$ = LEFT$(A$,M%-1)
        M% = MATCH("#"+A$,COMMAND.SCREEN$,1)
        IF M% THEN M% = VAL(MID$(COMMAND.SCREEN$,M%-1,2))
        IF M% = 0 THEN CALL EXEC(AA$): GOTO COMMAND.INPUT2
        COMMAND.SCREEN% = M%
        FEND

\   Ŀ
    DEF EXPAND.TABS  REM EXPANDS TAB STOPS OF COMPRESSED TEXT           
\   
        M% = MATCH(CHR$(9),A$,1)
        WHILE M%
        DONT.BLANK.PACK% = FALSE%
        A$ = LEFT$(A$,M%-1) + LEFT$("        ",9-MOD(M%,8)) + \
         RIGHT$(A$,LEN(A$)-M%)
        M% = MATCH(CHR$(9),A$,1)
        WEND
        A$ = A$ + VIS.CR$
        FEND

\   Ŀ
\          GET UPDATE FILE AND INPUT IT TO TEXT$                       
\   
        UPDATE.FILE$ = COMMAND$
        M% = MATCH("? !",UPDATE.FILE$,1)
        IF M% THEN MACRO.FILE$ = MID$(UPDATE.FILE$,M%+2,12):\
         UPDATE.FILE$ = LEFT$(UPDATE.FILE$,M%):\
         GOSUB GET.MACRO.1:MACRO$ = CR$ + MACRO$
        IF UPDATE.FILE$ = NULL$ THEN UPDATE.FILE$ = "TEST.BAS"
        M% = MATCH(".",UPDATE.FILE$,1)
        IF M% THEN BACK.FILE$ = LEFT$(UPDATE.FILE$,M%-1) ELSE \
         BACK.FILE$ = UPDATE.FILE$
        WORK.FILE$ = BACK.FILE$ + ".$$$"
        BACK.FILE$ = BACK.FILE$ + ".BAK"
        CALL CLS:PRINT:PRINT
        PRINT 
        IF VAL(A$) > 0 THEN MIN.MEM% = VAL(A$) ELSE MIN.MEM% = 5000
        CREATE WORK.FILE$ AS WORK.FILE%
        IF END # UPDATE.FILE% THEN NEW.FILE
        OPEN UPDATE.FILE$ AS UPDATE.FILE%
        GOTO READ.UPDATE.FILE
NEW.FILE:
        UPDATE.NEW% = TRUE%: GOTO COMMAND.LOOP
        DELETE WORK.FILE% 
        CALL CURSOR.ON
        STOP
READ.UPDATE.FILE:
        PRINT "Loading "; UPDATE.FILE$
        IF END # UPDATE.FILE% THEN UPDATE.END
        BEGIN% = 1 :ENDING% = MAX.LINES%
READ.UPDATE.ENTRY:
        FOR J% = BEGIN% TO ENDING%
        PRINT J%;CR$;
        READ # UPDATE.FILE%; LINE A$
        CALL EXPAND.TABS
        WHILE LEN(A$) > SCREEN.COLS%
        TEXT$(J%) = LEFT$(A$,SCREEN.COLS%)
        A$ = RIGHT$(A$,LEN(A$) - SCREEN.COLS%)
        J% = J% + 1
        WEND
        TEXT$(J%) = A$
        IF FRE > 0 AND FRE < MIN.MEM% THEN J% = MAX.LINES%
        NEXT J%
UPDATE.END:
        IF J% >= ENDING% THEN MORE.TEXT% = TRUE% ELSE MORE.TEXT% = FALSE%
        IF MACRO$ <> NULL$ THEN GOSUB EXECUTE.MACRO.ONCE
\ ͻ
\                                                                       
COMMAND.LOOP: REM PRINT COMMAND SCREEN, GET COMMAND AND DO IT           
\                                                                       
\ ͼ
        GOSUB ADD.VIS.CR
        GOSUB FIND.BOTTOM.OF.TEXT
        ON COMMAND.SCREEN% GOSUB \
         EDIT.REFRESH, END.IT, QUIT, RENAME.IT, DONT.BLANK.PACK, \
         BLANK.PACK, DO, HELP, PRINT.SCREEN, SPOOL.ON, SPOOL.OFF,\
         PUT.MACRO, GET.MACRO, INCLUDE, READ.MORE, WRITE, LINE.NO, \
         BLOCK.DELETE, BLOCK.MOVE, STOPP, DONT.BLANK.PACK, BLANK.PACK,\
         SET.SA, SET.RA
        GOTO COMMAND.LOOP

RECOVER: REM RECOVER FROM ERRORS
        ERR% = TRUE%
        IF ERR = "OM" THEN SPACE256$ = NULL$
        PRINT.ON% = TRUE%
        GOTO COMMAND.LOOP

\ Ŀ
END.IT: REM "END" COMMAND ENDS EDITING SESSION AND SAVES FILE           
\ 
        GOSUB FIND.BOTTOM.OF.TEXT
        FOR LINE.CT% = 1 TO BOTTOM.TEXT.LINE%
        GOSUB COMPACT.AND.WRITE
        PRINT LINE.CT%;CR$;
        NEXT LINE.CT%
        IF NOT MORE.TEXT% THEN GOTO FINAL.END
        PRINT "Saving end of Text"
        IF END # UPDATE.FILE% THEN END.OF.UPDATE
        K% = 301
        WHILE K% = 301
        FOR K% = 1 TO 300
        READ # UPDATE.FILE%; LINE TEXT$(K%)
        NEXT K%
END.OF.UPDATE:
        FOR L% = 1 TO K%-1
        PRINT USING "&"; # WORK.FILE%; TEXT$(L%)
        NEXT L%
        WEND
FINAL.END:
        PRINT
        CALL EXEC(HOME.DRIVE$)
        CALL EXEC("CD "+HOME$)
        PRINT USING "&"; # WORK.FILE%; STRING$(1,CHR$(1AH))
        CLOSE WORK.FILE%
        IF SIZE(BACK.FILE$) > 0 AND NOT UPDATE.NEW% THEN \
          OPEN BACK.FILE$ AS BACK.FILE%: DELETE BACK.FILE%
        IF NOT UPDATE.NEW% THEN CLOSE UPDATE.FILE% :\
         K% = RENAME(BACK.FILE$,UPDATE.FILE$)
        K% = RENAME(UPDATE.FILE$,WORK.FILE$)
        CALL CURSOR.ON
        STOP
COMPACT.AND.WRITE:
        A$ = NULL$
        WHILE RIGHT$(TEXT$(LINE.CT%),1) <> VIS.CR$
        A$ = A$ + TEXT$(LINE.CT%)
        TEXT$(LINE.CT%) = NULL$
        LINE.CT% = LINE.CT% + 1
        WEND
        A$ = A$ + LEFT$(TEXT$(LINE.CT%),LEN(TEXT$(LINE.CT%))-1)
        TEXT$(LINE.CT%) = NULL$
        IF DONT.BLANK.PACK% OR MATCH(CHR$(34),A$,1) THEN \
         GOTO OUTPUT.WORKFILE 
        FOR L% = INT%(LEN(A$)/8) TO 1 STEP -1
        IF MID$(A$,L%*8-1,2) <> "  " THEN GOTO NEXT.L
        FOR M% = L%*8-2 TO (L%-1)*8 +1 STEP -1
        IF MID$(A$,M%,1) <> " " THEN GOTO COMPACT
        NEXT M%
COMPACT:
        A$ = LEFT$(A$,M%) + CHR$(9) + RIGHT$(A$,LEN(A$) - L%*8)
NEXT.L:
        NEXT L%
OUTPUT.WORKFILE: 
        PRINT USING "&"; # WORK.FILE%; A$
        RETURN

\ Ŀ
QUIT: REM "QUIT" ENDS EDITING SESSION AND CANCELS CHANGES               
\ 
        IF NOT UPDATE.NEW% THEN CLOSE UPDATE.FILE%
        DELETE WORK.FILE%
        CALL CURSOR.ON
        STOP

\ Ŀ
RENAME.IT: REM "NAME" NAMES OR RENAMES VARIOUS FILES                    
\ 
        A$ = GET.INPUT$("Enter Update file name ")
        PRINT : IF A$ <> NULL$ THEN UPDATE.FILE$ = A$
GET.INCLUDE:
        A$ = GET.INPUT$("      Include file name ")
        PRINT : IF A$ <> NULL$ THEN INCLUDE.FILE$ = A$ ELSE GOTO GET.SPOOL
        IF END # INCLUDE.FILE% THEN NO.INCLUDE
        IF INCLUDE.OPEN% THEN CLOSE INCLUDE.FILE%
        OPEN INCLUDE.FILE$ AS INCLUDE.FILE%
        INCLUDE.OPEN% = TRUE%
NO.INCLUDE:
GET.SPOOL:
        A$ = GET.INPUT$("      Spool file name ")
        PRINT : IF A$ <> NULL$ THEN SPOOL.FILE$ = A$ ELSE RETURN
        IF END # SPOOL.FILE% THEN NO.SPOOL
        IF SPOOL.OPEN% THEN CLOSE SPOOL.FILE%
        OPEN SPOOL.FILE$ AS SPOOL.FILE%
        SPOOL.OPEN% = TRUE%
NO.SPOOL:
        RETURN

\ Ŀ
BLANK.PACK: REM "BPY" (BLANK PACK YES) COMPACTS TEXT UPON SAVING        
\ 
        DONT.BLANK.PACK% = FALSE% 
        RETURN 

\ Ŀ
DONT.BLANK.PACK: REM "BPN"(BLANK PACK NO) MEANS NO COMPACT TEXT SAVED   
\ 
        DONT.BLANK.PACK% = TRUE%
        RETURN 

\ Ŀ
SET.SA: REM SET SCREEN ATTRIBUTE FOR TEXT                               
\ 
        IF LINES% <> 0 THEN SA% = LINES%
        RETURN

\ Ŀ
SET.RA: REM SET SCREEN ATTRIBUTE FOR CURSOR                             
\ 
        IF LINES% <> 0 THEN RA% = LINES%
        RETURN

\ Ŀ
DO: REM "DO" CARRY OVER FROM CPM NOT NOW USED                           
\ 
        RETURN

\ Ŀ
HELP: REM "HELP" PRINTS COMMANDS AND KEYSTROKE USE                      
\ 
        CALL CLS
        PRINT "Commands are END (end editing and save changes) QUIT (end and forget changes)"
        PRINT "NAME (change name of file, include file, macro file)  BPN BPY (Blank pack y/n)"
        PRINT "PRINT (print file from cursor) PUT MAC (save key macro to disk) GET MAC"
        PRINT "INCLUDE (include text from file at cursor) READ xxx (Read xxx lines from disk)"
        PRINT "WRITE xxx Lines DELETE or DELETE xxx (delete Marked text or xxx lines)"
        PRINT "MOVE (move marked text to cursor) STOP (immediate QUIT) SA xx & RA xx (colors)"
        PRINT "SPOOL ON & SPOOL OFF (Print another file)  ESC key switches screens"
        PRINT "        CURSOR KEYS AS FOLLOWS (* use special keys)"
        PRINT "      *  cursor left                *  cursor right"
        PRINT "      *  cursor up                  *  cursor down"
        PRINT "      *  home cursor                *  tab"
        PRINT "      *  ENTER to break line        *  insert"
        PRINT "      *  backspace                  *  END of line"
        PRINT "      *  page up                    *  page down"
        PRINT "      *  Delete char                *  ESC to switch screens"
        PRINT "      ^L word tab                   ^T top of text"
        PRINT "      ^B bottom of text             ^Y delete word"
        PRINT "      ^N delete line from cursor    ^X move line to buffer"
        PRINT "      ^K copy line to buffer        ^W insert line buffer"
        PRINT "      ^D clear line buffer          ^P begin/end keystroke mac"
        PRINT "      ^E execute macro once         ^Q execute macro many"
        PRINT "      ^G search for (uses #?!)      ^S repeat search/replace" 
        PRINT "      ^O mark text lines begin & end for move or delete"
        PRINT
        A$ = GET.INPUT$("      Press ENTER ")
        RETURN

\ Ŀ
PRINT.SCREEN: REM "PRINT" PRINTS TEXT BEING EDITED TO PRINTER           
\ 
        IF SPOOLING% THEN RETURN
        GOSUB FIND.BOTTOM.OF.TEXT
        LINES% = 0
        IF MATCH("\!",A$,1) THEN \
         TITLE$ = CHR$(FORM.FEED%) + "FILE: " + UPDATE.FILE$:\
         ELSE TITLE$ = NULL$
        LPRINTER
        IF TITLE$ <> NULL$ THEN PRINT TITLE$:PRINT
        IF MARK.END% THEN J2% = MARK.BEGIN%:J3% = MARK.END% ELSE \
         J2% = CURRENT%:J3% = BOTTOM.TEXT.LINE%
        FOR J% = J2% TO J3%
        WORK.LEN% = LEN(TEXT$(J%))
        PRINT LEFT$(TEXT$(J%),WORK.LEN%-1)
        LINES% = LINES% + 1
        IF LINES% > LINES.PER.PAGE% THEN PRINT TITLE$:PRINT:LINES% = 0
        IF CONSTAT% THEN CONSOLE:RETURN
        NEXT J%
        CONSOLE
        RETURN

\ Ŀ
SPOOL.ON: REM "SPOOL ON" SETS FLAG TO SPOOL A DISK FILE WHILE EDITING   
\ 
        SPOOLING% = TRUE%
        RETURN

\ Ŀ
SPOOL.OFF: REM "SPOOL OFF" SET FLAG FOR SPOOL OFF                       
\ 
        SPOOLING% = FALSE%
        RETURN

\ Ŀ
PUT.MACRO: REM "PUT MAC" SAVES CURRENT KEYSTROKE MAC TO NAMED DISK FILE 
\ 
        A$ = GET.INPUT$("      Macro file name ")
        PRINT : IF A$ <> NULL$ THEN MACRO.FILE$ = A$
        CREATE MACRO.FILE$ AS MACRO.FILE%
        FOR J% = 1 TO LEN(MACRO$)
        PUT MACRO.FILE%,ASC(MID$(MACRO$,J%,1))
        NEXT J%
        PUT MACRO.FILE%,28
        CLOSE MACRO.FILE%
        RETURN

\ Ŀ
GET.MACRO: REM "GET MAC" GETS KEYSTROKE MACRO FROM NAMED DISK FILE      
\ 
        A$ = GET.INPUT$("      Macro file name ")
        PRINT : IF A$ <> NULL$ THEN MACRO.FILE$ = A$
GET.MACRO.1:
        OPEN MACRO.FILE$ AS MACRO.FILE%
        MACRO$ = NULL$
        WHILE TRUE%
        J% = GET(MACRO.FILE%)
        IF J% = 28 THEN CLOSE MACRO.FILE% : RETURN
        MACRO$ = MACRO$ + CHR$(J%)
        WEND
GET.PUT.END:
        RETURN

\ Ŀ
INCLUDE: REM "INCLUDE" GETS A SCREEN FULL FROM INCLUDE FILE & INSERTS IT
\ 
        IF NOT INCLUDE.OPEN% THEN GOSUB GET.INCLUDE
        IF END # INCLUDE.FILE% THEN EOF.INCLUDE
        GOSUB CLEAR.BUFFER
        A$ = NULL$
        WHILE BUFFER.BOTTOM% < SCREEN.LINES%
        READ # INCLUDE.FILE%; LINE A$
        CALL EXPAND.TABS
        WHILE LEN(A$) > SCREEN.COLS%
        BUFFER$(BUFFER.BOTTOM%) = LEFT$(A$,SCREEN.COLS%)
        BUFFER.BOTTOM% = BUFFER.BOTTOM% + 1
        A$ = RIGHT$(A$,LEN(A$) - SCREEN.COLS%)
        WEND
        BUFFER$(BUFFER.BOTTOM%) = A$
        BUFFER.BOTTOM% = BUFFER.BOTTOM% + 1
        WEND
END.OF.INCLUDE:
        CALL CLS
        FOR J% = 0 TO BUFFER.BOTTOM% - 1
        CALL APRINT(J%+1,1,BUFFER$(J%)+STRING$(80-LEN(BUFFER$(J%))," "),SA%)
        NEXT J%
        CALL TEMP.PSITION(BOTTOM.LINE%,1)
        PRINT "Y to accept, CR to cont ";:CALL ERAEOL
        KEY$ = L.UCASE$(CHR$(CONSOLE.INPUT%))
        IF KEY$ = "Y" THEN GOSUB INSERT.BUFFER: GOSUB CLEAR.BUFFER
        CALL TEMP.PSITION(BOTTOM.LINE%,1)
        PRINT "ESC to stop, CR to cont ";:CALL ERAEOL
        KEY$ = L.UCASE$(CHR$(CONSOLE.INPUT%))
        IF KEY$ = ESC$ THEN GOSUB CLEAR.BUFFER:RETURN
        IF NOT INCLUDE.OPEN% THEN RETURN
        GOTO INCLUDE
EOF.INCLUDE:
        INCLUDE.OPEN% = FALSE%
        CLOSE INCLUDE.FILE%
        GOTO END.OF.INCLUDE

\ Ŀ
READ.MORE: REM "READ nnn" READS MORE TEXT FROM INPUT FILE               
\ 
        GOSUB FIND.BOTTOM.OF.TEXT
        BEGIN% = BOTTOM.TEXT.LINE% + 1
        IF LINES% = 0 THEN ENDING% = MAX.LINES% ELSE ENDING% = BEGIN% + LINES%
        ENDING% = MIN%(MAX.LINES%,ENDING%)
        GOTO READ.UPDATE.ENTRY

\ Ŀ
WRITE: REM "WRITE nnn" SAVES NUMBER OF LINES SPECIFIED TO WORK FILE     
\ 
        PRINT.ON% = FALSE%
        GOSUB TOP.OF.TEXT
        IF LINES% = 0 THEN GOSUB FIND.BOTTOM.OF.TEXT:\
         LINES% = BOTTOM.TEXT.LINE%-1
        FOR LINE.CT% = 1 TO LINES%
        GOSUB COMPACT.AND.WRITE
        NEXT LINE.CT%
        FOR J% = LINES%+1 TO MAX.LINES%
        TEXT$(J%-LINES%) = TEXT$(J%)
        TEXT$(J%) = NULL$
        NEXT J%
        PRINT.ON% = TRUE%
        RETURN

\ Ŀ
LINE.NO: REM "LINE nnn" SETS CURSOR TO LINE nnn                         
\ 
        GOSUB FIND.BOTTOM.OF.TEXT
        CUR.ROW% = 1
        CUR.TOP.LINE% = MIN%(BOTTOM.TEXT.LINE%,MAX%(LINES%,1))
        RETURN

\ Ŀ
BLOCK.DELETE:  REM "DELETE nnn" DELETES nnn LINES STARTING AT CURSOR    
\              "DELETE" DELETES TEXT MARKED WITH MARK TEXT KEY          
\ 
        IF LINES% > 0 THEN MARK.BEGIN% = CURRENT%:GOSUB FIND.BOTTOM.OF.TEXT:\
         LINES% = MIN%(BOTTOM.TEXT.LINE%-MARK.BEGIN%+1,LINES%):\
         MARK.END% = MARK.BEGIN%+LINES%-1
        IF MARK.BEGIN% = 0 OR MARK.END% = 0 THEN RETURN
        IF MARK.END% <MARK.BEGIN% THEN J% = MARK.END%:MARK.END% = MARK.BEGIN%:\
         MARK.BEGIN% = J%
        LINES% = MARK.END%-MARK.BEGIN%+1
        FOR J% = MARK.END% + 1 TO MAX.LINES%
        TEXT$(J%-LINES%) = TEXT$(J%)
        TEXT$(J%) = NULL$
        NEXT J%
        FOR J% = MAX.LINES%-LINES%+1 TO MAX.LINES%
        TEXT$(J%) = NULL$
        NEXT J%
        CUR.TOP.LINE% = MARK.BEGIN%
        CUR.ROW% = 1: MARK.BEGIN% = 0: MARK.END% = 0
        RETURN

\ Ŀ
BLOCK.MOVE:  REM "MOVE" MOVES MARKED TEXT TO PSITION ABOVE CURSOR       
\ 
        BLOCK1% = MIN%(MARK.BEGIN%,MARK.END%)
        IF NOT BLOCK1% THEN RETURN
        LEN1% = ABS(MARK.END%-MARK.BEGIN%)+1
        NEXT.LINE% = CURRENT%
        IF (BLOCK1% <=NEXT.LINE%) AND (NEXT.LINE% <= BLOCK1%+LEN1%) THEN RETURN
        IF CURRENT% > BLOCK1%+LEN1% THEN BLOCK2% = BLOCK1% + LEN1% :\
         LEN2% = CURRENT% - BLOCK2%  ELSE BLOCK2%=BLOCK1%: \
         LEN2%=LEN1%:BLOCK1% = CURRENT%: LEN1% = BLOCK2% - BLOCK1%:\
         NEXT.LINE%= BLOCK2%+LEN2%
        WHILE TRUE%
        FOR J% = 0 TO MIN%(LEN1%,LEN2%) -1
        A$ = TEXT$(J% + BLOCK1%)
        TEXT$(J% + BLOCK1%) = TEXT$(J% + BLOCK2%)
        TEXT$(J% + BLOCK2%) = A$
        NEXT J%
        BLOCK1% = BLOCK1% + MIN%(LEN1%,LEN2%)
        IF LEN2% > LEN1% THEN LEN2% = ABS(LEN1%-LEN2%):\
         BLOCK2%=NEXT.LINE%-LEN2%:LEN1%=BLOCK2%-BLOCK1% \
         ELSE LEN1% = ABS(LEN1%-LEN2%): BLOCK2%=LEN1%+BLOCK1%
REM     IF MARK.END% = 0 THEN RETURN
        IF MIN%(LEN1%,LEN2%) = 0 THEN MARK.END% = 0:MARK.BEGIN%=0:RETURN
        WEND

\ Ŀ
STOPP:  CALL CURSOR.ON :STOP                    REM IF MACHINE HANGS    
\ 

\ ͻ
\                                                                       
\                       TEXT SCREEN PORTION OF PROGRAM                  
\                                                                       
\ ͼ

\ Ŀ
EDIT.LOOP: REM MAIN TEXT LOOP. KEYSTROKES ON TEXT SCREEN INTREPRETED HERE
\ 
        KEY% = CONSOLE.INPUT%
        WHILE KEY% = 0
        IF SCAN% < 59 OR SCAN%>83 THEN GOTO EDIT.LOOP
        FORWARD.BACK% = 1
        INSERTING% = FALSE%
        ON SCAN%-58 GOSUB F1,F2,F3,F4,F5,F6,F7,F8,F9,F10,F11,F12,\
         HOME.CURSOR, CURSOR.UP, BACK.PAGE.SCROLL, KEY.74, CURSOR.LEFT, \
         KEY.76, CURSOR.RIGHT, KEY.78, END.OF.LINE, CURSOR.DOWN, \
         FOR.PAGE.SCROLL, CHAR.INSERT, DELETE.CHAR
END.SCAN:
        IF REFRESH% THEN GOTO EDIT.REFRESH
        GOTO EDIT.LOOP
        WEND
        IF KEY% = 28 THEN GOTO EDIT.LOOP
        FORWARD.BACK% = 1
        IF KEY% > 31 AND KEY% < 127 THEN GOSUB PROCESS.TEXT: GOTO EDIT.LOOP
        M% = MATCH(CHR$(KEY%+64),CONTROL$,1)
        IF CHR$(KEY%) <> CR$ THEN INSERTING% = FALSE%
        IF M% = 0 THEN GOTO EDIT.LOOP
        ON M% GOSUB CURSOR.LEFT, CURSOR.RIGHT, CURSOR.UP, CURSOR.DOWN, \
         HOME.CURSOR, TAB.IT, WORD.TAB, \
         FOR.PAGE.SCROLL, BACK.PAGE.SCROLL, TOP.OF.TEXT, BOTTOM.OF.TEXT, \
         CR, CHAR.INSERT, BACK.SPACE, DELETE.CHAR, DELETE.WORD, DELETE.LINE, \
         MOVE.TO.BUFFER, COPY.TO.BUFFER , INSERT.BUFFER , CLEAR.BUFFER, \
         BEG.END.MACRO, EXECUTE.MACRO.ONCE, EXECUTE.MACRO.MANY, \
         SEARCH.FOR, REPEAT.SEARCH, MARK.TEXT, COMMAND.LOOP, CAP.EXCHANGE

        IF NOT REFRESH% THEN GOTO EDIT.LOOP
EDIT.REFRESH:
        IF PRINT.ON% THEN CALL CLS
        FOR J% = 1 TO SCREEN.LINES%
REM     IF CONSTAT% AND REFRESH% THEN GOTO EDIT.LOOP
        IF PRINT.ON% THEN \
         CALL APRINT(J%,1,TEXT$(J%+ CUR.TOP.LINE%-1)+\
          STRING$(80-LEN(TEXT$(J%+ CUR.TOP.LINE%-1))," "),SA%)
        NEXT J%
        CALL PSITION
        REFRESH% = FALSE%
        GOTO EDIT.LOOP

\ Ŀ
F1:     CUR.KEY% = CUR.KEY%+9                                       REM 
\ 

        IF CUR.KEY%>247 THEN CUR.KEY%=1         REM WAS 120
        CALL TEMP.PSITION(BOTTOM.LINE%,1)
        FOR J% = 0 TO 8
        PRINT "F";STR$(J%+2);" ";CHR$(CUR.KEY%+J%);"  ";
        NEXT J%
        RETURN
F2:     KEY% = CUR.KEY%+0:GOTO PROCESS.TEXT
F3:     KEY% = CUR.KEY%+1:GOTO PROCESS.TEXT
F4:     KEY% = CUR.KEY%+2:GOTO PROCESS.TEXT
F5:     KEY% = CUR.KEY%+3:GOTO PROCESS.TEXT
F6:     KEY% = CUR.KEY%+4:GOTO PROCESS.TEXT
F7:     KEY% = CUR.KEY%+5:GOTO PROCESS.TEXT
F8:     KEY% = CUR.KEY%+6:GOTO PROCESS.TEXT
F9:     KEY% = CUR.KEY%+7:GOTO PROCESS.TEXT
F10:    KEY% = CUR.KEY%+8:GOTO PROCESS.TEXT
F11:
F12:
        GOTO PROCESS.TEXT
KEY.74:
KEY.76:
KEY.78:
        CALL TEMP.PSITION(BOTTOM.LINE%,1)
        PRINT "KEY ";STR$(SCAN%-58);:CALL ERAEOL
        CALL PSITION
        RETURN
END.OF.LINE:
        CUR.COLUMN% = 79
        GOTO WORD.TAB
\ Ŀ
MARK.TEXT: REM MARK BEGINNING AND END OF TEXT FOR DELETION              
\ 
        CALL TEMP.PSITION(BOTTOM.LINE%,1)
        PRINT "Mark:";
        IF MARK.END% THEN PRINT "Cancel";:CALL ERAEOL:\
         MARK.END%=0:MARK.BEGIN%=0:\
         CALL PSITION:RETURN
        IF MARK.BEGIN% THEN MARK.END%=MAX%(CURRENT%,MARK.BEGIN%):\
         MARK.BEGIN%=MIN%(CURRENT%,MARK.BEGIN%):\
         PRINT MARK.BEGIN%;"Thru";MARK.END%;:CALL ERAEOL:\
         CALL PSITION:RETURN
        MARK.BEGIN% = CURRENT%
        PRINT MARK.BEGIN%;:CALL ERAEOL
        CALL PSITION
        RETURN

\ Ŀ
CURSOR.LEFT: REM CURSOR IS MOVED LEFT WITHOUT DISTRUBING TEXT           
\ 
        IF CUR.COLUMN% = 1 THEN CUR.COLUMN% = SCREEN.COLS%:GOTO CURSOR.UP
        CUR.COLUMN% = CUR.COLUMN% -1
        CALL PSITION
        RETURN
\ Ŀ
CURSOR.RIGHT: REM CURSOR MOVED RIGHT WITHOUT DISTRUBING TEXT            
\ 
        IF CUR.COLUMN% >= SCREEN.COLS% THEN CUR.COLUMN% = 1: GOTO CURSOR.DOWN
        CUR.COLUMN% = CUR.COLUMN% + 1
        CALL PSITION
        RETURN

\ Ŀ
CURSOR.UP: REM CURSOR MOVED UP ONE LINE WITHOUT DISTURBING TEXT         
\ 
        IF CUR.TOP.LINE% = 1 AND CUR.ROW% = 1 THEN RETURN
        IF CUR.ROW% > 1 THEN GOSUB ADD.VIS.CR
        WHILE CUR.TOP.LINE% > 1 AND CUR.ROW% = 1
        CUR.TOP.LINE% = CUR.TOP.LINE% -1
        FOR J% = 1 TO SCREEN.LINES%
        IF PRINT.ON% THEN \
        CALL APRINT(J%,1,TEXT$(J%+ CUR.TOP.LINE%-1)+STRING$(80-LEN(TEXT$(J%+ CUR.TOP.LINE%-1))," "),SA%)
        NEXT J%
        RETURN
        WEND
        CUR.ROW% = CUR.ROW% -1
        CALL PSITION
        RETURN

\ Ŀ
CURSOR.DOWN: REM CURSOR MOVED DOWN ONE LINE WITHOUT DISTRUBING TEXT     
\ 
        IF CUR.TOP.LINE% >= MAX.LINES%- SCREEN.LINES% AND \
         CUR.ROW% >= SCREEN.LINES% THEN RETURN
        GOSUB ADD.VIS.CR
        IF (CUR.TOP.LINE% < MAX.LINES% - SCREEN.LINES%) AND \
         CUR.ROW% = SCREEN.LINES% THEN \
         CUR.TOP.LINE% = CUR.TOP.LINE% + 1: \
         CALL TEMP.PSITION(BOTTOM.LINE%,1):\
         GOSUB PRINT1:\
         CALL PSITION : RETURN
        CUR.ROW% = CUR.ROW% + 1
        CALL PSITION
        RETURN
PRINT1:
        IF NOT PRINT.ON% THEN RETURN
        CALL TEMP.PSITION(SCREEN.LINES%+1,1):PRINT
        CALL APRINT(SCREEN.LINES%,1,TEXT$(CUR.TOP.LINE%+SCREEN.LINES% -1)+\
              STRING$(80-LEN(TEXT$(CUR.TOP.LINE%+SCREEN.LINES%-1))," "),SA%)
        RETURN

\ Ŀ
HOME.CURSOR: REM CURSOR FAR LEFT, THEN TOP LEFT, THEN BOTTOM LEFT       
\ 
        IF CUR.COLUMN% > 1 THEN CUR.COLUMN% = 1: CALL PSITION: RETURN
        GOSUB ADD.VIS.CR
        GOSUB FIND.BOTTOM.OF.TEXT
        IF CUR.ROW% = 1 THEN IF BOTTOM.TEXT.LINE%-CUR.TOP.LINE%+1 < \ 
         SCREEN.LINES% THEN CUR.ROW%=BOTTOM.TEXT.LINE%-CUR.TOP.LINE%+1:\
         CALL PSITION:RETURN ELSE \
         CUR.ROW% = SCREEN.LINES%:CALL PSITION : RETURN
        CUR.ROW% = 1 : CALL PSITION: RETURN

\ Ŀ
TAB.IT: REM TAB KEY SET FOR PROGRAMING (1,9,17 ETC)                     
\ 
        CUR.COLUMN% = (INT%((CUR.COLUMN%-1)/8)+1)*8 + 1
        IF CUR.COLUMN% > SCREEN.COLS% THEN CUR.COLUMN% = 1: GOTO CURSOR.DOWN
        CALL PSITION
        RETURN

\ Ŀ
WORD.TAB: REM TABS TO BEGINNING OF NEXT WORD                            
\ 
        GOSUB GET.NEXT.TAB
        IF NEXT.WORD.TAB% > 0 THEN CUR.COLUMN% = NEXT.WORD.TAB%+1:CALL PSITION
        RETURN

\ Ŀ
FOR.PAGE.SCROLL: REM SCROLLS TEXT FORWARD ONE PAGE AT THE TIME          
\ 
        GOSUB ADD.VIS.CR
        GOSUB FIND.BOTTOM.OF.TEXT
        CUR.TOP.LINE% = MIN%(CUR.TOP.LINE%+ SCREEN.LINES% -1,\
         BOTTOM.TEXT.LINE% - SCREEN.LINES% + 1)
        REFRESH% = TRUE%
        IF CUR.TOP.LINE% < 1 THEN CUR.TOP.LINE% = 1:\
         CUR.ROW% = BOTTOM.TEXT.LINE%
        RETURN

\ Ŀ
BACK.PAGE.SCROLL: REM SCROLLS TEXT BACKWARD ONE PAGE AT THE TIME        
\ 
        GOSUB ADD.VIS.CR
        CUR.TOP.LINE% = MAX%(CUR.TOP.LINE%-SCREEN.LINES%+1,1)
        REFRESH% = TRUE%
        RETURN

\ Ŀ
TOP.OF.TEXT: REM GO TO TOP OF TEXT                                      
\ 
        GOSUB ADD.VIS.CR
        CUR.TOP.LINE% = 1
        REFRESH% = TRUE%
        CUR.ROW% = 1
        CUR.COLUMN% = 1
        RETURN

\ Ŀ
BOTTOM.OF.TEXT: REM GO TO BOTTOM OF TEXT                                
\ 
        GOSUB ADD.VIS.CR
        GOSUB FIND.BOTTOM.OF.TEXT
        CUR.TOP.LINE% = BOTTOM.TEXT.LINE% - SCREEN.LINES% + 1
        REFRESH% = TRUE%
        IF CUR.TOP.LINE% <= 1 THEN CUR.TOP.LINE% = 1:\
         CUR.ROW% = BOTTOM.TEXT.LINE% ELSE CUR.ROW% = SCREEN.LINES%
        RETURN

\ Ŀ
CR:     REM CARRIAGE RETURN BREAKS TEXT AT CURSOR OR STARTS NEW LINE    
\           END OF THAT LINE IS MARKED WITH VIS.CR$(~) VISUAL CR        
\ 
        GOSUB ADD.VIS.CR
        IF CUR.COLUMN% = 1 THEN GOSUB OPEN.TEXT: CALL PSITION: RETURN
        WORK.LEN% = LEN(TEXT$(CURRENT%))
        IF PRINT.ON% THEN CALL APRINT (CUR.ROW%,CUR.COLUMN%,\
         VIS.CR$+STRING$(80-CUR.COLUMN%," "),SA%)
        IF CUR.COLUMN% > WORK.LEN% THEN GOSUB DELETE.VIS.CR
        IF CUR.COLUMN% >= WORK.LEN% THEN \
         TEXT$(CURRENT%) = LEFT$(TEXT$(CURRENT%)+SPACE80$,\
         CUR.COLUMN%-1) + VIS.CR$:\ 
          ELSE WORK.TEXT$ =RIGHT$(TEXT$(CURRENT%),WORK.LEN% -CUR.COLUMN%+1):\
          TEXT$(CURRENT%)= LEFT$(TEXT$(CURRENT%),CUR.COLUMN%-1)+VIS.CR$:\
          GOSUB PULL.TEXT.UP
        IF CUR.ROW% < SCREEN.LINES% THEN CUR.ROW% = CUR.ROW% + 1 :\
         ELSE CUR.TOP.LINE% = CUR.TOP.LINE% + 1:GOSUB PRINT2
        CUR.COLUMN% = 1
        CALL PSITION
        GOSUB ADD.VIS.CR
        RETURN
PRINT2:
        IF PRINT.ON% AND (CUR.COLUMN% < SCREEN.COLS%) THEN PRINT
        GOSUB PRINT1
        RETURN

\ Ŀ
CHAR.INSERT: REM FLAG SET, PROCESSED AT PROCESS.TEXT. FLAG STAYS SET    
\                UNTIL CONTROL KEY (OTHER THAN CR) IS HIT               
\ 
        INSERTING% = 1
        RETURN

\ Ŀ
BACK.SPACE: REM SETS FLAG PROCESSED AT PROCESS.TEXT                     
\ 
        KEY% = 32
        IF CUR.COLUMN% = 1 THEN GOSUB PROCESS.TEXT:GOTO CURSOR.LEFT
        FORWARD.BACK% = -1
        GOTO PROCESS.TEXT

\ Ŀ
CAP.EXCHANGE: REM CHARACTER IS TOGGLED CAP TO LOWER CASE                
\ 
        KEY$ = MID$(TEXT$(CURRENT%),CUR.COLUMN%,1)
        IF KEY$ = NULL$ THEN GOSUB CURSOR.DOWN:GOTO HOME.CURSOR
        KEY% = ASC(KEY$)
        IF KEY% > 64 AND KEY% < 91 THEN \
         KEY% = KEY% + 32:GOTO PROCESS.TEXT
        IF KEY% > 96 AND KEY% < 123 THEN \
         KEY% = KEY% - 32: GOTO PROCESS.TEXT
        GOTO CURSOR.RIGHT

\ Ŀ
DELETE.CHAR: REM CHARACTER IS DELETED AND TEXT IS PULLED LEFT           
\ 
        GOSUB ADD.VIS.CR
        WORK.TEXT$ = TEXT$(CURRENT%)
        WORK.LEN% = LEN(WORK.TEXT$)
        IF RIGHT$(WORK.TEXT$,1)=VIS.CR$ AND CUR.COLUMN% = WORK.LEN% THEN RETURN
        IF CUR.COLUMN%> WORK.LEN% THEN RETURN
        TEXT$(CURRENT%) = LEFT$(WORK.TEXT$,CUR.COLUMN%-1) + \
         RIGHT$(WORK.TEXT$,WORK.LEN%-CUR.COLUMN%)
        IF RIGHT$(TEXT$(CURRENT%),1) <> VIS.CR$ THEN \
         WORK.TEXT$ = TEXT$(CURRENT%) :GOTO PULL.TEXT.UP
        IF PRINT.ON% THEN \
         CALL APRINT (CUR.ROW%,CUR.COLUMN%,RIGHT$(WORK.TEXT$,\
         WORK.LEN%-CUR.COLUMN%)+" ",SA%)
        CALL PSITION
        RETURN

\ Ŀ
DELETE.WORD: REM WORD IS DELETED AND TEXT IS PULLED LEFT                
\ 
        GOSUB ADD.VIS.CR
        GOSUB GET.NEXT.TAB
        IF NEXT.WORD.TAB% <= CUR.COLUMN% THEN RETURN
        WORK.TEXT$ = TEXT$(CURRENT%)
        WORK.LEN% = LEN(WORK.TEXT$)
        TEXT$(CURRENT%) = LEFT$(WORK.TEXT$,CUR.COLUMN%-1) + \
         RIGHT$(WORK.TEXT$,WORK.LEN%-NEXT.WORD.TAB%)
        IF RIGHT$(TEXT$(CURRENT%),1) <> VIS.CR$ THEN \
         WORK.TEXT$ = TEXT$(CURRENT%) :GOTO PULL.TEXT.UP
        IF PRINT.ON% THEN \
         CALL APRINT (CUR.ROW%,CUR.COLUMN%,RIGHT$(WORK.TEXT$,WORK.LEN%-\
          NEXT.WORD.TAB%)+STRING$(NEXT.WORD.TAB%-CUR.COLUMN%+1," "),SA%)
        CALL PSITION
        RETURN

\ Ŀ
DELETE.LINE: REM DELETES LINE FROM CURSOR TO END OF LINE. TEXT PULLED UP
\ 
        GOSUB DELETE.VIS.CR
        WORK.TEXT$ = LEFT$(TEXT$(CURRENT%) + SPACE80$,CUR.COLUMN%-1)
PULL.TEXT.UP:
        GOSUB FIND.BOTTOM.OF.TEXT 
        IF BOTTOM.TEXT.LINE% = CURRENT% THEN RETURN
        I% = 0
        WHILE RIGHT$(WORK.TEXT$,1) <> VIS.CR$ AND WORK.TEXT$ <> NULL$
        I% = I% + 1
        WORK.TEXT$ = WORK.TEXT$ + TEXT$(CURRENT% + I%)
        WEND
        IF KEY% = CR% THEN I% = I% -1
        IF LEN(WORK.TEXT$) > SCREEN.COLS%*(I%+1) THEN \
         CUR.ROW% = CUR.ROW% + 1: P.U.CALLED% = TRUE%:\
         GOSUB OPEN.TEXT : I% = 0 : CUR.ROW% = CUR.ROW% -1:\
         P.U.CALLED% = FALSE%
        IF LEN(WORK.TEXT$) <= SCREEN.COLS%*I% THEN \
         GOSUB DELETE.LINE1 : I% = 0
        J% = 0
        IF KEY% = CR% THEN CUR.ROW% = CUR.ROW% + 1
        WHILE WORK.TEXT$ <> NULL$
        TEXT$(CURRENT% + J%) = LEFT$(WORK.TEXT$,SCREEN.COLS%)
        WORK.LEN% = LEN(WORK.TEXT$) -SCREEN.COLS%
        WORK.LEN% = MAX%(WORK.LEN%,0)
        J% = J% + 1
        WORK.TEXT$ = RIGHT$(WORK.TEXT$,WORK.LEN%)
        WEND
        IF I% THEN GOSUB REWRITE.PART1 ELSE GOSUB REWRITE.PART
        IF KEY% = CR% THEN CUR.ROW% = CUR.ROW% -1:RETURN
        CALL PSITION
        RETURN
DELETE.LINE1:
        MIN.VARPTR% = VARPTR(TEXT$(CURRENT%))
        MIN1% = PEEK(MIN.VARPTR%) : MIN2% = PEEK(MIN.VARPTR%+1)
        FOR J% = CUR.ROW% + CUR.TOP.LINE% TO BOTTOM.TEXT.LINE%
        FROM% = TEXT.0% + J%*2
        TO% = FROM% - 2
        POKE TO%, PEEK(FROM%)
        POKE TO%+1, PEEK(FROM%+1)
        NEXT J%
        MAX.VARPTR% = VARPTR(TEXT$(BOTTOM.TEXT.LINE%))
        POKE MAX.VARPTR%, MIN1% 
        POKE MAX.VARPTR% +1, MIN2%
        TEXT$(BOTTOM.TEXT.LINE%) = NULL$:BOTTOM.TEXT.LINE%=BOTTOM.TEXT.LINE%-1
        RETURN
REWRITE.PART:
        FOR J% = CUR.ROW% TO SCREEN.LINES%
        IF PRINT.ON% THEN \
         CALL APRINT(J%,1,TEXT$(J%+CUR.TOP.LINE%-1)+\
         STRING$(80-LEN(TEXT$(J%+CUR.TOP.LINE%-1))," "),SA%)
        NEXT J%
        RETURN
REWRITE.PART1:
        LINE.END% = CUR.ROW% + I%
        IF LINE.END% > SCREEN.LINES% THEN GOTO REWRITE.PART
        FOR J% = CUR.ROW% TO LINE.END%
        IF PRINT.ON% THEN \
         CALL APRINT(J%,1,TEXT$(J%+CUR.TOP.LINE%-1)+\
         STRING$(80-LEN(TEXT$(J%+CUR.TOP.LINE%-1))," "),SA%)
        NEXT J%
        RETURN

\ Ŀ
MOVE.TO.BUFFER: REM MOVES LINE AT CURSOR TO BUFFER AND DELETES LINE FROM TEXT
COPY.TO.BUFFER: REM COPIES LINE AT CURSOR TO BUFFER WITHOUT DELETING LINE
\ 
        GOSUB ADD.VIS.CR
        IF BUFFER.BOTTOM% > MAX.BUFFER.LINES% THEN PRINT BELL$;:RETURN
        BUFFER$(BUFFER.BOTTOM%) = TEXT$(CURRENT%)
        BUFFER.BOTTOM% = BUFFER.BOTTOM% + 1
        IF KEY% = COPY.TO.BUFFER% THEN GOTO CURSOR.DOWN
        SAVE.COL% = CUR.COLUMN%
        CUR.COLUMN% = 1
        GOSUB DELETE.LINE
        CUR.COLUMN% = SAVE.COL%
        CALL PSITION
        RETURN

\ Ŀ
INSERT.BUFFER:  REM CONTENTS OF BUFFER COPIED TO TEXT ABOVE LINE AT CURSOR
\ 
        GOSUB ADD.VIS.CR
        IF BUFFER.BOTTOM% = 0 THEN RETURN
        CALL TEMP.PSITION(BOTTOM.LINE%,1)
        IF PRINT.ON% THEN \
         PRINT "Inserting ";BUFFER.BOTTOM%;" lines ";:CALL ERAEOL
        FOR J% = MAX.LINES% TO CURRENT% + BUFFER.BOTTOM% STEP -1
        TEXT$(J%) = TEXT$(J%-BUFFER.BOTTOM%)
        NEXT J%
        FOR J% = 0 TO BUFFER.BOTTOM% -1
        TEXT$(CURRENT% + J%) = BUFFER$(J%)
        NEXT J%
        REFRESH% = TRUE%
        CUR.TOP.LINE% = CUR.TOP.LINE% + BUFFER.BOTTOM%
        RETURN

\ Ŀ
CLEAR.BUFFER: REM CLEARS BUFFER                                         
\ 
        FOR J% = 1 TO MAX.BUFFER.LINES%
        BUFFER$(J%) = NULL$
        NEXT J%
        BUFFER.BOTTOM% = 0
        RETURN

\ Ŀ
BEG.END.MACRO: REM THIS KEY BEGINS AND ENDS A KEYSTROKE MACRO SEQUENCE  
\ 
        SAVE.MACRO% = NOT SAVE.MACRO%
        CALL TEMP.PSITION(BOTTOM.LINE%,1)
        IF SAVE.MACRO% THEN MACRO$ = NULL$:PRINT "Started"; ELSE \
         PRINT "Ended";
        PRINT " Key macro";:CALL ERAEOL
        CALL PSITION
        RETURN

\ Ŀ
EXECUTE.MACRO.ONCE: REM THIS KEY EXECUTES A KEYSTROKE MACRO ONCE        
\ 
        IF SAVE.MACRO% THEN GOSUB BEG.END.MACRO
        MACRO.TIMES% = 1
EXECUTE.MACRO.ONCE1:
        IF MACRO$ =NULL$ THEN EXECUTE.MACRO% =FALSE% :\
         PRINT.ON% = TRUE% ELSE EXECUTE.MACRO% =TRUE%
        MACRO.USED% = 0
        RETURN

\ Ŀ
EXECUTE.MACRO.MANY: REM THIS KEY IS USED TO EXECUTE A KEYSTROKE MULTIPLE TIMES
\ 
        IF SAVE.MACRO% THEN GOSUB BEG.END.MACRO
        GOSUB ADD.VIS.CR
        CALL TEMP.PSITION(BOTTOM.LINE%,1)
        MACRO.TIMES% = VAL(GET.INPUT$("Execute macro times: "))
        CALL PSITION
        PRINT.ON% = FALSE%
        GOSUB EXECUTE.MACRO.ONCE1
        RETURN

\ Ŀ
\                 GLOBAL SEARCH AND REPLACE WITH WILDCARDS              
\       USE SEARCH FOR KEY TO SEARCH. USE AGAIN TO SPECIFY REPLACE      
\       STRING. USE AGAIN TO SPECIFY TIMES TO DO SEARCH AND REPLACE     
\ 
SEARCH.FOR: REM SEARCH, REPLACE, TIMES KEY
        GOSUB ADD.VIS.CR
        GOSUB CANCEL.SEARCH
        SEARCH$ = GET.INPUT$("Search:")
        IF KEY% = ESC% THEN GOSUB CANCEL.SEARCH: CALL PSITION: RETURN 
        IF KEY% = CR% THEN GOTO SEARCH.INPUT.DONE

        REPLACE$ = GET.INPUT$(":Replace:") 
        SEARCH.AND.REPLACE% = TRUE%
        IF KEY% = ESC% THEN GOSUB CANCEL.SEARCH: CALL PSITION: RETURN
        IF KEY% = CR% THEN GOTO SEARCH.INPUT.DONE

        TIMES$ = GET.INPUT$(":Times:")
        IF KEY% = ESC% THEN GOSUB CANCEL.SEARCH: CALL PSITION: RETURN
        GLOBAL.SEARCH% = VAL(TIMES$) 
        IF TIMES$ = NULL$ THEN GLOBAL.SEARCH% = 20000 
        GOTO SEARCH.INPUT.DONE
CANCEL.SEARCH:
        TIMES$ = NULL$ : REPLACE$ = NULL$: SEARCH$ = NULL$
        SEARCH.AND.REPLACE% = FALSE% 
        GLOBAL.SEARCH% = 1
        CALL TEMP.PSITION(BOTTOM.LINE%,1)
        CALL ERAEOL
        CALL TEMP.PSITION(BOTTOM.LINE%,1)
        RETURN
SEARCH.INPUT.DONE:
        CALL TEMP.PSITION(BOTTOM.LINE%,1)
        IF SEARCH.AND.REPLACE% THEN GOTO SEARCH.AND.REPLACE
        GOSUB SEARCH
        IF NOT SEARCH.MATCH% THEN MACRO$ = NULL$:IF PRINT.ON% THEN \
         PRINT SEARCH$;" Not Found";:CALL ERAEOL: CALL PSITION
        RETURN
SEARCH.AND.REPLACE:
        M% = -1
        SLASHES% = -1 

        WHILE M%
        SLASHES% = SLASHES% + 1
        M% = MATCH("\\",SEARCH$,M%+2)
        WEND
        REPLACE.LEN% = LEN(SEARCH$) - SLASHES%
        KEY% = 0
        PRINT.ON% = FALSE%
        FOR K% = 1 TO GLOBAL.SEARCH%
        GOSUB SEARCH
        IF (SEARCH.MATCH%=0) AND (K%=1) AND PRINT.ON% THEN \
         PRINT SEARCH$;" Not Found";:CALL ERAEOL
        IF NOT SEARCH.MATCH% THEN PRINT.ON% = TRUE%:\
         PRINT SEARCH$;" Not Found ";:CALL ERAEOL:CALL PSITION: RETURN
        TEXT$(J1%) = LEFT$(TEXT$(J1%),SEARCH.MATCH%-1) + REPLACE$ + \
         RIGHT$(TEXT$(J1%),LEN(TEXT$(J1%)) - SEARCH.MATCH% - REPLACE.LEN% + 1)
        IF REPLACE.LEN% - LEN(REPLACE$) THEN IF LEN(TEXT$(J1%)) > SCREEN.COLS%\
         OR RIGHT$(TEXT$(J1%),1) <> VIS.CR$ AND LEN(TEXT$(J1%)) <>\
         SCREEN.COLS% THEN WORK.TEXT$ = TEXT$(J1%):GOSUB PULL.TEXT.UP
        NEXT K%
        PRINT.ON% = TRUE%
        RETURN
SEARCH:
        IF MARK.END% > 0 AND CURRENT% < MARK.BEGIN% THEN GOTO SKIP.CURRENT.LINE
        J1% = CURRENT%  
        SEARCH.MATCH% = \
         MATCH(SEARCH$,TEXT$(J1%)+TEXT$(J1%+1),CUR.COLUMN%+START.SPOT%)
        IF SEARCH.MATCH% > LEN(TEXT$(J1%)) THEN SEARCH.MATCH% = 0
        START.SPOT% = 0
        IF SEARCH.MATCH% THEN GOTO FOUND.SEARCH
SKIP.CURRENT.LINE:
        IF MARK.END% THEN J2% = MAX%(MARK.BEGIN%,CURRENT%+1):\
         J3% = MARK.END% ELSE \
         J2% = CURRENT%+1:J3% = BOTTOM.TEXT.LINE%
        FOR J1% = J2% TO J3%
        SEARCH.MATCH% = MATCH(SEARCH$,TEXT$(J1%)+TEXT$(J1%+1),1)
        IF SEARCH.MATCH% > LEN(TEXT$(J1%)) THEN SEARCH.MATCH% = 0
        IF SEARCH.MATCH% THEN GOTO FOUND.SEARCH
        NEXT J1%
        RETURN
FOUND.SEARCH:
        CUR.TOP.LINE% = J1% - CUR.ROW% + 1
        REFRESH% = TRUE%
        CUR.COLUMN% = SEARCH.MATCH%
        IF SEARCH.AND.REPLACE% AND K% < GLOBAL.SEARCH% THEN \
         CUR.COLUMN% = SEARCH.MATCH% + LEN(REPLACE$) 
        RETURN

\ Ŀ
REPEAT.SEARCH: REM REPEAT SEARCH (AND REPLACE) AGAIN                    
\ 
        IF NOT REFRESH% THEN GOSUB ADD.VIS.CR
        START.SPOT% = 1
        GOTO SEARCH.INPUT.DONE

\ Ŀ
PROCESS.TEXT: REM TEXT CHARACTERS PROCESSED HERE                        
\ 
        IF NOT INSERTING% THEN GOSUB DELETE.VIS.CR
        WORK.TEXT$ = TEXT$(CURRENT%)
        WORK.LEN% = LEN(WORK.TEXT$)
        IF (CUR.COLUMN% >WORK.LEN%) AND INSERTING% THEN GOSUB DELETE.VIS.CR
        IF PRINT.ON% THEN CALL APRINT (CUR.ROW%,CUR.COLUMN%,CHR$(KEY%),SA%)
        IF WORK.LEN% < CUR.COLUMN% THEN TEXT$(CURRENT%) = \
         LEFT$(WORK.TEXT$+SPACE80$,CUR.COLUMN%-1) + CHR$(KEY%):\
         CUR.COLUMN% = CUR.COLUMN% + FORWARD.BACK%:GOTO TEST.LENGTH
        TEXT$(CURRENT%) = \
         LEFT$(WORK.TEXT$,CUR.COLUMN%-1) + CHR$(KEY%) + \
         RIGHT$(WORK.TEXT$,WORK.LEN% - CUR.COLUMN%+INSERTING%)
        IF INSERTING% AND PRINT.ON% THEN \
         CALL APRINT (CUR.ROW%,CUR.COLUMN%+1,\
          RIGHT$(WORK.TEXT$,WORK.LEN%-CUR.COLUMN%+1),SA%)
        IF INSERTING% AND WORK.LEN% = SCREEN.COLS% THEN WORK.TEXT$ = \
         TEXT$(CURRENT%): GOSUB PULL.TEXT.UP
        CUR.COLUMN% = CUR.COLUMN% + FORWARD.BACK%
TEST.LENGTH:
        IF CUR.COLUMN% > SCREEN.COLS% THEN GOSUB CURSOR.RIGHT
        CALL PSITION
        RETURN
\ Ŀ
\               END OF TEXT SCREEN PORTION OF PROGRAM                   
\ 

\ Ŀ
\          VARIOUS TEXT SCREEN AND COMMAND SCREEN SUBROUTINES           
\ 

OPEN.TEXT:
        GOSUB FIND.BOTTOM.OF.TEXT
        BOTTOM.TEXT.LINE% = BOTTOM.TEXT.LINE%+1
        MAX.VARPTR% = VARPTR(TEXT$(BOTTOM.TEXT.LINE%))
        MAX1% = PEEK(MAX.VARPTR%) : MAX2% = PEEK(MAX.VARPTR%+1)
        MIN.LINES% = CUR.ROW% + CUR.TOP.LINE%
        FOR J% = BOTTOM.TEXT.LINE% TO MIN.LINES% STEP -1
        TO% = TEXT.0% + J%*2
        FROM% = TO% - 2
        POKE TO%, PEEK(FROM%)
        POKE TO%+1, PEEK(FROM%+1)
        NEXT J%
        MIN.VARPTR% = VARPTR(TEXT$(J%))
        POKE MIN.VARPTR%, MAX1%
        POKE MIN.VARPTR% +1, MAX2%
        TEXT$(J%) = VIS.CR$
        IF INSERTING% OR P.U.CALLED% THEN RETURN
        FOR J% = CUR.ROW% TO SCREEN.LINES%
        IF PRINT.ON% THEN \
         CALL APRINT(J%,1,TEXT$(J%+CUR.TOP.LINE%-1)+\
         STRING$(80-LEN(TEXT$(J%+CUR.TOP.LINE%-1))," "),SA%)
        NEXT J%
        CALL TEMP.PSITION(BOTTOM.LINE%,1)
        IF PRINT.ON% THEN CALL ERAEOL
        CALL PSITION
        RETURN

ADD.VIS.CR:
        IF RIGHT$(TEXT$(CURRENT%),1) <> VIS.CR$ AND LEN(TEXT$(CURRENT%)) < \
         SCREEN.COLS% THEN TEXT$(CURRENT%) = TEXT$(CURRENT%) + VIS.CR$:\
          IF PRINT.ON% THEN \
          CALL APRINT (CUR.ROW%,LEN(TEXT$(CURRENT%)),VIS.CR$,SA%)
        RETURN
DELETE.VIS.CR:
        WORK.LEN% = LEN(TEXT$(CURRENT%))
        IF RIGHT$(TEXT$(CURRENT%),1) = VIS.CR$ THEN \
         TEXT$(CURRENT%) = LEFT$(TEXT$(CURRENT%),WORK.LEN% -1):\
          IF PRINT.ON% THEN CALL APRINT (CUR.ROW%,WORK.LEN%," ",SA%)
        RETURN
FIND.BOTTOM.OF.TEXT:
        FOR BOTTOM.TEXT.LINE% = MAX.LINES% TO 1 STEP -1
        IF TEXT$(BOTTOM.TEXT.LINE%) <> NULL$ THEN RETURN
        NEXT BOTTOM.TEXT.LINE%
        RETURN
GET.NEXT.TAB:
        NEXT.WORD.TAB% = 0
        A$ = " #": GOSUB GET.N
        A$ = " !": GOSUB GET.N
        A$ = ",#": GOSUB GET.N
        A$ = ",!": GOSUB GET.N
        A$ = "," + CHR$(34) + "#": GOSUB GET.N
        A$ = "," + CHR$(34) + "!": GOSUB GET.N
        IF NEXT.WORD.TAB% = 0 THEN NEXT.WORD.TAB% = LEN(TEXT$(CURRENT%))-1
        RETURN
GET.N:
        N% = MATCH(A$,TEXT$(CURRENT%),CUR.COLUMN%+1)
        NEXT.WORD.TAB% = NON.ZERO.MIN%(NEXT.WORD.TAB%,N%)
        RETURN
END


