/* Caprice32 - Amstrad CPC Emulator
   (c) Copyright 1997-2004 Ulrich Doewich

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
   This file includes video filters from the SMS Plus/SDL 
   sega master system emulator :
   (c) Copyright Gregory Montoir
   http://membres.lycos.fr/cyxdown/smssdl/
*/

/*
   This file includes video filters from MAME
   (Multiple Arcade Machine Emulator) :
   (c) Copyright The MAME Team
   http://www.mame.net/
*/

#include "video.h"
#include "cap32.h"
#include <math.h>

// the real video surface
static SDL_Surface* vid;
// the video surface shown by the plugin to the application
static SDL_Surface* pub;

extern t_CPC CPC;

#ifndef min
#define min(a,b) (a<b ? a : b)
#endif

#ifndef max
#define max(a,b) (a>b ? a : b)
#endif

/* ------------------------------------------------------------------------------------ */
/* Half size with hardware flip video plugin ------------------------------------------ */
/* ------------------------------------------------------------------------------------ */
SDL_Surface* 
halfhw_init(int w,int h, int bpp)
{
	vid=SDL_SetVideoMode(PSP_SDL_SCREEN_WIDTH,PSP_SDL_SCREEN_HEIGHT, bpp, SDL_ANYFORMAT|SDL_DOUBLEBUF|SDL_HWSURFACE|SDL_HWPALETTE);
	if (!vid)
		return NULL;
	SDL_FillRect(vid,NULL,SDL_MapRGB(vid->format,0,0,0));
	return vid;
}

void 
halfhw_setpal(SDL_Color* c)
{
	SDL_SetPalette(vid, SDL_LOGPAL | SDL_PHYSPAL, c, 0, 32); 
}

bool 
halfhw_lock()
{
	return true;
}

void 
halfhw_unlock()
{
}

void 
halfhw_flip()
{
	SDL_Flip(vid);
}

void 
halfhw_close()
{
}

/* ------------------------------------------------------------------------------------ */
/* End of video plugins --------------------------------------------------------------- */
/* ------------------------------------------------------------------------------------ */

video_plugin video_plugin_list[]=
{
  {"Half size with hardware flip",	halfhw_init,	halfhw_setpal,	halfhw_lock,		halfhw_unlock,		halfhw_flip,	halfhw_close,		ALL,		1			},
{NULL,					NULL,		NULL,		NULL,			NULL,			NULL,		NULL,			0,		0			}
};

