{
Ŀ
                 Joe Forster/STA                 
                                                 
                   STARZIP.PAS                   
                                                 
                    Star Zip                     

}

program Star_Zip;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}
{$M 16384, 0, 655360}

uses
  DOS, StarBase;

const
{Pack modes}
  pmBoth        = 0;
  pmDiskZip     = 1;
  pmFileZip     = 2;
  BufferSize    = 256;
{Length of filepacked ZipCode archive directory buffer}
  DirBufferMax  = 3072;
{Length of ZipCode archive buffer}
  ZipBufferMax  = 47104;
{Error messages during ZipCode decompression}
  InvalidTrack  : string[20] = 'Invalid track number';
  InvalidSector : string[21] = 'Invalid sector number';
  DupSector     : string[23] = 'Duplicate sector number';
  EndOfFile     : string[22] = 'Unexpected end of file';
  HexaNum       : array [0..15] of Char = '0123456789ABCDEF';
{Array containing the error messages}
  ErrorString: array[1..4] of Word = (
    Ofs(InvalidTrack),
    Ofs(InvalidSector),
    Ofs(DupSector),
    Ofs(EndOfFile));

type
  PString       = ^string;
  TBuffer       = array [0..BufferSize - 1] of Byte;
  TDirEntry     = record
    Name        : string[16];
    Attr        : Byte;
    Size,
    Time        : Longint;
  end;

var
  Found,
  StoreData,
  Test,
  ZipEnd,
  Quit          : Boolean;
  PackMode,
  NameBaseChar,
  FileNum,
  FileCount,
  ErrorCode,
  StartTrack,
  StartSector,
  Trk,
  Sec,
  SectorCount,
  MaxSector,
  VolNum,
  OddInc,
  EvenInc,
  Data          : Byte;
  PackChar      : Char;
  DummyLen,
  DirCount,
  ZipCount,
  ZipSize,
  WrittenSize   : Word;
  DiskSize      : Longint;
  Buffer        : PBuffer;
  IDCode        : string[2];
  Part,
  BaseName      : string;
  TrackMap      : array [0..20] of Boolean;
  TempBuffer    : TBlock;
  DiskBuffer    : TDiskBuffer;
  ZipBuffer     : array [0..ZipBufferMax - 1] of Byte;

{The directory lister of filepacked ZipCode archives}
procedure ZipDirLister; external;
{$L ZIPLIST.OBJ}

{Split the PC file name into name and extension
  Input : Entry: the PC file name
          Name: the string to contain the name
          Ext: the string to contain the extension}
procedure SplitName(Path: string; var Dir, Name, Ext: string);
begin
  LongFSplit(Path, Dir, Name, Ext);
  if (Ext = '') and (Name = '') then Name := '*';
  if Ext = '.' then Ext := '';
end;

{Determine pack mode based on the first character of the file name and strip
  the first characters off of the file name
  Input : S: name of the current file
          B: when True, the pack mode is determined
  Output: the corrected file name}
function CorrectZipName(S: string; B: Boolean): string;
var
  D,
  E,
  N             : string;
begin
  if (Length(S) > 2) and (UpCase(S[1]) in ['1'..'5', 'A'..'E', 'X']) and (S[2] = '!') then
  begin
    if S[1] in ['1'..'4'] then
    begin
      if not B or (S[1] = '1') then PackMode := pmDiskZip;
    end
    else
    begin
      if not B or (UpCase(S[1]) = 'X') then PackMode := pmFileZip;
    end;
    CorrectZipName := Copy(S, 3, 255);
  end
  else
  begin
    CorrectZipName := S;
  end;
  case PackMode of
    pmBoth: PackChar := '?';
    pmDiskZip:
    begin
      NameBaseChar := Ord('0');
      PackChar := '1';
    end;
    pmFileZip:
    begin
      NameBaseChar := Ord('a') - 1;
      PackChar := 'x';
    end;
  end;
  LongFSplit(S, D, N, E);
  S := N + E;
end;

{Convert a word into a hexadecimal string
  Input : D: the word
          L: number of digits to put into the string
  Output: the hexadecimal string}
function HexaStr(D: Word): string;
var
  I             : Byte;
  S             : string;
begin
  S := '';
  for I := 3 downto 0 do S := S + HexaNum[(D shr (I * 4) and 15)];
  HexaStr := S;
end;

{Read a buffer of data from the input file
  Input : Buffer: buffer to rea the data into
          Len: length of the data read}
procedure ReadPart(Buffer: PBuffer; var Len: Word);
var
  M,
  Q             : Byte;
begin
  Len := 0;
  while not Error and (Len < BufferSize) and (Track > 0) do
  begin
    Error := ((Track > MaxTrack) or (Sector >= SectorNum(Track)));
    if not Error then
    begin
      ReadDiskBlock(Track, Sector, @DataBuffer);
      Track := DataBuffer[0];
      Sector := DataBuffer[1];
      if Track = 0 then _End := True;
      for Q := 0 to 255 do Buffer^[Len + Q] := DataBuffer[Q];
      Inc(Len, 256);
    end;
  end;
  Error := Error or (IOResult <> 0);
  _End := Error or _End;
  if Error then Len := 0;
end;

{Write a buffer of data into the output file
  Input : Buffer: buffer containing the data to write
          Len: length of the data read
          FileEnd: when True, the input file has ended}
procedure WritePart(Buffer: PBuffer; Len: Word; FileEnd: Boolean);
var
  F,
  O             : Boolean;
  Q             : Byte;
  X,
  Z             : Longint;
begin
  X := 0;
  F := True;
  while F and (X < Len) do
  begin
    if X + 254 < Len then Z := 254 else Z := Len - X;
    for Q := Z to 255 do DataBuffer[Q] := 0;
    for Q := 0 to Z - 1 do DataBuffer[Q + 2] := Buffer^[X + Q];
    ExtSeek(Image, DiskPos(Track, Sector) shl 8);
    if (X + 254 < Len) or not FileEnd then
    begin
      F := SearchNextBlock;
    end
    else
    begin
      F := True;
      Track := 0;
      Sector := Z + 1;
    end;
    DataBuffer[0] := Track;
    DataBuffer[1] := Sector;
    ExtBlockWrite(Image, DataBuffer, 256);
    Inc(X, Z);
    Inc(Block);
    if not F then
    begin
      WriteLn(DiskName, ' is full');
      O := False;
      Error := True;
    end;
  end;
  Error := Error or (IOResult <> 0);
end;

{Convert a hexadecimal string into a word
  Input : S: the hexadecimal string
          Code: when not 0, an error occured
  Output: the converted word}
function HexaEval(S: string; var Code: Integer): Word;
var
  I,
  X             : Byte;
  V             : Word;
begin
  V := 0;
  I := 1;
  Code := 0;
  while (Code = 0) and (I <= Length(S)) do
  begin
    X := LeftPos(S[I], HexaNum);
    if X = 0 then Code := I else V := V shl 4 + X - 1;
    Inc(I);
  end;
  HexaEval := V;
end;

procedure WroteOK(Orig, Written: Word);
begin
  if Orig <> Written then
  begin
    ClrLine;
    WriteLn('Destination disk full');
    Error := True;
    Quit := True;
  end;
end;

{Proceed to the next ZipCode archive}
procedure NewFile(Add: Boolean);
var
  C             : Char;

{Write the current contents of the buffer onto the disk}
procedure WriteFile;
var
  W             : Word;
begin
  if (PackMode = pmFileZip) and (VolNum > 0) then ZipBuffer[2] := SectorCount;
  ExtBlockWrite2(ArcFile, ZipBuffer, ZipCount, W);
  ExtSetFTime(ArcFile, FileDate);
  ExtClose(ArcFile);
  WroteOK(ZipCount, W);
end;

begin
  case PackMode of
    pmDiskZip:
    begin
      Inc(Track);
      Quit := (Track >= MaxTrack);
    end;
    pmFileZip: if not Add then Quit := ((FileCount = 0) and (CopySize = 0));
  end;
  if Quit then
  begin
    if Add then WriteFile;
  end
  else
  begin
    case PackMode of
      pmDiskZip:
      begin
        FillChar(TrackMap, 21, 0);
        case Track of
          1..17: MaxSector := 21;
          18..24: MaxSector := 19;
          25..30: MaxSector := 18;
          31..40: MaxSector := 17;
        end;
        VolNum := LeftPos(Chr(Track), #1#9#17#26#36);
      end;
      pmFileZip: MaxSector := 166;
    end;
    case VolNum of
      1: Part := 'Processing part';
      2..255:
      begin
        if Add and Over then WriteFile;
      end;
    end;
    if (VolNum > 0) or (PackMode = pmFileZip) then
    begin
      if VolNum = 0 then C := 'x' else C := Chr(VolNum + NameBaseChar);
      ArcName := Dir2 + C + '!' + BaseName;
      ArcFile.LongName := ArcName;
      if Add then
      begin
        if VolNum = 1 then
        begin
          if LineFeed then
          begin
            LineFeed := False;
            WriteLn;
          end;
          WriteLn('Creating archive: ', Dir2, '?!', BaseName, ' out of ', DiskName);
        end;
        Part := Part + ' ' + C;
        Over := True;
        if LongOpenFile(ArcFile.LongName, ArcFile, fmReadOnly) = 0 then
        begin
          ExtClose(ArcFile);
          Over := Question(ArcName + ' exists. Overwrite', 'Always', 'nEver', '', Overwrite);
        end;
        if Over then
        begin
          IOError := LongOpenFile(ArcFile.LongName, ArcFile, fmWriteOnly);
          if IOError = 0 then
          begin
            if PackMode = pmDiskZip then
            begin
              Write(#13, Part);
              LineFeed := True;
            end;
            case PackMode of
              pmDiskZip:
              begin
                if Track = 1 then
                begin
                  ZipBuffer[0] := $FE;
                  ZipBuffer[1] := $03;
                  ZipCount := 4;
                end
                else
                begin
                  ZipBuffer[0] := $00;
                  ZipBuffer[1] := $04;
                  ZipCount := 2;
                end;
              end;
              pmFileZip:
              begin
                if VolNum > 0 then
                begin
                  ZipBuffer[0] := $FF;
                  ZipBuffer[1] := $03;
                  ZipBuffer[2] := 0;
                  ZipCount := 3;
                  Inc(VolNum);
                end;
              end;
            end;
          end
          else
          begin
            if LineFeed then WriteLn;
            WriteLn('Cannot create ', ArcName);
          end;
        end
        else
        begin
          IOError := 254;
        end;
      end
      else
      begin
        if VolNum = 2 - PackMode then
        begin
          if LineFeed then
          begin
            LineFeed := False;
            WriteLn;
          end;
          if List then Write('Listing') else if Test then Write('Testing') else Write('Extracting');
          Write(' archive: ', Dir2, '?!', BaseName);
          if List or Test then WriteLn else WriteLn(' into ', DiskName);
          if List then
          begin
            WriteLn('Blocks         Name        Type');
            WriteLn('------  ------------------  ---');
          end;
        end;
        Part := Part + ' ' + C;
        IOError := LongOpenFile(ArcFile.LongName, ArcFile, fmReadOnly);
        if IOError = 0 then
        begin
          ZipSize := ExtFileSize(ArcFile);
          if ZipSize <= 49152 then
          begin
            if PackMode = pmDiskZip then
            begin
              Write(#13, Part);
              LineFeed := True;
            end;
            ExtBlockRead(ArcFile, ZipBuffer, ZipSize);
            case PackMode of
              pmDiskZip:
              begin
                if Track = 1 then
                begin
                  ExtGetFTime(ArcFile, FileDate);
                  ZipCount := 4;
                end
                else
                begin
                  ZipCount := 2;
                end;
              end;
              pmFileZip:
              begin
                ExtGetFTime(ArcFile, FileDate);
                if VolNum = 0 then
                begin
                  MaxSector := 0;
                  if not Error then
                  begin
                    Move(ZipBuffer, DiskBuffer, ZipSize);
                    FileCount := DiskBuffer[$0200];
                    DirCount := $0201;
                  end;
                end
                else
                begin
                  MaxSector := ZipBuffer[2];
                  ZipCount := 3;
                end;
                Inc(VolNum);
              end;
            end;
          end
          else
          begin
            if LineFeed then WriteLn;
            WriteLn(ArcName, ' is too big');
          end;
          ExtClose(ArcFile);
          if not List and not Test and not Error and Question('Delete ' + ArcName, 'Always', 'nEver', '', Delete) then
            LongErase(ArcFile.LongName);
          ZipEnd := False;
        end
        else
        begin
          if IOError in [2, 3] then
          begin
            if LineFeed then WriteLn;
            WriteLn(ArcName, ' not found');
          end;
        end;
      end;
    end;
  end;
  Error := (IOError <> 0);
end;

{Read a byte from the ZipCode archive}
function ReadZipByte: Byte; assembler;
asm
    push si;
    push ax;
    mov si, Offset(ZipBuffer);
    add si, ZipCount;
    inc ZipCount;
    mov ax, ZipCount;
    cmp ax, ZipSize;
    jb @1;
    mov ZipEnd, 1;
@1: pop ax;
    mov al, [si];
    pop si;
end;

{Write a byte into the ZipCode archive}
function WriteZipByte: Byte; assembler;
asm
    push di;
    mov di, Offset(ZipBuffer);
    add di, ZipCount;
    inc ZipCount;
    mov [di], al;
    pop di;
end;

{ZipCode 'Add' option processor}
procedure ZipAddOptions(const Option: string); far;
begin
  case Option[1] of
    'I':
    begin
      if (PackMode = pmDiskZip) and (Length(Option) = 5) then
      begin
        ZipCount := HexaEval(Copy(Option, 2, 4), IOError);
        Error := (IOError <> 0);
        if not Error then
        begin
          IDCode[0] := #2;
          IDCode[1] := Chr(Hi(ZipCount));
          IDCode[2] := Chr(Lo(ZipCount));
        end;
      end
      else
      begin
        Error := True;
      end;
    end;
    'S': StoreData := True;
  else
    AddOptions(Option);
  end;
end;

begin
  WriteLn('Star Zip' + VersionStr + CopyrightStr);
  WriteLn;
  if Test8086 = 0 then
  begin
    WriteLn('This program requires an 80286 CPU or above');
  end
  else
  begin
    if ParamCount < 2 then
    begin
      WriteLn('This program creates, lists, tests and extracts Commodore ZipCode archives.');
      WriteLn;
      WriteLn('Create diskpack: STARZIP [-]A <diskname> [-|/C|D|Ixxyy|S|Y] [<zipname>]');
      WriteLn('Create filepack: STARZIP [-]F <diskname> [-|/C|D|Y] [<zipname>]');
      WriteLn('List filepack  : STARZIP [-]L <zipname>');
      WriteLn('Test diskpack  : STARZIP [-]T <zipname>');
      WriteLn('Extract        : STARZIP [-]X <zipname> [-|/4|7|8|C|D|X[D|P|S]|Y] [<diskname>]');
    end
    else
    begin
      CommonInit;
      PackMode := pmBoth;
      FileMode := 0;
      IDCode := '';
      StoreData := False;
      case Command of
        'A', 'F':
        begin
          case Command of
            'A': PackMode := pmDiskZip;
            'F': PackMode := pmFileZip;
          end;
          ParseCmdLine(ZipAddOptions);
          if not Error then
          begin
            DiskName := UpperCase(LongParamStr(2));
            BaseName := UpperCase(LongParamStr(Number));
            SplitName(DiskName, Dir1, Name1, Ext1);
            SplitName(BaseName, Dir2, Name2, Ext2);
            if PackMode = pmDiskZip then Ext1 := GetDiskExt(dt1541) else FixDiskExt(Ext1);
            Name2 := CorrectZipName(Name2, False);
            SearchPar := Dir1 + Name1 + Ext1;
            LongFindFirst(SearchPar, Archive + ReadOnly, Entry);
            if DOSError <> 0 then
            begin
              WriteLn(SearchPar, ' not found');
            end
            else
            begin
              repeat
                SplitName(Entry.LongName, Dir, Name1, Ext1);
                DiskName := Dir1 + Name1 + Ext1;
                BaseName := CloneName(Name1, Name2);
                if Length(BaseName) in [7..8] then Dec(BaseName[0], 2);
                BaseName := BaseName + CloneName(Ext1, Ext2);
                case PackMode of
                  pmDiskZip:
                  begin
                    NameBaseChar := Ord('0');
                    IOError := LongOpenFile(DiskName, Image, fmReadOnly);
                    if IOError = 0 then DiskType := GetDiskType(ExtFileSize(Image));
                  end;
                  pmFileZip:
                  begin
                    NameBaseChar := Ord('a') - 1;
                    CopySize := 0;
                    VolNum := 1;
                    FillChar(DiskBuffer, 512, 0);
                    asm
                      push ds;
                      mov cx, ZipHeaderLen;
                      push ds;
                      pop es;
                      push cs;
                      pop ds;
                      mov si, Offset(ZipDirLister);
                      mov di, Offset(DiskBuffer);
                      cld;
                      rep movsb;
                      pop ds;
                    end;
                    DirCount := $0201;
                    IOError := OpenImage(False);
                  end;
                end;
                if IOError = 0 then
                begin
                  if DiskType <> 255 then
                  begin
                    CheckDiskType;
                    if PackMode = pmDiskZip then
                    begin
                      if IDCode = '' then
                      begin
                        ReadBAM;
                        Count := $90;
                        if DiskType and $80 = dt1581 then Count := $04;
                        Move(BAM[Count + $12], ZipBuffer[2], 2);
                        ExtSeek(Image, 0);
                      end
                      else
                      begin
                        Move(IDCode[1], ZipBuffer[2], 2);
                      end;
                    end;
                    ExtGetFTime(Image, FileDate);
                    Track := 0;
                    EscPressed := False;
                    Error := False;
                    Quit := False;
                    OddInc := 11;
                    EvenInc := 256 - 10;
                    FileCount := 0;
                    CopySize := 0;
                    while not EscPressed and not Error and not Quit do
                    begin
                      NewFile(True);
                      if not Error and not Quit then
                      begin
                        case PackMode of
                          pmDiskZip:
                          begin
                            ExtBlockRead(Image, DiskBuffer, MaxSector shl 8);
                            case Track of
                              18, 25:
                              begin
                                Dec(OddInc);
                                Inc(EvenInc);
                              end;
                            end;
                          end;
                        end;
                        SectorCount := 0;
                        Sec := 0;
                        while not EscPressed and not Error and not Quit and (SectorCount < MaxSector) do
                        begin
                          Escape;
                          if not EscPressed then
                          begin
                            if PackMode = pmFileZip then
                            begin
                              if CopySize = 0 then
                              begin
                                Quit := True;
                                while Quit and ReadCBMEntry(CBMEntry) do Quit := (CBMEntry.Attr = 0);
                                if not Quit then
                                begin
                                  FileName := CBMEntry.Name;
                                  Attr := CBMEntry.Attr;
                                  MakeName;
                                  OpenRead;
                                  StartTrack := Track;
                                  StartSector := Sector;
                                  WriteLn('  Adding: ', PCName);
                                  Inc(FileCount);
                                end;
                              end;
                              if Quit then
                              begin
                                if FileCount = 0 then
                                begin
                                  WriteLn(DiskName, ' is empty');
                                  NewFile(True);
                                  LongErase(ArcName);
                                end
                                else
                                begin
                                  DiskBuffer[$01FF] := VolNum - 1;
                                  DiskBuffer[$0200] := FileCount;
                                  Quit := False;
                                  if ZipCount > 3 then NewFile(True) else Dec(DiskBuffer[$01FF]);
                                  Quit := True;
                                  Move(DiskBuffer, ZipBuffer, DirCount);
                                  ZipCount := DirCount;
                                  VolNum := 0;
                                  NewFile(True);
                                  ArcName[1] := 'x';
                                  LongGetFAttr(ArcName, DummyLen);
                                  if IOResult = 0 then LongErase(TempFile.LongName);
                                  LongRename(ArcFile.LongName, ArcName);
                                end;
                              end
                              else
                              begin
                                if (Track > 0) and ((Track <> DirTrack) or (Sector > FirstDirSector)) then
                                begin
                                  ReadPart(@TempBuffer, DummyLen);
                                  Inc(CopySize);
                                end
                                else
                                begin
                                  _End := True;
                                end;
                                if _End then
                                begin
                                  FileName := CBMEntry.Name;
                                  while Length(FileName) < 16 do FileName := FileName + #160;
                                  asm
                                    mov si, Offset(FileName);
                                    mov di, Offset(DiskBuffer);
                                    add di, DirCount;
                                    push ds;
                                    pop es;
                                    mov cx, 16;
                                    cld;
                                    lodsb;
                                    rep movsb;
                                    mov al, FileType;
                                    or al, $80;
                                    stosb;
                                    mov ax, word ptr CopySize;
                                    stosw;
                                    mov al, StartTrack;
                                    stosb;
                                    mov al, StartSector;
                                    stosb;
                                    add DirCount, 21;
                                  end;
                                end;
                              end;
                            end;
                            if not Quit and not Error and ((PackMode = pmDiskZip) or (CopySize > 0)) then
                            begin
                              FillChar(DataBuffer, 256, 0);
                              asm
                                cmp PackMode, pmFileZip;
                                jne @18;
                                mov si, Offset(TempBuffer);
                                mov al, [si];
                                mov Trk, al;
                                mov al, [si][1];
                                mov Sec, al;
                                jmp @19;
                            @18:mov al, Track;
                                mov Trk, al;
                                mov al, Sec;
                                xor ah, ah;
                                shl ax, 8;
                                mov si, Offset(DiskBuffer);
                                add si, ax;
                            @19:mov di, Offset(DataBuffer);
                                cmp StoreData, False;
                                jne @6;
                                xor bh, bh;
                                mov cx, 256;
                                cmp PackMode, pmFileZip;
                                jne @20;
                                sub cx, 2;
                            @20:push cx;
                                push si;
                                cmp PackMode, pmFileZip;
                                jne @1;
                                add si, 2;
                            @1: mov bl, [si];
                                inc byte ptr [di][bx];
                                inc si;
                                loop @1;
                                pop si;
                                pop cx;
                                cmp byte ptr [di][bx], cl;
                                jne @2;
                                mov al, Trk;
                                or al, $40;
                                call WriteZipByte;
                                mov al, Sec;
                                call WriteZipByte;
                                mov al, bl;
                                call WriteZipByte;
                                jmp @3;
                            @2: xor bx, bx;
                            @5: cmp byte ptr [di][bx], cl;
                                je @4;
                                inc bx;
                                cmp bx, 256;
                                jb @5;
                            @4: cmp bx, 256;
                                jae @6;
                                push bx;
                                push bp;
                                xor bp, bp;
                                xor dx, dx;
                                mov bx, 1;
                                cmp PackMode, pmFileZip;
                                jne @10;
                                add bp, 2;
                                add bx, 2;
                            @10:cmp bx, 256;
                                jae @7;
                                mov al, ds:[si][bp];
                                cmp al, [si][bx];
                                je @8;
                            @7: mov cx, bx;
                                sub cx, bp;
                                cmp cx, 3;
                                jbe @9;
                                mov cx, 3;
                            @9: add dx, cx;
                                mov bp, bx;
                            @8: inc bx;
                                cmp bx, 256;
                                jbe @10;
                                pop bp;
                                pop bx;
                                mov ax, 252;
                                cmp PackMode, pmFileZip;
                                jne @21;
                                sub ax, 2;
                            @21:cmp dx, ax;
                                jbe @11;
                            @6: mov al, Trk;
                                call WriteZipByte;
                                mov al, Sec;
                                call WriteZipByte;
                                mov cx, 256;
                                cmp PackMode, pmFileZip;
                                jne @12;
                                sub cx, 2;
                                add si, 2;
                            @12:mov al, [si];
                                call WriteZipByte;
                                inc si;
                                loop @12;
                                jmp @3;
                            @11:mov al, Trk;
                                or al, $80;
                                call WriteZipByte;
                                mov al, Sec;
                                call WriteZipByte;
                                mov al, dl;
                                call WriteZipByte;
                                mov dl, bl;
                                mov al, dl;
                                call WriteZipByte;
                                push bp;
                                xor bp, bp;
                                mov bx, 1;
                                cmp PackMode, pmFileZip;
                                jne @17;
                                add bp, 2;
                                add bx, 2;
                            @17:mov al, ds:[si][bp];
                                cmp bx, 256;
                                jae @13;
                                cmp al, [si][bx];
                                je @14;
                            @13:mov cx, bx;
                                sub cx, bp;
                                cmp cx, 3;
                                jbe @15;
                                mov dh, al;
                                mov al, dl;
                                call WriteZipByte;
                                mov al, cl;
                                call WriteZipByte;
                                mov al, dh;
                                call WriteZipByte;
                                jmp @16;
                            @15:call WriteZipByte;
                                loop @15;
                            @16:cmp bx, 256;
                                jae @14;
                                mov bp, bx;
                            @14:inc bx;
                                cmp bx, 256;
                                jbe @17;
                                pop bp;
                            @3:
                              end;
                              if SectorCount and 1 = 0 then Inc(Sec, OddInc) else Inc(Sec, EvenInc);
                              Inc(SectorCount);
                            end;
                            if (PackMode = pmFileZip) and _End then CopySize := 0;
                          end;
                          if (IOResult <> 0) or Error then WriteLn('Cannot add ', PCName, ' correctly');
                        end;
                      end;
                    end;
                  end
                  else
                  begin
                    WriteLn(DiskName, ' is not a valid disk image');
                  end;
                  ExtClose(Image);
                  if not Error and Question('Delete ' + DiskName, 'Always', 'nEver', '', Delete) then
                    LongErase(Image.LongName);
                  ClrLine;
                  LineFeed := True;
                end;
                LongFindNext(Entry);
              until (DOSError <> 0) or EscPressed;
              LongFindClose(Entry);
            end;
          end;
        end;
        'L', 'T', 'X':
        begin
          Test := (Command = 'T');
          if List or Test then ParseCmdLine(NoOptions) else ParseCmdLine(ExtractOptions);
          if not Error then
          begin
            BaseName := UpperCase(LongParamStr(2));
            DiskName := UpperCase(LongParamStr(Number));
            SplitName(DiskName, Dir1, Name1, Ext1);
            SplitName(BaseName, Dir2, Name2, Ext2);
            Name2 := CorrectZipName(Name2, False);
            SearchPar := Dir2 + PackChar + '!' + Name2 + Ext2;
            LongFindFirst(SearchPar, Archive + ReadOnly, Entry);
            if DOSError = 0 then
            begin
              repeat
                SplitName(Entry.LongName, Dir, Name2, Ext2);
                PackMode := pmBoth;
                Name2 := CorrectZipName(Name2, True);
                if (not List and (PackMode = pmDiskZip)) or (not Test and (PackMode = pmFileZip)) then
                begin
                  Found := True;
                  DiskName := Dir1 + CloneName(Name2, Name1) + GetDiskExt(DiskType);
                  BaseName := Name2 + Ext2;
                  Over := True;
                  IOError := 0;
                  if not List and not Test then
                  begin
                    if LongOpenFile(DiskName, Image, fmReadOnly) = 0 then
                    begin
                      ExtClose(Image);
                      if PackMode = pmDiskZip then Over := Question(DiskName + ' exists. Overwrite',
                        'Always', 'nEver', '', Overwrite);
                    end
                    else
                    begin
                      if PackMode = pmFileZip then
                      begin
                        if CreateDisk <> 0 then
                        begin
                          WriteLn('Cannot create ', DiskName);
                          Over := False;
                        end;
                      end;
                    end;
                    if Over and (PackMode = pmDiskZip) then InOutRes := LongOpenFile(Image.LongName, Image, fmWriteOnly);
                  end;
                  if Over then
                  begin
                    if IOError = 0 then
                    begin
                      AllBlocks := 0;
                      FileNum := 0;
                      EscPressed := False;
                      Error := False;
                      Quit := False;
                      case PackMode of
                        pmDiskZip:
                        begin
                          ArcName := Dir2 + '5!' + BaseName;
                          DiskType := dt1541;
                          if LongOpenFile(ArcName, ArcFile, fmReadOnly) = 0 then
                          begin
                            ExtClose(ArcFile);
                            DiskType := dt1541Ext;
                          end;
                          CheckDiskType;
                          CopySize := 1;
                          Track := 0;
                        end;
                        pmFileZip:
                        begin
                          FileCount := 1;
                          CopySize := 0;
                          MaxSector := 166;
                          VolNum := 0;
                          CheckDiskType;
                          NewFile(False);
                        end;
                      end;
                      Over := True;
                      while not EscPressed and not Error and not Quit do
                      begin
                        NewFile(False);
                        if not Error and not Quit then
                        begin
                          SectorCount := 0;
                          while not EscPressed and not Error and not Quit and (SectorCount < MaxSector) do
                          begin
                            if CopySize = 0 then
                            begin
                              Quit := (FileCount = 0);
                              if not Quit then
                              begin
                                asm
                                  mov si, Offset(DiskBuffer);
                                  add si, DirCount;
                                  mov di, Offset(FileName);
                                  push ds;
                                  pop es;
                                  mov cx, 16;
                                  cld;
                                  mov al, cl;
                                  stosb;
                                  rep movsb;
                                  lodsb;
                                  mov ah, al;
                                  and ah, $7F;
                                  xor al, al;
                                  cmp ah, 'D';
                                  je @3;
                                  inc al;
                                  cmp ah, 'S';
                                  je @3;
                                  inc al;
                                  cmp ah, 'P';
                                  je @3;
                                  inc al;
                                  cmp ah, 'U';
                                  jne @1;
                              @3: or al, $80;
                                  mov Attr, al;
                                  lodsw;
                                  mov word ptr CopySize, ax;
                                  add DirCount, 21;
                                  jmp @2;
                              @1: mov Error, True;
                              @2:
                                end;
                                MakeName;
                                if List then
                                begin
                                  Over := True;
                                end
                                else
                                begin
                                  Over := Question('Extract ' + PCName, 'Always', 'nEver', '', Confirm);
                                  if Over then
                                  begin
                                    repeat
                                      if OpenWrite(FileName, Attr, CopySize, False) = 254 then
                                      begin
                                        Error := False;
                                        Over := Question(PCName + ' exists. Extract anyway', 'Always',
                                          'nEver', 'Rename', Overwrite);
                                        if Over then Over := (OpenWrite(FileName, Attr, CopySize, True) = 0);
                                      end;
                                    until Over or (Overwrite <> aaRename);
                                  end;
                                  if not Over then WriteLn('  Skipping:   ', PCName);
                                end;
                                if Over then
                                begin
                                  if List then
                                  begin
                                    PCName := '"' + ASCIIName +  '"';
                                    while Length(PCName) < 20 do PCName := PCName + ' ';
                                    WriteLn(CopySize:6, '  ', PCName, ShortCBMExt[Attr and 7]);
                                  end
                                  else
                                  begin
                                    WriteLn('  Extracting: ', PCName);
                                  end;
                                end;
                                Dec(FileCount);
                                Inc(FileNum);
                                Inc(AllBlocks, CopySize);
                              end;
                            end;
                            Escape;
                            if not Error and not EscPressed and not Quit then
                            begin
                              if CopySize > 0 then
                              begin
                                asm
                                  call ReadZipByte;
                                  mov Trk, al;
                                  cmp PackMode, pmFileZip;
                                  je @21;
                                  mov al, Trk;
                                  and al, $3F;
                                  cmp al, Track;
                                  mov al, 1;
                                  jne @1;
                              @21:call ReadZipByte;
                                  mov Sec, al;
                                  cmp PackMode, pmFileZip;
                                  jne @22;
                                  mov di, Offset(TempBuffer);
                                  jmp @23;
                              @22:mov bl, Sec;
                                  cmp bl, MaxSector;
                                  mov al, 2;
                                  jae @1;
                                  mov si, Offset(TrackMap);
                                  xor bh, bh;
                                  cmp byte ptr [si][bx], 0;
                                  mov al, 3;
                                  jne @1;
                                  mov al, 1;
                                  mov [si][bx], al;
                                  mov al, Sec;
                                  xor ah, ah;
                                  shl ax, 8;
                                  mov di, Offset(DiskBuffer);
                                  add di, ax;
                              @23:mov al, Trk;
                                  test al, $80;
                                  je @2;
                                  call ReadZipByte;
                                  mov cl, al;
                                  xor ch, ch;
                                  call ReadZipByte;
                                  mov dl, al;
                                  cmp ZipEnd, False;
                                  jne @19;
                              @6: call ReadZipByte;
                                  cmp al, dl;
                                  je @3;
                                  mov [di], al;
                                  inc di;
                                  jmp @4;
                              @3: call ReadZipByte;
                                  mov dh, al;
                                  cmp ZipEnd, False;
                                  jne @19;
                                  call ReadZipByte;
                              @5: mov [di], al;
                                  inc di;
                                  dec dh;
                                  or dh, dh;
                                  jne @5;
                                  sub cx, 2;
                              @4: loop @6;
                                  jmp @8;
                              @2: mov cx, $100;
                                  cmp PackMode, pmFileZip;
                                  jne @7;
                                  sub cx, 2;
                              @7: test al, $40;
                                  je @10;
                                  cmp ZipEnd, False;
                                  jne @19;
                                  call ReadZipByte;
                              @9: mov [di], al;
                                  inc di;
                                  loop @9;
                                  jmp @8;
                              @10:cmp ZipEnd, False;
                                  jne @19;
                                  call ReadZipByte;
                                  mov [di], al;
                                  inc di;
                                  loop @10;
                                  jmp @8;
                              @19:mov al, 4;
                                  jmp @20;
                              @1: dec ZipCount;
                              @20:mov ErrorCode, al;
                                  mov Error, True;
                              @8: inc SectorCount;
                                end;
                              end;
                              if (PackMode = pmFileZip) and not Error then
                              begin
                                if CopySize = 0 then
                                begin
                                  if not List then CloseWrite;
                                end
                                else
                                begin
                                  Dec(CopySize);
                                  if not List and Over then
                                  begin
                                    if Trk and $3F > 0 then Sec := 255;
                                    if Sec < 2 then
                                    begin
                                      DataBuffer[0] := $0D;
                                      Sec := 2;
                                    end;
                                    WritePart(@TempBuffer, Sec - 1, (CopySize = 0));
                                    if CopySize = 0 then CloseWrite;
                                  end;
                                end;
                              end;
                            end;
                          end;
                          if Error then
                          begin
                            if PackMode = pmDiskZip then
                            begin
                              if LineFeed then WriteLn;
                              WriteLn(PString(Ptr(DSeg, ErrorString[ErrorCode]))^, ' at $', HexaStr(ZipCount),
                                ' in ', ArcName);
                            end;
                          end
                          else
                          begin
                            if (PackMode = pmDiskZip) and not Test then
                            begin
                              ExtBlockWrite2(Image, DiskBuffer, MaxSector shl 8, WrittenSize);
                              WroteOK(MaxSector shl 8, WrittenSize);
                            end;
                          end;
                        end;
                      end;
                      if not Test then
                      begin
                        if List then
                        begin
                          WriteLn('------  ------------------  ---');
                          Write(AllBlocks:6, '  ');
                          Data := 12;
                          if FileNum = 1 then Inc(Data);
                          Write(FileNum:Data, ' file');
                          if FileNum > 1 then Write('s');
                          WriteLn;
                        end;
                        if EscPressed or Error and (PackMode = pmDiskZip) then LongErase(Image.LongName);
                        if not List and not Error then
                        begin
                          ExtSetFTime(Image, FileDate);
                          ExtClose(Image);
                        end;
                      end;
                      ClrLine;
                      LineFeed := True;
                    end
                    else
                    begin
                      WriteLn('Cannot create ', DiskName);
                    end;
                  end;
                end;
                LongFindNext(Entry);
              until (DOSError <> 0) or EscPressed;
              LongFindClose(Entry);
            end;
            if not Found then WriteLn('No archives found');
          end;
        end;
      else
        WriteLn('Unknown command');
      end;
    end;
  end;
end.
