{
Ŀ
                 Joe Forster/STA                 
                                                 
                   STARLYNX.PAS                  
                                                 
                    Star Lynx                    

}

program Star_Lynx;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}
{$M 16384, 0, 655360}

uses
  DOS, StarBase;

const
{Length of the Lynx buffer}
  LynxBufferMax = 16384;

var
  SpecError     : Boolean;
  LynxSize      : Word;
  LynxStart,
  Header,
  HeaderEnd,
  FileLen       : Longint;
  Creator       : string;
  NumStr        : array [0..9] of Char;
  DiskBuffer    : TDiskBuffer;
  LynxBuffer    : array [0..LynxBufferMax - 1] of Byte;

{The Lynx archive header}
procedure LynxHeader; external;
{$L LYNXHDR.OBJ}

{Read a number from an archive file
  Input : SI: offset of current character in the buffer
  Output: AX: word read from the buffer
          BL: the character following the number
          CF: if 1 then an invalid character was found}
function ReadNum: Word; assembler;
asm
@6: cmp byte ptr LynxBuffer[si], ' ';
    jne @5;
    inc si;
    jmp @6;
@5: xor ax, ax;
    xor bh, bh;
    mov cx, 10;
@2: mov bl, byte ptr LynxBuffer[si];
    cmp bl, ' ';
    je @1;
    cmp bl, 13;
    je @1;
    cmp bl, '0';
    jb @3;
    cmp bl, '9';
    ja @3;
    mul cx;
    sub bl, '0';
    add ax, bx;
    jc @3;
    inc si;
    jmp @2;
@1: cmp byte ptr LynxBuffer[si], ' ';
    jne @7;
    inc si;
    jmp @1;
@7: mov bl, byte ptr LynxBuffer[si];
    clc;
    jmp @4;
@3: stc;
@4:
end;

{Write a number into an archive file
  Input : AX: number to be put into the file
          SI: offset of current character in the buffer}
procedure WriteNum; assembler;
asm
    mov byte ptr LynxBuffer[si], ' ';
    inc si;
    or ax, ax;
    jne @3;
    mov byte ptr LynxBuffer[si], '0';
    inc si;
    jmp @1;
@3: mov cx, 10;
    push ds;
    pop es;
    mov di, Offset(NumStr);
    cld;
@2: xor dx, dx;
    div cx;
    xchg ax, dx;
    add al, '0';
    stosb;
    xchg ax, dx;
    or ax, ax;
    jne @2;
    mov bx, di;
    dec bx;
@4: mov al, [bx];
    mov byte ptr LynxBuffer[si], al;
    dec bx;
    inc si;
    cmp bx, Offset(NumStr);
    jae @4;
@1: mov byte ptr LynxBuffer[si], ' ';
    inc si;
end;

{Lynx 'List' option processor}
procedure LynxListOptions(const Option: string); far;
begin
  case Option[1] of
    'V': Verbose := True;
  else
    CharSetOptions(Option);
  end;
end;

begin
  WriteLn('Star Lynx' + VersionStr + CopyrightStr);
  WriteLn;
  if Test8086 = 0 then
  begin
    WriteLn('This program requires an 80286 CPU or above');
  end
  else
  begin
    if ParamCount < 2 then
    begin
      WriteLn('This program creates, lists and extracts Commodore Lynx archives.');
      WriteLn;
      WriteLn('Create : STARLYNX [-]A <filename> [-|/C|D|Y] [<lynxname>]');
      WriteLn('List   : STARLYNX [-]L <lynxname> [-|/V]');
      WriteLn('Extract: STARLYNX [-]X <lynxname> [-|/4|7|8|C|D|X[D|P|S]|Y] [<diskname>]');
    end
    else
    begin
      CommonInit;
      case Command of
        'A':
        begin
          ParseCmdLine(AddOptions);
          if not Error then
          begin
            DiskName := UpperCase(LongParamStr(2));
            ArcName := UpperCase(LongParamStr(Number));
            SplitName(DiskName, Dir1, Name1, Ext1);
            SplitName(ArcName, Dir2, Name2, Ext2);
            FixDiskExt(Ext1);
            if Ext2 = '.*' then Ext2 := '.lnx';
            SearchPar := Dir1 + Name1 + Ext1;
            LongFindFirst(SearchPar, Archive + ReadOnly, Entry);
            if DOSError <> 0 then
            begin
              WriteLn(SearchPar, ' not found');
            end
            else
            begin
              repeat
                asm
                  push ds;
                  mov cx, LynxHeaderLen;
                  mov DiskSize, cx;
                  push ds;
                  pop es;
                  push cs;
                  pop ds;
                  mov si, Offset(LynxHeader);
                  mov di, Offset(LynxBuffer);
                  cld;
                  rep movsb;
                  pop ds;
                end;
                FileNum := 0;
                LynxSize := 256;
                Error := True;
                SplitName(Entry.LongName, Dir, Name1, Ext1);
                DiskName := Dir1 + Entry.LongName;
                ArcName := Dir2 + CloneName(Name1, Name2) + Ext2;
                if OpenImage(False) = 0 then
                begin
                  Error := False;
                  ExtGetFTime(Image, FileDate);
                  while ReadCBMEntry(CBMEntry) do
                  begin
                    if CBMEntry.Attr > 0 then
                    begin
                      Attr := CBMEntry.Attr and 7;
                      if Attr in [0..3] then
                      begin
                        Inc(FileNum);
                        FileType := UpCase(ShortCBMExt[Attr][1]);
                        Block := 0;
                        if (Track > 0) and ((Track <> DirTrack) or (Sector > FirstDirSector)) then
                        begin
                          while (Track > 0) and (Track < MaxTrack) and (Sector < SectorNum(Track)) do
                          begin
                            Inc(Block);
                            ReadDiskBlock(Track, Sector, @DataBuffer);
                            Track := DataBuffer[0];
                            Sector := DataBuffer[1];
                          end;
                        end
                        else
                        begin
                          Sector := 0;
                        end;
                        asm
                          push ds;
                          pop es;
                          mov di, Offset(LynxBuffer);
                          add di, LynxSize;
                          mov si, Offset(CBMEntry.Name);
                          cld;
                          lodsb;
                          mov cl, al;
                          xor ch, ch;
                          push cx;
                          rep movsb;
                          pop cx;
                          mov al, 160;
                      @2: cmp cx, 16;
                          jae @1;
                          stosb;
                          inc cx;
                          jmp @2;
                      @1: mov si, di;
                          sub si, Offset(LynxBuffer);
                          mov byte ptr LynxBuffer[si], 13;
                          inc si;
                          mov ax, Block;
                          call WriteNum;
                          mov byte ptr LynxBuffer[si], 13;
                          inc si;
                          mov al, FileType;
                          mov byte ptr LynxBuffer[si], al;
                          inc si;
                          mov byte ptr LynxBuffer[si], 13;
                          inc si;
                          mov al, Sector;
                          xor ah, ah;
                          call WriteNum;
                          mov byte ptr LynxBuffer[si], 13;
                          inc si;
                          mov LynxSize, si;
                        end;
                      end;
                    end;
                  end;
                  ExtClose(Image);
                end
                else
                begin
                  WriteLn(DiskName, ' is not a valid disk image');
                end;
                if not Error then
                begin
                  asm
                    mov si, DiskSize;
                    mov ax, FileNum;
                    call WriteNum;
                    mov byte ptr LynxBuffer[si], 13;
                    inc si;
                    mov DiskSize, si;
                    push ds;
                    pop es;
                    mov dx, si;
                    mov si, Offset(LynxBuffer[256]);
                    mov di, dx;
                    add di, Offset(LynxBuffer);
                    mov cx, LynxSize;
                    sub cx, 256;
                    cld;
                    rep movsb;
                    mov bx, di;
                    mov cx, 254;
                    xor al, al;
                    rep stosb;
                    sub bx, Offset(LynxBuffer);
                    mov LynxSize, bx;
                    mov ax, bx;
                    mov cl, 254;
                    div cl;
                    or ah, ah;
                    je @1;
                    inc al;
                @1: xor ah, ah;
                    mov BlockNum, ax;
                    mov si, LynxBlockPos;
                    call WriteNum;
                    mov ax, BlockNum;
                    mov cl, 254;
                    mul cl;
                    mov LynxSize, ax;
                  end;
                  if LineFeed then WriteLn;
                  WriteLn('Creating archive: ', ArcName, ' out of ', DiskName);
                  if FileNum = 0 then
                  begin
                    WriteLn(DiskName, ' is empty');
                  end
                  else
                  begin
                    Over := True;
                    IOError := 0;
                    if LongOpenFile(ArcName, ArcFile, fmReadOnly) = 0 then
                    begin
                      ExtClose(ArcFile);
                      Over := Question(ArcName + ' exists. Overwrite', 'Always', 'nEver', '', Overwrite);
                    end;
                    if Over then
                    begin
                      IOError := LongOpenFile(ArcFile.LongName, ArcFile, fmWriteOnly);
                      if IOError = 0 then
                      begin
                        ExtBlockWrite(ArcFile, LynxBuffer, LynxSize);
                        AllSize := LynxSize;
                        if OpenImage(False) = 0 then
                        begin
                          FileCount := 1;
                          while not Error and ReadCBMEntry(CBMEntry) do
                          begin
                            if CBMEntry.Attr > 0 then
                            begin
                              Attr := CBMEntry.Attr and 7;
                              if Attr in [0..3] then
                              begin
                                FileName := CBMEntry.Name;
                                MakeName;
                                OpenRead;
                                Buffer := New(PBuffer);
                                WriteLn('  Adding: ', PCName);
                                if (Track > 0) and ((Track <> DirTrack) or (Sector > FirstDirSector)) then
                                begin
                                  LynxSize := AllSize mod 254;
                                  if LynxSize > 0 then
                                  begin
                                    LynxSize := 254 - LynxSize;
                                    Inc(AllSize, LynxSize);
                                    FillChar(Buffer^, LynxSize, 0);
                                    ExtBlockWrite(ArcFile, Buffer^, LynxSize);
                                  end;
                                  while not Error and not _End do
                                  begin
                                    ReadPart(Buffer, LynxSize);
                                    Inc(AllSize, LynxSize);
                                    ExtBlockWrite(ArcFile, Buffer^, LynxSize);
                                  end;
                                end;
                                Dispose(Buffer);
                                if (IOResult <> 0) or Error then WriteLn('Cannot add ', PCName, ' correctly');
                                Inc(FileCount);
                              end;
                            end;
                          end;
                          CloseImage;
                        end;
                        ExtSetFTime(ArcFile, FileDate);
                        ExtClose(ArcFile);
                        if Error then LongErase(ArcFile.LongName);
                        LineFeed := True;
                      end
                      else
                      begin
                        WriteLn('Cannot create ', ArcName);
                      end;
                    end;
                    ExtClose(Image);
                    if not Error and Question('Delete ' + DiskName, 'Always', 'nEver', '', Delete) then
                      LongErase(Image.LongName);
                  end;
                end;
                LongFindNext(Entry);
              until (DOSError <> 0) or EscPressed;
              LongFindClose(Entry);
            end;
          end;
        end;
        'L', 'X':
        begin
          if List then ParseCmdLine(LynxListOptions) else ParseCmdLine(ExtractOptions);
          if not Error then
          begin
            DiskName := UpperCase(LongParamStr(Number));
            ArcName := UpperCase(LongParamStr(2));
            SplitName(DiskName, Dir1, Name1, Ext1);
            SplitName(ArcName, Dir2, Name2, Ext2);
            if Ext2 = '.*' then Ext2 := '.lnx';
            SearchPar := Dir2 + Name2 + Ext2;
            LongFindFirst(SearchPar, Archive + ReadOnly, Entry);
            if DOSError <> 0 then
            begin
              WriteLn(SearchPar, ' not found');
            end
            else
            begin
              repeat
                SplitName(Entry.LongName, Dir, Name2, Ext2);
                DiskName := Dir1 + CloneName(Name2, Name1) + GetDiskExt(DiskType);
                ArcName := Dir2 + Name2 + Ext2;
                Error := False;
                if LongOpenFile(ArcName, ArcFile, fmReadOnly) = 0 then
                begin
                  ExtGetFTime(ArcFile, FileDate);
                  if ExtFileSize(ArcFile) >= 254 then
                  begin
                    ExtBlockRead(ArcFile, LynxBuffer, 128);
                    asm
                      xor si, si;
                  @3: cmp word ptr LynxBuffer[si], 0;
                      jne @1;
                      cmp word ptr LynxBuffer[si][2], $0D00;
                      jne @1;
                      add si, 4;
                      jmp @2;
                  @1: inc si;
                      cmp si, 92;
                      jb @3;
                      xor si, si;
                  @2: mov word ptr Header[0], si;
                      mov word ptr Header[2], 0;
                    end;
                    ExtSeek(ArcFile, Header);
                    ExtBlockRead(ArcFile, LynxBuffer, 128);
                    asm
                      xor si, si;
                      call ReadNum;
                      jc @1;
                      or ax, ax;
                      je @1;
                      mov BlockNum, ax;
                      mov dx, si;
                      xor bl, bl;
                  @5: cmp byte ptr LynxBuffer[si], 13;
                      je @2;
                      cmp word ptr LynxBuffer[si], 'YL';
                      jne @6;
                      cmp word ptr LynxBuffer[si][2], 'XN';
                      jne @6;
                      inc bl;
                  @6: inc si;
                      cmp si, 30;
                      jb @5;
                      jmp @1;
                  @2: or bl, bl;
                      je @1;
                      inc si;
                      xchg si, dx;
                      mov cx, dx;
                      sub cx, si;
                      dec cl;
                      add si, Offset(LynxBuffer);
                      mov di, Offset(Creator);
                      mov bx, Offset(PETToASCLower);
                      push ds;
                      pop es;
                      cld;
                      mov al, cl;
                      stosb;
                  @4: lodsb;
                      xlat;
                      stosb;
                      loop @4;
                      mov si, dx;
                      call ReadNum;
                      jc @1;
                      or ax, ax;
                      je @1;
                      cmp bl, 13;
                      jne @1;
                      mov FileNum, ax;
                      inc si;
                      add word ptr Header[0], si;
                      jmp @3;
                  @1: mov Error, True;
                  @3:
                    end;
                  end;
                  if Error then
                  begin
                    WriteLn(ArcName, ' is not a valid Lynx archive');
                  end
                  else
                  begin
                    Over := True;
                    HeaderEnd := BlockNum * 254;
                    LynxStart := HeaderEnd;
                    AllSize := 0;
                    AllBlocks := 0;
                    if LineFeed then WriteLn;
                    if List then Write('Listing') else Write('Extracting');
                    Write(' archive: ', ArcName);
                    if List then
                    begin
                      if Verbose then WriteLn(' ("', Creator, '")') else WriteLn;
                      WriteLn('Length  Blocks         Name        Type');
                      WriteLn('------  ------  ------------------  ---');
                    end
                    else
                    begin
                      WriteLn(' into ', DiskName);
                      Over := True;
                      if LongOpenFile(DiskName, Image, fmReadOnly) = 0 then
                      begin
                        ExtClose(Image);
                      end
                      else
                      begin
                        if CreateDisk <> 0 then
                        begin
                          WriteLn('Cannot create ', DiskName);
                          Over := False;
                        end;
                      end;
                    end;
                    if Over then
                    begin
                      FileCount := 1;
                      while not EscPressed and not Error and (FileCount <= FileNum) do
                      begin
                        if Header >= HeaderEnd then
                        begin
                          Error := True;
                          WriteLn(ArcName, ' has an invalid header');
                        end
                        else
                        begin
                          ExtSeek(ArcFile, Header);
                          ExtBlockRead(ArcFile, LynxBuffer, 32);
                          SpecError := False;
                          asm
                            xor si, si;
                        @2: mov al, byte ptr LynxBuffer[si];
                            cmp al, 13;
                            je @3;
                            mov byte ptr FileName[si][1], al;
                            inc si;
                            cmp si, 17;
                            jb @2;
                            xor si, si;
                        @3: mov ax, si;
                            mov byte ptr FileName[0], al;
                            or al, al;
                            je @1;
                            push si;
                            call MakeASCIIName;
                            pop si;
                            jc @1;
                            inc si;
                            call ReadNum;
                            jc @1;
                            cmp bl, 13;
                            jne @1;
                            mov BlockNum, ax;
                            inc si;
                            mov al, byte ptr LynxBuffer[si];
                            mov FileType, al;
                            inc si;
                            mov al, byte ptr LynxBuffer[si];
                            cmp al, 13;
                            jne @1;
                            inc si;
                            call ReadNum;
                            jnc @6;
                            mov SpecError, True;
                            jmp @4;
                        @6: cmp bl, 13;
                            jne @1;
                            mov ByteNum, ax;
                            inc si;
                            mov ah, FileType;
                            xor al, al;
                            cmp ah, 'D';
                            je @5;
                            inc al;
                            cmp ah, 'S';
                            je @5;
                            inc al;
                            cmp ah, 'P';
                            je @5;
                            inc al;
                            cmp ah, 'U';
                            jne @1;
                        @5: mov Attr, al;
                            add word ptr Header[0], si;
                            adc word ptr Header[2], 0;
                            jmp @4;
                        @1: mov Error, True;
                        @4:
                          end;
                          if SpecError then
                          begin
                            if FileCount = FileNum then
                            begin
                              if BlockNum = 0 then
                              begin
                                ByteNum := 0;
                              end
                              else
                              begin
                                FileLen := ExtFileSize(ArcFile) - LynxStart - (Longint(BlockNum) - 1) * 254;
                                if FileLen > 254 then ByteNum := 255 else ByteNum := FileLen mod 254 + 1;
                              end;
                            end
                            else
                            begin
                              Error := True;
                            end;
                          end;
                          CopySize := 0;
                          if BlockNum <> 0 then CopySize := Longint(BlockNum) * 254 - 255 + ByteNum;
                          if Error then
                          begin
                            WriteLn(ArcName, ' has an invalid entry');
                          end
                          else
                          begin
                            Inc(AllSize, CopySize);
                            Inc(AllBlocks, BlockNum);
                            if List then
                            begin
                              PCName := '"' + ASCIIName + '"';
                              while Length(PCName) < 18 do PCName := PCName + ' ';
                              WriteLn(CopySize:6, '  ', BlockNum:6, '  ', PCName, '  ', ShortCBMExt[Attr]);
                            end
                            else
                            begin
                              Escape;
                              if not EscPressed then
                              begin
                                MakeName;
                                Over := Question('Extract ' + PCName, 'Always', 'nEver', '', Confirm);
                                if Over then
                                begin
                                  repeat
                                    if OpenWrite(FileName, Attr, CopySize, False) = 254 then
                                    begin
                                      Error := False;
                                      Over := Question(PCName + ' exists. Extract anyway', 'Always',
                                        'nEver', 'Rename', Overwrite);
                                      if Over then Over := (OpenWrite(FileName, Attr, CopySize, True) = 0);
                                    end;
                                  until Over or (Overwrite <> aaRename);
                                end;
                                if not Over then WriteLn('  Skipping:   ', PCName);
                                if Over and not Error then
                                begin
                                  Buffer := New(PBuffer);
                                  FillChar(Buffer^, BufferSize, 0);
                                  WriteLn('  Extracting: ', PCName);
                                  ExtSeek(ArcFile, LynxStart);
                                  while not EscPressed and (CopySize > 0) and not _End and not Error do
                                  begin
                                    if CopySize > BufferSize then LynxSize := BufferSize else LynxSize := CopySize;
                                    Dec(CopySize, LynxSize);
                                    ExtBlockRead(ArcFile, Buffer^, LynxSize);
                                    WritePart(Buffer, LynxSize, (CopySize = 0));
                                    Escape;
                                  end;
                                  if (IOResult <> 0) or Error then WriteLn('Cannot extract ', PCName, ' correctly');
                                  CloseWrite;
                                  Dispose(Buffer);
                                end;
                              end;
                            end;
                            Inc(LynxStart, BlockNum * 254);
                          end;
                        end;
                        Inc(FileCount);
                      end;
                      if List then
                      begin
                        WriteLn('------  ------  ------------------  ---');
                        Write(AllSize:6, '  ', AllBlocks:6, '  ');
                        Count := 12;
                        if FileNum = 1 then Inc(Count);
                        Write(FileNum:Count, ' file');
                        if FileNum > 1 then Write('s');
                        WriteLn;
                      end;
                    end;
                  end;
                  ExtClose(ArcFile);
                  if not List and not Error and Question('Delete ' + ArcName, 'Always', 'nEver', '', Delete) then
                    LongErase(ArcFile.LongName);
                  LineFeed := True;
                end
                else
                begin
                  WriteLn;
                  WriteLn('Cannot open ', ArcName);
                end;
                LongFindNext(Entry);
              until (DOSError <> 0) or EscPressed;
              LongFindClose(Entry);
            end;
          end;
        end;
      else
        WriteLn('Unknown command');
      end;
    end;
  end;
end.
