{
Ŀ
                 Joe Forster/STA                 
                                                 
                   STARLBR.PAS                   
                                                 
                   Star Library                  

}

program Star_Library;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}
{$M 16384, 0, 655360}

uses
  DOS, StarBase;

const
{Size of Library buffer}
  LBRBufferMax  = 4096;
{Library archive signature}
  LBRSign       : string[3] = 'DWB';

var
  LBRSize       : Word;
  FileSize,
  LBRStart,
  Header,
  HeaderEnd     : Longint;
  NumStr        : array [0..9] of Char;
  DiskBuffer    : TDiskBuffer;
  LBRBuffer     : array [0..LBRBufferMax - 1] of Byte;

{Read a number from an archive file
  Input : SI: offset of current character in the buffer
          CX: base number
  Output: AX:DX: longint read from the buffer
          BL: the character following the number
          CF: if 1 then an invalid character was found}
function ReadNum: Longint; assembler;
asm
@6: cmp byte ptr LBRBuffer[si], ' ';
    jne @5;
    inc si;
    jmp @6;
@5: xor ax, ax;
    xor bx, bx;
@2: mov dl, byte ptr LBRBuffer[si];
    cmp dl, 'a';
    jb @8;
    cmp dl, 'z';
    ja @8;
    sub dl, 'a' - 'A';
@8: sub dl, '0';
    cmp dl, 9;
    jbe @9;
    sub dl, 'A' - '0' - 10;
@9: cmp dl, cl;
    ja @1;
    xor dh, dh;
    mov di, dx;
    xor dx, dx;
    xchg ax, bx;
    mul cx;
    or dx, dx;
    jne @3;
    xchg ax, bx;
    mul cx;
    add bx, dx;
    jc @3;
    add ax, di;
    adc bx, 0;
    jc @3;
    inc si;
    jmp @2;
@1: cmp byte ptr LBRBuffer[si], ' ';
    jne @7;
    inc si;
    jmp @1;
@7: mov dx, bx;
    mov bl, byte ptr LBRBuffer[si];
    clc;
    jmp @4;
@3: stc;
@4:
end;

{Write a number into an archive file
  Input : AX:DX: longint to be written into the file
          CX: base number
          DI: minimum number of characters; if number is shorter then
              spaces are prepended
          SI: offset of current character in the buffer}
procedure WriteNum; assembler;
asm
    push bp;
    and di, $000F;
    sub di, 2;
    jnc @6;
    xor di, di;
@6: mov bp, di;
    mov byte ptr LBRBuffer[si], ' ';
    inc si;
    mov bx, dx;
    mov di, Offset(NumStr);
@2: xor dx, dx;
    xchg ax, bx;
    div cx;
    xchg ax, bx;
    div cx;
    add dl, '0';
    cmp dl, '9';
    jbe @5;
    add dl, 'A' - '0' - 10;
@5: mov [di], dl;
    inc di;
    or bp, bp;
    je @7;
    dec bp;
@7: mov dx, ax;
    or dx, bx;
    jne @2;
    mov al, ' ';
    or bp, bp;
    je @8;
@3: mov [di], al;
    inc di;
    dec bp;
    jne @3;
@8: mov bx, di;
    dec bx;
@4: mov al, [bx];
    mov byte ptr LBRBuffer[si], al;
    dec bx;
    inc si;
    cmp bx, Offset(NumStr);
    jae @4;
@1: mov byte ptr LBRBuffer[si], ' ';
    inc si;
    pop bp;
end;

{Read a directory entry from the Library archive}
procedure ReadLBREntry;
var
  I             : Integer;
begin
  ExtSeek(ArcFile, Header);
  ExtBlockRead(ArcFile, LBRBuffer, 32);
  I := IOResult;
  asm
    xor si, si;
@4: mov al, byte ptr LBRBuffer[si];
    cmp al, 13;
    je @3;
    mov byte ptr FileName[si][1], al;
    inc si;
    cmp si, 17;
    jb @4;
    xor si, si;
@3: mov ax, si;
    mov byte ptr FileName[0], al;
    or si, si;
    je @1;
    inc si;
    mov ah, byte ptr LBRBuffer[si];
    xor al, al;
    cmp ah, 'D';
    je @5;
    inc al;
    cmp ah, 'S';
    je @5;
    inc al;
    cmp ah, 'P';
    je @5;
    inc al;
    cmp ah, 'U';
    jne @1;
@5: or al, $80;
    mov Attr, al;
    inc si;
    cmp byte ptr LBRBuffer[si], 13;
    jne @1;
    inc si;
    mov cx, 10;
    call ReadNum;
    jc @1;
    cmp bl, 13;
    jne @1;
    mov word ptr CopySize[0], ax;
    mov word ptr CopySize[2], dx;
    inc si;
    add word ptr Header[0], si;
    jmp @2;
@1: mov Error, True;
@2:
  end;
end;

begin
  WriteLn('Star Library' + VersionStr + CopyrightStr);
  WriteLn;
  if Test8086 = 0 then
  begin
    WriteLn('This program requires an 80286 CPU or above');
  end
  else
  begin
    if ParamCount < 2 then
    begin
      WriteLn('This program creates, lists and extracts Commodore Library archives.');
      WriteLn;
      WriteLn('Create : STARLBR [-]A <diskname> [-|/C|D|Y] [<lbrname>]');
      WriteLn('List   : STARLBR [-]L <lbrname>');
      WriteLn('Extract: STARLBR [-]X <lbrname> [-|/4|7|8|C|D|X[D|P|S]|Y] [<diskname>]');
    end
    else
    begin
      CommonInit;
      case Command of
        'A':
        begin
          ParseCmdLine(AddOptions);
          if not Error then
          begin
            DiskName := UpperCase(LongParamStr(2));
            ArcName := UpperCase(LongParamStr(Number));
            SplitName(DiskName, Dir1, Name1, Ext1);
            SplitName(ArcName, Dir2, Name2, Ext2);
            FixDiskExt(Ext1);
            if Ext2 = '.*' then Ext2 := '.lbr';
            SearchPar := Dir1 + Name1 + Ext1;
            LongFindFirst(SearchPar, Archive + ReadOnly, Entry);
            if DOSError <> 0 then
            begin
              WriteLn(SearchPar, ' not found');
            end
            else
            begin
              repeat
                FileNum := 0;
                LBRSize := 10;
                Error := True;
                SplitName(Entry.LongName, Dir, Name1, Ext1);
                DiskName := Dir1 + Entry.LongName;
                ArcName := Dir2 + CloneName(Name1, Name2) + Ext2;
                if OpenImage(False) = 0 then
                begin
                  Error := False;
                  ExtGetFTime(Image, FileDate);
                  while ReadCBMEntry(CBMEntry) do
                  begin
                    if CBMEntry.Attr > 0 then
                    begin
                      Attr := CBMEntry.Attr and 7;
                      if Attr in [0..3] then
                      begin
                        Inc(FileNum);
                        FileType := UpCase(ShortCBMExt[Attr][1]);
                        CBMEntry.Size := 0;
                        if (Track > 0) and ((Track <> DirTrack) or (Sector > FirstDirSector)) then
                        begin
                          while (Track > 0) and (Track < MaxTrack) and (Sector < SectorNum(Track)) do
                          begin
                            ReadDiskBlock(Track, Sector, @DataBuffer);
                            Track := DataBuffer[0];
                            Sector := DataBuffer[1];
                            if Track > 0 then Inc(CBMEntry.Size, 254) else Inc(CBMEntry.Size, Sector - 1);
                          end;
                        end;
                        asm
                          push ds;
                          pop es;
                          mov di, Offset(LBRBuffer);
                          add di, LBRSize;
                          mov si, Offset(CBMEntry.Name);
                          cld;
                          lodsb;
                          mov cl, al;
                          xor ch, ch;
                          rep movsb;
                          mov al, 13;
                          stosb;
                          mov al, FileType;
                          stosb;
                          mov al, 13;
                          stosb;
                          mov si, di;
                          sub si, Offset(LBRBuffer);
                          mov ax, word ptr CBMEntry.Size[0];
                          mov dx, word ptr CBMEntry.Size[2];
                          mov cx, 10;
                          xor di, di;
                          call WriteNum;
                          mov di, si;
                          add di, Offset(LBRBuffer);
                          mov al, 13;
                          stosb;
                          mov bx, di;
                          sub bx, Offset(LBRBuffer);
                          mov LBRSize, bx;
                        end;
                      end;
                    end;
                  end;
                  ExtClose(Image);
                end
                else
                begin
                  WriteLn(DiskName, ' is not a valid disk image');
                end;
                if not Error then
                begin
                  asm
                    push ds;
                    pop es;
                    mov di, Offset(LBRBuffer);
                    mov si, Offset(LBRSign);
                    cld;
                    lodsb;
                    mov cl, al;
                    xor ch, ch;
                    rep movsb;
                    mov si, di;
                    sub si, Offset(LBRBuffer);
                    mov ax, FileNum;
                    xor dx, dx;
                    mov cx, 10;
                    xor di, di;
                    call WriteNum;
                    mov di, si;
                    add di, Offset(LBRBuffer);
                    mov al, 13;
                    stosb;
                    mov si, Offset(LBRBuffer[10]);
                    mov cx, LBRSize;
                    sub cx, 10;
                    rep movsb;
                    sub di, Offset(LBRBuffer);
                    mov LBRSize, di;
                  end;
                  if LineFeed then WriteLn;
                  WriteLn('Creating archive: ', ArcName, ' out of ', DiskName);
                  if FileNum = 0 then
                  begin
                    WriteLn(DiskName, ' is empty');
                  end
                  else
                  begin
                    Over := True;
                    IOError := 0;
                    if LongOpenFile(ArcName, ArcFile, fmReadOnly) = 0 then
                    begin
                      ExtClose(ArcFile);
                      Over := Question(ArcName + ' exists. Overwrite', 'Always', 'nEver', '', Overwrite);
                    end;
                    if Over then
                    begin
                      IOError := LongOpenFile(ArcFile.LongName, ArcFile, fmWriteOnly);
                      if IOError = 0 then
                      begin
                        ExtBlockWrite(ArcFile, LBRBuffer, LBRSize);
                        if OpenImage(False) = 0 then
                        begin
                          AllSize := LBRSize;
                          FileCount := 1;
                          while not Error and ReadCBMEntry(CBMEntry) do
                          begin
                            if CBMEntry.Attr > 0 then
                            begin
                              Attr := CBMEntry.Attr and 7;
                              if Attr in [0..3] then
                              begin
                                FileName := CBMEntry.Name;
                                MakeName;
                                OpenRead;
                                Buffer := New(PBuffer);
                                WriteLn('  Adding: ', PCName);
                                if (Track > 0) and ((Track <> DirTrack) or (Sector > FirstDirSector)) then
                                begin
                                  while not Error and not _End do
                                  begin
                                    ReadPart(Buffer, LBRSize);
                                    Inc(AllSize, LBRSize);
                                    ExtBlockWrite(ArcFile, Buffer^, LBRSize);
                                  end;
                                end;
                                Dispose(Buffer);
                                if (IOResult <> 0) or Error then WriteLn('Cannot add ', PCName, ' correctly');
                                Inc(FileCount);
                              end;
                            end;
                          end;
(*!                          LBRSize := AllSize mod 1024;
                          if LBRSize > 0 then
                          begin
                            LBRSize := 1024 - LBRSize;
                            FillChar(Buffer^, LBRSize, 26);
                            BlockWrite(ArcFile, Buffer^, LBRSize);
                          end;!*)
                          CloseImage;
                        end;
                        ExtSetFTime(ArcFile, FileDate);
                        ExtClose(ArcFile);
                        if Error then LongErase(ArcFile.LongName);
                        LineFeed := True;
                      end
                      else
                      begin
                        WriteLn('Cannot create ', ArcName);
                      end;
                    end;
                    ExtClose(Image);
                    if not Error and Question('Delete ' + DiskName, 'Always', 'nEver', '', Delete) then
                      LongErase(Image.LongName);
                  end;
                end;
                LongFindNext(Entry);
              until (DOSError <> 0) or EscPressed;
              LongFindClose(Entry);
            end;
          end;
        end;
        'L', 'X':
        begin
          if List then ParseCmdLine(NoOptions) else ParseCmdLine(ExtractOptions);
          if not Error then
          begin
            DiskName := UpperCase(LongParamStr(Number));
            ArcName := UpperCase(LongParamStr(2));
            SplitName(DiskName, Dir1, Name1, Ext1);
            SplitName(ArcName, Dir2, Name2, Ext2);
            if Ext2 = '.*' then Ext2 := '.lbr';
            SearchPar := Dir2 + Name2 + Ext2;
            LongFindFirst(SearchPar, Archive + ReadOnly, Entry);
            if DOSError <> 0 then
            begin
              WriteLn(SearchPar, ' not found');
            end
            else
            begin
              repeat
                SplitName(Entry.LongName, Dir, Name2, Ext2);
                DiskName := Dir1 + CloneName(Name2, Name1) + GetDiskExt(DiskType);
                ArcName := Dir2 + Name2 + Ext2;
                Error := False;
                if LongOpenFile(ArcName, ArcFile, fmReadOnly) = 0 then
                begin
                  ExtGetFTime(ArcFile, FileDate);
                  Over := True;
                  Header := 0;
                  ExtBlockRead(ArcFile, LBRBuffer, 10);
                  asm
                    push ds;
                    pop es;
                    mov di, Offset(LBRBuffer);
                    mov si, Offset(LBRSign);
                    cld;
                    lodsb;
                    mov cl, al;
                    xor ch, ch;
                    rep cmpsb;
                    jne @1;
                    mov si, di;
                    sub si, Offset(LBRBuffer);
                    mov cx, 10;
                    call ReadNum;
                    jc @1;
                    or dx, dx;
                    jne @1;
                    or ah, ah;
                    jne @1;
                    cmp bl, 13;
                    jne @1;
                    mov FileNum, ax;
                    inc si;
                    mov word ptr Header[0], si;
                    jmp @2;
                @1: mov Error, True;
                @2:
                  end;
                  LBRStart := Header;
                  FileCount := 0;
                  while not Error and (FileCount < FileNum) do
                  begin
                    ReadLBREntry;
                    Inc(FileCount);
                  end;
                  if Error then
                  begin
                    WriteLn(ArcName, ' is not a valid Library archive');
                  end
                  else
                  begin
                    HeaderEnd := Header;
                    Header := LBRStart;
                    LBRStart := HeaderEnd;
                    AllSize := 0;
                    AllBlocks := 0;
                    if LineFeed then WriteLn;
                    if List then Write('Listing') else Write('Extracting');
                    Write(' archive: ', ArcName);
                    if List then
                    begin
                      WriteLn;
                      WriteLn('Length  Blocks         Name          Type');
                      WriteLn('------  ------  ------------------  -----');
                    end
                    else
                    begin
                      WriteLn(' into ', DiskName);
                      Over := True;
                      if LongOpenFile(DiskName, Image, fmReadOnly) = 0 then
                      begin
                        ExtClose(Image);
                      end
                      else
                      begin
                        if CreateDisk <> 0 then
                        begin
                          WriteLn('Cannot create ', DiskName);
                          Over := False;
                        end;
                      end;
                    end;
                    if Over then
                    begin
                      FileCount := 1;
                      while not EscPressed and not Error and (FileCount <= FileNum) do
                      begin
                        if Header >= HeaderEnd then
                        begin
                          Error := True;
                          WriteLn(ArcName, ' has an invalid header');
                        end
                        else
                        begin
                          ReadLBREntry;
                          asm
                            mov ax, word ptr CopySize[0];
                            mov dx, word ptr CopySize[2];
                            mov cx, 254;
                            div cx;
                            or dx, dx;
                            je @1;
                            inc ax;
                        @1: mov BlockNum, ax;
                          end;
                          Inc(AllSize, CopySize);
                          Inc(AllBlocks, BlockNum);
                          FileSize := CopySize;
                          if Attr and $40 = 0 then Protected := ' ' else Protected := '<';
                          if Attr and $80 = 0 then Closed := '*' else Closed := ' ';
                          if List then
                          begin
                            MakeASCIIName;
                            PCName := '"' + ASCIIName + '"';
                            while Length(PCName) < 18 do PCName := PCName + ' ';
                            WriteLn(CopySize:6, '  ', BlockNum:6, '  ', PCName, '  ',
                              Closed, ShortCBMExt[Attr and 7], Protected);
                          end
                          else
                          begin
                            Escape;
                            if not EscPressed then
                            begin
                              MakeName;
                              Over := Question('Extract ' + PCName, 'Always', 'nEver', '', Confirm);
                              if Over then
                              begin
                                repeat
                                  if OpenWrite(FileName, Attr, CopySize, False) = 254 then
                                  begin
                                    Error := False;
                                    Over := Question(PCName + ' exists. Extract anyway', 'Always',
                                      'nEver', 'Rename', Overwrite);
                                    if Over then Over := (OpenWrite(FileName, Attr, CopySize, True) = 0);
                                  end;
                                until Over or (Overwrite <> aaRename);
                              end;
                              if not Over then WriteLn('  Skipping:   ', PCName);
                              if Over and not Error then
                              begin
                                Buffer := New(PBuffer);
                                FillChar(Buffer^, BufferSize, 0);
                                WriteLn('  Extracting: ', PCName);
                                ExtSeek(ArcFile, LBRStart);
                                while not EscPressed and (CopySize > 0) and not _End and not Error do
                                begin
                                  if CopySize > BufferSize then LBRSize := BufferSize else LBRSize := CopySize;
                                  Dec(CopySize, LBRSize);
                                  ExtBlockRead(ArcFile, Buffer^, LBRSize);
                                  WritePart(Buffer, LBRSize, (CopySize = 0));
                                  Escape;
                                end;
                                if (IOResult <> 0) or Error then WriteLn('Cannot extract ', PCName, ' correctly');
                                CloseWrite;
                                Dispose(Buffer);
                              end;
                            end;
                          end;
                          Inc(LBRStart, FileSize);
                        end;
                        Inc(FileCount);
                      end;
                      if List then
                      begin
                        WriteLn('------  ------  ------------------  -----');
                        Write(AllSize:6, '  ', AllBlocks:6, '  ');
                        Count := 12;
                        if FileNum = 1 then Inc(Count);
                        Write(FileNum:Count, ' file');
                        if FileNum > 1 then Write('s');
                        WriteLn;
                      end;
                    end;
                    ExtClose(ArcFile);
                    if not List and not Error and Question('Delete ' + ArcName, 'Always', 'nEver', '', Delete) then
                      LongErase(ArcFile.LongName);
                    LineFeed := True;
                  end;
                end
                else
                begin
                  WriteLn;
                  WriteLn('Cannot open ', ArcName);
                end;
                LongFindNext(Entry);
              until (DOSError <> 0) or EscPressed;
              LongFindClose(Entry);
            end;
          end;
        end;
      else
        WriteLn('Unknown command');
      end;
    end;
  end;
end.
