{
Ŀ
                 Joe Forster/STA                 
                                                 
                   STARARK.PAS                   
                                                 
                   Star Arkive                   

}

program Star_Arkive;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}
{$M 16384, 0, 655360}

uses
  DOS, StarBase;

const
{Size of Arkive buffer}
  ARKBufferMax  = 4096;

var
  ARKSize       : Word;
  ARKStart,
  Header,
  HeaderEnd     : Longint;
  ExtAttrib     : array [0..8] of Byte;
  DiskBuffer    : TDiskBuffer;
  ARKBuffer     : array [0..ARKBufferMax - 1] of Byte;

begin
  WriteLn('Star Arkive' + VersionStr + CopyrightStr);
  WriteLn;
  if Test8086 = 0 then
  begin
    WriteLn('This program requires an 80286 CPU or above');
  end
  else
  begin
    if ParamCount < 2 then
    begin
      WriteLn('This program creates, lists and extracts Commodore Arkive archives.');
      WriteLn;
      WriteLn('Create : STARARK [-]A <diskname> [-|/C|Y] [<arkname>]');
      WriteLn('List   : STARARK [-]L <arkname>');
      WriteLn('Extract: STARARK [-]X <arkname> [-|/4|7|8|C|D|X[D|P|S]|Y] [<diskname>]');
    end
    else
    begin
      CommonInit;
      case Command of
        'A':
        begin
          ParseCmdLine(AddOptions);
          if not Error then
          begin
            DiskName := UpperCase(LongParamStr(2));
            ArcName := UpperCase(LongParamStr(Number));
            SplitName(DiskName, Dir1, Name1, Ext1);
            SplitName(ArcName, Dir2, Name2, Ext2);
            FixDiskExt(Ext1);
            if Ext2 = '.*' then Ext2 := '.ark';
            SearchPar := Dir1 + Name1 + Ext1;
            LongFindFirst(SearchPar, Archive + ReadOnly, Entry);
            if DOSError <> 0 then
            begin
              WriteLn(SearchPar, ' not found');
            end
            else
            begin
              repeat
                FileNum := 0;
                ARKSize := 1;
                Error := True;
                SplitName(Entry.LongName, Dir, Name1, Ext1);
                DiskName := Dir1 + Entry.LongName;
                ArcName := Dir2 + CloneName(Name1, Name2) + Ext2;
                if OpenImage(False) = 0 then
                begin
                  Error := False;
                  ExtGetFTime(Image, FileDate);
                  while ReadCBMEntry(CBMEntry) do
                  begin
                    if CBMEntry.Attr > 0 then
                    begin
                      Attr := CBMEntry.Attr and 7;
                      if Attr in [0..3] then
                      begin
                        Inc(FileNum);
                        FileType := UpCase(ShortCBMExt[Attr][1]);
                        Block := 0;
                        if (Track > 0) and ((Track <> DirTrack) or (Sector > FirstDirSector)) then
                        begin
                          while (Track > 0) and (Track < MaxTrack) and (Sector < SectorNum(Track)) do
                          begin
                            Inc(Block);
                            ReadDiskBlock(Track, Sector, @DataBuffer);
                            Track := DataBuffer[0];
                            Sector := DataBuffer[1];
                          end;
                        end
                        else
                        begin
                          Sector := 0;
                        end;
                        asm
                          push ds;
                          pop es;
                          mov di, Offset(ARKBuffer);
                          add di, ARKSize;
                          mov al, CBMEntry.Attr;
                          cld;
                          stosb;
                          mov al, Sector;
                          stosb;
                          mov si, Offset(CBMEntry.Name);
                          lodsb;
                          mov cl, al;
                          xor ch, ch;
                          push cx;
                          rep movsb;
                          pop cx;
                          mov al, 160;
                      @2: cmp cx, 16;
                          jae @1;
                          stosb;
                          inc cx;
                          jmp @2;
                      @1: mov al, EntryPos;
                          xor ah, ah;
                          mov si, ax;
                          add si, Offset(DirBuffer[21]);
                          mov cx, 9;
                          rep movsb;
                          mov ax, Block;
                          stosw;
                          mov bx, di;
                          sub bx, Offset(ARKBuffer);
                          mov ARKSize, bx;
                        end;
                      end;
                    end;
                  end;
                  ExtClose(Image);
                end
                else
                begin
                  WriteLn(DiskName, ' is not a valid disk image');
                end;
                if not Error then
                begin
                  asm
                    mov al, byte ptr FileNum[0];
                    mov byte ptr ARKBuffer[0], al;
                    mov ax, ARKSize;
                    mov cl, 254;
                    div cl;
                    or ah, ah;
                    je @1;
                    inc al;
                @1: xor ah, ah;
                    mov cl, 254;
                    mul cl;
                    mov ARKSize, ax;
                  end;
                  if LineFeed then WriteLn;
                  WriteLn('Creating archive: ', ArcName, ' out of ', DiskName);
                  if FileNum = 0 then
                  begin
                    WriteLn(DiskName, ' is empty');
                  end
                  else
                  begin
                    Over := True;
                    IOError := 0;
                    if LongOpenFile(ArcName, ArcFile, fmReadOnly) = 0 then
                    begin
                      ExtClose(ArcFile);
                      Over := Question(ArcName + ' exists. Overwrite', 'Always', 'nEver', '', Overwrite);
                    end;
                    if Over then
                    begin
                      IOError := LongOpenFile(ArcFile.LongName, ArcFile, fmWriteOnly);
                      if IOError = 0 then
                      begin
                        ExtBlockWrite(ArcFile, ARKBuffer, ARKSize);
                        if OpenImage(False) = 0 then
                        begin
                          FileCount := 1;
                          while not Error and ReadCBMEntry(CBMEntry) do
                          begin
                            if CBMEntry.Attr > 0 then
                            begin
                              Attr := CBMEntry.Attr and 7;
                              if Attr in [0..3] then
                              begin
                                FileName := CBMEntry.Name;
                                MakeName;
                                OpenRead;
                                AllSize := 0;
                                Buffer := New(PBuffer);
                                WriteLn('  Adding: ', PCName);
                                if (Track > 0) and ((Track <> DirTrack) or (Sector > FirstDirSector)) then
                                begin
                                  while not Error and not _End do
                                  begin
                                    ReadPart(Buffer, ARKSize);
                                    Inc(AllSize, ARKSize);
                                    ExtBlockWrite(ArcFile, Buffer^, ARKSize);
                                  end;
                                end;
                                ARKSize := AllSize mod 254;
                                if ARKSize > 0 then
                                begin
                                  ARKSize := 254 - ARKSize;
                                  FillChar(Buffer^, ARKSize, 0);
                                  ExtBlockWrite(ArcFile, Buffer^, ARKSize);
                                end;
                                Dispose(Buffer);
                                if (IOResult <> 0) or Error then WriteLn('Cannot add ', PCName, ' correctly');
                                Inc(FileCount);
                              end;
                            end;
                          end;
                          CloseImage;
                        end;
                        ExtSetFTime(ArcFile, FileDate);
                        ExtClose(ArcFile);
                        if Error then LongErase(ArcFile.LongName);
                        LineFeed := True;
                      end
                      else
                      begin
                        WriteLn('Cannot create ', ArcName);
                      end;
                    end;
                    if not Error and Question('Delete ' + DiskName, 'Always', 'nEver', '', Delete) then
                      LongErase(Image.LongName);
                  end;
                end;
                LongFindNext(Entry);
              until (DOSError <> 0) or EscPressed;
              LongFindClose(Entry);
            end;
          end;
        end;
        'L', 'X':
        begin
          if List then ParseCmdLine(NoOptions) else ParseCmdLine(ExtractOptions);
          if not Error then
          begin
            DiskName := UpperCase(LongParamStr(Number));
            ArcName := UpperCase(LongParamStr(2));
            SplitName(DiskName, Dir1, Name1, Ext1);
            SplitName(ArcName, Dir2, Name2, Ext2);
            if Ext2 = '.*' then Ext2 := '.ark';
            SearchPar := Dir2 + Name2 + Ext2;
            LongFindFirst(SearchPar, Archive + ReadOnly, Entry);
            if DOSError <> 0 then
            begin
              WriteLn(SearchPar, ' not found');
            end
            else
            begin
              repeat
                SplitName(Entry.LongName, Dir, Name2, Ext2);
                DiskName := Dir1 + CloneName(Name2, Name1) + GetDiskExt(DiskType);
                ArcName := Dir2 + Name2 + Ext2;
                Error := False;
                if LongOpenFile(ArcName, ArcFile, fmReadOnly) = 0 then
                begin
                  ExtGetFTime(ArcFile, FileDate);
                  Over := True;
                  Header := 1;
                  ExtBlockRead(ArcFile, Data, 1);
                  asm
                    mov al, Data;
                    xor ah, ah;
                    mov FileNum, ax;
                    mov cl, 29;
                    mul cl;
                    inc ax;
                    mov cl, 254;
                    div cl;
                    or ah, ah;
                    je @1;
                    inc al;
                @1: xor ah, ah;
                    mov BlockNum, ax;
                  end;
                  HeaderEnd := BlockNum * 254;
                  ARKStart := HeaderEnd;
                  AllSize := 0;
                  AllBlocks := 0;
                  if LineFeed then WriteLn;
                  if List then Write('Listing') else Write('Extracting');
                  Write(' archive: ', ArcName);
                  if List then
                  begin
                    WriteLn;
                    WriteLn('Length  Blocks         Name          Type');
                    WriteLn('------  ------  ------------------  -----');
                  end
                  else
                  begin
                    WriteLn(' into ', DiskName);
                    Over := True;
                    if LongOpenFile(DiskName, Image, fmReadOnly) = 0 then
                    begin
                      ExtClose(Image);
                    end
                    else
                    begin
                      if CreateDisk <> 0 then
                      begin
                        WriteLn('Cannot create ', DiskName);
                        Over := False;
                      end;
                    end;
                  end;
                  if Over then
                  begin
                    FileCount := 1;
                    while not EscPressed and not Error and (FileCount <= FileNum) do
                    begin
                      if Header >= HeaderEnd then
                      begin
                        Error := True;
                        WriteLn(ArcName, ' has an invalid header');
                      end
                      else
                      begin
                        ExtSeek(ArcFile, Header);
                        ExtBlockRead(ArcFile, ARKBuffer, 29);
                        asm
                          mov si, Offset(ARKBuffer);
                          cld;
                          lodsb;
                          mov Attr, al;
                          lodsb;
                          xor ah, ah;
                          mov ByteNum, ax;
                          push ds;
                          pop es;
                          mov di, Offset(FileName);
                          mov al, 16;
                          stosb;
                          mov cl, al;
                          xor ch, ch;
                          rep movsb;
                          mov di, Offset(ExtAttrib);
                          mov cx, 9;
                          rep movsb;
                          lodsw;
                          mov BlockNum, ax;
                          add word ptr Header[0], 29;
                          adc word ptr Header[2], 0;
                          xor dx, dx;
                          mov ax, ByteNum;
                          or ax, ax;
                          je @1;
                          mov ax, BlockNum;
                          mov cx, 254;
                          mul cx;
                          sub ax, 255;
                          sbb dx, 0;
                          add ax, ByteNum;
                          adc dx, 0;
                      @1: mov word ptr CopySize[0], ax;
                          mov word ptr CopySize[2], dx;
                        end;
                        Inc(AllSize, CopySize);
                        Inc(AllBlocks, BlockNum);
                        if Attr and $40 = 0 then Protected := ' ' else Protected := '<';
                        if Attr and $80 = 0 then Closed := '*' else Closed := ' ';
                        if List then
                        begin
                          MakeASCIIName;
                          PCName := '"' + ASCIIName + '"';
                          while Length(PCName) < 18 do PCName := PCName + ' ';
                          WriteLn(CopySize:6, '  ', BlockNum:6, '  ', PCName, '  ',
                            Closed, ShortCBMExt[Attr and 7], Protected);
                        end
                        else
                        begin
                          Escape;
                          if not EscPressed then
                          begin
                            MakeName;
                            Over := Question('Extract ' + PCName, 'Always', 'nEver', '', Confirm);
                            if Over then
                            begin
                              repeat
                                if OpenWrite(FileName, Attr, CopySize, False) = 254 then
                                begin
                                  Error := False;
                                  Over := Question(PCName + ' exists. Extract anyway', 'Always',
                                    'nEver', 'Rename', Overwrite);
                                  if Over then Over := (OpenWrite(FileName, Attr, CopySize, True) = 0);
                                end;
                              until Over or (Overwrite <> aaRename);
                            end;
                            if not Over then WriteLn('  Skipping:   ', PCName);
                            if Over and not Error then
                            begin
                              Buffer := New(PBuffer);
                              FillChar(Buffer^, BufferSize, 0);
                              WriteLn('  Extracting: ', PCName);
                              ExtSeek(ArcFile, ARKStart);
                              while not EscPressed and (CopySize > 0) and not _End and not Error do
                              begin
                                if CopySize > BufferSize then ARKSize := BufferSize else ARKSize := CopySize;
                                Dec(CopySize, ARKSize);
                                ExtBlockRead(ArcFile, Buffer^, ARKSize);
                                WritePart(Buffer, ARKSize, (CopySize = 0));
                                Escape;
                              end;
                              if (IOResult <> 0) or Error then WriteLn('Cannot extract ', PCName, ' correctly');
                              asm
                                push ds;
                                pop es;
                                mov al, EntryPos;
                                xor ah, ah;
                                mov di, ax;
                                add di, Offset(DirBuffer[21]);
                                mov si, Offset(ExtAttrib);
                                mov cx, 9;
                                cld;
                                rep movsb;
                              end;
                              CloseWrite;
                              Dispose(Buffer);
                            end;
                          end;
                        end;
                        Inc(ARKStart, BlockNum * 254);
                      end;
                      Inc(FileCount);
                    end;
                    if List then
                    begin
                      WriteLn('------  ------  ------------------  -----');
                      Write(AllSize:6, '  ', AllBlocks:6, '  ');
                      Count := 12;
                      if FileNum = 1 then Inc(Count);
                      Write(FileNum:Count, ' file');
                      if FileNum > 1 then Write('s');
                      WriteLn;
                    end;
                  end;
                  ExtClose(ArcFile);
                  if not List and not Error and Question('Delete ' + ArcName, 'Always', 'nEver', '', Delete) then
                    LongErase(ArcFile.LongName);
                  LineFeed := True;
                end
                else
                begin
                  WriteLn;
                  WriteLn('Cannot open ', ArcName);
                end;
                LongFindNext(Entry);
              until (DOSError <> 0) or EscPressed;
              LongFindClose(Entry);
            end;
          end;
        end;
      else
        WriteLn('Unknown command');
      end;
    end;
  end;
end.
