<?xml version="1.0"?> 
<!-- use this with an xslt processor to produce html  -->
<!-- e.g. $ java org.apache.xalan.xslt.Process \ -->
<!--                 -IN data.xml \ -->
<!--                 -XSL d64tohtml.xsl \ -->
<!--                 -out data.html -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="xml" indent="yes"/>

<xsl:template match="d64database">
<HTML>
  <HEAD>
    <TITLE>
      d64 html database.
    </TITLE>
  </HEAD>
  <BODY BGCOLOR="#000080" TEXT="#add8e6" LINK="#ffff00" VLINK="#9acd32">

  <H1>
  <xsl:text> d64 html database </xsl:text>
  </H1>

  <DL>
  <DT>
  <xsl:text> original database created at </xsl:text>
  <xsl:value-of select="@date" />
  </DT>
  </DL>

  <DL>
  <DT>
  <xsl:text> original database created by application </xsl:text>
  <xsl:value-of select="@creator" />
  </DT>
  </DL>

  <DL>
  <DT>
  <xsl:text> original database created by user </xsl:text>
  <xsl:value-of select="@user" />
  </DT>
  </DL>

  <DL>
  <DT>
  <xsl:text> original database created on machine </xsl:text>
  <xsl:value-of select="@machine" />
  </DT>
  </DL>

  <DL>
  <DT>
  <xsl:text> original database created from directory </xsl:text>
  <xsl:value-of select="@directory" />
  </DT>
  </DL>

  <H1>
  <xsl:text> Disks in database </xsl:text>
  </H1>

	<xsl:for-each select="disk/header">
	  <DL>
	  <DT>
	  <H3>
		<xsl:element name="a">
		<xsl:attribute name="href">
		  <xsl:text>#number</xsl:text>
		  <xsl:number value="position()" format="1"/>
		</xsl:attribute>
		<xsl:attribute name="name">
		  <xsl:text>index</xsl:text>
		  <xsl:number value="position()" format="1"/>
		</xsl:attribute>
		  Disk
		  <xsl:text> </xsl:text>
		  <xsl:number value="position()" format="1. "/>
		  <xsl:text> : </xsl:text>
		  <xsl:value-of select="@preamble" />
		  <xsl:text> </xsl:text>
		  <xsl:value-of select="@title" />
		  <xsl:text> </xsl:text>
		  <xsl:value-of select="@extension" />
		  <xsl:text> </xsl:text>
		</xsl:element>
	  </H3>
	  </DT>
	  </DL>
		<xsl:apply-templates/>
	</xsl:for-each>

  <H1>
  <xsl:text> Detailed disk contents </xsl:text>
  </H1>

	<DL>
	<xsl:for-each select="disk">
	  <DT>
	  <TABLE BORDER="3" FRAME="box" RULES="all" SUMMARY="Contents of disk">
	    <THEAD>
	    <TR>
	    <TD ALIGN="center" COLSPAN="4">
	    <H3>
		  <xsl:text> </xsl:text>
		  <xsl:number value="position()" format="1. "/>
		  <xsl:text> : </xsl:text>
			<xsl:for-each select="header">
			  <xsl:value-of select="@title" />
			</xsl:for-each>
		  <xsl:text> : </xsl:text>
		  Source
		  <xsl:value-of select="@file" />
		  Extension
		  <xsl:value-of select="@extension" />
		  Type
		  <xsl:value-of select="@type" />
	    </H3>
	    </TD>
	    </TR>

	    <TR>
	    <TD ALIGN="center" COLSPAN="1">
		  <xsl:text> Blocks free : </xsl:text>
		  <xsl:for-each select="tail">
		    <xsl:value-of select="@freeblocks" />
		  </xsl:for-each>
	    </TD>
	    <TD ALIGN="center" COLSPAN="3">
		  <xsl:for-each select="errorchannel">
		    <xsl:value-of select="@number" />
		    <xsl:text>, </xsl:text>
		    <xsl:value-of select="@message" />
		    <xsl:text>, </xsl:text>
		    <xsl:value-of select="@track" />
		    <xsl:text>, </xsl:text>
		    <xsl:value-of select="@sector" />
		  </xsl:for-each>
	    </TD>
	    </TR>
	    </THEAD>
		<xsl:element name="a">
		<xsl:attribute name="name">
		  <xsl:text>number</xsl:text>
		  <xsl:number value="position()" format="1"/>
		</xsl:attribute>
		<xsl:attribute name="href">
		  <xsl:text>#index</xsl:text>
		  <xsl:number value="position()" format="1"/>
		</xsl:attribute>
		  <xsl:text> Top </xsl:text>
		</xsl:element>
		<TBODY>
		  <TR>
		    <TH ALIGN="center">
		    <xsl:text> Blocks </xsl:text>
		    </TH>
		    <TH ALIGN="center">
		    <xsl:text> Name </xsl:text>
		    </TH>
		    <TH ALIGN="center">
		    <xsl:text> Type </xsl:text>
		    </TH>
		    <TH ALIGN="center">
		    <xsl:text> Comment </xsl:text>
		    </TH>
		  </TR>
		  <xsl:for-each select="file">
		    <TR>
		    <TD ALIGN="center">
		    <xsl:value-of select="@blocks" />
		    </TD>
		    <TD ALIGN="center">
		    <xsl:value-of select="@name" />
		    </TD>
		    <TD ALIGN="center">
		    <xsl:value-of select="@type" />
		    </TD>
		    <TD ALIGN="center">
		    <xsl:value-of select="@comment" />
		    </TD>
		    </TR>
		  </xsl:for-each>
		  <xsl:apply-templates/>
		</TBODY>
	  </TABLE>
	  </DT>
	</xsl:for-each>
	</DL>
</BODY>
</HTML>
</xsl:template>

</xsl:stylesheet>
