/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Camera;
import com.threed.jpct.Config;
import com.threed.jpct.FrameBuffer;
import com.threed.jpct.Logger;
import com.threed.jpct.Object3D;
import com.threed.jpct.Object3DList;
import com.threed.jpct.Portals;
import com.threed.jpct.threading.WorkLoad;
import com.threed.jpct.threading.Worker;
import com.threed.jpct.util.Overlay;
import java.util.Hashtable;

public final class WorldProcessor {
    private int granularity = 1;
    private Worker worker = null;
    private MyWorkLoad[] workLoads = null;
    private Hashtable thread2Arrays = new Hashtable();

    public WorldProcessor(int n) {
        this(n, 2);
    }

    public WorldProcessor(int n, int n2) {
        n2 = Math.max(1, n2);
        if (n > 1) {
            this.worker = new Worker(n);
        } else {
            n2 = 1;
        }
        this.granularity = n2 * n;
        Logger.log("New WorldProcessor created using " + n + " thread(s) and granularity of " + n2 + "!");
    }

    synchronized void dispose() {
        if (this.worker != null) {
            this.worker.dispose();
            this.workLoads = null;
            this.worker = null;
            this.thread2Arrays = null;
        }
    }

    public void finalize() {
        this.dispose();
    }

    void createWSNormals() {
        float[][] fArray = (float[][])this.thread2Arrays.get(Thread.currentThread());
        if (fArray != null && fArray[6] == null) {
            int n = fArray[0].length;
            for (int i = 6; i < 9; ++i) {
                fArray[i] = new float[n];
            }
        }
    }

    float[][] getArrays(int n) {
        Object object = (float[][])this.thread2Arrays.get(Thread.currentThread());
        if (object == null || object[0].length < n) {
            if (object == null) {
                object = new float[9][];
                Logger.log("Creating new world processor buffer for thread " + Thread.currentThread().getName());
            } else {
                Logger.log("Enlarging world processor buffer (" + object[0].length + "->" + n + ") for thread " + Thread.currentThread().getName(), 3);
            }
            int n2 = 6;
            if (object != null && object[6] != null) {
                n2 = 9;
            }
            for (int i = 0; i < n2; ++i) {
                object[i] = new float[n];
            }
            this.thread2Arrays.put(Thread.currentThread(), object);
        }
        return object;
    }

    boolean process(FrameBuffer frameBuffer, Object3DList object3DList, Portals portals, Camera camera, boolean bl, float f, float f2, boolean bl2, boolean bl3, int n, int n2, float f3, float f4, boolean bl4) {
        if (this.worker == null) {
            bl3 = this.processInternal(frameBuffer, object3DList, portals, camera, bl, f, f2, bl2, bl3, n, n2, f3, f4, bl4);
        } else {
            int n3;
            int n4;
            if (this.workLoads == null) {
                this.workLoads = new MyWorkLoad[this.granularity];
                for (n4 = 0; n4 < this.granularity; ++n4) {
                    this.workLoads[n4] = new MyWorkLoad();
                }
            }
            n4 = (n2 - n) / this.granularity;
            int n5 = n;
            for (n3 = 0; n3 < this.granularity; ++n3) {
                int n6 = n5 + n4;
                if (n6 > n2) {
                    n6 = n2;
                } else if (n3 == this.granularity - 1) {
                    n6 = n2;
                }
                MyWorkLoad myWorkLoad = this.workLoads[n3];
                myWorkLoad.setRange(frameBuffer, object3DList, portals, camera, bl, f, f2, bl2, bl3, n5, n6, f3, f4, bl4);
                this.worker.add(myWorkLoad);
                n5 = n6;
            }
            this.worker.waitForAll();
            for (n3 = 0; n3 < this.granularity; ++n3) {
                bl3 |= this.workLoads[n3].getResult();
            }
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processInternal(FrameBuffer frameBuffer, Object3DList object3DList, Portals portals, Camera camera, boolean bl, float f, float f2, boolean bl2, boolean bl3, int n, int n2, float f3, float f4, boolean bl4) {
        for (int i = n; i < n2; ++i) {
            Object object;
            Object3D object3D = object3DList.elementAt(i);
            if (object3D == null) {
                Logger.log("Null object in queue...?", 0);
                continue;
            }
            object3D.object3DRendered = false;
            if (bl4 && object3D.compiled != null && !object3D.isCompiled() && object3D.getMesh().anzTri > 0) {
                object = this;
                synchronized (object) {
                    if (object3D.shareWith != null) {
                        Object3D object3D2 = object3D.shareWith;
                        if (object3D2.compiled == null) {
                            Logger.log("Parent object hasn't been compiled...trying to compile it for you!", 1);
                            object3D2.compile();
                        }
                        if (object3D2.compiled != null && !object3D2.isCompiled() && object3D2.getMesh().anzTri > 0) {
                            Logger.log("Compiling source object...", 2);
                            frameBuffer.versionHelper.compile(object3D2, frameBuffer.glRend);
                        }
                    }
                    frameBuffer.versionHelper.compile(object3D, frameBuffer.glRend);
                    Config.glVertexArrays = true;
                }
            }
            if ((object = object3D.getUserObject()) != null && object instanceof Overlay) {
                ((Overlay)object).update(frameBuffer);
            }
            if (!object3D.isVisible) continue;
            int n3 = !object3D.oneSectorOnly && object3D.sector != null ? object3D.sector[0] : object3D.singleSectorNumber;
            if (object3D.hasPortals) {
                object3D.transformVertices(frameBuffer);
                if (!Config.doPortalHsr) continue;
                portals.processPortals(f, f2, f3, f4);
                continue;
            }
            if (Config.doPortalHsr && !object3D.dynSectorDetect && object3D.oneSectorOnly && !portals.isSectorVisible(object3D, n3)) continue;
            boolean bl5 = false;
            bl5 = object3D.transformVertices(frameBuffer);
            if (bl5 || object3D.objMesh.anzTri <= 0 || !object3D.someSectorVisible && object3D.dynSectorDetect) continue;
            if (!(!object3D.isTrans || object3D.isEnvmapped && object3D.isBumpmapped)) {
                bl3 = true;
            }
            object3D.render(bl, f, f2, f3, f4, camera.divx, camera.divy, bl2);
        }
        return bl3;
    }

    private class MyWorkLoad
    implements WorkLoad {
        private int start = 0;
        private int end = 0;
        private FrameBuffer buffer;
        private Object3DList objectList;
        private Portals portals;
        private Camera camera;
        private boolean software;
        private float mx;
        private float my;
        private boolean mayOptimize;
        private boolean hasToSort;
        private float camScaleX;
        private float camScaleY;
        private boolean gl;

        public void setRange(FrameBuffer frameBuffer, Object3DList object3DList, Portals portals, Camera camera, boolean bl, float f, float f2, boolean bl2, boolean bl3, int n, int n2, float f3, float f4, boolean bl4) {
            this.start = n;
            this.end = n2;
            this.buffer = frameBuffer;
            this.objectList = object3DList;
            this.portals = portals;
            this.camera = camera;
            this.software = bl;
            this.mx = f;
            this.my = f2;
            this.mayOptimize = bl2;
            this.hasToSort = bl3;
            this.camScaleY = f4;
            this.camScaleX = f3;
            this.gl = bl4;
        }

        public boolean getResult() {
            return this.hasToSort;
        }

        public void doWork() {
            this.hasToSort = WorldProcessor.this.processInternal(this.buffer, this.objectList, this.portals, this.camera, this.software, this.mx, this.my, this.mayOptimize, this.hasToSort, this.start, this.end, this.camScaleX, this.camScaleY, this.gl);
        }

        public void error(Exception exception) {
            exception.printStackTrace();
            Logger.log(exception, 0);
        }

        public void done() {
        }
    }
}

