/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Config;
import com.threed.jpct.GenericContainer;
import com.threed.jpct.IVertexController;
import com.threed.jpct.IntegerC;
import com.threed.jpct.Logger;
import com.threed.jpct.Matrix;
import com.threed.jpct.Object3D;
import com.threed.jpct.SimpleVector;
import com.threed.jpct.Vectors;
import com.threed.jpct.World;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public final class Mesh
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final boolean COMPRESS = true;
    public static final boolean DONT_COMPRESS = false;
    public static final int SERIALIZE_ALL = 0;
    public static final int SERIALIZE_VERTICES_ONLY = 1;
    public static final int SERIALIZE_LOW_PRECISION = 2;
    private int serializeMethod = 0;
    private IVertexController myController = null;
    boolean normalsCalculated;
    boolean tangentsCalculated = false;
    int anzVectors;
    int maxVectors;
    int anzCoords;
    int anzTri;
    int[][] points;
    float[] xOrg;
    float[] yOrg;
    float[] zOrg;
    float[] nxOrg;
    float[] nyOrg;
    float[] nzOrg;
    int[] coords;
    int obbStart;
    int obbEnd;
    short[] sxOrg = null;
    short[] syOrg = null;
    short[] szOrg = null;
    short[] snxOrg = null;
    short[] snyOrg = null;
    short[] snzOrg = null;
    float[][] tangentVectors;

    Mesh(int n) {
        this.maxVectors = n;
        this.anzVectors = 0;
        this.anzCoords = 0;
        this.anzTri = 0;
        this.obbStart = 0;
        this.obbEnd = 0;
        this.normalsCalculated = false;
        this.points = new int[this.maxVectors / 3 + 1][3];
        this.coords = new int[this.maxVectors];
        this.xOrg = new float[this.maxVectors];
        this.yOrg = new float[this.maxVectors];
        this.zOrg = new float[this.maxVectors];
        this.nxOrg = new float[this.maxVectors];
        this.nyOrg = new float[this.maxVectors];
        this.nzOrg = new float[this.maxVectors];
    }

    public boolean setVertexController(IVertexController iVertexController, boolean bl) {
        if (this.myController != null) {
            this.myController.destroy();
        }
        if (iVertexController.init(this, bl)) {
            this.myController = iVertexController;
            return true;
        }
        return false;
    }

    public void applyVertexController() {
        if (this.myController != null) {
            this.myController.apply();
            this.myController.updateMesh();
        } else {
            Logger.log("No controller has been assigned to this mesh", 1);
        }
    }

    public void removeVertexController() {
        if (this.myController != null) {
            this.myController.destroy();
            this.myController = null;
        }
    }

    public void strip() {
        this.points = null;
        this.coords = null;
    }

    void strongStrip(World world, Object3D object3D) {
        if (world == null) {
            return;
        }
        int n = world.objectList.size();
        for (int i = 0; i < n; ++i) {
            Object3D object3D2 = world.objectList.elementAt(i);
            if (object3D2 == object3D || object3D2.objMesh != this || object3D2.isCompiled() && !object3D2.dynamic) continue;
            return;
        }
        this.nxOrg = null;
        this.nyOrg = null;
        this.nzOrg = null;
        this.sxOrg = null;
        this.syOrg = null;
        this.szOrg = null;
        this.snxOrg = null;
        this.snyOrg = null;
        this.snzOrg = null;
    }

    public void compress() {
        int n;
        int n2 = this.anzCoords;
        int n3 = this.anzVectors + 8;
        if (this.obbEnd == 0) {
            n2 += 8;
        }
        float[] fArray = new float[n2];
        float[] fArray2 = new float[n2];
        float[] fArray3 = new float[n2];
        float[] fArray4 = new float[n2];
        float[] fArray5 = new float[n2];
        float[] fArray6 = new float[n2];
        for (n = 0; n < this.anzCoords; ++n) {
            fArray[n] = this.xOrg[n];
            fArray2[n] = this.yOrg[n];
            fArray3[n] = this.zOrg[n];
            fArray4[n] = this.nxOrg[n];
            fArray5[n] = this.nyOrg[n];
            fArray6[n] = this.nzOrg[n];
        }
        this.xOrg = fArray;
        this.yOrg = fArray2;
        this.zOrg = fArray3;
        this.nxOrg = fArray4;
        this.nyOrg = fArray5;
        this.nzOrg = fArray6;
        if (n3 < this.maxVectors) {
            int n4;
            n = n3 / 3 + 1;
            int[][] nArray = new int[n][3];
            int[] nArray2 = new int[n3];
            for (n4 = 0; n4 < n3; ++n4) {
                nArray2[n4] = this.coords[n4];
            }
            for (n4 = 0; n4 < n; ++n4) {
                nArray[n4] = this.points[n4];
            }
            this.coords = nArray2;
            this.points = nArray;
            this.maxVectors = n3;
        }
    }

    public Mesh cloneMesh(boolean bl) {
        int n;
        Mesh mesh = new Mesh(this.maxVectors);
        mesh.anzCoords = this.anzCoords;
        mesh.anzVectors = this.anzVectors;
        mesh.anzTri = this.anzTri;
        mesh.obbStart = this.obbStart;
        mesh.obbEnd = this.obbEnd;
        for (n = 0; n < this.maxVectors; ++n) {
            mesh.coords[n] = this.coords[n];
            if (n >= this.anzCoords) continue;
            mesh.xOrg[n] = this.xOrg[n];
            mesh.yOrg[n] = this.yOrg[n];
            mesh.zOrg[n] = this.zOrg[n];
            mesh.nxOrg[n] = this.nxOrg[n];
            mesh.nyOrg[n] = this.nyOrg[n];
            mesh.nzOrg[n] = this.nzOrg[n];
        }
        n = this.maxVectors / 3 + 1;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 3; ++j) {
                mesh.points[i][j] = this.points[i][j];
            }
        }
        if (bl) {
            mesh.compress();
        }
        return mesh;
    }

    public int getVertexCount() {
        return this.anzVectors;
    }

    public int getUniqueVertexCount() {
        return this.anzCoords;
    }

    public int getTriangleCount() {
        return this.anzTri;
    }

    public float[] getBoundingBox() {
        return this.calcBoundingBox();
    }

    void translateMesh(Matrix matrix, Matrix matrix2) {
        int n = 0;
        while (n < this.anzCoords) {
            int n2 = n;
            this.zOrg[n2] = this.zOrg[n2] + (matrix.mat[3][2] + matrix2.mat[3][2]);
            int n3 = n;
            this.xOrg[n3] = this.xOrg[n3] + (matrix.mat[3][0] + matrix2.mat[3][0]);
            int n4 = n++;
            this.yOrg[n4] = this.yOrg[n4] + (matrix.mat[3][1] + matrix2.mat[3][1]);
        }
    }

    final float getLargestCoveredDistance() {
        float f = -1.0f;
        for (int i = 0; i < this.anzTri; ++i) {
            int n = this.coords[this.points[i][0]];
            int n2 = this.coords[this.points[i][1]];
            int n3 = this.coords[this.points[i][2]];
            float f2 = this.xOrg[n];
            float f3 = this.yOrg[n];
            float f4 = this.zOrg[n];
            float f5 = this.xOrg[n2];
            float f6 = this.yOrg[n2];
            float f7 = this.zOrg[n2];
            float f8 = this.xOrg[n3];
            float f9 = this.yOrg[n3];
            float f10 = this.zOrg[n3];
            float f11 = Math.abs(f2 - f5);
            float f12 = Math.abs(f5 - f8);
            float f13 = Math.abs(f2 - f8);
            float f14 = Math.abs(f3 - f6);
            float f15 = Math.abs(f6 - f9);
            float f16 = Math.abs(f3 - f9);
            float f17 = Math.abs(f4 - f7);
            float f18 = Math.abs(f7 - f10);
            float f19 = Math.abs(f4 - f10);
            if (f11 > f) {
                f = f11;
            }
            if (f12 > f) {
                f = f12;
            }
            if (f13 > f) {
                f = f13;
            }
            if (f14 > f) {
                f = f14;
            }
            if (f15 > f) {
                f = f15;
            }
            if (f16 > f) {
                f = f16;
            }
            if (f17 > f) {
                f = f17;
            }
            if (f18 > f) {
                f = f18;
            }
            if (!(f19 > f)) continue;
            f = f19;
        }
        return f;
    }

    synchronized void calcNormals() {
        if (this.anzTri >= Config.optimizeNormalCalcTH) {
            this.calcNormalsFast();
        } else {
            this.calcNormalsSlow();
        }
        this.normalsCalculated = true;
    }

    final Vector[] calcNormalsMD2(Vector[] vectorArray) {
        Vector[] vectorArray2 = null;
        if (vectorArray == null) {
            vectorArray2 = new Vector[this.anzCoords];
        }
        for (int i = 0; i < this.anzCoords; ++i) {
            float f;
            float f2;
            float f3;
            float f4;
            float f5;
            float f6;
            float f7;
            float f8;
            int n;
            int n2;
            int n3;
            int n4;
            if (vectorArray == null) {
                vectorArray2[i] = new Vector();
            }
            int n5 = 0;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            float f9 = this.xOrg[i];
            float f10 = this.yOrg[i];
            float f11 = this.zOrg[i];
            if (vectorArray == null) {
                for (n4 = 0; n4 < this.anzTri; ++n4) {
                    n3 = this.coords[this.points[n4][0]];
                    n2 = this.coords[this.points[n4][1]];
                    n = this.coords[this.points[n4][2]];
                    float f12 = this.xOrg[n];
                    f8 = this.yOrg[n];
                    f7 = this.zOrg[n];
                    f6 = this.xOrg[n3];
                    f5 = this.yOrg[n3];
                    f4 = this.zOrg[n3];
                    f3 = this.xOrg[n2];
                    f2 = this.yOrg[n2];
                    f = this.zOrg[n2];
                    if (!(f9 == f12 && f10 == f8 && f11 == f7 || f9 == f3 && f10 == f2 && f11 == f) && (f9 != f6 || f10 != f5 || f11 != f4)) continue;
                    vectorArray2[i].addElement(IntegerC.valueOf(n4));
                    ++n5;
                    double d4 = f12;
                    double d5 = f8;
                    double d6 = f7;
                    double d7 = (double)f6 - d4;
                    double d8 = (double)f5 - d5;
                    double d9 = (double)f4 - d6;
                    double d10 = (double)f3 - d4;
                    double d11 = (double)f2 - d5;
                    double d12 = (double)f - d6;
                    d += d8 * d12 - d9 * d11;
                    d2 += d9 * d10 - d7 * d12;
                    d3 += d7 * d11 - d8 * d10;
                }
            } else {
                for (n4 = 0; n4 < vectorArray[i].size(); ++n4) {
                    n3 = (Integer)vectorArray[i].elementAt(n4);
                    n2 = this.coords[this.points[n3][0]];
                    n = this.coords[this.points[n3][1]];
                    int n6 = this.coords[this.points[n3][2]];
                    f8 = this.xOrg[n6];
                    f7 = this.yOrg[n6];
                    f6 = this.zOrg[n6];
                    f5 = this.xOrg[n2];
                    f4 = this.yOrg[n2];
                    f3 = this.zOrg[n2];
                    f2 = this.xOrg[n];
                    f = this.yOrg[n];
                    float f13 = this.zOrg[n];
                    if (!(f9 == f8 && f10 == f7 && f11 == f6 || f9 == f2 && f10 == f && f11 == f13) && (f9 != f5 || f10 != f4 || f11 != f3)) continue;
                    ++n5;
                    double d13 = f8;
                    double d14 = f7;
                    double d15 = f6;
                    double d16 = (double)f5 - d13;
                    double d17 = (double)f4 - d14;
                    double d18 = (double)f3 - d15;
                    double d19 = (double)f2 - d13;
                    double d20 = (double)f - d14;
                    double d21 = (double)f13 - d15;
                    d += d17 * d21 - d18 * d20;
                    d2 += d18 * d19 - d16 * d21;
                    d3 += d16 * d20 - d17 * d19;
                }
            }
            if (n5 == 0) continue;
            double d22 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
            if (d22 == 0.0) {
                d22 = 1.0E-12f;
            }
            this.nxOrg[i] = (float)(d / d22);
            this.nyOrg[i] = (float)(d2 / d22);
            this.nzOrg[i] = (float)(d3 / d22);
        }
        if (vectorArray == null) {
            return vectorArray2;
        }
        return vectorArray;
    }

    SimpleVector calcCenter() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n = 0;
        for (int i = 0; i < this.anzTri; ++i) {
            int[] nArray = this.points[i];
            for (int j = 0; j < 3; ++j) {
                int n2 = this.coords[nArray[j]];
                f += this.xOrg[n2];
                f3 += this.yOrg[n2];
                f2 += this.zOrg[n2];
                ++n;
            }
        }
        if (n != 0) {
            float f4 = n;
            return new SimpleVector(f / f4, f3 / f4, f2 / f4);
        }
        return new SimpleVector(0.0f, 0.0f, 0.0f);
    }

    void rotateMesh(Matrix matrix, float f, float f2, float f3, float f4) {
        float f5 = matrix.mat[0][0];
        float f6 = matrix.mat[1][0];
        float f7 = matrix.mat[2][0];
        float f8 = matrix.mat[0][1];
        float f9 = matrix.mat[1][1];
        float f10 = matrix.mat[2][1];
        float f11 = matrix.mat[0][2];
        float f12 = matrix.mat[1][2];
        float f13 = matrix.mat[2][2];
        float f14 = f;
        float f15 = f2;
        float f16 = f3;
        for (int i = 0; i < this.anzCoords; ++i) {
            float f17 = this.zOrg[i] - f16;
            float f18 = this.xOrg[i] - f14;
            float f19 = this.yOrg[i] - f15;
            float f20 = f18 * f5 + f19 * f6 + f17 * f7 + f14;
            float f21 = f18 * f8 + f19 * f9 + f17 * f10 + f15;
            float f22 = f18 * f11 + f19 * f12 + f17 * f13 + f16;
            this.xOrg[i] = f20;
            this.yOrg[i] = f21;
            this.zOrg[i] = f22;
            f18 = this.nxOrg[i];
            f19 = this.nyOrg[i];
            f17 = this.nzOrg[i];
            f20 = f18 * f5 + f19 * f6 + f17 * f7;
            f21 = f18 * f8 + f19 * f9 + f17 * f10;
            f22 = f18 * f11 + f19 * f12 + f17 * f13;
            this.nxOrg[i] = f20 / f4;
            this.nyOrg[i] = f21 / f4;
            this.nzOrg[i] = f22 / f4;
        }
    }

    synchronized float[] calcBoundingBox() {
        float[] fArray = new float[6];
        float f = 1.0E11f;
        float f2 = -1.0E11f;
        float f3 = 1.0E11f;
        float f4 = -1.0E11f;
        float f5 = 1.0E11f;
        float f6 = -1.0E11f;
        int n = this.anzCoords;
        if (this.obbStart != 0) {
            n = this.obbStart;
        }
        for (int i = 0; i < n; ++i) {
            float f7 = this.xOrg[i];
            float f8 = this.yOrg[i];
            float f9 = this.zOrg[i];
            if (f7 < f) {
                f = f7;
            }
            if (f7 > f2) {
                f2 = f7;
            }
            if (f8 < f3) {
                f3 = f8;
            }
            if (f8 > f4) {
                f4 = f8;
            }
            if (f9 < f5) {
                f5 = f9;
            }
            if (!(f9 > f6)) continue;
            f6 = f9;
        }
        fArray[0] = f;
        fArray[1] = f2;
        fArray[2] = f3;
        fArray[3] = f4;
        fArray[4] = f5;
        fArray[5] = f6;
        return fArray;
    }

    private final void calcNormalsSlow() {
        for (int i = 0; i < this.anzCoords; ++i) {
            int n = 0;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = this.xOrg[i];
            float f5 = this.yOrg[i];
            float f6 = this.zOrg[i];
            for (int j = 0; j < this.anzTri; ++j) {
                int n2 = this.coords[this.points[j][0]];
                int n3 = this.coords[this.points[j][1]];
                int n4 = this.coords[this.points[j][2]];
                float f7 = this.xOrg[n4];
                float f8 = this.yOrg[n4];
                float f9 = this.zOrg[n4];
                float f10 = this.xOrg[n2];
                float f11 = this.yOrg[n2];
                float f12 = this.zOrg[n2];
                float f13 = this.xOrg[n3];
                float f14 = this.yOrg[n3];
                float f15 = this.zOrg[n3];
                if (!(f4 == f7 && f5 == f8 && f6 == f9 || f4 == f13 && f5 == f14 && f6 == f15) && (f4 != f10 || f5 != f11 || f6 != f12)) continue;
                ++n;
                float f16 = f10 - f7;
                float f17 = f11 - f8;
                float f18 = f12 - f9;
                float f19 = f13 - f7;
                float f20 = f14 - f8;
                float f21 = f15 - f9;
                f += f17 * f21 - f18 * f20;
                f2 += f18 * f19 - f16 * f21;
                f3 += f16 * f20 - f17 * f19;
            }
            if (n == 0) continue;
            float f22 = (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
            if (f22 == 0.0f) {
                f22 = 1.0E-12f;
            }
            this.nxOrg[i] = f / f22;
            this.nyOrg[i] = f2 / f22;
            this.nzOrg[i] = f3 / f22;
        }
    }

    void calculateTangentVectors(Vectors vectors) {
        int n;
        Object object;
        int n2;
        long l = System.currentTimeMillis();
        if (this.tangentVectors == null || this.tangentVectors.length != this.anzCoords) {
            this.tangentVectors = new float[this.anzCoords][];
        }
        SimpleVector[] simpleVectorArray = new SimpleVector[this.anzCoords];
        SimpleVector[] simpleVectorArray2 = new SimpleVector[this.anzCoords];
        int n3 = simpleVectorArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            simpleVectorArray[n2] = new SimpleVector(0.0f, 0.0f, 0.0f);
            simpleVectorArray2[n2] = new SimpleVector(0.0f, 0.0f, 0.0f);
        }
        n3 = this.anzTri;
        for (n2 = 0; n2 < n3; ++n2) {
            float f;
            object = this.points[n2];
            int n4 = this.coords[object[0]];
            n = this.coords[object[1]];
            int n5 = this.coords[object[2]];
            float f2 = this.xOrg[n4];
            float f3 = this.yOrg[n4];
            float f4 = this.zOrg[n4];
            float f5 = this.xOrg[n];
            float f6 = this.yOrg[n];
            float f7 = this.zOrg[n];
            float f8 = this.xOrg[n5];
            float f9 = this.yOrg[n5];
            float f10 = this.zOrg[n5];
            float f11 = vectors.nuOrg[object[0]];
            float f12 = vectors.nvOrg[object[0]];
            float f13 = vectors.nuOrg[object[1]];
            float f14 = vectors.nvOrg[object[1]];
            float f15 = vectors.nuOrg[object[2]];
            float f16 = vectors.nvOrg[object[2]];
            float f17 = f5 - f2;
            float f18 = f8 - f2;
            float f19 = f6 - f3;
            float f20 = f9 - f3;
            float f21 = f7 - f4;
            float f22 = f10 - f4;
            float f23 = f13 - f11;
            float f24 = f15 - f11;
            float f25 = f14 - f12;
            float f26 = f16 - f12;
            if (f23 == 0.0f) {
                f23 = 1.0E-5f;
            }
            if (f24 == 0.0f) {
                f24 = 1.0E-5f;
            }
            if (f25 == 0.0f) {
                f25 = 1.0E-5f;
            }
            if (f26 == 0.0f) {
                f26 = 1.0E-5f;
            }
            if ((f = f23 * f26 - f24 * f25) == 0.0f) {
                f = 1.0E-5f;
            }
            float f27 = 1.0f / f;
            SimpleVector simpleVector = new SimpleVector((f26 * f17 - f25 * f18) * f27, (f26 * f19 - f25 * f20) * f27, (f26 * f21 - f25 * f22) * f27);
            SimpleVector simpleVector2 = new SimpleVector((f23 * f18 - f24 * f17) * f27, (f23 * f20 - f24 * f19) * f27, (f23 * f22 - f24 * f21) * f27);
            simpleVectorArray[n4].add(simpleVector);
            simpleVectorArray[n].add(simpleVector);
            simpleVectorArray[n5].add(simpleVector);
            simpleVectorArray2[n4].add(simpleVector2);
            simpleVectorArray2[n].add(simpleVector2);
            simpleVectorArray2[n5].add(simpleVector2);
        }
        SimpleVector simpleVector = new SimpleVector();
        object = new SimpleVector();
        SimpleVector simpleVector3 = new SimpleVector();
        n3 = this.anzCoords;
        for (n = 0; n < n3; ++n) {
            simpleVector.set(this.nxOrg[n], this.nyOrg[n], this.nzOrg[n]);
            simpleVector3.set(simpleVectorArray[n]);
            ((SimpleVector)object).set(simpleVector);
            float f = simpleVector.calcDot(simpleVector3);
            ((SimpleVector)object).scalarMul(f);
            simpleVector3.sub((SimpleVector)object);
            simpleVector3 = simpleVector3.normalize();
            float[] fArray = this.tangentVectors[n];
            if (fArray == null) {
                fArray = new float[4];
                this.tangentVectors[n] = fArray;
            }
            fArray[0] = simpleVector3.x;
            fArray[1] = simpleVector3.y;
            fArray[2] = simpleVector3.z;
            SimpleVector simpleVector4 = simpleVector.calcCross(simpleVector3);
            f = simpleVector4.calcDot(simpleVectorArray2[n]);
            fArray[3] = f < 0.0f ? -1.0f : 1.0f;
        }
        this.tangentsCalculated = true;
        Logger.log("Tangent vectors calculated in " + (System.currentTimeMillis() - l) + "ms!");
    }

    private final void calcNormalsFast() {
        Vector<Integer> vector;
        float f;
        float f2;
        float f3;
        int n;
        Hashtable<GenericContainer, Vector<Integer>> hashtable = new Hashtable<GenericContainer, Vector<Integer>>();
        for (n = 0; n < this.anzTri; ++n) {
            int[] nArray = this.points[n];
            for (int i = 0; i < 3; ++i) {
                int n2 = this.coords[nArray[i]];
                f3 = this.xOrg[n2];
                f2 = this.yOrg[n2];
                f = this.zOrg[n2];
                GenericContainer genericContainer = new GenericContainer(3);
                genericContainer.add(f3);
                genericContainer.add(f2);
                genericContainer.add(f);
                vector = (Vector)hashtable.get(genericContainer);
                if (vector == null) {
                    vector = new Vector<Integer>(4);
                    hashtable.put(genericContainer, vector);
                }
                vector.addElement(IntegerC.valueOf(n));
            }
        }
        for (n = 0; n < this.anzCoords; ++n) {
            int n3 = 0;
            float f4 = 0.0f;
            float f5 = 0.0f;
            f3 = 0.0f;
            f2 = this.xOrg[n];
            f = this.yOrg[n];
            float f6 = this.zOrg[n];
            vector = new GenericContainer(3);
            ((GenericContainer)((Object)vector)).add(f2);
            ((GenericContainer)((Object)vector)).add(f);
            ((GenericContainer)((Object)vector)).add(f6);
            Object v = hashtable.get(vector);
            if (v != null) {
                Vector vector2 = (Vector)v;
                for (int i = 0; i < vector2.size(); ++i) {
                    int n4 = (Integer)vector2.elementAt(i);
                    int n5 = this.coords[this.points[n4][0]];
                    int n6 = this.coords[this.points[n4][1]];
                    int n7 = this.coords[this.points[n4][2]];
                    float f7 = this.xOrg[n7];
                    float f8 = this.yOrg[n7];
                    float f9 = this.zOrg[n7];
                    float f10 = this.xOrg[n5];
                    float f11 = this.yOrg[n5];
                    float f12 = this.zOrg[n5];
                    float f13 = this.xOrg[n6];
                    float f14 = this.yOrg[n6];
                    float f15 = this.zOrg[n6];
                    ++n3;
                    float f16 = f10 - f7;
                    float f17 = f11 - f8;
                    float f18 = f12 - f9;
                    float f19 = f13 - f7;
                    float f20 = f14 - f8;
                    float f21 = f15 - f9;
                    f4 += f17 * f21 - f18 * f20;
                    f5 += f18 * f19 - f16 * f21;
                    f3 += f16 * f20 - f17 * f19;
                }
            }
            if (n3 == 0) continue;
            float f22 = (float)Math.sqrt(f4 * f4 + f5 * f5 + f3 * f3);
            if (f22 == 0.0f) {
                f22 = 1.0E-12f;
            }
            this.nxOrg[n] = f4 / f22;
            this.nyOrg[n] = f5 / f22;
            this.nzOrg[n] = f3 / f22;
        }
    }

    public void setSerializeMethod(int n) {
        this.serializeMethod = n;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if ((this.serializeMethod & 2) != 0) {
            this.xOrg = this.shortToFloat(this.sxOrg);
            this.sxOrg = null;
            this.yOrg = this.shortToFloat(this.syOrg);
            this.syOrg = null;
            this.zOrg = this.shortToFloat(this.szOrg);
            this.szOrg = null;
            this.nxOrg = this.shortToFloat(this.snxOrg);
            this.snxOrg = null;
            this.nyOrg = this.shortToFloat(this.snyOrg);
            this.snyOrg = null;
            this.nzOrg = this.shortToFloat(this.snzOrg);
            this.snzOrg = null;
        }
        if ((this.serializeMethod & 1) != 0) {
            this.nxOrg = new float[this.xOrg.length];
            this.nyOrg = new float[this.yOrg.length];
            this.nzOrg = new float[this.zOrg.length];
            if (this.points != null) {
                this.calcNormals();
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        float[] fArray = this.xOrg;
        float[] fArray2 = this.yOrg;
        float[] fArray3 = this.zOrg;
        float[] fArray4 = this.nxOrg;
        float[] fArray5 = this.nyOrg;
        float[] fArray6 = this.nzOrg;
        if ((this.serializeMethod & 1) != 0) {
            this.nxOrg = null;
            this.nyOrg = null;
            this.nzOrg = null;
        }
        if ((this.serializeMethod & 2) != 0) {
            this.sxOrg = this.floatToShort(this.xOrg);
            this.xOrg = null;
            this.syOrg = this.floatToShort(this.yOrg);
            this.yOrg = null;
            this.szOrg = this.floatToShort(this.zOrg);
            this.zOrg = null;
            this.snxOrg = this.floatToShort(this.nxOrg);
            this.nxOrg = null;
            this.snyOrg = this.floatToShort(this.nyOrg);
            this.nyOrg = null;
            this.snzOrg = this.floatToShort(this.nzOrg);
            this.nzOrg = null;
        }
        objectOutputStream.defaultWriteObject();
        this.xOrg = fArray;
        this.yOrg = fArray2;
        this.zOrg = fArray3;
        this.nxOrg = fArray4;
        this.nyOrg = fArray5;
        this.nzOrg = fArray6;
    }

    private short[] floatToShort(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        short[] sArray = new short[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            sArray[i] = (short)(Float.floatToRawIntBits(fArray[i]) >> 16);
        }
        return sArray;
    }

    private float[] shortToFloat(short[] sArray) {
        if (sArray == null) {
            return null;
        }
        float[] fArray = new float[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            fArray[i] = Float.intBitsToFloat(sArray[i] << 16);
        }
        return fArray;
    }
}

