/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import java.io.PrintStream;
import java.util.Date;
import java.util.Vector;

public class Logger {
    public static final int ERROR = 0;
    public static final int WARNING = 1;
    public static final int MESSAGE = 2;
    public static final int DEBUG = 3;
    public static final int ON_ERROR_THROW_EXCEPTION = 2;
    public static final int ON_ERROR_EXIT = 1;
    public static final int ON_ERROR_RESUME_NEXT = 0;
    public static final boolean STORE_MESSAGES = true;
    public static final boolean DISCARD_MESSAGES = false;
    public static final int LL_ONLY_ERRORS = 0;
    public static final int LL_ERRORS_AND_WARNINGS = 1;
    public static final int LL_VERBOSE = 2;
    public static final int LL_DEBUG = 3;
    private static Vector messages = new Vector();
    private static int writeCnt = 1;
    private static int mode = 0;
    private static int logLevel = 2;
    private static boolean saveLog = false;
    private static int currentCnt = 0;
    private static PrintStream myOut = System.out;
    private static final String[] HEAD = new String[]{"ERROR: ", "WARNING: ", "MESSAGE: "};

    public static void setPrintStream(PrintStream printStream) {
        myOut = printStream;
    }

    public static void setOutputBuffering(int n) {
        if (n < 1) {
            n = 1;
        }
        writeCnt = n;
        currentCnt = 0;
    }

    public static void setMessageBuffer(boolean bl) {
        saveLog = bl;
    }

    public static void setOnError(int n) {
        mode = n;
    }

    public static String[] getMessageBuffer() {
        String[] stringArray = new String[messages.size()];
        for (int i = 0; i < messages.size(); ++i) {
            stringArray[i] = (String)messages.elementAt(i);
        }
        return stringArray;
    }

    public static void setLogLevel(int n) {
        logLevel = n;
    }

    public static int getLogLevel() {
        return logLevel;
    }

    public static synchronized void log(String string, int n) {
        if (n <= logLevel) {
            try {
                if (n < 0 || n > 3) {
                    n = 3;
                }
                if (n < 2) {
                    string = "[ " + new Date() + " ] - " + HEAD[n] + string;
                }
                messages.addElement(string);
                if (++currentCnt >= writeCnt) {
                    currentCnt = 0;
                    int n2 = messages.size();
                    for (int i = n2 - writeCnt; i < n2; ++i) {
                        myOut.println((String)messages.elementAt(i));
                    }
                    if (!saveLog) {
                        messages.removeAllElements();
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("ERROR: Error while handling log messages...!");
            }
            if (n == 0) {
                if (mode == 1) {
                    System.exit(-99);
                } else if (mode == 2) {
                    throw new RuntimeException(string);
                }
            }
        }
    }

    public static void log(String string) {
        Logger.log(string, 2);
    }

    public static void log(Throwable throwable) {
        Logger.log(throwable.getMessage(), 0);
    }

    public static void log(Throwable throwable, int n) {
        Logger.log(throwable.getMessage(), n);
    }

    public static boolean isDebugEnabled() {
        return logLevel == 3;
    }
}

