/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Animation;
import com.threed.jpct.Config;
import com.threed.jpct.Logger;
import com.threed.jpct.Mesh;
import com.threed.jpct.Object3D;
import com.threed.jpct.RGBColor;
import com.threed.jpct.SimpleVector;
import com.threed.jpct.Texture;
import com.threed.jpct.TextureManager;
import com.threed.jpct.Vectors;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class DeSerializer {
    private static final int INTS = 0;
    private static final int FLOATS = 1;
    private static final int INT_INTS = 2;
    private static final int FLOAT_FLOATS = 3;
    private static final int VERSION = 2;
    private byte[] buffer = new byte[256];
    private int index = 0;
    private int length = 0;

    public void serialize(Object3D object3D, OutputStream outputStream, boolean bl) {
        this.serializeArray(new Object3D[]{object3D}, outputStream, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeArray(Object3D[] object3DArray, OutputStream outputStream, boolean bl) {
        try {
            if (!(outputStream instanceof BufferedOutputStream)) {
                outputStream = new BufferedOutputStream(outputStream);
            }
            this.write(2, outputStream);
            this.write(object3DArray.length, outputStream);
            for (int i = 0; i < object3DArray.length; ++i) {
                Object object;
                int n;
                Object3D object3D = object3DArray[i];
                Mesh mesh = object3D.getMesh();
                Vectors vectors = object3D.objVectors;
                int n2 = 0;
                if (object3D.multiMode != null) {
                    n2 = object3D.multiMode.length;
                    if (bl) {
                        n2 = object3D.maxStagesUsed - 1;
                    }
                }
                this.write(bl, outputStream);
                this.writeMesh(mesh, outputStream);
                this.write(vectors.nuOrg, outputStream);
                this.write(vectors.nvOrg, outputStream);
                this.write(vectors.uMul, n2, outputStream);
                this.write(vectors.vMul, n2, outputStream);
                this.write(vectors.alpha, outputStream);
                this.write(vectors.maxVectors, outputStream);
                this.write(vectors.hasAlpha, outputStream);
                if (!bl) {
                    this.write(vectors.sbOrg, outputStream);
                    this.write(vectors.srOrg, outputStream);
                    this.write(vectors.sgOrg, outputStream);
                    this.write(vectors.uOrg, outputStream);
                    this.write(vectors.vOrg, outputStream);
                    this.write(vectors.buOrg, outputStream);
                    this.write(vectors.bvOrg, outputStream);
                    this.write(vectors.vertexSector, outputStream);
                }
                SimpleVector simpleVector = object3D.getCenter();
                SimpleVector simpleVector2 = object3D.getRotationPivot();
                this.writeVector(simpleVector, outputStream);
                this.writeVector(simpleVector2, outputStream);
                this.write(object3D.hasBeenBuild, outputStream);
                this.write(object3D.texture, outputStream);
                this.write(object3D.multiMode, n2, outputStream);
                this.write(object3D.multiTex, n2, outputStream);
                TextureManager textureManager = TextureManager.getInstance();
                Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
                for (n = 0; n < object3D.texture.length; ++n) {
                    Integer n3 = new Integer(object3D.texture[n]);
                    if (n3 == -1) continue;
                    hashtable.put(n3, textureManager.getNameByID(n3));
                }
                if (object3D.multiTex != null) {
                    for (n = 0; n < n2; ++n) {
                        for (int j = 0; j < object3D.multiTex[n].length; ++j) {
                            object = new Integer(object3D.multiTex[n][j]);
                            if ((Integer)object == -1) continue;
                            hashtable.put(object, textureManager.getNameByID((Integer)object));
                        }
                    }
                }
                this.write(hashtable.size(), outputStream);
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    Integer n4 = (Integer)enumeration.nextElement();
                    object = (String)hashtable.get(n4);
                    this.write(n4, outputStream);
                    this.write((String)object, outputStream);
                }
                this.write(object3D.usesMultiTexturing, outputStream);
                this.write(object3D.maxStagesUsed, outputStream);
                this.writeAnimation(object3D, outputStream);
            }
        }
        catch (Exception exception) {
            Logger.log("Can't serialize object: " + exception.getMessage(), 0);
            exception.printStackTrace();
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public Object3D deserialize(InputStream inputStream) {
        return this.deserializeArray(inputStream)[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object3D[] deserializeArray(InputStream inputStream) {
        block27: {
            Object3D[] object3DArray;
            try {
                int n = this.readInt(inputStream);
                if (n > 2) {
                    Logger.log("Unsupported version: " + n, 0);
                    Object3D[] object3DArray2 = null;
                    return object3DArray2;
                }
                int n2 = 1;
                if (n >= 2) {
                    n2 = this.readInt(inputStream);
                }
                Object3D[] object3DArray3 = new Object3D[n2];
                for (int i = 0; i < n2; ++i) {
                    Object object;
                    Object object2;
                    int n3;
                    int n4;
                    Object object3;
                    boolean bl = this.readBoolean(inputStream);
                    Mesh mesh = this.readMesh(inputStream);
                    int n5 = mesh.anzTri;
                    Object3D object3D = new Object3D(n5);
                    Mesh mesh2 = object3D.getMesh();
                    Vectors vectors = object3D.objVectors;
                    mesh2.anzCoords = mesh.anzCoords;
                    mesh2.anzTri = n5;
                    mesh2.anzVectors = mesh.anzVectors;
                    mesh2.maxVectors = mesh.maxVectors;
                    mesh2.normalsCalculated = mesh.normalsCalculated;
                    mesh2.xOrg = mesh.xOrg;
                    mesh2.yOrg = mesh.yOrg;
                    mesh2.zOrg = mesh.zOrg;
                    mesh2.nxOrg = mesh.nxOrg;
                    mesh2.nyOrg = mesh.nyOrg;
                    mesh2.nzOrg = mesh.nzOrg;
                    mesh2.coords = mesh.coords;
                    mesh2.obbStart = mesh.obbStart;
                    mesh2.obbEnd = mesh.obbEnd;
                    mesh2.points = mesh.points;
                    int n6 = mesh.maxVectors;
                    vectors.xTr = new float[n6];
                    vectors.yTr = new float[n6];
                    vectors.zTr = new float[n6];
                    if (!Config.saveMemory) {
                        vectors.sb = new float[n6];
                        vectors.sg = new float[n6];
                        vectors.sr = new float[n6];
                    }
                    vectors.sx = new float[n6];
                    vectors.sy = new float[n6];
                    vectors.sz = new float[n6];
                    vectors.su = new float[n6];
                    vectors.sv = new float[n6];
                    if (!Config.saveMemory) {
                        vectors.eu = new float[n6];
                        vectors.ev = new float[n6];
                        vectors.bsu = new float[n6];
                        vectors.bsv = new float[n6];
                    }
                    vectors.nuOrg = this.readFloatArray(inputStream);
                    vectors.nvOrg = this.readFloatArray(inputStream);
                    vectors.uMul = this.readFloatFloatArray(inputStream);
                    vectors.vMul = this.readFloatFloatArray(inputStream);
                    vectors.alpha = this.readFloatArray(inputStream);
                    vectors.maxVectors = this.readInt(inputStream);
                    vectors.hasAlpha = this.readBoolean(inputStream);
                    if (!bl) {
                        vectors.sbOrg = this.readFloatArray(inputStream);
                        vectors.srOrg = this.readFloatArray(inputStream);
                        vectors.sgOrg = this.readFloatArray(inputStream);
                        vectors.uOrg = this.readFloatArray(inputStream);
                        vectors.vOrg = this.readFloatArray(inputStream);
                        vectors.buOrg = this.readFloatArray(inputStream);
                        vectors.bvOrg = this.readFloatArray(inputStream);
                        vectors.vertexSector = this.readIntArray(inputStream);
                    }
                    SimpleVector simpleVector = this.readVector(inputStream);
                    SimpleVector simpleVector2 = this.readVector(inputStream);
                    object3D.centerX = simpleVector.x;
                    object3D.centerY = simpleVector.y;
                    object3D.centerZ = simpleVector.z;
                    object3D.xRotationCenter = simpleVector2.x;
                    object3D.yRotationCenter = simpleVector2.y;
                    object3D.zRotationCenter = simpleVector2.z;
                    object3D.hasBeenBuild = this.readBoolean(inputStream);
                    object3D.texture = this.readIntArray(inputStream);
                    object3D.multiMode = this.readIntIntArray(inputStream);
                    object3D.multiTex = this.readIntIntArray(inputStream);
                    int n7 = this.readInt(inputStream);
                    Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
                    Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
                    TextureManager textureManager = TextureManager.getInstance();
                    Enumeration enumeration = textureManager.getNames();
                    while (enumeration.hasMoreElements()) {
                        object3 = (String)enumeration.nextElement();
                        n4 = textureManager.getTextureID((String)object3);
                        hashtable2.put((String)object3, new Integer(n4));
                    }
                    for (n3 = 0; n3 < n7; ++n3) {
                        n4 = this.readInt(inputStream);
                        object2 = this.readString(inputStream);
                        hashtable.put(new Integer(n4), (String)object2);
                    }
                    for (n3 = 0; n3 < object3D.texture.length; ++n3) {
                        int n8;
                        n4 = object3D.texture[n3];
                        object2 = null;
                        object = (String)hashtable.get(new Integer(n4));
                        if (object == null) continue;
                        object2 = (Integer)hashtable2.get(object);
                        object3D.texture[n3] = object2 != null ? (Integer)object2 : ((n8 = this.createTexture((String)object)) != -1 ? n8 : textureManager.getTextureID("--dummy--"));
                    }
                    if (object3D.multiTex != null) {
                        for (n3 = 0; n3 < object3D.multiTex.length; ++n3) {
                            for (n4 = 0; n4 < object3D.multiTex[n3].length; ++n4) {
                                int n9;
                                int n10 = object3D.multiTex[n3][n4];
                                object = null;
                                String string = (String)hashtable.get(new Integer(n10));
                                if (string == null) continue;
                                object = (Integer)hashtable2.get(string);
                                object3D.multiTex[n3][n4] = object != null ? (Integer)object : ((n9 = this.createTexture(string)) != -1 ? n9 : textureManager.getTextureID("--dummy--"));
                            }
                        }
                    }
                    object3D.usesMultiTexturing = this.readBoolean(inputStream);
                    object3D.maxStagesUsed = this.readInt(inputStream);
                    object3 = this.readAnimation(object3D, inputStream);
                    if (object3 != null) {
                        object3D.setAnimationSequence((Animation)object3);
                    }
                    object3DArray3[i] = object3D;
                }
                object3DArray = object3DArray3;
            }
            catch (Exception exception) {
                Logger.log("Can't deserialize object: " + exception.getMessage(), 0);
                exception.printStackTrace();
                break block27;
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            return object3DArray;
        }
        return null;
    }

    private int createTexture(String string) {
        int n = string.indexOf("__obj-Color:");
        int n2 = string.indexOf("__3ds-Color:");
        if (n != 0 && n2 != 0) {
            return -1;
        }
        String[] stringArray = string.substring(12).split("/");
        if (stringArray.length != 3) {
            return -1;
        }
        int n3 = Integer.parseInt(stringArray[0]);
        int n4 = Integer.parseInt(stringArray[1]);
        int n5 = Integer.parseInt(stringArray[2]);
        Texture texture = new Texture(8, 8, new RGBColor(n3, n4, n5));
        TextureManager.getInstance().addTexture(string, texture);
        return TextureManager.getInstance().getTextureID(string);
    }

    private void writeAnimation(Object3D object3D, OutputStream outputStream) throws Exception {
        int n;
        Animation animation = object3D.getAnimationSequence();
        if (animation == null) {
            this.write(0, outputStream);
            return;
        }
        animation.strip();
        this.write(animation.maxFrames, outputStream);
        this.write(animation.aktFrames, outputStream);
        for (n = 0; n < animation.aktFrames; ++n) {
            this.writeMesh(animation.keyFrames[n], outputStream);
        }
        this.write(animation.endFrame, outputStream);
        this.write(animation.mode, outputStream);
        this.write(animation.anzAnim, outputStream);
        this.write(animation.wrapMode, outputStream);
        this.write(animation.startFrames, outputStream);
        this.write(animation.endFrames, outputStream);
        for (n = 0; n < animation.startFrames.length; ++n) {
            this.write(animation.seqNames[n], outputStream);
        }
    }

    private Animation readAnimation(Object3D object3D, InputStream inputStream) throws Exception {
        int n;
        Animation animation = null;
        int n2 = 0;
        try {
            n2 = this.readInt(inputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n2 == 0) {
            return null;
        }
        animation = new Animation(n2);
        animation.aktFrames = this.readInt(inputStream);
        for (n = 0; n < animation.aktFrames; ++n) {
            animation.keyFrames[n] = this.readMesh(inputStream);
        }
        animation.endFrame = this.readInt(inputStream);
        animation.mode = this.readInt(inputStream);
        animation.anzAnim = this.readInt(inputStream);
        animation.wrapMode = this.readInt(inputStream);
        animation.startFrames = this.readIntArray(inputStream);
        animation.endFrames = this.readIntArray(inputStream);
        for (n = 0; n < animation.startFrames.length; ++n) {
            animation.seqNames[n] = this.readString(inputStream);
        }
        return animation;
    }

    private SimpleVector readVector(InputStream inputStream) throws Exception {
        return new SimpleVector(this.readFloat(inputStream), this.readFloat(inputStream), this.readFloat(inputStream));
    }

    private void writeVector(SimpleVector simpleVector, OutputStream outputStream) throws Exception {
        this.write(simpleVector.x, outputStream);
        this.write(simpleVector.y, outputStream);
        this.write(simpleVector.z, outputStream);
    }

    private Mesh readMesh(InputStream inputStream) throws Exception {
        int n = this.readInt(inputStream);
        if (n == 0) {
            return null;
        }
        int n2 = this.readInt(inputStream);
        int n3 = this.readInt(inputStream);
        int n4 = this.readInt(inputStream);
        Mesh mesh = new Mesh(1);
        mesh.anzCoords = n;
        mesh.anzTri = n2;
        mesh.anzVectors = n3;
        mesh.maxVectors = n4;
        mesh.normalsCalculated = this.readBoolean(inputStream);
        mesh.xOrg = this.readFloatArray(inputStream);
        mesh.yOrg = this.readFloatArray(inputStream);
        mesh.zOrg = this.readFloatArray(inputStream);
        mesh.nxOrg = this.readFloatArray(inputStream);
        mesh.nyOrg = this.readFloatArray(inputStream);
        mesh.nzOrg = this.readFloatArray(inputStream);
        mesh.coords = this.readIntArray(inputStream);
        mesh.obbStart = this.readInt(inputStream);
        mesh.obbEnd = this.readInt(inputStream);
        mesh.points = this.readIntIntArray(inputStream);
        return mesh;
    }

    private void writeMesh(Mesh mesh, OutputStream outputStream) throws Exception {
        if (mesh == null) {
            this.write(0, outputStream);
            return;
        }
        this.write(mesh.anzCoords, outputStream);
        this.write(mesh.anzTri, outputStream);
        this.write(mesh.anzVectors, outputStream);
        this.write(mesh.maxVectors, outputStream);
        this.write(mesh.normalsCalculated, outputStream);
        this.write(mesh.xOrg, outputStream);
        this.write(mesh.yOrg, outputStream);
        this.write(mesh.zOrg, outputStream);
        this.write(mesh.nxOrg, outputStream);
        this.write(mesh.nyOrg, outputStream);
        this.write(mesh.nzOrg, outputStream);
        this.write(mesh.coords, outputStream);
        this.write(mesh.obbStart, outputStream);
        this.write(mesh.obbEnd, outputStream);
        this.write(mesh.points, outputStream);
    }

    private void write(float[] fArray, OutputStream outputStream) throws Exception {
        int n;
        this.write(1, outputStream);
        if (fArray == null) {
            this.write(-1, outputStream);
            return;
        }
        boolean bl = true;
        for (n = 0; n < fArray.length; ++n) {
            if (fArray[n] == 0.0f) continue;
            bl = false;
            break;
        }
        if (bl && fArray.length == 1) {
            bl = false;
        }
        if (bl) {
            this.write(-fArray.length, outputStream);
            return;
        }
        this.write(fArray.length, outputStream);
        for (n = 0; n < fArray.length; ++n) {
            this.write(fArray[n], outputStream);
        }
    }

    private void write(int[] nArray, OutputStream outputStream) throws Exception {
        int n;
        this.write(0, outputStream);
        if (nArray == null) {
            this.write(-1, outputStream);
            return;
        }
        boolean bl = true;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] == 0) continue;
            bl = false;
            break;
        }
        if (bl && nArray.length == 1) {
            bl = false;
        }
        if (bl) {
            this.write(-nArray.length, outputStream);
            return;
        }
        this.write(nArray.length, outputStream);
        for (n = 0; n < nArray.length; ++n) {
            this.write(nArray[n], outputStream);
        }
    }

    private void write(byte[] byArray, OutputStream outputStream) throws Exception {
        int n;
        this.write(0, outputStream);
        if (byArray == null) {
            this.write(-1, outputStream);
            return;
        }
        boolean bl = true;
        for (n = 0; n < byArray.length; ++n) {
            if (byArray[n] == 0) continue;
            bl = false;
            break;
        }
        if (bl && byArray.length == 1) {
            bl = false;
        }
        if (bl) {
            this.write(-byArray.length, outputStream);
            return;
        }
        this.write(byArray.length, outputStream);
        for (n = 0; n < byArray.length; ++n) {
            this.write(byArray[n], outputStream);
        }
    }

    private void write(int[][] nArray, OutputStream outputStream) throws Exception {
        int n = 0;
        if (nArray != null) {
            n = nArray.length;
        }
        this.write(nArray, n, outputStream);
    }

    private void write(int[][] nArray, int n, OutputStream outputStream) throws Exception {
        this.write(2, outputStream);
        if (nArray == null) {
            this.write(-1, outputStream);
            return;
        }
        this.write(n, outputStream);
        for (int i = 0; i < n; ++i) {
            this.write(nArray[i].length, outputStream);
            for (int j = 0; j < nArray[i].length; ++j) {
                this.write(nArray[i][j], outputStream);
            }
        }
    }

    private void write(float[][] fArray, OutputStream outputStream) throws Exception {
        this.write(fArray, fArray.length, outputStream);
    }

    private void write(float[][] fArray, int n, OutputStream outputStream) throws Exception {
        this.write(3, outputStream);
        if (fArray == null) {
            this.write(-1, outputStream);
            return;
        }
        this.write(n, outputStream);
        for (int i = 0; i < n; ++i) {
            this.write(fArray[i].length, outputStream);
            for (int j = 0; j < fArray[i].length; ++j) {
                this.write(fArray[i][j], outputStream);
            }
        }
    }

    private void write(boolean bl, OutputStream outputStream) throws Exception {
        if (bl) {
            this._writeInt(1, outputStream);
        } else {
            this._writeInt(0, outputStream);
        }
    }

    private String readString(InputStream inputStream) throws Exception {
        int[] nArray = this.readIntArray(inputStream);
        byte[] byArray = new byte[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i] = (byte)nArray[i];
        }
        String string = new String(byArray, "UTF-8");
        if (string.equals("*null*")) {
            return null;
        }
        return string;
    }

    private void write(String string, OutputStream outputStream) throws Exception {
        if (string == null) {
            string = "*null*";
        }
        this.write(string.getBytes("UTF-8"), outputStream);
    }

    private void write(int n, OutputStream outputStream) throws Exception {
        this._writeInt(n, outputStream);
    }

    private void write(float f, OutputStream outputStream) throws Exception {
        this._writeInt(Float.floatToIntBits(f), outputStream);
    }

    private float[] readFloatArray(InputStream inputStream) throws Exception {
        int n = this.readInt(inputStream);
        if (n != 1) {
            throw new Exception("float[] array expected (" + n + ")!");
        }
        int n2 = this.readInt(inputStream);
        if (n2 == -1) {
            return null;
        }
        if (n2 < 0) {
            float[] fArray = new float[-n2];
            return fArray;
        }
        float[] fArray = new float[n2];
        for (int i = 0; i < n2; ++i) {
            fArray[i] = this.readFloat(inputStream);
        }
        return fArray;
    }

    private int[] readIntArray(InputStream inputStream) throws Exception {
        int n = this.readInt(inputStream);
        if (n != 0) {
            throw new Exception("int[] array expected (" + n + ")!");
        }
        int n2 = this.readInt(inputStream);
        if (n2 == -1) {
            return null;
        }
        if (n2 < 0) {
            int[] nArray = new int[-n2];
            return nArray;
        }
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = this.readInt(inputStream);
        }
        return nArray;
    }

    private int[][] readIntIntArray(InputStream inputStream) throws Exception {
        int n = this.readInt(inputStream);
        if (n != 2) {
            throw new Exception("int[][] array expected (" + n + ")!");
        }
        int n2 = this.readInt(inputStream);
        if (n2 == -1) {
            return null;
        }
        int[][] nArrayArray = new int[n2][];
        for (int i = 0; i < n2; ++i) {
            int n3 = this.readInt(inputStream);
            int[] nArray = new int[n3];
            for (int j = 0; j < n3; ++j) {
                nArray[j] = this.readInt(inputStream);
            }
            nArrayArray[i] = nArray;
        }
        return nArrayArray;
    }

    private float[][] readFloatFloatArray(InputStream inputStream) throws Exception {
        int n = this.readInt(inputStream);
        if (n != 3) {
            throw new Exception("float[][] array expected (" + n + ")!");
        }
        int n2 = this.readInt(inputStream);
        if (n2 == -1) {
            return null;
        }
        float[][] fArrayArray = new float[n2][];
        for (int i = 0; i < n2; ++i) {
            int n3 = this.readInt(inputStream);
            float[] fArray = new float[n3];
            for (int j = 0; j < n3; ++j) {
                fArray[j] = this.readFloat(inputStream);
            }
            fArrayArray[i] = fArray;
        }
        return fArrayArray;
    }

    private boolean readBoolean(InputStream inputStream) throws Exception {
        int n = this._readInt(inputStream);
        return n != 0;
    }

    private int readInt(InputStream inputStream) throws Exception {
        return this._readInt(inputStream);
    }

    private float readFloat(InputStream inputStream) throws Exception {
        return Float.intBitsToFloat(this._readInt(inputStream));
    }

    private int _readInt(InputStream inputStream) throws Exception {
        return this.read(inputStream);
    }

    private void _writeInt(int n, OutputStream outputStream) throws Exception {
        outputStream.write(new byte[]{(byte)(n >> 24), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)});
    }

    private void fillBuffer(InputStream inputStream, int n) throws Exception {
        this.index = 0;
        if (inputStream.available() == 0) {
            throw new Exception("Premature end of file!");
        }
        this.length += inputStream.read(this.buffer, n, this.buffer.length - n);
    }

    private int read(InputStream inputStream) throws Exception {
        int n;
        if (this.index >= this.length || this.length == 0) {
            n = 0;
            this.length = 0;
            while (this.length % 4 != 0 || n == 0) {
                this.fillBuffer(inputStream, n);
                n = this.length;
            }
        }
        n = ((this.buffer[this.index] & 0xFF) << 24) + ((this.buffer[this.index + 1] & 0xFF) << 16) + ((this.buffer[this.index + 2] & 0xFF) << 8) + (this.buffer[this.index + 3] & 0xFF);
        this.index += 4;
        return n;
    }
}

