/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Config;
import com.threed.jpct.FrameBuffer;
import com.threed.jpct.Texture;
import com.threed.jpct.TextureManager;
import com.threed.jpct.World;
import com.threed.jpct.util.Overlay;
import java.awt.Color;

class BlittingWrapper {
    private World world = new World();
    private Overlay overlay = null;
    private FrameBuffer buffer = null;
    private FrameBuffer intBuffer = null;
    private static final String TEXTURE_NAME = "--*--BlittingWrapper_internal--*--";

    BlittingWrapper(FrameBuffer frameBuffer) {
        this.buffer = frameBuffer;
        if (frameBuffer.getSamplingMode() > 0 && frameBuffer.getSamplingMode() < 4) {
            this.intBuffer = new FrameBuffer(frameBuffer.getOutputWidth(), frameBuffer.getOutputHeight(), 0);
            this.intBuffer.pixels = frameBuffer.getPixels();
        } else {
            this.intBuffer = frameBuffer;
        }
        this.overlay = new Overlay(this.world, this.buffer, null);
    }

    void blit(Texture texture, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl, Color color) {
        TextureManager textureManager = TextureManager.getInstance();
        if (!textureManager.containsTexture(TEXTURE_NAME)) {
            textureManager.addTexture(TEXTURE_NAME);
        }
        textureManager.replaceTexture(TEXTURE_NAME, texture);
        if (color != null) {
            this.overlay.setColor(color);
        } else {
            this.overlay.setColor(Color.white);
        }
        this.overlay.setTexture(TEXTURE_NAME);
        this.overlay.setNewCoordinates(n3, n4, n3 + n7, n4 + n8);
        this.overlay.setSourceCoordinates(n, n2, n + n5, n2 + n6);
        this.overlay.setTransparency(n9);
        if (bl) {
            this.overlay.setTransparencyMode(1);
        } else {
            this.overlay.setTransparencyMode(0);
        }
        this.overlay.setDepth(Config.nearPlane + 0.001f);
        FrameBuffer frameBuffer = this.intBuffer;
        if (this.buffer.blittingTarget != 0 && this.intBuffer != this.buffer) {
            frameBuffer = this.buffer;
        }
        this.world.renderScene(frameBuffer);
        this.world.draw(frameBuffer);
        frameBuffer.update();
    }

    void dispose() {
        TextureManager textureManager = TextureManager.getInstance();
        textureManager.replaceTexture(TEXTURE_NAME, textureManager.getDummyTexture());
        textureManager.removeTexture(TEXTURE_NAME);
        this.buffer = null;
        this.intBuffer = null;
        this.overlay = null;
        this.world = null;
    }
}

