/*  DS
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */ 

using namespace std;

#include "ds/ds.h"
#include "handlers/himage.h"
#include "handlers/hmodel.h"
#include "handlers/hcamera.h"
#include "handlers/hspikeball.h"
#include "handlers/hmulticube.h"

using namespace DS;

int main(int argc, char **argv)
{	
	DemoSystem* pDemoSystem;
	try {		
#ifdef NOFILE
		pDemoSystem = DemoSystem::Instance(argc, argv, "../demo.xpk", "demo.xml");
		//pDemoSystem = DemoSystem::Instance(argc, argv, "demo.xpk", "demo.xml");
		//pDemoSystem = DemoSystem::Instance(argc, argv, argv[0], "demo.xml");
#else
		pDemoSystem = DemoSystem::Instance(argc, argv, "../data", "demo.xml");
		//pDemoSystem = DemoSystem::Instance(argc, argv, "../demo.xpk", "demo.xml");
		//pDemoSystem = DemoSystem::Instance(argc, argv, argv[0], "demo.xml");
#endif
		pDemoSystem->AddHandlerFactory("image", new HandlerFactory<HImage>);
		pDemoSystem->AddHandlerFactory("camera", new HandlerFactory<HCamera>);
		pDemoSystem->AddHandlerFactory("model", new HandlerFactory<HModel>);
		pDemoSystem->AddHandlerFactory("spikeball", new HandlerFactory<HSpikeBall>);
		pDemoSystem->AddHandlerFactory("multicube", new HandlerFactory<HMultiCube>);
		pDemoSystem->Run();
	} catch (DS::Exception e) {
		e.Show();
	}
	pDemoSystem->Release();
	return 0;
}
