/*  DS
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#include "quad.h"

namespace DS
{
	void DrawQuad(float width, float height)
	{
		DrawQuad(-(width/2), -(height/2), width/2, height/2);
	}
	
	void DrawQuad(float x1, float y1, float x2, float y2)
	{
		glBegin(GL_QUADS);
			glTexCoord2f(1.0f, 1.0f);
			glVertex3f(x2, y2, 0);		
			glTexCoord2f(1.0f, 0.0f); 
			glVertex3f(x2, y1, 0);
			glTexCoord2f(0.0f, 0.0f);
			glVertex3f(x1, y1, 0);
			glTexCoord2f(0.0f, 1.0f);		
			glVertex3f(x1, y2, 0);
		glEnd();		
	}
}
