/*  DS
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#ifndef HMULTICUBE_H
#define HMULTICUBE_H

#include "../ds/handler.h"

namespace DS
{
	class HMultiCube : public Handler {
	public:
		HMultiCube();
		void Draw(long time);
	private:
		void Init();
		void CacheData();
		void LoadData();
		void Reset();
	
		struct Attrib { long time; float x, y, z, xs, ys, zs, xr, yr, zr, r, g, b, light; };
		std::vector<float> m_x;
		std::vector<float> m_y;
		std::vector<float> m_z;
		std::vector<Attrib> m_attr;
		Attrib m_state;
		unsigned int m_current;
		
		std::string m_tname;
		GLuint m_texture;
	};
}

#endif
