/*  DS
 *  Copyright (C) Anders Asplund and Joakim Kolsjö 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#include "hmodel.h"
#include "../ds/handler.h"
#include "utils/quad.h"

using namespace std;

namespace DS
{	
	HModel::HModel()
	{
		// Set defaults
		m_pHandleAttr->Insert("file", "required");
		m_pHandleAttr->Insert("textured", "1");
		m_pHandleAttr->Insert("ftex", "");
		m_pDefaultNodeAttr->Insert("time", "required");
		m_pDefaultNodeAttr->Insert("x", "0");
		m_pDefaultNodeAttr->Insert("y", "0");
		m_pDefaultNodeAttr->Insert("z", "0");
		m_pDefaultNodeAttr->Insert("r", "1");
		m_pDefaultNodeAttr->Insert("g", "1");
		m_pDefaultNodeAttr->Insert("b", "1");
		m_pDefaultNodeAttr->Insert("xs", "1");
		m_pDefaultNodeAttr->Insert("ys", "1");
		m_pDefaultNodeAttr->Insert("zs", "1");
		m_pDefaultNodeAttr->Insert("xr", "0");
		m_pDefaultNodeAttr->Insert("yr", "0");
		m_pDefaultNodeAttr->Insert("zr", "0");
		m_pDefaultNodeAttr->Insert("light", "1");
	}

	void HModel::Init()
	{
		for(int i = 0; i < (int)m_NodeAttrList.size(); i++)
		{
			Map* pNodeAttr = m_NodeAttrList[i];
			Attrib temp;
			temp.time = atol(pNodeAttr->Get("time"));
			temp.x = atof(pNodeAttr->Get("x"));
			temp.y = atof(pNodeAttr->Get("y"));
			temp.z = atof(pNodeAttr->Get("z"));
			temp.r = atof(pNodeAttr->Get("r"));
			temp.g = atof(pNodeAttr->Get("g"));
			temp.b = atof(pNodeAttr->Get("b"));
			temp.xs = atof(pNodeAttr->Get("xs"));
			temp.ys = atof(pNodeAttr->Get("ys"));
			temp.zs = atof(pNodeAttr->Get("zs"));
			temp.xr = atof(pNodeAttr->Get("xr"));
			temp.yr = atof(pNodeAttr->Get("yr"));
			temp.zr = atof(pNodeAttr->Get("zr"));
			temp.light = atof(pNodeAttr->Get("light"));
			m_attr.push_back(temp);
		}		
		
		m_bTextured = atoi(m_pHandleAttr->Get("textured"));
		m_forcedtex = m_pHandleAttr->Get("ftex");
		
		SetupRange();
	}
	
	void HModel::Reset()
	{
		m_current = 1;
	}
	
	void HModel::CacheData()
	{
		m_pModelLoader->Load(m_pHandleAttr->Get("file"));
		if(m_forcedtex != "")
			m_pTextureLoader->Load(m_forcedtex.c_str());
		else
			m_ftex = 0;
	}
	
	void HModel::LoadData()
	{
		m_pModel = m_pModelLoader->GetModel(m_pHandleAttr->Get("file"));
		if(m_forcedtex != "")
			m_ftex = m_pTextureLoader->GetTexture(m_forcedtex.c_str());
	}
	
	void HModel::Draw(long time)
	{		
		// Find current state
		if(m_attr.size() > 2 && m_current < m_attr.size()-1)
			if(time > m_attr[m_current].time)
				m_current++;
			
		float s = (float)(time - m_attr[m_current-1].time)/(m_attr[m_current].time - m_attr[m_current-1].time);			
		m_state.x =  m_attr[m_current-1].x + (m_attr[m_current].x-m_attr[m_current-1].x)*s;
		m_state.y =  m_attr[m_current-1].y + (m_attr[m_current].y-m_attr[m_current-1].y)*s;
		m_state.z =  m_attr[m_current-1].z + (m_attr[m_current].z-m_attr[m_current-1].z)*s;
		m_state.r =  m_attr[m_current-1].r + (m_attr[m_current].r-m_attr[m_current-1].r)*s;
		m_state.g =  m_attr[m_current-1].g + (m_attr[m_current].g-m_attr[m_current-1].g)*s;
		m_state.b =  m_attr[m_current-1].b + (m_attr[m_current].b-m_attr[m_current-1].b)*s;
		m_state.xs =  m_attr[m_current-1].xs + (m_attr[m_current].xs-m_attr[m_current-1].xs)*s;
		m_state.ys =  m_attr[m_current-1].ys + (m_attr[m_current].ys-m_attr[m_current-1].ys)*s;
		m_state.zs =  m_attr[m_current-1].zs + (m_attr[m_current].zs-m_attr[m_current-1].zs)*s;
		m_state.xr =  m_attr[m_current-1].xr + (m_attr[m_current].xr-m_attr[m_current-1].xr)*s;
		m_state.yr =  m_attr[m_current-1].yr + (m_attr[m_current].yr-m_attr[m_current-1].yr)*s;
		m_state.zr =  m_attr[m_current-1].zr + (m_attr[m_current].zr-m_attr[m_current-1].zr)*s;
		m_state.light =  m_attr[m_current-1].light + (m_attr[m_current].light - m_attr[m_current-1].light)*s;
		
		glPushMatrix();
			glTranslatef(m_state.x, m_state.y, m_state.z);
			glRotatef(m_state.xr, 1, 0, 0);
			glRotatef(m_state.yr, 0, 1, 0);
			glRotatef(m_state.zr, 0, 0, 1);
			glScalef(m_state.xs, m_state.ys, m_state.zs);
			glColor3f(m_state.light, m_state.light, m_state.light);
			
			glEnable(GL_LIGHT1);
			glEnable(GL_LIGHTING);
			if(m_bTextured)
				glEnable(GL_TEXTURE_2D);
			GLfloat diffuse[] = { m_state.light*0.3*m_state.r, m_state.light*0.3*m_state.g, m_state.light*0.3*m_state.b, 0 };
			glLightfv(GL_LIGHT1, GL_DIFFUSE, diffuse);
			GLfloat ambient[] = { m_state.light*0.3*m_state.r, m_state.light*0.3*m_state.g, m_state.light*0.3*m_state.b, 1 };
			glLightModelfv(GL_LIGHT_MODEL_AMBIENT, ambient);
			
			glBindTexture(GL_TEXTURE_2D, m_ftex);
			m_pModel->Draw();
			
			glDisable(GL_LIGHT1);
			glDisable(GL_LIGHTING);
			if(m_bTextured)
				glDisable(GL_TEXTURE_2D);
			
		glPopMatrix();
	}
}
