 /*  DS
 *  Copyright (C) Anders Asplund and Joakim Kolsjö 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#include "himage.h"
#include "utils/quad.h"

using namespace std;

namespace DS
{	
	HImage::HImage()
	{
		// Set defaults
		m_pHandleAttr->Insert("file", "required");
		m_pDefaultNodeAttr->Insert("curve", "linear");
		m_pDefaultNodeAttr->Insert("time", "required");
		m_pDefaultNodeAttr->Insert("x", "0");
		m_pDefaultNodeAttr->Insert("y", "0");
		m_pDefaultNodeAttr->Insert("z", "0");
		m_pDefaultNodeAttr->Insert("xs", "1");
		m_pDefaultNodeAttr->Insert("ys", "1");
		m_pDefaultNodeAttr->Insert("xr", "0");
		m_pDefaultNodeAttr->Insert("yr", "0");
		m_pDefaultNodeAttr->Insert("zr", "0");
		m_pDefaultNodeAttr->Insert("light", "1");
	}

	void HImage::Init()
	{
		for(int i = 0; i < (int)m_NodeAttrList.size(); i++)
		{
			Map* pNodeAttr = m_NodeAttrList[i];
			Attrib temp;
			temp.time = atol(pNodeAttr->Get("time"));
			temp.x = atof(pNodeAttr->Get("x"));
			temp.y = atof(pNodeAttr->Get("y"));
			temp.z = atof(pNodeAttr->Get("z"));
			temp.xs = atof(pNodeAttr->Get("xs"));
			temp.ys = atof(pNodeAttr->Get("ys"));
			temp.xr = atof(pNodeAttr->Get("xr"));
			temp.yr = atof(pNodeAttr->Get("yr"));
			temp.zr = atof(pNodeAttr->Get("zr"));
			temp.light = atof(pNodeAttr->Get("light"));
			
			// Check curvetype
			string curve = pNodeAttr->Get("curve");
			if(curve == "linear") temp.curvetype = 0;
			else if(curve == "sharp") temp.curvetype = 1;
			else throw Exception("[HImage::Init]", (string)"Unknown curvetype: " + curve + ".");
			
			m_attr.push_back(temp);
		}		

		SetupRange();
	}
	
	void HImage::Reset()
	{
		m_current = 1;
	}
	
	void HImage::CacheData()
	{
		m_pTextureLoader->Load(m_pHandleAttr->Get("file"));
	}
	
	void HImage::LoadData()
	{
		m_texture = m_pTextureLoader->GetTexture(m_pHandleAttr->Get("file"));
	}
	
	void HImage::Draw(long time)
	{		
		// Find current state
		if(m_attr.size() > 2 && m_current < m_attr.size()-1)
			if(time > m_attr[m_current].time)
				m_current++;
			
		float s = (float)(time - m_attr[m_current-1].time)/(m_attr[m_current].time - m_attr[m_current-1].time);			
			
		if(m_attr[m_current].curvetype == 0) // Linear
		{
			m_state.x =  m_attr[m_current-1].x + (m_attr[m_current].x-m_attr[m_current-1].x)*s;
			m_state.y =  m_attr[m_current-1].y + (m_attr[m_current].y-m_attr[m_current-1].y)*s;
			m_state.z =  m_attr[m_current-1].z + (m_attr[m_current].z-m_attr[m_current-1].z)*s;
			m_state.xs =  m_attr[m_current-1].xs + (m_attr[m_current].xs-m_attr[m_current-1].xs)*s;
			m_state.ys =  m_attr[m_current-1].ys + (m_attr[m_current].ys-m_attr[m_current-1].ys)*s;
			m_state.xr =  m_attr[m_current-1].xr + (m_attr[m_current].xr-m_attr[m_current-1].xr)*s;
			m_state.yr =  m_attr[m_current-1].yr + (m_attr[m_current].yr-m_attr[m_current-1].yr)*s;
			m_state.zr =  m_attr[m_current-1].zr + (m_attr[m_current].zr-m_attr[m_current-1].zr)*s;
			m_state.light =  m_attr[m_current-1].light + (m_attr[m_current].light - m_attr[m_current-1].light)*s;
		}
		else if(m_attr[m_current].curvetype == 1) // Sharp
		{
			m_state.x = m_attr[m_current].x;
			m_state.y = m_attr[m_current].y;
			m_state.z = m_attr[m_current].z;
			m_state.xs = m_attr[m_current].xs;
			m_state.ys = m_attr[m_current].ys;
			m_state.xr = m_attr[m_current].xr;
			m_state.yr = m_attr[m_current].yr;
			m_state.zr = m_attr[m_current].zr;
			m_state.light = m_attr[m_current].light;
		}
		
		glPushMatrix();
			glTranslatef(m_state.x, m_state.y, m_state.z);
			glRotatef(m_state.xr, 1, 0, 0);
			glRotatef(m_state.yr, 0, 1, 0);
			glRotatef(m_state.zr, 0, 0, 1);
			glColor3f(m_state.light, m_state.light, m_state.light);
			
			glEnable(GL_TEXTURE_2D);
			glBindTexture(GL_TEXTURE_2D, m_texture);
			DrawQuad(m_state.xs, m_state.ys);
			glDisable(GL_TEXTURE_2D);
		glPopMatrix();
	}
}
