/*  DS
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */ 

#ifndef XMLPARSER_H
#define XMLPARSER_H

#include "../common.h"

namespace DS
{	
	class XMLElement {
	public:
		XMLElement(int row);
		~XMLElement();
		std::vector<XMLElement*> GetChildElements();
		const char* GetAttribute(const char* pName);
		const char* GetValue();
		int GetRow();
	
		friend class XMLParser;
	private:
		void AddChildElement(XMLElement* pElement);
		void AddAttribute(const char* pName, const char* pValue);
		void SetValue(const char* pValue);
	
		std::map<std::string, std::string> m_attributes;
		std::vector<XMLElement*> m_ChildElements;
		std::string m_value;
		int m_row;
	};
	
	class XMLParser {
	public:
		XMLParser();
		~XMLParser();
		XMLElement* Load(const char* pFile);
		XMLElement* Parse(const char* pData, long length);
	private:
		XMLElement* ParseElement();
		void FindNextLine();
		std::vector<std::string> m_lines;
		int m_currentline;
		XMLElement* m_pRootElement;
	};
}

#endif
