/*  DS
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */ 

#ifndef STRINGTOOLS_H
#define STRINGTOOLS_H

#include <map>
#include <string>
#include <vector>

namespace DS
{
	class Map {
	public:
		~Map();
		void Insert(const char* pKey, const char* pText);
		const char* Get(const char* pKey);
		std::vector<std::string> GetList();
		void Clear();
		Map* Clone();
	private:
		std::map<std::string, std::string> m_map;
	};
	
	std::string ftoa(float fnumber);
	std::string itoa(int inumber);
}

#endif
