/*  DS
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */ 

#include <sstream>
#include "stringtools.h"

using namespace std;

namespace DS
{
	Map::~Map()
	{
		Clear();
	}

	void Map::Insert(const char* pKey, const char* pText)
	{
		m_map[pKey] = pText;
	}
		
	const char* Map::Get(const char* pKey)
	{
		return m_map[pKey].c_str();
	}

	void Map::Clear()
	{
		m_map.clear();
	}
	
	vector<std::string> Map::GetList()
	{
		vector<string> out;
		
		std::map <std::string, std::string>::iterator miter = m_map.begin();
		while(miter != m_map.end())
		{
			out.push_back(miter->first);
			++miter;
		}	
		
		return out;
	}
	
	Map* Map::Clone()
	{
		Map* pMapClone = new Map;
		vector<string> keylist = GetList();
		
		for(int i = 0; i < (int)keylist.size(); i++)
			pMapClone->Insert(keylist[i].c_str(), m_map[keylist[i]].c_str());
		
		return pMapClone;
	}
	
	std::string ftoa(float fnumber)
	{
		stringstream ss; ss << fnumber;
		return ss.str();
	}
	
	std::string itoa(int inumber)
	{
		stringstream ss; ss << inumber;
		return ss.str();
	}
}
