/*  DS
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#ifndef SCRIPTPARSER_H
#define SCRIPTPARSER_H

#include "common.h"
#include "handler.h"
#include "scene.h"
#include "io/video.h"
#include "utils/xmlparser.h"
#include "io/datareader.h"

namespace DS
{		
	class ScriptParser {
	public:
		ScriptParser();
		~ScriptParser();
		void AddHandlerFactory(const char* pKey, Factory<Handler>* pHandlerFactory);
	protected:
		void Parse();
		DataReader* m_pDataReader;
		
		std::vector<Scene*> m_scenes;
		std::map<std::string, Factory<Handler>*> m_factories;
		std::string m_demotitle, m_musicfile;
		MemFile* m_pScriptFile;
	private:
		// XML tools
		bool Attribute(XMLElement* pElement, const char* pAttribute);
		bool Value(XMLElement* pElement, const char* pValue);
		const char* Get(XMLElement* pElement, const char* pAttribute);
		std::vector<XMLElement*> GetChildren(XMLElement* pElement);
		
		// Parser
		float Calc(const char* pNumberString, float sum, char op);
		std::string ProcessMaths(const char* pText, Map* pBindMap);
		void ParseAttributes(XMLElement* pElement, Map* pMap, Map* pBindMap, bool bNode);
		const char* GetAttr(XMLElement* pElement, const char* pAttribute);
	};
}

#endif
