/*  DS
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#ifndef SCENE_H
#define SCENE_H

#include "common.h"
#include "handler.h"
#include "io/modelloader.h"

namespace DS
{		
	class Scene : public TimeRange {
	public:
		Scene();
		~Scene();
		void Draw(long time);
		void Draw(float progress, long time);
		const char* GetID();
		bool GetActive();
	
		friend class DemoSystem;
		friend class ScriptParser;
	private:
		void SetResources(DataReader* pDataReader, TextureLoader* pTextureLoader, ModelLoader* pModelLoader);
		void CacheData();
		void LoadData();
		void Reset();
		void AddHandler(Handler* pHandler);
		void SetActive(bool active);
		void SetID(const char* pID);
		std::vector<Handler*> m_handlers;
		std::map<std::string, std::vector<Handler*> >::iterator m_hiter;
	
		bool m_active;	
		std::string m_id;
	};
}

#endif
