/*  DS
 *  Copyright (C) Anders Asplund and Joakim Kolsjö 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#include "scene.h"

using namespace std;

namespace DS
{	
	Scene::Scene()
	{

	}
	
	Scene::~Scene()
	{
	
		m_handlers.clear();
	}
	
	void Scene::AddHandler(Handler* pHandler)
	{
		m_handlers.push_back(pHandler);
	}
	
	bool Scene::GetActive()
	{
		return m_active;
	}
	
	const char* Scene::GetID()
	{
		return m_id.c_str();
	}
	
	void Scene::SetActive(bool active)
	{
		m_active = active;
	}
	
	void Scene::SetID(const char* pID)
	{
		m_id = pID;
	}
	
	void Scene::Draw(long time)
	{
		for(int i = 0; i < (int)m_handlers.size(); i++) {
			if(m_handlers[i]->IsActive(time))
				m_handlers[i]->Draw(time);
		}	
	}

	void Scene::Draw(float progress, long time)
	{
		for(int i = 0; i < (int)m_handlers.size(); i++) {
			m_handlers[i]->Draw((long)((float)progress + time));
		}	
	}
	
	void Scene::CacheData()
	{
		for(int i = 0; i < (int)m_handlers.size(); i++) {
			m_handlers[i]->CacheData();
		}
	}
	
	void Scene::LoadData()
	{
		for(int i = 0; i < (int)m_handlers.size(); i++)
			m_handlers[i]->LoadData();
	}
	
	void Scene::Reset()
	{
		for(int i = 0; i < (int)m_handlers.size(); i++)
			m_handlers[i]->Reset();	
	}
	
	void Scene::SetResources(DataReader* pDataReader,
			TextureLoader* pTextureLoader, ModelLoader* pModelLoader)
	{
		for(int i = 0; i < (int)m_handlers.size(); i++)
			m_handlers[i]->SetResources(pDataReader, pTextureLoader, pModelLoader);
	}
}
