/*  DS
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */
 
#include "loadinfo.h"

using namespace std;

namespace DS
{
	LoadInfo::LoadInfo(int states)
	{
		m_pMutex = SDL_CreateMutex();
		m_pValues = new float[states];
		m_pSizes = new float[states];
		m_nStates = states;
		for(int i = 0; i < m_nStates; i++) {
			m_pValues[i] = 0;
			m_pSizes[i] = (float)1/states;
		}
	}
	
	float LoadInfo::GetTotal()
	{
		SDL_mutexP(m_pMutex);
		float total = 0;
		for(int i = 0; i < m_nStates; i++)
			total += (float)m_pValues[i]*m_pSizes[i];
		SDL_mutexV(m_pMutex);
		return total;
	}
	
	void LoadInfo::SetSize(int n, float size)
	{
		m_pSizes[n] = size;
	}
	
	float& LoadInfo::GetState(int n)
	{
		return m_pValues[n];
	}
	
	void LoadInfo::LockState()
	{
		SDL_mutexP(m_pMutex);	
	}
	
	void LoadInfo::ReleaseState()
	{
		SDL_mutexV(m_pMutex);
	}
}
