/*  DS
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */ 
 
#include "video.h"

using namespace std;

namespace DS
{
	void Video::Init(int width, int height, bool fullscreen, const char* pTitle)
	{
		m_Width = width;
		m_Height = height;
		m_fullscreen = fullscreen;
		m_Title = pTitle;
		m_pScreen = 0;
		
		OpenWindow();
	}
	
	void Video::OpenWindow()
	{
		static char *fn = "[Video::OpenWindow]";
		
		// Set video flags
		int flags = SDL_HWSURFACE;
		flags |= SDL_OPENGL;
		
		if(m_fullscreen)
			flags |= SDL_FULLSCREEN;
				
		// Get screen pointer
		if(!(m_pScreen = SDL_SetVideoMode(m_Width, m_Height, 32, flags)))
			throw Exception(fn, (string)"Mode set failed: " + SDL_GetError() + ".");
			
		// Set window title
		SDL_WM_SetCaption(m_Title.c_str(), NULL);
		
		// Hide cursor
		SDL_ShowCursor(0);
	}
	
	void Video::Update()
	{
		SDL_GL_SwapBuffers();
	}
}
