/*  DS
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */ 

#ifndef MUSIC_H
#define MUSIC_H

#include "../common.h"
#include <fmod.h>
#include "datareader.h"

namespace DS
{
	class Music {
	public:
		Music(DataReader* pDataReader);
		~Music();
		void Init(int samplerate);
		void Load(const char* pFile);
		void Play();
		void Stop();
		void SetVolume(int volume);
		int GetVolume();
	private:
		bool m_bHasInit;
		bool m_bHasLoad;
		int m_volume;
		DataReader* m_pDataReader;
		FMUSIC_MODULE* m_pSong;
	};
}

#endif
