/*  DS
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */ 

#ifndef MODEL_LOADER_H
#define MODEL_LOADER_H

#include "../common.h"
#include "textureloader.h"
#include "datareader.h"

namespace DS
{
	class ModelLoader {
	public:
		ModelLoader(TextureLoader* pTextureLoader, DataReader* pDataReader);
		~ModelLoader();
		void Load(const char* pFile);
		Model* GetModel(const char* pFile);
	private:
		std::map<std::string, Model*> m_models;
		TextureLoader* m_pTextureLoader;
		DataReader* m_pDataReader;
	};
}

#endif
