/*  DS
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */ 
 
#include "modelloader.h"

using namespace std;

namespace DS
{	
	ModelLoader::ModelLoader(TextureLoader* pTextureLoader, DataReader* pDataReader)
	{
		m_pTextureLoader = pTextureLoader;
		m_pDataReader = pDataReader;
	}
	
	ModelLoader::~ModelLoader()
	{
		std::map <std::string, Model*>::iterator iter = m_models.begin();
		while(iter != m_models.end())
		{
			delete iter->second;
			++iter;
		}		
	}
	
	void ModelLoader::Load(const char* pFile)
	{
		Model* pModel = new Model;
		try {
			pModel->Load(pFile, m_pDataReader->GetFile(pFile));
		} catch (Exception e) {
			delete pModel;
			throw Exception(e.GetFunctionName(), e.GetMessage());
		}
		
		m_models[pFile] = pModel;
	}
	
	Model* ModelLoader::GetModel(const char* pFile)
	{
		if(!m_models[pFile])
			Load(pFile);
	
		m_models[pFile]->MakeGL(m_pTextureLoader);
		
		return m_models[pFile];	
	}
}
