/*  DS
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */ 

#ifndef READ_XPK_H
#define READ_XPK_H

#include <zlib.h>
#include "../datareader.h"

namespace DS
{
	class ReadXPK : public DataReader {
	public:
		ReadXPK(const char* pFile);
		void Init();
		void Read(const char* pFile);
	private:
		std::vector<uLongf> m_rsizes;
		std::vector<uLongf> m_csizes;
		std::string m_archive;
		uLongf m_ctotal;
		long m_loc;
	};		
}

#endif
