/*  DS
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */ 

/* Code derived from Brett Porter's lesson31 at nehe. */

#ifndef LOAD_MS3D_H
#define LOAD_MS3D_H

#include "../datareader.h"
#include "../textureloader.h"
#include <zlib.h>
#include <png.h>

namespace DS
{
	class TextureLoader;
	
	class Model {
	public:
		Model();
		~Model();
		void MakeGL(TextureLoader* pTextureLoader);
		void Load(const char *pFile, MemFile* pMemFile);
		void Draw();

		// Data structures
		struct Vertex { float position[3]; };
		struct Triangle { int vindices[3]; float vnormals[3][3], tex_s[3], tex_t[3]; };
		struct Material {
			float ambient[4], diffuse[4], specular[4], emissive[4], shininess;
			GLuint texture;
		};
		struct Mesh {
			int* ptindices;
			int material;
			int nTriangles;
		};
		
		// Model data
		Vertex* m_pVertices;
		int m_nVertices;
		
		Triangle* m_pTriangles;
		int m_nTriangles;
		
		Material* m_pMaterials;
		int m_nMaterials;
		
		Mesh* m_pMeshes;
		int m_nMeshes;
		
		std::vector<std::string> m_textures;
		std::string m_file;
	};

	// Structures for reading Milkshape 3D data
	// byte-align structures
	#ifdef _MSC_VER
	#	pragma pack( push, packing )
	#	pragma pack( 1 )
	#	define PACK_STRUCT
	#elif defined( __GNUC__ )
	#	define PACK_STRUCT	__attribute__((packed))
	#else
	#	error you must byte-align these structures with the appropriate compiler directives
	#endif
	
	typedef char byte;
	typedef unsigned short word;
	
	struct MS3DHeader { char id[10]; int version; } PACK_STRUCT;
	
	struct MS3DVertex { byte flags; float vertex[3]; char boneID; byte refCount;
	} PACK_STRUCT;
	
	struct MS3DTriangle { word flags; word vindices[3]; float vnormals[3][3];
		float tex_s[3], tex_t[3]; byte smoothingGroup; byte groupIndex;
	} PACK_STRUCT;
	
	struct MS3DMaterial { char name[32]; float ambient[4]; float diffuse[4];
		float specular[4]; float emissive[4]; float shininess;
		float transparency; byte mode; char texture[128];
		char m_lightmap[128]; } PACK_STRUCT;
	
	struct MS3DJoint { byte flags; char name[32]; char parentName[32];
		float rotation[3]; float translation[3]; word numRotationKeyframes;
		word numTranslationKeyframes; } PACK_STRUCT;
	
	struct MS3DKeyframe { float time; float parameter[3]; } PACK_STRUCT;
	
	// Default alignment
	#ifdef _MSC_VER
	#	pragma pack( pop, packing )
	#endif
	
	#undef PACK_STRUCT
}

#endif
