/*  DS
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */ 

#ifndef DATAREADER_H
#define DATAREADER_H

#include "../common.h"

namespace DS
{
	class MemFile {
	public:
		MemFile(char* pData, int length);
		~MemFile();
		int Read(void* pBuffer, int size);
		void Seek(int pos, signed char mode);
		int Tell();
		char* GetData();
		int GetLength();
	private:
		char* m_pData;	
		int m_length;
		int m_pos;
	};
		
	class DataReader {
	public:
		virtual ~DataReader();
		virtual void Init()=0;
		virtual MemFile* GetFile(const char* pFile);
		virtual void Read(const char* pFile)=0;
	protected:
		std::map<std::string, MemFile*> m_MemFiles;
		std::vector<std::string> m_FileNames;
	};
}

#endif
