/*  DS
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#ifndef HANDLER_H
#define HANDLER_H

#include "io/datareader.h"
#include "io/textureloader.h"
#include "io/modelloader.h"

namespace DS
{
	class TimeRange {
	public:
		TimeRange();
		bool IsActive(long time);
	protected:
		void SetRange(long start, long end);
	private:
		bool m_active;
		long m_start;
		long m_end;
	};
	
	class Handler : public TimeRange {
	public:
		Handler();
		virtual ~Handler();
		virtual void Draw(long time)=0;
		virtual void Reset()=0;
		
		friend class Scene;
		friend class ScriptParser;
	protected:
		void SetupRange();
	
		Map* m_pHandleAttr;
		Map* m_pDefaultNodeAttr;
		std::vector<Map*> m_NodeAttrList;
	
		DataReader* m_pDataReader;
		TextureLoader* m_pTextureLoader;
		ModelLoader* m_pModelLoader;
	private:
		virtual void CacheData()=0;
		virtual void LoadData()=0;
		virtual void Init()=0;
		void SetResources(DataReader* pDataReader, TextureLoader* pTextureLoader, ModelLoader* pModelLoader);
		Map* GetHandlerAttr();
		Map* CreateNodeAttr();
	};
	
	template <class T> class Factory {
	public:
		virtual T* Create()=0;
	};
	
	template <class T> class HandlerFactory : public Factory<Handler> {
	public:
		Handler* Create() { return new T; }
	};
}

#endif
